//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID55ef2226_654b_473d_a45c_10aaed6a0d82
{
    public class Class__UseCameraPosition : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Widget = 0,
            Camera = 1
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Widget = inputs[(int)InputId.Widget];
            var Camera = inputs[(int)InputId.Camera].Eval(context).Dynamic;  // Needs to be checked for null!
            //<<< _params
            
            Framefield.Core.OperatorPartTraits.ICameraProvider camProvider = Camera.This as Framefield.Core.OperatorPartTraits.ICameraProvider;
            if (camProvider == null)
            {
                Logger.Error(this, "camera not defined");
                return context;
            }

            // Render Scene
            
            // Render Camera
            var prevTransform = context.ObjectTWorld;
            var m = camProvider.GetLastWorldToCamera();
            m.Invert();
            m.Row4 = new Vector4( camProvider.GetLastPosition(),1);
            context.ObjectTWorld = m;
            Widget.Eval(context);
            context.ObjectTWorld = prevTransform;
            
            return context;
        }
    }
}

