using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace Framefield.Core.IDf4733b31_0635_4cbb_86a1_e699a2fbb789
{

    public class Class_Comp_Time : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Year = 0,
            Month = 1,
            Day = 2
        }
        //<<< _inputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Year = inputs[(int)InputId.Year].Eval(context).Value;
            var Month = inputs[(int)InputId.Month].Eval(context).Value;
            var Day = inputs[(int)InputId.Day].Eval(context).Value;
            //<<< _params
            
            var ts = DateTime.UtcNow - new DateTime((int)Math.Floor(Year),(int)Math.Round(Month),(int)Math.Round(Day));
            context.Text = String.Format("{0}", (long)ts.TotalMilliseconds);
            return context;
        }
    }
}


