//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDa06de583_056f_458e_b16a_adf0dff713f4
{
    public class Class_ChannelMixer : FXImageFunction
    {
        protected override bool NeedsDepth { get { return false; } }
        protected override BlendState BlendState { get { return _renderer.DisabledBlendState; } }

        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image = 1,
            MultiplyRR = 2,
            MultiplyRG = 3,
            MultiplyRB = 4,
            MultiplyRA = 5,
            MultiplyGR = 6,
            MultiplyGG = 7,
            MultiplyGB = 8,
            MultiplyGA = 9,
            MultiplyBR = 10,
            MultiplyBG = 11,
            MultiplyBB = 12,
            MultiplyBA = 13,
            MultiplyAR = 14,
            MultiplyAG = 15,
            MultiplyAB = 16,
            MultiplyAA = 17,
            AddR = 18,
            AddG = 19,
            AddB = 20,
            AddA = 21
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            return PrepareAndEvalOnChange(context, () =>
            {
                //>>> __params
                var Code = inputs[(int)InputId.Code].Eval(context).Text;
                var Image = inputs[(int)InputId.Image].Eval(context).Image; if (Image == null) return;
                var MultiplyRR = inputs[(int)InputId.MultiplyRR].Eval(context).Value;
                var MultiplyRG = inputs[(int)InputId.MultiplyRG].Eval(context).Value;
                var MultiplyRB = inputs[(int)InputId.MultiplyRB].Eval(context).Value;
                var MultiplyRA = inputs[(int)InputId.MultiplyRA].Eval(context).Value;
                var MultiplyR = new Color4(MultiplyRR, MultiplyRG, MultiplyRB, MultiplyRA);
                var MultiplyGR = inputs[(int)InputId.MultiplyGR].Eval(context).Value;
                var MultiplyGG = inputs[(int)InputId.MultiplyGG].Eval(context).Value;
                var MultiplyGB = inputs[(int)InputId.MultiplyGB].Eval(context).Value;
                var MultiplyGA = inputs[(int)InputId.MultiplyGA].Eval(context).Value;
                var MultiplyG = new Color4(MultiplyGR, MultiplyGG, MultiplyGB, MultiplyGA);
                var MultiplyBR = inputs[(int)InputId.MultiplyBR].Eval(context).Value;
                var MultiplyBG = inputs[(int)InputId.MultiplyBG].Eval(context).Value;
                var MultiplyBB = inputs[(int)InputId.MultiplyBB].Eval(context).Value;
                var MultiplyBA = inputs[(int)InputId.MultiplyBA].Eval(context).Value;
                var MultiplyB = new Color4(MultiplyBR, MultiplyBG, MultiplyBB, MultiplyBA);
                var MultiplyAR = inputs[(int)InputId.MultiplyAR].Eval(context).Value;
                var MultiplyAG = inputs[(int)InputId.MultiplyAG].Eval(context).Value;
                var MultiplyAB = inputs[(int)InputId.MultiplyAB].Eval(context).Value;
                var MultiplyAA = inputs[(int)InputId.MultiplyAA].Eval(context).Value;
                var MultiplyA = new Color4(MultiplyAR, MultiplyAG, MultiplyAB, MultiplyAA);
                var AddR = inputs[(int)InputId.AddR].Eval(context).Value;
                var AddG = inputs[(int)InputId.AddG].Eval(context).Value;
                var AddB = inputs[(int)InputId.AddB].Eval(context).Value;
                var AddA = inputs[(int)InputId.AddA].Eval(context).Value;
                var Add = new Color4(AddR, AddG, AddB, AddA);
                //<<< __params

                //>>> __setup
                using (var ImageView = new ShaderResourceView(context.D3DDevice, Image))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image").AsShaderResource().SetResource(ImageView);
                    _effect.GetVariableByName("MultiplyR").AsVector().Set(MultiplyR);
                    _effect.GetVariableByName("MultiplyG").AsVector().Set(MultiplyG);
                    _effect.GetVariableByName("MultiplyB").AsVector().Set(MultiplyB);
                    _effect.GetVariableByName("MultiplyA").AsVector().Set(MultiplyA);
                    _effect.GetVariableByName("Add").AsVector().Set(Add);
                    //<<< __setup

                    _blendState = OperatorPartContext.DefaultRenderer.DisabledBlendState;
                    Render(context);

                    //>>> _cleanup
                    }
                //<<< _cleanup
            });
        }
    }
}

