//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID6c995f97_59e2_4b9b_b9b4_2aacaeab4928
{
    public class Class_Damper : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Value = 0,
            Friction = 1
        }
        //<<< _inputids
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            var Friction = inputs[(int)InputId.Friction].Eval(context).Value;
            //<<< _params

            if (context.GlobalTime < _dampedTime)
                _damped = Value;
            
            if( Double.IsNaN(_damped))
                _damped = Value;

            _damped = Friction*_damped + (1 - Friction)*Value;
            _dampedTime = context.GlobalTime;
            context.Value = _damped;
            return context;
        }
        
        float _damped;
        float _dampedTime = 999999;
    }
}

