//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID9fc759e7_8242_4857_a834_8a1471ce9644
{
    public class Class_Distance : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Pos1X = 0,
            Pos1Y = 1,
            Pos1Z = 2,
            Pos2X = 3,
            Pos2Y = 4,
            Pos2Z = 5
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Pos1X = inputs[(int)InputId.Pos1X].Eval(context).Value;
            var Pos1Y = inputs[(int)InputId.Pos1Y].Eval(context).Value;
            var Pos1Z = inputs[(int)InputId.Pos1Z].Eval(context).Value;
            var Pos1 = new Vector3(Pos1X, Pos1Y, Pos1Z);
            var Pos2X = inputs[(int)InputId.Pos2X].Eval(context).Value;
            var Pos2Y = inputs[(int)InputId.Pos2Y].Eval(context).Value;
            var Pos2Z = inputs[(int)InputId.Pos2Z].Eval(context).Value;
            var Pos2 = new Vector3(Pos2X, Pos2Y, Pos2Z);
            //<<< _params

            context.Value = Vector3.Distance(Pos1, Pos2);
            
            return context;
        }
    }
}

