//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Dynamic;

namespace Framefield.Core.ID943ca3de_9e5f_4b11_bce2_267156192a6f
{
    public class Class_ManipulateMemory : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Binary = 0,
            Seed = 1,
            Amount = 2,
            Strength = 3,
            Offset = 4
        }
        //<<< _inputids

        public override void Dispose()
        {
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> __params
            var Binary = inputs[(int)InputId.Binary].Eval(context).Dynamic;
            var Seed = inputs[(int)InputId.Seed].Eval(context).Value;
            var Amount = inputs[(int)InputId.Amount].Eval(context).Value;
            var Strength = inputs[(int)InputId.Strength].Eval(context).Value;
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            //<<< __params

            if (Binary == null)
            {
               context.Dynamic = null;
               return context;
            }

            if (_copiedBinary == null || Changed)
            {
                try
                {
                    if (_randomNumbers == null || (int)Seed != _seed || Binary.Data.Length != _randomNumbers.Length)
                    {
                        _seed = (int)Seed;
                        Random random = new Random(_seed);
                        _randomNumbers = new float[Binary.Data.Length];
                        for (int i = 0; i < Binary.Data.Length; ++i)
                            _randomNumbers[i] = (float)random.NextDouble();
                    }

                    _copiedBinary = new byte[Binary.Data.Length];
                    Array.Copy(Binary.Data, _copiedBinary, Binary.Data.Length);
                    for (int i = (int)Offset; i < _copiedBinary.Length; ++i)
                    {
                        if (_randomNumbers[i] < Amount/100)
                        {
                            _copiedBinary[i] += (byte)((_randomNumbers[i] - 0.5f)*Strength/100*255);
                        }
                    }
                }
                catch (Exception e)
                {
                    //Logger.Error(this, "binary data could not be manipulated: {0}", e.Message);
                    _copiedBinary = null;
                } 

                Changed = false;
            }

            if (_copiedBinary != null)
            {
                dynamic obj = new ExpandoObject();
                obj.Data = _copiedBinary;
                context.Dynamic = obj;
            }
            else
            {
                context.Dynamic = null;
            }
            return context;
        }

        int _seed;
        byte[] _copiedBinary;
        float[] _randomNumbers;
    }
    
}

