//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID0f859853_b8db_498a_9e15_a5636cf1717d
{
    public class Class_FXImageTemplate : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            Image1 = 1,
            Trigger = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; if (Image1 == null) return context;
            var Trigger = inputs[(int)InputId.Trigger].Eval(context).Value;
            //<<< _params
            
            if( Trigger != 0) {
            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("Trigger").AsScalar().Set(Trigger);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });            }
            return context;
        }

    }
}



