//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID292f24a9_8d8b_4dfd_837b_c9c7203c3dd0
{
    public class Class_SetResolutionGeneric : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Subtree = 0,
            SizeX = 1,
            SizeY = 2
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Subtree = inputs[(int)InputId.Subtree];
            var SizeX = inputs[(int)InputId.SizeX].Eval(context).Value;
            var SizeY = inputs[(int)InputId.SizeY].Eval(context).Value;
            var Size = new Vector2(SizeX, SizeY);
            //<<< _params

            var prevViewport = context.Viewport;
            context.Viewport = new ViewportF(0, 0, SizeX, SizeY);

            context = Subtree.Eval(context);

            context.Viewport = prevViewport;
            Changed = false;
            return context;
        }
    }
}


