//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID84d87d78_6573_422f_bc06_6369d0c6e9b1
{
    public class Class_StarDistort : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            CenterX = 1,
            CenterY = 2,
            Image1 = 3,
            NoiseImage = 4,
            Repeat = 5,
            DistributionStrength = 6,
            DistributionNoise = 7,
            DistributionPhase = 8,
            Radius = 9,
            SizeScatterStrength = 10,
            SizeScatterFrequency = 11,
            SizeScatterPhase = 12,
            OffsetContentX = 13,
            OffsetContentY = 14
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var CenterX = inputs[(int)InputId.CenterX].Eval(context).Value;
            var CenterY = inputs[(int)InputId.CenterY].Eval(context).Value;
            var Center = new Vector2(CenterX, CenterY);
            var Image1 = inputs[(int)InputId.Image1].Eval(context).Image; // Needs to be checked for null!
            var NoiseImage = inputs[(int)InputId.NoiseImage].Eval(context).Image; // Needs to be checked for null!
            var Repeat = inputs[(int)InputId.Repeat].Eval(context).Value;
            var DistributionStrength = inputs[(int)InputId.DistributionStrength].Eval(context).Value;
            var DistributionNoise = inputs[(int)InputId.DistributionNoise].Eval(context).Value;
            var DistributionPhase = inputs[(int)InputId.DistributionPhase].Eval(context).Value;
            var Distribution = new Vector3(DistributionStrength, DistributionNoise, DistributionPhase);
            var Radius = inputs[(int)InputId.Radius].Eval(context).Value;
            var SizeScatterStrength = inputs[(int)InputId.SizeScatterStrength].Eval(context).Value;
            var SizeScatterFrequency = inputs[(int)InputId.SizeScatterFrequency].Eval(context).Value;
            var SizeScatterPhase = inputs[(int)InputId.SizeScatterPhase].Eval(context).Value;
            var SizeScatter = new Vector3(SizeScatterStrength, SizeScatterFrequency, SizeScatterPhase);
            var OffsetContentX = inputs[(int)InputId.OffsetContentX].Eval(context).Value;
            var OffsetContentY = inputs[(int)InputId.OffsetContentY].Eval(context).Value;
            var OffsetContent = new Vector2(OffsetContentX, OffsetContentY);
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));

                //>>> _setup
                using (var Image1View = new ShaderResourceView(context.D3DDevice, Image1))
                using (var NoiseImageView = new ShaderResourceView(context.D3DDevice, NoiseImage))
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("Center").AsVector().Set(new Vector2(CenterX, CenterY));
                    _effect.GetVariableByName("Image1").AsShaderResource().SetResource(Image1View);
                    _effect.GetVariableByName("NoiseImage").AsShaderResource().SetResource(NoiseImageView);
                    _effect.GetVariableByName("Repeat").AsScalar().Set(Repeat);
                    _effect.GetVariableByName("Distribution").AsVector().Set(new Vector3(DistributionStrength, DistributionNoise, DistributionPhase));
                    _effect.GetVariableByName("Radius").AsScalar().Set(Radius);
                    _effect.GetVariableByName("SizeScatter").AsVector().Set(new Vector3(SizeScatterStrength, SizeScatterFrequency, SizeScatterPhase));
                    _effect.GetVariableByName("OffsetContent").AsVector().Set(new Vector2(OffsetContentX, OffsetContentY));
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



