//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;
using Framefield.Core.Testing;

namespace Framefield.Core.ID8d75be40_3e11_47a0_b398_c270a85225cf
{
    public class Class_ValueTester : TesterFunction
    {
        public override void SetupTestCase(OperatorPart subtree)
        {
            _subTree = subtree;
        }

        public override bool GenerateData(OperatorPartContext context)
        {
            _currentValue = _subTree.Eval(context).Value;
            return true;
        }

        public override void StoreAsReferenceData(int index, int count)
        {
            SetReferenceValue(index, count, _currentValue);
        }

        public override bool CompareData(int index, int count, float threshold, out string compareResultString)
        {
            compareResultString = String.Empty;
            bool result = false;
            float referenceValue = 0;
            try
            {
                referenceValue = GetReferenceValue(index, count);
            }
            catch (IOException ex)
            {
                compareResultString = String.Format("reference not loaded: {0}", ex.Message);
                return false;
            }

            double deviation = Math.Abs(_currentValue - referenceValue);
            if (deviation < threshold)
            {
                result = true;
            }
            else
            {
                result = false;
                compareResultString = String.Format("{0} != {1}, ", _currentValue, referenceValue);
            }
            compareResultString += String.Format("{0}", deviation);
            return result;
        }

        string GetReferenceFilename(int index, int count)
        {
            return GetReferenceFilename(index, count, ".Value");
        }

        float GetReferenceValue(int index, int count)
        {
            return (float)Convert.ToDouble(File.ReadAllText(GetReferenceFilename(index, count)));
        }

        void SetReferenceValue(int index, int count, float value)
        {
            FileInfo fi = new FileInfo(GetReferenceFilename(index, count));
            if (!Directory.Exists(fi.DirectoryName))
                Directory.CreateDirectory(fi.DirectoryName);
            using (StreamWriter outfile = new StreamWriter(fi.FullName))
            {
                outfile.Write(value);
            }
        }

        OperatorPart _subTree;
        float _currentValue;
    }
}

