// A little PETSCII intro for the Vammala Party'17 (Jarkko rikkoi omansa)

#include <stdio.h>
#include <string.h>
#include <c64lib.h>
#include <delta_c.c> // Shouldn't do this, but I did it anyway

extern char delta[];

extern void biisi_start(void);
extern void biisi_play(void);
extern char biisi[];

char *scroll=
"                                        "
"Fit & Friends present at Vammala Party 2017: Nothing but PET SKI. "
"And as you know, we keep our promises - there is nothing else here "
"than a pet (a jolly cat) skiing downhill. Animation by Dr. TerrorZ, "
"music by Yzi and this pitiful piece of code by Marq. Greetings to "
"Mikron as usual. "
"                 --WRAP--"
"                                        ";

void main()
{
	int frame=0,slen=strlen(scroll),off=0,ys=1,y=50;
	unsigned char c,skrol=7;

	*(char *)VIC_MEM=0x14;
	memset((char *)COLOR_RAM,LIGHT_BLUE,1000);
	__asm__("sei");
	while(1)
	{
		waitline(48);
		*(char *)VIC_COLOR=LIGHT_BLUE;
		waitline(y);
		*(char *)VIC_COLOR=BLUE;

		ys++;
		y+=ys;
		if(y>252)
		{
			y-=ys;
			ys=-(ys>>1);

			if(ys==0)
				break;
		}
	}

	*(char *)VIC_CTR0=VIC_25_ROWS+3;

	// Convert *SCII to screen codes
	printf("%c%s",147,scroll);
	memcpy(scroll,(char *)CHAR_RAM,slen);
	memset((char *)COLOR_RAM,WHITE,1000);

	__asm__("sei");
	*(char *)VIC_BORDER=WHITE;
	*(char *)VIC_COLOR=WHITE;
	*(char *)VIC_MEM=0x14;

	// Fade in (rather brutal now)
	memcpy((char *)CHAR_RAM,delta+2,1000);
	memcpy((char *)COLOR_RAM,delta+1002,1000);

	*(char *)1=0x35; // E000 = RAM
	memcpy((char *)0xe000,biisi,4096);

	*(char *)VIC_CTR0=VIC_25_ROWS+VIC_BLANK+3;

	biisi_start();

	while(1) // Main loop
	{
		for(c=0;c<3;c++) // Draw one diff of anim
		{
			waitline(235);
			*(char *)VIC_MEM=0x16;
			*(char *)VIC_CTR1=skrol;
//			*(char *)VIC_BORDER=RED;

			waitline(250);
			waitline(251);
			biisi_play();
			*(char *)VIC_MEM=0x14;
			*(char *)VIC_CTR1=VIC_40_COLS+1;

//			*(char *)VIC_BORDER=BLUE;
			deltafp[frame]();
//			*(char *)VIC_BORDER=YELLOW;

			memset((char *)COLOR_RAM+40*24,BLUE,40);
			memcpy((char *)CHAR_RAM+40*24,&scroll[off],40);

			skrol--;
			if(skrol==255)
				skrol=7;

			if(skrol==0)
			{
				off++;
				if(off==slen-40)
					off=0;
			}
//			*(char *)VIC_BORDER=WHITE;
		}

		frame++;
		if(frame==8)
			frame=0;
	}
}
