/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.eggine;

import java.net.URISyntaxException;
import java.net.URL;
import javafx.embed.swing.JFXPanel;
import javafx.scene.media.AudioSpectrumListener;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;

public class Audio {
    private MediaPlayer mp;
    private JFXPanel jfxPanel;
    private AudioSpectrumListener audioSpectrumListener;
    private float[] audioData = new float[128];

    public Audio(String musicFile) throws URISyntaxException {
        this.jfxPanel = new JFXPanel();
        this.jfxPanel.setVisible(false);
        URL url = Thread.currentThread().getContextClassLoader().getResource("audio/" + musicFile);
        String uriString = url.toURI().toString();
        this.mp = new MediaPlayer(new Media(uriString));
        this.audioSpectrumListener = new AudioSpectrumListener(){

            public void spectrumDataUpdate(double timestamp, double duration, float[] magnitudes, float[] phases) {
                for (int i = 0; i < Audio.this.audioData.length; ++i) {
                    ((Audio)Audio.this).audioData[i] = (magnitudes[i] + 60.0f) / 60.0f;
                }
            }
        };
        this.mp.setAudioSpectrumListener(this.audioSpectrumListener);
    }

    public void play() {
        this.mp.play();
        this.mp.setVolume(1.0);
    }

    public void stop() {
        this.mp.stop();
        this.jfxPanel = null;
    }

    public float[] getAudioSpectrum() {
        return this.audioData;
    }

    public float getAvgSpectrum() {
        return this.getAvgRange(0, this.audioData.length, this.audioData.length);
    }

    public float getAvgRange(int min, int max) {
        return this.getAvgRange(min, max, max - min);
    }

    public float getAvgRange(int min, int max, float div) {
        float avg = 0.0f;
        if (max > this.audioData.length) {
            max = this.audioData.length;
        }
        for (int i = min; i < max; ++i) {
            avg += this.audioData[i];
        }
        return avg /= div;
    }
}

