/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.eggine;

import java.util.ArrayList;
import java.util.logging.Logger;
import net.exitus.gfxlib.resources.Mesh;
import net.exitus.gfxlib.resources.MeshFrontFace;
import net.exitus.gfxlib.resources.MeshType;
import net.exitus.gfxlib.resources.VertexLayout;
import org.joml.Vector3f;

public class MeshGenerator {
    protected static final Logger logger = Logger.getLogger(MeshGenerator.class.getName());
    private final double TWOPI = Math.PI * 2;
    private final double PID2 = 1.5707963267948966;

    public float[] genSuperEllipsoidArray(double n2, double n1, int n) {
        int numVerts = n / 2 * (n + 1) * 6 * 2;
        float[] verts = new float[numVerts];
        int ind = 0;
        P p = new P();
        P p1 = new P();
        P p2 = new P();
        P en = new P();
        double delta = 0.06283185307179587 / (double)n;
        for (int j = 0; j < n / 2; ++j) {
            double t1 = (double)j * (Math.PI * 2) / (double)n - 1.5707963267948966;
            double t2 = (double)(j + 1) * (Math.PI * 2) / (double)n - 1.5707963267948966;
            for (int i = 0; i <= n; ++i) {
                double t3 = i == 0 || i == n ? 0.0 : (double)i * (Math.PI * 2) / (double)n;
                this.evalSuperEllipse(t2, t3, n1, n2, p);
                this.evalSuperEllipse(t2 + delta, t3, n1, n2, p1);
                this.evalSuperEllipse(t2, t3 + delta, n1, n2, p2);
                en = this.calcNormal(p1, p, p2);
                verts[ind++] = (float)p.x;
                verts[ind++] = (float)p.y;
                verts[ind++] = (float)p.z;
                verts[ind++] = (float)en.x;
                verts[ind++] = (float)en.y;
                verts[ind++] = (float)en.z;
                this.evalSuperEllipse(t1, t3, n1, n2, p);
                this.evalSuperEllipse(t1 + delta, t3, n1, n2, p1);
                this.evalSuperEllipse(t1, t3 + delta, n1, n2, p2);
                en = this.calcNormal(p1, p, p2);
                verts[ind++] = (float)p.x;
                verts[ind++] = (float)p.y;
                verts[ind++] = (float)p.z;
                verts[ind++] = (float)en.x;
                verts[ind++] = (float)en.y;
                verts[ind++] = (float)en.z;
            }
        }
        System.out.println("ind: " + ind + ", numVerts: " + numVerts);
        return verts;
    }

    public Mesh genSuperEllipsoid(double n2, double n1, int n) {
        float[] verts = this.genSuperEllipsoidArray(n2, n1, n);
        ArrayList<VertexLayout> layout = new ArrayList<VertexLayout>();
        layout.add(VertexLayout.POS);
        layout.add(VertexLayout.NORMAL);
        Mesh m = new Mesh("superellipsoid" + System.currentTimeMillis(), MeshType.TRIANGLE_STRIP, MeshFrontFace.CW);
        m.setVertices(verts, layout);
        return m;
    }

    public Mesh genSuperEllipsoid2(double n2, double n1, double nn2, double nn1, int n) {
        float[] verts = this.genSuperEllipsoidArray(n2, n1, n);
        float[] verts2 = this.genSuperEllipsoidArray(nn2, nn1, n);
        float[] res = new float[verts.length + verts2.length - 1];
        int i = 0;
        int j = 0;
        while (i < res.length - 13) {
            res[i] = verts[j];
            res[i + 1] = verts[j + 1];
            res[i + 2] = verts[j + 2];
            res[i + 3] = verts[j + 3];
            res[i + 4] = verts[j + 4];
            res[i + 5] = verts[j + 5];
            res[i + 6] = verts2[j];
            res[i + 7] = verts2[j + 1];
            res[i + 8] = verts2[j + 2];
            res[i + 9] = verts2[j + 3];
            res[i + 10] = verts2[j + 4];
            res[i + 11] = verts2[j + 5];
            i += 12;
            j += 6;
        }
        ArrayList<VertexLayout> layout = new ArrayList<VertexLayout>();
        layout.add(VertexLayout.POS);
        layout.add(VertexLayout.NORMAL);
        layout.add(VertexLayout.BINORMAL);
        layout.add(VertexLayout.TANGENT);
        Mesh m = new Mesh("superellipsoid" + System.currentTimeMillis(), MeshType.TRIANGLE_STRIP, MeshFrontFace.CW);
        m.setVertices(res, layout);
        return m;
    }

    private void evalSuperEllipse(double t1, double t2, double p1, double p2, P p) {
        double ct1 = Math.cos(t1);
        double ct2 = Math.cos(t2);
        double st1 = Math.sin(t1);
        double st2 = Math.sin(t2);
        double tmp = Math.signum(ct1) * Math.pow(Math.abs(ct1), p1);
        p.x = tmp * Math.signum(ct2) * Math.pow(Math.abs(ct2), p2);
        p.y = Math.signum(st1) * Math.pow(Math.abs(st1), p1);
        p.z = tmp * Math.signum(st2) * Math.pow(Math.abs(st2), p2);
    }

    private P calcNormal(P p1, P p2, P p3) {
        Vector3f norm = new Vector3f();
        Vector3f v1 = new Vector3f((float)(p1.x - p2.x), (float)(p1.y - p2.y), (float)(p1.z - p2.z));
        Vector3f v2 = new Vector3f((float)(p2.x - p3.x), (float)(p2.y - p3.y), (float)(p2.z - p3.z));
        norm = v1.cross(v2);
        norm = norm.normalize();
        P normOut = new P();
        normOut.x = norm.x;
        normOut.y = norm.y;
        normOut.z = norm.z;
        return normOut;
    }

    private class P {
        double x;
        double y;
        double z;
    }
}

