/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.eggine;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import net.exitus.eggine.Audio;
import net.exitus.eggine.MeshGenerator;
import net.exitus.eggine.Skybox;
import net.exitus.eggine.Syncer;
import net.exitus.gfxlib.ogl.OGLApp;
import net.exitus.gfxlib.resources.Camera;
import net.exitus.gfxlib.resources.FreeCamera;
import net.exitus.gfxlib.resources.LookAtCamera;
import net.exitus.gfxlib.resources.Material;
import net.exitus.gfxlib.resources.Mesh;
import net.exitus.gfxlib.resources.MeshFrontFace;
import net.exitus.gfxlib.resources.MeshType;
import net.exitus.gfxlib.resources.Model;
import net.exitus.gfxlib.resources.Texture;
import net.exitus.gfxlib.resources.VertexLayout;
import net.exitus.gfxlib.shader.Shader;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;

public class Retry
extends OGLApp {
    protected static final Logger logger = Logger.getLogger(Retry.class.getName());
    private Shader quadShader;
    private Shader quadShaderMulju;
    private Shader fsQuad;
    private Shader texSpher;
    private Shader skyBoxShader;
    private Shader pointSpr;
    private int textureId;
    private int MSAATexture;
    private int uniformTimeLoc;
    private Material cubeMat;
    private Material quadMat;
    private Material quadMatMulju;
    private Material sEllipsMat;
    private Material sEllipsMat2;
    private Material logoPalloMat;
    private Texture texture;
    private Texture texture2;
    private Texture bkgTex;
    private Texture bkgTex2;
    private Texture lensTex;
    private Texture paraffin;
    private Texture lightZero;
    private Texture pyrotech;
    private Texture alaViiva;
    private Texture ylaViiva;
    private Texture vortex;
    private Texture credAika;
    private Texture credPhar;
    private Texture syria;
    private Texture black;
    private Matrix4f viewProj = new Matrix4f();
    private Matrix4f view = new Matrix4f();
    private Matrix4f proj = new Matrix4f();
    private FreeCamera fpsCam;
    private Camera mainCam;
    private Camera curCam;
    private int camIndex = 0;
    private List<Camera> cameras = new ArrayList<Camera>();
    private Mesh sEllips2Mesh;
    private Model cube1;
    private Model quad;
    private Model cubeMulju;
    private Model sEllips;
    private Model sEllips2;
    private Model logoPallo;
    private List<Model> models = new ArrayList<Model>();
    private Model points;
    private boolean toggleFreeCam;
    private boolean toggleBloom = true;
    private boolean toggleLens = false;
    private float morphFactor = 0.0f;
    private Float tonemapExposure = Float.valueOf(0.0f);
    private Map<String, Object> tonemapParams = new HashMap<String, Object>();
    private Syncer exposureCounterDec = new Syncer(0.0f, 2.5f, 7.5f, -0.1f);
    private Map<String, Object> params = new HashMap<String, Object>();
    private Skybox skyBox;
    private Skybox skyBoxLines;
    private Skybox skyBoxAav;
    Audio audio;
    float audioSync = 0.0f;
    float skyBoxOpaq = 1.0f;
    float bloomFactor = 0.9f;
    float lumTresh = 0.2f;
    float barrelPower = 1.0f;
    float lightZeroOpaq = 0.0f;
    float pyrotechOpaq = 0.0f;
    float alaViivaOpaq = 0.0f;
    float ylaViivaOpaq = 0.0f;
    float vortexOpaq = 0.0f;
    float alaViivaXTrans = 0.0f;
    float ylaViivaXTrans = 0.0f;
    float pyrotechZoom = 1.0f;
    float vortexZoom = 1.0f;
    float credAikaOpaq = 0.0f;
    float credPharOpaq = 0.0f;
    float credAikaZoom = 1.0f;
    float credPharZoom = 1.0f;
    float syriaOpaq = 0.0f;
    float syriaZoom = 1.0f;
    float blackOpaq = 0.0f;
    float lensFactor = 1.0f;
    Random rand;
    float cameraChangeCooloOff = 0.0f;
    float logoPalloSync = 0.0f;

    public Retry(String windowTitle, int resolutionWidth, int resolutionHeight, int majorVersion, int minorVersion, boolean fullScreen, boolean vSync, int msaa, int anisotropy, int seed) throws IOException, Exception {
        super(windowTitle, resolutionWidth, resolutionHeight, majorVersion, minorVersion, fullScreen, vSync, msaa, anisotropy);
        this.tonemapParams.put("exposure", this.tonemapExposure);
        this.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.audio = new Audio("MDemo2017_2.mp3");
        this.rand = new Random(seed == -1 ? 667L : (long)seed);
    }

    @Override
    public void init() throws Exception {
        logger.info("initCameras()");
        this.initCameras();
        logger.info("initShaders()");
        this.initShaders();
        logger.info("createSkyBox()");
        this.createSkyBox();
        logger.info("initAssets()");
        this.initAssets();
        logger.info("initQuad()");
        this.initQuad();
        this.points = this.createPointModel();
        logger.info("windowVisible(true)");
        this.windowVisible(true);
        GLFW.glfwSetInputMode(this.window, 208897, 212995);
        logger.info("audio.play()");
        this.audio.play();
    }

    void initShaders() throws IOException {
        this.quadShader = this.createShader("shaders/texturedQuad.vs", "shaders/cubeTextureRef.fs");
        this.texSpher = this.createShader("shaders/texturedMorph.vs", "shaders/cubeTextureRef.fs");
        this.pointSpr = this.createShader("shaders/pointSprite.vs", "shaders/pointSprite.fs");
    }

    Model createPointModel() throws IOException {
        GL11.glEnable(34913);
        GL11.glEnable(34370);
        GL11.glEnable(34370);
        Texture pointSprTex = new Texture("textures/retry_64_pallo.png", this.anisotropy);
        Material pointSprMat = new Material("PointSprite mat", this.pointSpr);
        pointSprMat.addTexture("tex", pointSprTex).addTexture("tex2", new Texture("textures/bokeh2.png", 0));
        pointSprMat.setParameter("spriteSize", 10);
        float[] points = new float[30000];
        for (int i = 0; i < points.length; i += 3) {
            points[i] = this.rand.nextFloat() * -15.0f + this.rand.nextFloat() * 15.0f;
            points[i + 1] = this.rand.nextFloat() * -15.0f + this.rand.nextFloat() * 15.0f;
            points[i + 2] = this.rand.nextFloat() * -15.0f + this.rand.nextFloat() * 15.0f;
        }
        ArrayList<VertexLayout> layout = new ArrayList<VertexLayout>();
        layout.add(VertexLayout.POS);
        Mesh pointMesh = new Mesh("points", MeshType.POINTS, MeshFrontFace.CCW);
        pointMesh.setVertices(points, layout);
        pointMesh.uploadToGPU();
        Model pointModel = new Model("pointmodel", pointMesh, pointSprMat, null);
        pointModel.setRotSpd(-0.2f, 0.6f, 0.3f);
        pointModel.setPosition(-5.0f, 0.0f, 0.0f);
        return pointModel;
    }

    void createSkyBox() throws IOException {
        this.skyBoxShader = this.createShader("shaders/cubeTexture.vs", "shaders/cubeTexture.fs");
        logger.info("create skybox urban_hires");
        this.skyBox = new Skybox(this.skyBoxShader, "textures/urban_front_hires.png", "textures/urban_back_hires.png", "textures/urban_top_hires.png", "textures/urban_bottom_hires.png", "textures/urban_left_hires.png", "textures/urban_right_hires.png");
        this.skyBox.setProjection(45.0f, this.resolutionWidth, this.resolutionHeight, 0.1f, 100.0f);
        logger.info("create skybox aavikko");
        this.skyBoxAav = new Skybox(this.skyBoxShader, "textures/aavikko_front.png", "textures/aavikko_back.png", "textures/aavikko_top.png", "textures/aavikko_bottom.png", "textures/aavikko_left.png", "textures/aavikko_right.png");
        this.skyBoxAav.setProjection(45.0f, this.resolutionWidth, this.resolutionHeight, 0.1f, 100.0f);
        logger.info("create skybox lines");
        this.skyBoxLines = new Skybox(this.skyBoxShader, "textures/lines_front.jpg", "textures/lines_back.jpg", "textures/lines_top.jpg", "textures/lines_bottom.jpg", "textures/lines_left.jpg", "textures/lines_right.jpg");
        this.skyBoxLines.setProjection(45.0f, this.resolutionWidth, this.resolutionHeight, 0.1f, 100.0f);
        this.skyBoxLines.setBlackIsOpaque(false);
        this.skyBoxLines.setTint(0.75f, 0.0f, 1.0f);
        this.skyBoxLines.setOpaqueness(0.0f);
    }

    void initQuad() throws IOException {
        float[] vertices = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f};
        int[] indices = new int[]{0, 1, 2, 1, 3, 2};
        ArrayList<VertexLayout> layout = new ArrayList<VertexLayout>();
        layout.add(VertexLayout.POS);
        layout.add(VertexLayout.TEXCOORD1);
    }

    void initCameras() {
        this.fpsCam = new FreeCamera(45.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f);
        this.mainCam = new LookAtCamera(45.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f, new Vector3f(0.0f, 0.0f, 4.0f), new Vector3f(0.0f, 0.0f, 0.0f));
        this.cameras.add(this.mainCam);
        this.cameras.add(new LookAtCamera(45.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f, new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        this.cameras.add(new LookAtCamera(45.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f, new Vector3f(0.0f, 3.0f, 3.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        this.cameras.add(new LookAtCamera(45.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f, new Vector3f(0.0f, 0.0f, 4.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        this.cameras.add(new LookAtCamera(45.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f, new Vector3f(0.0f, 0.0f, 5.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        this.cameras.add(new LookAtCamera(45.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f, new Vector3f(-50.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        this.curCam = this.mainCam;
    }

    void initAssets() throws IOException, URISyntaxException {
        this.texture2 = new Texture("textures/lava01.jpg", this.anisotropy);
        Texture logoPalloTex = new Texture("textures/pyro_logo.png", this.anisotropy);
        this.bkgTex2 = new Texture("textures/decal_alpha.png", 0);
        this.lensTex = new Texture("textures/lens_green.jpg", 0);
        this.paraffin = new Texture("textures/decal_alpha.png", 0);
        this.pyrotech = new Texture("textures/pyrotech_logo.png", 0);
        this.alaViiva = new Texture("textures/viiva.png", 0);
        this.ylaViiva = new Texture("textures/viiva2.png", 0);
        this.vortex = new Texture("textures/vortex_6_orig.png", 0);
        this.lightZero = new Texture("textures/light_zero_logo_720.png", 0);
        this.credPhar = new Texture("textures/credits_phara.png", 0);
        this.credAika = new Texture("textures/credits_aikapallo.png", 0);
        this.syria = new Texture("textures/syria.jpg", 0);
        this.black = new Texture("textures/black_screen.jpg", 0);
        GL11.glDisable(2884);
        GL11.glEnable(32926);
        GL11.glEnable(2929);
        MeshGenerator mGen = new MeshGenerator();
        Mesh sEllip = mGen.genSuperEllipsoid2(0.6, 0.6, 3.0, 3.0, 512);
        sEllip.uploadToGPU();
        Texture tex = new Texture("textures/sateenkaari_sphericalmap_color.jpg", this.anisotropy);
        this.sEllipsMat = new Material("SuperEllipsoid material", this.texSpher);
        this.sEllipsMat.addTexture("tex", tex).addTexture("cube_texture", this.skyBoxAav.getTexture()).addTexture("cube_texture2", this.skyBoxLines.getTexture()).addTexture("cube_texture3", this.skyBox.getTexture());
        this.sEllipsMat.setParameter("morph_factor", Float.valueOf(0.0f));
        float[] tint = new float[]{this.skyBoxLines.getTint().x, this.skyBoxLines.getTint().y, this.skyBoxLines.getTint().z};
        this.sEllipsMat.setParameter("ref2_tint", tint);
        this.sEllipsMat.setParameter("diffuse_tex_factor", Float.valueOf(1.0f));
        this.sEllipsMat.setParameter("reflection_factor", Float.valueOf(1.0f));
        this.sEllipsMat.setParameter("black_is_opaque", 1);
        this.sEllipsMat.setParameter("ref3_opaq", 0);
        this.sEllips = new Model("SuperEllipsoidMod", sEllip, this.sEllipsMat, null);
        this.sEllips.setRotSpd(-38.0f, -35.0f, 39.0f);
        this.sEllips.setPosition(0.0f, 0.0f, 0.0f);
        this.sEllips.setScale(1.0f, 1.0f, 1.0f);
        Mesh logoPalloMesh = mGen.genSuperEllipsoid(1.0, 1.0, 128);
        logoPalloMesh.uploadToGPU();
        this.logoPalloMat = new Material("SuperEllipsoid material not morphing", this.texSpher);
        this.logoPalloMat.addTexture("tex", logoPalloTex);
        this.logoPalloMat.setParameter("morph_factor", Float.valueOf(0.0f));
        this.logoPalloMat.setParameter("reflection_factor", Float.valueOf(0.0f));
        this.logoPalloMat.setParameter("diffuse_tex_factor", Float.valueOf(0.0f));
        this.logoPalloMat.setParameter("black_is_opaque", 0);
        this.logoPallo = new Model("SuperEllipsoidMod2", logoPalloMesh, this.logoPalloMat, null);
        this.logoPallo.setRotSpd(0.0f, 0.0f, 20.0f);
        this.logoPallo.setRotation(270.0f, 0.0f, 0.0f);
        this.logoPallo.setPosition(0.0f, 0.0f, 0.0f);
        this.logoPallo.setScale(1.0f, 1.0f, 1.0f);
    }

    public void genRandomModel() {
        float y;
        Model m = new Model("m" + this.rand.nextInt(), this.sEllips2Mesh, this.sEllipsMat2, null);
        this.models.add(m);
        m.setRotSpd(this.rand.nextFloat() * 50.0f, this.rand.nextFloat() * 50.0f, this.rand.nextFloat() * 50.0f);
        float x = 20.0f - this.rand.nextFloat() * 40.0f;
        if (x <= 5.0f && x >= 0.0f) {
            x = -this.rand.nextFloat() * 10.0f;
        }
        if ((y = 20.0f - this.rand.nextFloat() * 40.0f) <= 5.0f && y >= 0.0f) {
            y = -this.rand.nextFloat() * 10.0f;
        }
        m.setPosition(x, y, -20.0f - this.rand.nextFloat() * 30.0f);
        m.setMoveSpd(0.0f, 0.0f, 2 + this.rand.nextInt(10));
        m.setScale(0.8f, 0.8f, 0.8f);
    }

    public Camera getRandomCamera() {
        int ind = this.rand.nextInt(this.cameras.size() - 1);
        return this.cameras.get(ind);
    }

    @Override
    public void updateFrame(double delta, double time) {
        if (time >= 125.0) {
            this.exit();
        }
        this.audioSync = this.audio.getAvgRange(50, 128, 2.0f);
        float audioSync2 = this.audio.getAvgRange(0, 30);
        float audioSync3 = this.audio.getAvgRange(0, 20, 2.0f);
        float fullAudioSpec = this.audio.getAvgRange(0, 128, 20.0f);
        this.lensFactor = 0.8f + fullAudioSpec;
        this.barrelPower = 0.5f + this.audioSync * 2.0f;
        this.lumTresh = 0.8f - audioSync3;
        if (fullAudioSpec > 0.49f && this.cameraChangeCooloOff < 0.1f) {
            this.curCam = this.getRandomCamera();
            this.cameraChangeCooloOff = 1.0f;
        }
        if (this.cameraChangeCooloOff > 0.0f) {
            this.cameraChangeCooloOff -= 0.01f;
        }
        this.logoPalloMat.setParameter("diffuse_tex_factor", Float.valueOf(fullAudioSpec));
        this.logoPallo.setScale(1.0f + fullAudioSpec, 1.0f + fullAudioSpec, 1.0f + fullAudioSpec);
        float angle = (float)(-time) * 0.1f;
        float angle2 = (float)(-time) * 0.8f;
        float angle3 = (float)time * 0.6f;
        this.mainCam.setLookAt(0.0f, 0.0f, 0.0f);
        this.mainCam.setPosition(2.0f * (float)(Math.cos(angle) - Math.sin(angle)), 0.0f, 2.0f * (float)(Math.sin(angle) + Math.cos(angle)));
        this.cameras.get(2).setPosition(3.0f, 3.0f, (float)Math.sin(audioSync3) * 2.0f);
        this.cameras.get(3).setLookAt(0.0f, 0.0f, 0.0f);
        this.cameras.get(3).setPosition(2.0f * (float)(Math.cos(angle2) - Math.sin(angle2)), 0.0f, 2.0f * (float)(Math.sin(angle2) + Math.cos(angle2)));
        this.cameras.get(4).setLookAt(2.0f, -1.5f, 1.0f);
        this.cameras.get(4).setPosition(0.0f, 5.0f * (float)(Math.cos(angle3) - Math.sin(angle3)), 5.0f * (float)(Math.sin(angle3) + Math.cos(angle3)));
        Vector3f cam6Lat = this.cameras.get(5).getLookAt();
        Vector3f cam6Pos = this.cameras.get(5).getPosition();
        this.cameras.get(5).setLookAt(cam6Lat.x, 0.0f, 0.0f);
        this.cameras.get(5).setPosition(cam6Pos.x, 0.0f, cam6Pos.z - 0.01f);
        this.sEllipsMat.setParameter("morph_factor", Float.valueOf((float)(Math.sin(time) + Math.cos(time))));
        this.skyBoxLines.setOpaqueness(this.audioSync);
        this.sEllipsMat.setParameter("ref2_opaq", Float.valueOf(this.audioSync));
        System.out.println("time: " + time);
        if (time >= 1.5 && time <= 8.5) {
            this.ylaViivaXTrans += 0.004f;
            this.alaViivaXTrans -= 0.004f;
            this.pyrotechZoom += 0.001f;
        }
        if (time >= 1.5 && time < (double)1.6f) {
            this.tonemapExposure = Float.valueOf(1.0f);
            this.exposureCounterDec.setValue(7.5f);
            this.pyrotechOpaq = 1.0f;
            this.alaViivaOpaq = 1.0f;
            this.ylaViivaOpaq = 1.0f;
        } else if (time >= 8.5 && time < (double)8.6f) {
            this.exposureCounterDec.setValue(7.5f);
            this.pyrotechOpaq = 0.0f;
            this.alaViivaOpaq = 0.0f;
            this.ylaViivaOpaq = 0.0f;
            this.vortexOpaq = 1.0f;
        } else if (time > 8.5 && time < 15.5) {
            this.vortexZoom += 0.001f;
        } else if (time >= 15.5 && time < (double)15.6f) {
            this.exposureCounterDec.setValue(7.5f);
            this.vortexOpaq = 0.0f;
        } else if (time > 29.0) {
            float ref3_opaq;
            this.skyBoxOpaq = 1.0f - ((float)time - 29.0f) * 0.5f;
            if (this.skyBoxOpaq < 0.0f) {
                this.skyBoxOpaq = 0.0f;
            }
            this.sEllipsMat.setParameter("ref3_opaq", Float.valueOf((ref3_opaq = ((float)time - 29.0f) * 0.5f) > 1.0f ? 1.0f : ref3_opaq));
            this.sEllipsMat.setParameter("reflection_factor", Float.valueOf(this.skyBoxOpaq > 1.0f ? 1.0f : this.skyBoxOpaq));
            if (this.bloomFactor < 1.5f) {
                this.bloomFactor += ref3_opaq;
            }
            if (time < 35.0 && this.lightZeroOpaq < 1.0f) {
                this.lightZeroOpaq += 0.01f;
            }
        }
        if (time > 35.0) {
            this.lightZeroOpaq -= 0.01f;
        }
        if (time > (double)42.8f && time < (double)47.8f) {
            this.credAikaOpaq = 1.0f;
            this.credAikaZoom += 0.001f;
        }
        if (time >= (double)47.8f) {
            this.credAikaOpaq = 0.0f;
        }
        if (time > (double)49.8f && time < (double)54.8f) {
            this.credPharOpaq = 1.0f;
            this.credPharZoom += 0.001f;
        }
        if (time > (double)54.8f) {
            this.credPharOpaq = 0.0f;
        }
        if (time > 60.0 && time < 62.0) {
            this.syriaOpaq = audioSync2 + this.audioSync;
            this.syriaZoom += 0.005f;
        }
        if (time > 62.0 && time < 63.0 && this.syriaOpaq > 0.0f) {
            this.syriaOpaq -= 0.1f;
        }
        if (time > 70.0 && time < 72.0) {
            this.syriaOpaq = audioSync2 + this.audioSync;
            this.syriaZoom += 0.005f;
        }
        if (time > 72.0 && time < 73.0 && this.syriaOpaq > 0.0f) {
            this.syriaOpaq -= 0.1f;
        }
        if (time > 120.0) {
            this.blackOpaq += 0.01f;
        }
        if (this.tonemapExposure.floatValue() != 0.0f) {
            this.tonemapExposure = Float.valueOf(this.exposureCounterDec.change());
        }
        this.sEllips.update(delta, time);
        this.logoPallo.update(delta, time);
        this.points.update(delta, time);
        this.fpsCam.update(delta);
        this.curCam.update(delta);
        this.skyBoxAav.setOpaqueness(this.skyBoxOpaq);
    }

    @Override
    public void renderFrame(double alpha, double time) {
        if (this.toggleFreeCam) {
            this.view = this.fpsCam.getView();
            this.proj = this.fpsCam.getProjection();
            this.viewProj = this.fpsCam.getViewProjection();
        } else {
            this.view = this.curCam.getView();
            this.proj = this.curCam.getProjection();
            this.viewProj = this.curCam.getViewProjection();
        }
        this.skyBox.draw(this.view, null);
        this.skyBoxLines.draw(this.view, null);
        if (time < 31.0) {
            this.skyBoxAav.draw(this.view, null);
        }
        this.sEllips.draw(this.viewProj, this.view, this.proj);
        this.params.clear();
        this.params.put("opaqueness", Float.valueOf(this.audioSync));
        this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.paraffin, true, this.params);
        GL11.glEnable(3042);
        GL11.glBlendFunc(1, 1);
        this.logoPallo.draw(this.viewProj, this.view, this.proj);
        this.points.draw(this.viewProj, this.view, this.proj);
        if (this.lightZeroOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.lightZeroOpaq));
            this.params.put("scale", Float.valueOf(1.0f + this.audioSync));
            this.params.put("xTrans", Float.valueOf(0.0f));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.lightZero, true, this.params);
        }
        if (this.pyrotechOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.pyrotechOpaq));
            this.params.put("scale", Float.valueOf(this.pyrotechZoom));
            this.params.put("xTrans", Float.valueOf(0.0f));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.pyrotech, true, this.params);
        }
        if (this.alaViivaOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.alaViivaOpaq));
            this.params.put("scale", Float.valueOf(1.0f));
            this.params.put("xTrans", Float.valueOf(this.alaViivaXTrans));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.alaViiva, true, this.params);
        }
        if (this.ylaViivaOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.ylaViivaOpaq));
            this.params.put("scale", Float.valueOf(1.0f));
            this.params.put("xTrans", Float.valueOf(this.ylaViivaXTrans));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.ylaViiva, true, this.params);
        }
        if (this.syriaOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.syriaOpaq));
            this.params.put("scale", Float.valueOf(this.syriaZoom));
            this.params.put("xTrans", Float.valueOf(0.0f));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.syria, true, this.params);
        }
        GL11.glDisable(3042);
        if (this.credAikaOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.credAikaOpaq));
            this.params.put("scale", Float.valueOf(this.credAikaZoom));
            this.params.put("xTrans", Float.valueOf(0.0f));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.credAika, true, this.params);
        }
        if (this.credPharOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.credPharOpaq));
            this.params.put("scale", Float.valueOf(this.credPharZoom));
            this.params.put("xTrans", Float.valueOf(0.0f));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.credPhar, true, this.params);
        }
        if (this.vortexOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.vortexOpaq));
            this.params.put("scale", Float.valueOf(this.vortexZoom));
            this.params.put("xTrans", Float.valueOf(0.0f));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.vortex, true, this.params);
        }
        if (this.blackOpaq > 0.0f) {
            this.params.put("opaqueness", Float.valueOf(this.blackOpaq));
            this.params.put("scale", Float.valueOf(1.0f));
            this.params.put("xTrans", Float.valueOf(0.0f));
            this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.black, true, this.params);
        }
    }

    @Override
    public void handleKey(int key, int scancode, int action, int mods) {
        if (key == 257 && action == 0 && mods == 4) {
            this.toggleFullscreen();
        }
        if (key == 67 && action == 1) {
            this.toggleFreeCam = !this.toggleFreeCam;
        } else if (key == 66 && action == 1) {
            this.toggleBloom = !this.toggleBloom;
        } else if (key == 76 && action == 1) {
            this.toggleLens = !this.toggleLens;
        } else if (key == 78 && action == 1) {
            if (this.camIndex < this.cameras.size()) {
                ++this.camIndex;
            }
            if (this.camIndex >= this.cameras.size()) {
                this.camIndex = 0;
            }
            this.curCam = this.cameras.get(this.camIndex);
        }
        if (this.toggleFreeCam) {
            this.fpsCam.handleKey(key, scancode, action, mods);
        }
    }

    @Override
    public void handleMouseButton(long window, int button, int action, int mods) {
    }

    @Override
    public void handleCursorPosition(long window, double xpos, double ypos) {
        if (this.toggleFreeCam) {
            GLFW.glfwSetInputMode(window, 208897, 212995);
            this.fpsCam.handleCursorPosition(window, xpos, ypos);
        } else {
            GLFW.glfwSetInputMode(window, 208897, 212993);
        }
    }

    @Override
    public void handleScroll(long window, double xoffset, double yoffset) {
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Arrays.toString(args));
        try (Retry g = new Retry("Retry", 1280, 720, 3, 3, true, false, 8, 8, args.length == 0 || args[0] == null ? -1 : Integer.parseInt(args[0]));){
            g.run();
        }
    }

    @Override
    public void close() throws Exception {
        this.audio.stop();
        System.exit(0);
    }

    @Override
    public void postProcessFrame(double time) {
        Texture blurred = null;
        if (this.toggleBloom) {
            this.params.clear();
            this.params.put("LumTresh", Float.valueOf(this.lumTresh));
            this.params.put("lensFactor", Float.valueOf(this.lensFactor));
            this.postProcessEffect("shaders/postProcessBrightPass.fs", this.params, this.toggleLens ? this.lensTex : null, null);
            this.params.put("NumSamples", 12);
            this.params.put("vTint", new float[]{0.7f, 0.2f, 0.9f, 1.0f});
            this.params.put("fTexScale", Float.valueOf(0.5f));
            this.params.put("fBlurScale", Float.valueOf(0.1f));
            this.postProcessEffect("shaders/postProcessLens.fs", this.params);
            this.params.put("dir", new float[]{1.0f, 0.0f});
            this.postProcessEffect("shaders/postProcessBlur.fs", this.params);
            this.params.put("dir", new float[]{0.0f, 1.0f});
            this.postProcessEffect("shaders/postProcessBlur.fs", this.params);
            this.params.put("dir", new float[]{1.0f, 0.0f});
            this.postProcessEffect("shaders/postProcessBlur.fs", this.params);
            this.params.put("dir", new float[]{0.0f, 1.0f});
            blurred = this.postProcessEffect("shaders/postProcessBlur.fs", this.params, true, null);
            this.resetPostProcess();
        }
        this.tonemapParams.put("exposure", this.tonemapExposure);
        this.tonemapParams.put("bloomFactor", Float.valueOf(this.bloomFactor));
        Texture toneMapped = this.postProcessEffect("shaders/postProcessTonemap.fs", this.tonemapParams, true, blurred);
        this.postProcessEffect("shaders/postProcessVignette.fs");
    }
}

