/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.eggine;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import net.exitus.gfxlib.resources.CubeTexture;
import net.exitus.gfxlib.resources.Mesh;
import net.exitus.gfxlib.resources.Texture;
import net.exitus.gfxlib.shader.Shader;
import net.exitus.gfxlib.utils.loaders.JSONModelLoader;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;

public class Skybox {
    protected static final Logger logger = Logger.getLogger(Skybox.class.getName());
    private Mesh mesh;
    private CubeTexture cubeTex;
    private Shader shader;
    private Matrix4f transformation = new Matrix4f().scale(100.0f);
    private Matrix4f projection = new Matrix4f();
    private boolean blackIsOpaque = true;
    private Vector3f tint = new Vector3f(0.0f, 0.0f, 0.0f);
    private float opaqueness = 1.0f;

    public Skybox(Shader shader, String front, String back, String top, String bottom, String left, String right) throws IOException {
        this();
        this.shader = shader;
        this.cubeTex = new CubeTexture(front, back, top, bottom, left, right, true);
    }

    public void setProjection(float fov, float width, float height, float near, float far) {
        this.projection.setPerspective((float)Math.toRadians(fov), width / height, near, far);
    }

    public void setBlackIsOpaque(boolean flag) {
        this.blackIsOpaque = flag;
    }

    public void setOpaqueness(float val) {
        this.opaqueness = val;
    }

    public void setTint(float r, float g, float b) {
        this.tint.x = r;
        this.tint.y = g;
        this.tint.z = b;
    }

    public Vector3f getTint() {
        return this.tint;
    }

    private Skybox() throws IOException {
        JSONModelLoader loader = null;
        try {
            loader = new JSONModelLoader("models/test_model.json");
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        logger.info("loader.parseMesh(cube)");
        this.mesh = loader.parseMesh("cube");
        logger.info("Upload cube to GPU!");
        this.mesh.uploadToGPU();
    }

    public Texture getTexture() {
        return this.cubeTex;
    }

    public void draw(Matrix4f view, Matrix4f proj) {
        this.shader.bind();
        this.shader.setVariable("black_is_opaque", this.blackIsOpaque ? 1 : 0);
        this.shader.setVariable("tint", this.tint.x, this.tint.y, this.tint.z);
        this.shader.setVariable("opaqueness", this.opaqueness);
        Matrix4f v = new Matrix4f(view);
        v.setTranslation(0.0f, 0.0f, 0.0f);
        Matrix4f mvp = new Matrix4f(proj == null ? this.projection : proj);
        mvp.mul(v);
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer fb = stack.callocFloat(16);
            this.shader.setVariable("mvp", mvp.get(fb));
        }
        this.cubeTex.bind(0);
        GL11.glDisable(2929);
        GL11.glDisable(2884);
        this.mesh.draw();
        GL11.glEnable(2929);
        this.cubeTex.unbind();
        this.shader.unbind();
    }
}

