/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.bgfx;

import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.exitus.gfxlib.GfxApp;
import net.exitus.gfxlib.bgfx.BgfxUtils;
import net.exitus.gfxlib.utils.Utils;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.bgfx.BGFX;
import org.lwjgl.bgfx.BGFXPlatform;
import org.lwjgl.bgfx.BGFXPlatformData;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWNativeCocoa;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.glfw.GLFWNativeX11;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Platform;

public abstract class BgfxApp
implements GfxApp {
    private static final Logger logger = Logger.getLogger(BgfxApp.class.getName());
    private GLFWErrorCallback errorCallback;
    private GLFWKeyCallback keyCallback;
    private GLFWFramebufferSizeCallback resizeCallback;
    private long window;
    GLFWVidMode vidmode;
    private int[] wPos;
    private CharSequence windowTitle;
    protected int resolutionWidth = 320;
    protected int resolutionHeight = 240;
    private boolean fullScreen = false;
    private boolean vSync = true;
    private boolean printStats = false;

    public BgfxApp() throws IOException {
        System.setProperty("org.lwjgl.librarypath", "lib");
        LogManager.getLogManager().readConfiguration(this.getFileStream("logging.properties"));
    }

    public BgfxApp(String windowTitle, int resolutionWidth, int resolutionHeight, boolean fullScreen, boolean vSync) throws IOException {
        this();
        this.windowTitle = windowTitle;
        this.resolutionWidth = resolutionWidth;
        this.resolutionHeight = resolutionHeight;
        this.fullScreen = fullScreen;
        this.vSync = vSync;
        this.internalInit();
    }

    @Override
    public abstract void renderFrame(double var1, double var3);

    @Override
    public abstract void init() throws Exception;

    @Override
    public abstract void handleKey(int var1, int var2, int var3, int var4);

    private void setWindowHints() {
        GLFW.glfwWindowHint(139265, 0);
        GLFW.glfwWindowHint(131076, 0);
    }

    private void internalInit() {
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW!");
        }
        this.errorCallback = GLFWErrorCallback.createPrint(System.err);
        GLFW.glfwSetErrorCallback(this.errorCallback);
        this.setWindowHints();
        this.window = GLFW.glfwCreateWindow(this.resolutionWidth, this.resolutionHeight, this.windowTitle, this.fullScreen ? GLFW.glfwGetPrimaryMonitor() : 0L, 0L);
        if (this.window == 0L) {
            GLFW.glfwTerminate();
            throw new RuntimeException("Failed to create the GLFW window!");
        }
        this.keyCallback = new GLFWKeyCallback(){

            @Override
            public void invoke(long window, int key, int scancode, int action, int mods) {
                BgfxApp.this.handleKey(key, scancode, action, mods);
                logger.log(Level.FINEST, "char: {0} key: {1} scancode: {2} action: {3} mods: {4}", new Object[]{Character.valueOf((char)key), key, scancode, action, mods});
                if (key == 256 && action == 0) {
                    GLFW.glfwSetWindowShouldClose(window, true);
                } else if (key == 73 && action == 1) {
                    BgfxApp.this.printStats = !BgfxApp.this.printStats;
                }
            }
        };
        GLFW.glfwSetKeyCallback(this.window, this.keyCallback);
        this.resizeCallback = new GLFWFramebufferSizeCallback(){

            @Override
            public void invoke(long window, int width, int height) {
                BgfxApp.this.resolutionWidth = width;
                BgfxApp.this.resolutionHeight = height;
                logger.log(Level.CONFIG, "Current resolution: " + BgfxApp.this.resolutionWidth + "x" + BgfxApp.this.resolutionHeight);
                BGFX.bgfx_reset(BgfxApp.this.resolutionWidth, BgfxApp.this.resolutionHeight, BgfxApp.this.vSync ? 128 : 0);
            }
        };
        GLFW.glfwSetFramebufferSizeCallback(this.window, this.resizeCallback);
        this.vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        try (MemoryStack stack = MemoryStack.stackPush();){
            BGFXPlatformData platformData = BGFXPlatformData.callocStack(stack);
            switch (Platform.get()) {
                case LINUX: {
                    platformData.ndt(GLFWNativeX11.glfwGetX11Display());
                    platformData.nwh(GLFWNativeX11.glfwGetX11Window(this.window));
                    break;
                }
                case MACOSX: {
                    platformData.ndt(0L);
                    platformData.nwh(GLFWNativeCocoa.glfwGetCocoaWindow(this.window));
                    break;
                }
                case WINDOWS: {
                    platformData.ndt(0L);
                    platformData.nwh(GLFWNativeWin32.glfwGetWin32Window(this.window));
                }
            }
            platformData.context(0L);
            platformData.backBuffer(0L);
            platformData.backBufferDS(0L);
            BGFXPlatform.bgfx_set_platform_data(platformData);
        }
        if (!BGFX.bgfx_init(7, 0, 0, null, null)) {
            throw new RuntimeException("Error initializing bgfx renderer");
        }
        BgfxUtils.printRenderers();
        BGFX.bgfx_reset(this.resolutionWidth, this.resolutionHeight, 128);
        BgfxUtils.zZeroToOne = !BGFX.bgfx_get_caps().homogeneousDepth();
        BGFX.bgfx_set_debug(8);
        this.setClearColor(0.4f, 0.6f, 0.9f, 1.0f);
        BGFX.bgfx_set_state(0x100001000000017L, 0);
        GLFW.glfwShowWindow(this.window);
    }

    private boolean shouldExit() {
        return GLFW.glfwWindowShouldClose(this.window);
    }

    protected final void setClearColor(float r, float g, float b, float a) {
        int rr = (int)(r * 255.0f);
        int gg = (int)(g * 255.0f);
        int bb = (int)(b * 255.0f);
        int aa = (int)(a * 255.0f);
        BGFX.bgfx_set_view_clear(0, 3, (rr << 24) + (gg << 16) + (bb << 8) + aa, 1.0f, 0);
    }

    private void setViewport() {
        IntBuffer width = BufferUtils.createIntBuffer(1);
        IntBuffer height = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetFramebufferSize(this.window, width, height);
        this.resolutionWidth = width.get();
        this.resolutionHeight = height.get();
        BGFX.bgfx_set_view_rect(0, 0, 0, this.resolutionWidth, this.resolutionHeight);
    }

    protected final int[] getWindowPosition() {
        IntBuffer wPosX = BufferUtils.createIntBuffer(1);
        IntBuffer wPosY = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetWindowPos(this.window, wPosX, wPosY);
        return new int[]{wPosX.get(), wPosY.get()};
    }

    protected final void toggleFullscreen() {
        if (!this.fullScreen) {
            this.wPos = this.getWindowPosition();
        }
        this.fullScreen = !this.fullScreen;
        this.setWindowHints();
        GLFW.glfwSetWindowMonitor(this.window, this.fullScreen ? GLFW.glfwGetPrimaryMonitor() : 0L, this.wPos[0], this.wPos[1], this.resolutionWidth, this.resolutionHeight, this.vidmode.refreshRate());
    }

    protected final void run() {
        long lastTime;
        try {
            this.init();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
            logger.log(Level.SEVERE, "Exiting application...");
            return;
        }
        long startTime = lastTime = GLFW.glfwGetTimerValue();
        while (!this.shouldExit()) {
            long now = GLFW.glfwGetTimerValue();
            long frameTime = now - lastTime;
            lastTime = now;
            double freq = GLFW.glfwGetTimerFrequency();
            double toMs = 1000.0 / freq;
            double time = (double)(now - startTime) / freq;
            this.setViewport();
            BGFX.bgfx_touch(0);
            this.renderFrame(frameTime, time);
            this.printStats();
            BGFX.bgfx_frame(false);
            GLFW.glfwPollEvents();
        }
    }

    protected final InputStream getFileStream(String name) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream(name);
    }

    protected final String getFilePath(String name) {
        return Utils.getDir(name);
    }

    protected final void printResolutions() {
        logger.log(Level.CONFIG, "Primary monitor: {0}", GLFW.glfwGetMonitorName(GLFW.glfwGetPrimaryMonitor()));
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        for (int i = 0; i < monitors.limit(); ++i) {
            long monitor = monitors.get(i);
            logger.log(Level.CONFIG, GLFW.glfwGetMonitorName(GLFW.glfwGetPrimaryMonitor()));
            logger.log(Level.CONFIG, "--------------------------");
            GLFWVidMode.Buffer modes = GLFW.glfwGetVideoModes(monitor);
            for (int j = 0; j < modes.limit(); ++j) {
                GLFWVidMode mode = (GLFWVidMode)modes.get(j);
                logger.log(Level.CONFIG, mode.width() + "x" + mode.height() + "@" + mode.refreshRate());
            }
        }
    }

    @Override
    public void close() throws Exception {
        logger.log(Level.CONFIG, "Freeing graphics system resources...");
        BGFX.bgfx_shutdown();
        GLFW.glfwDestroyWindow(this.window);
        this.keyCallback.free();
        this.resizeCallback.free();
        GLFW.glfwTerminate();
        this.errorCallback.free();
    }

    @Override
    public void renderDebugText(String text, int x, int y) {
        BGFX.bgfx_dbg_text_clear(0, false);
        BGFX.bgfx_dbg_text_printf(x, y, 79, text);
    }

    private void printStats() {
        if (this.printStats) {
            BGFX.bgfx_set_debug(4);
        } else {
            BGFX.bgfx_set_debug(8);
        }
    }

    @Override
    public void windowVisible(boolean flag) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

