/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.bgfx;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.exitus.gfxlib.utils.Utils;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.bgfx.BGFX;
import org.lwjgl.bgfx.BGFXMemory;
import org.lwjgl.bgfx.BGFXReleaseFunctionCallbackI;
import org.lwjgl.bgfx.BGFXVertexDecl;
import org.lwjgl.system.MemoryUtil;

public class BgfxUtils {
    private static final Logger logger = Logger.getLogger(BgfxUtils.class.getName());
    private static BGFXReleaseFunctionCallbackI releaseMemoryCb = (_ptr, _userData) -> MemoryUtil.nmemFree(_ptr);
    static boolean zZeroToOne;

    static void printRenderers() {
        int[] rendererTypes = new int[9];
        int count = BGFX.bgfx_get_supported_renderers(rendererTypes);
        logger.log(Level.CONFIG, "Renderers supported:");
        for (int i = 0; i < count; ++i) {
            logger.log(Level.CONFIG, "    " + BGFX.bgfx_get_renderer_name(rendererTypes[i]));
        }
        logger.log(Level.CONFIG, "Current renderer: " + BGFX.bgfx_get_renderer_name(BGFX.bgfx_get_renderer_type()));
    }

    public static BGFXVertexDecl createVertexDecl(boolean withNormals, boolean withColor, int numUVs) {
        BGFXVertexDecl decl = BGFXVertexDecl.calloc();
        BGFX.bgfx_vertex_decl_begin(decl, BGFX.bgfx_get_renderer_type());
        BGFX.bgfx_vertex_decl_add(decl, 0, 3, 4, false, false);
        if (withNormals) {
            BGFX.bgfx_vertex_decl_add(decl, 1, 3, 4, false, false);
        }
        if (withColor) {
            BGFX.bgfx_vertex_decl_add(decl, 4, 4, 0, true, false);
        }
        if (numUVs > 0) {
            BGFX.bgfx_vertex_decl_add(decl, 8, 2, 4, false, false);
        }
        BGFX.bgfx_vertex_decl_end(decl);
        return decl;
    }

    public static short createVertexBuffer(ByteBuffer buffer, BGFXVertexDecl decl, Object[][] vertices) {
        Object[][] objectArray = vertices;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] vtx;
            for (Object attr : vtx = objectArray[i]) {
                if (attr instanceof Float) {
                    buffer.putFloat(((Float)attr).floatValue());
                    continue;
                }
                if (attr instanceof Integer) {
                    buffer.putInt((Integer)attr);
                    continue;
                }
                throw new RuntimeException("Invalid parameter type");
            }
        }
        if (buffer.remaining() != 0) {
            throw new RuntimeException("ByteBuffer size and number of arguments do not match");
        }
        buffer.flip();
        return BgfxUtils.createVertexBuffer(buffer, decl);
    }

    public static short createVertexBuffer(ByteBuffer buffer, BGFXVertexDecl decl) {
        BGFXMemory vbhMem = BGFX.bgfx_make_ref(buffer);
        return BGFX.bgfx_create_vertex_buffer(vbhMem, decl, 0);
    }

    public static short createIndexBuffer(ByteBuffer buffer, int[] indices) {
        for (int idx : indices) {
            buffer.putShort((short)idx);
        }
        if (buffer.remaining() != 0) {
            throw new RuntimeException("ByteBuffer size and number of arguments do not match");
        }
        buffer.flip();
        BGFXMemory ibhMem = BGFX.bgfx_make_ref(buffer);
        return BGFX.bgfx_create_index_buffer(ibhMem, 0);
    }

    private static ByteBuffer loadResource(String resourcePath, String name) throws IOException {
        String path = "file:\\" + resourcePath.replace("/", "\\");
        logger.log(Level.INFO, "Loading resource " + name + " from " + path);
        URL url = new URL(path + name);
        if (url == null) {
            throw new IOException("Resource not found: " + path + name);
        }
        int resourceSize = url.openConnection().getContentLength();
        logger.log(Level.CONFIG, "bgfx: loading resource '" + url.getFile() + "' (" + resourceSize + " bytes)");
        ByteBuffer resource = MemoryUtil.memAlloc(resourceSize);
        try (BufferedInputStream bis = new BufferedInputStream(url.openStream());){
            int b;
            do {
                if ((b = bis.read()) == -1) continue;
                resource.put((byte)b);
            } while (b != -1);
        }
        resource.flip();
        return resource;
    }

    public static short loadShader(String name) throws IOException {
        String resourcePath = Utils.getResourceDir() + "shaders/";
        switch (BGFX.bgfx_get_renderer_type()) {
            case 2: 
            case 3: {
                resourcePath = resourcePath + "dx11/";
                break;
            }
            case 1: {
                resourcePath = resourcePath + "dx9/";
                break;
            }
            case 7: {
                resourcePath = resourcePath + "glsl/";
                break;
            }
            case 5: {
                resourcePath = resourcePath + "metal/";
                break;
            }
            default: {
                throw new IOException("No shaders supported for " + BGFX.bgfx_get_renderer_name(BGFX.bgfx_get_renderer_type()) + " renderer");
            }
        }
        ByteBuffer shaderCode = BgfxUtils.loadResource(resourcePath, name + ".bin");
        return BGFX.bgfx_create_shader(BGFX.bgfx_make_ref_release(shaderCode, releaseMemoryCb, 0L));
    }

    public static short loadShader(char[] shaderCodeGLSL, char[] shaderCodeD3D9, char[] shaderCodeD3D11, char[] shaderCodeMtl) throws IOException {
        char[] sc;
        switch (BGFX.bgfx_get_renderer_type()) {
            case 2: 
            case 3: {
                sc = shaderCodeD3D11;
                break;
            }
            case 1: {
                sc = shaderCodeD3D9;
                break;
            }
            case 7: {
                sc = shaderCodeGLSL;
                break;
            }
            case 5: {
                sc = shaderCodeMtl;
                break;
            }
            default: {
                throw new IOException("No shaders supported for " + BGFX.bgfx_get_renderer_name(BGFX.bgfx_get_renderer_type()) + " renderer");
            }
        }
        ByteBuffer shaderCode = MemoryUtil.memAlloc(sc.length);
        for (char c : sc) {
            shaderCode.put((byte)c);
        }
        shaderCode.flip();
        return BGFX.bgfx_create_shader(BGFX.bgfx_make_ref_release(shaderCode, releaseMemoryCb, 0L));
    }

    public static short loadTexture(String fileName) throws IOException {
        ByteBuffer textureData = BgfxUtils.loadResource(Utils.getResourceDir(), fileName);
        BGFXMemory textureMemory = BGFX.bgfx_make_ref_release(textureData, releaseMemoryCb, 0L);
        return BGFX.bgfx_create_texture(textureMemory, 0, 0, null);
    }

    public static void lookAt(Vector3f at, Vector3f eye, Matrix4f dest) {
        dest.setLookAtLH(eye.x, eye.y, eye.z, at.x, at.y, at.z, 0.0f, 1.0f, 0.0f);
    }

    public static void perspective(float fov, int width, int height, float near, float far, Matrix4f dest) {
        float fovRadians = fov * (float)Math.PI / 180.0f;
        float aspect = (float)width / (float)height;
        dest.setPerspectiveLH(fovRadians, aspect, near, far, zZeroToOne);
    }

    public static void ortho(float left, float right, float bottom, float top, float zNear, float zFar, Matrix4f dest) {
        dest.setOrthoLH(left, right, bottom, top, zNear, zFar, zZeroToOne);
    }
}

