/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Random;
import net.exitus.gfxlib.bgfx.BgfxApp;
import net.exitus.gfxlib.bgfx.BgfxUtils;
import net.exitus.gfxlib.shader.Shader;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.bgfx.BGFX;
import org.lwjgl.bgfx.BGFXVertexDecl;
import org.lwjgl.system.MemoryUtil;

public class CubeExampleAppBGFX
extends BgfxApp {
    private static final Object[][] cubeVertices = new Object[][]{{Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), -16777216}, {Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), -16776961}, {Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), -16711936}, {Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(1.0f), -16711681}, {Float.valueOf(-1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), -65536}, {Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(-1.0f), -65281}, {Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), -256}, {Float.valueOf(1.0f), Float.valueOf(-1.0f), Float.valueOf(-1.0f), -1}};
    private static final int[] cubeIndices = new int[]{0, 1, 2, 1, 3, 2, 4, 6, 5, 5, 6, 7, 0, 2, 4, 4, 2, 6, 1, 5, 3, 5, 7, 3, 0, 4, 1, 4, 5, 1, 2, 3, 6, 6, 3, 7};
    private BGFXVertexDecl decl;
    private ByteBuffer vertices;
    private short vbh;
    private ByteBuffer indices;
    private short ibh;
    private short program;
    private Matrix4f view = new Matrix4f();
    private FloatBuffer viewBuf;
    private Matrix4f proj = new Matrix4f();
    private FloatBuffer projBuf;
    private Matrix4f model = new Matrix4f();
    private FloatBuffer modelBuf;

    public CubeExampleAppBGFX(String windowTitle, int resolutionWidth, int resolutionHeight, boolean fullScreen, boolean vSync) throws IOException {
        super(windowTitle, resolutionWidth, resolutionHeight, fullScreen, vSync);
    }

    @Override
    public void init() throws Exception {
        this.decl = BgfxUtils.createVertexDecl(false, true, 0);
        this.vertices = MemoryUtil.memAlloc(128);
        this.vbh = BgfxUtils.createVertexBuffer(this.vertices, this.decl, cubeVertices);
        this.indices = MemoryUtil.memAlloc(cubeIndices.length * 2);
        this.ibh = BgfxUtils.createIndexBuffer(this.indices, cubeIndices);
        short vs = BgfxUtils.loadShader("vs_cubes");
        short fs = BgfxUtils.loadShader("fs_cubes");
        this.program = BGFX.bgfx_create_program(vs, fs, true);
        this.viewBuf = MemoryUtil.memAllocFloat(16);
        this.projBuf = MemoryUtil.memAllocFloat(16);
        this.modelBuf = MemoryUtil.memAllocFloat(16);
    }

    @Override
    public void renderFrame(double alpha, double time) {
        BgfxUtils.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, -35.0f), this.view);
        BgfxUtils.perspective(60.0f, this.resolutionWidth, this.resolutionHeight, 0.1f, 100.0f, this.proj);
        this.view.get(this.viewBuf);
        this.proj.get(this.projBuf);
        BGFX.bgfx_set_view_transform(0, this.viewBuf, this.projBuf);
        for (int yy = 0; yy < 11; ++yy) {
            for (int xx = 0; xx < 11; ++xx) {
                this.model.identity().translate(-15.0f + (float)xx * 3.0f, -15.0f + (float)yy * 3.0f, 0.0f).rotateAffineXYZ((float)xx * 0.21f, (float)yy * 0.37f, 0.0f);
                this.model.get(this.modelBuf);
                BGFX.bgfx_set_transform(this.modelBuf);
                BGFX.bgfx_set_vertex_buffer(0, this.vbh, 0, 8);
                BGFX.bgfx_set_index_buffer(this.ibh, 0, 36);
                BGFX.bgfx_set_state(0x100001000000017L, 0);
                BGFX.bgfx_submit(0, this.program, 0, false);
            }
        }
    }

    @Override
    public void close() throws Exception {
        MemoryUtil.memFree(this.viewBuf);
        MemoryUtil.memFree(this.projBuf);
        MemoryUtil.memFree(this.modelBuf);
        BGFX.bgfx_destroy_program(this.program);
        BGFX.bgfx_destroy_index_buffer(this.ibh);
        MemoryUtil.memFree(this.indices);
        BGFX.bgfx_destroy_vertex_buffer(this.vbh);
        MemoryUtil.memFree(this.vertices);
        this.decl.free();
        super.close();
    }

    @Override
    public void handleKey(int key, int scancode, int action, int mods) {
        if (key == 32 && (action == 1 || action == 2) && mods == 0) {
            Random r = new Random();
            this.setClearColor(r.nextFloat(), r.nextFloat(), r.nextFloat(), 1.0f);
        } else if (key == 257 && action == 0 && mods == 4) {
            this.toggleFullscreen();
        }
    }

    public static void main(String[] args) throws IOException, Exception {
        try (CubeExampleAppBGFX g = new CubeExampleAppBGFX("Cube example", 1280, 720, false, true);){
            g.run();
        }
    }

    @Override
    public Shader createShader(String vsFilename, String fsFilename) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateFrame(double delta, double time) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void handleMouseButton(long window, int button, int action, int mods) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void handleCursorPosition(long window, double xpos, double ypos) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void handleScroll(long window, double xoffset, double yoffset) {
    }

    @Override
    public void postProcessFrame(double time) {
    }
}

