/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.examples;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.exitus.gfxlib.ogl.OGLApp;
import net.exitus.gfxlib.resources.Camera;
import net.exitus.gfxlib.resources.FreeCamera;
import net.exitus.gfxlib.resources.LookAtCamera;
import net.exitus.gfxlib.resources.Material;
import net.exitus.gfxlib.resources.Mesh;
import net.exitus.gfxlib.resources.Model;
import net.exitus.gfxlib.resources.Texture;
import net.exitus.gfxlib.shader.Shader;
import net.exitus.gfxlib.utils.loaders.JSONModelLoader;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;

public class ModelLoaderOGL
extends OGLApp {
    int vao;
    int quadProgram;
    int quadProgram_inputPosition;
    int quadProgram_inputTextureCoords;
    int texLocation;
    int texLocation2;
    Model cube1;
    Model cube2;
    Mesh jsonMesh;
    Mesh quadMesh;
    List<Model> cubes = new ArrayList<Model>();
    Shader textureShader;
    Shader quadShader;
    int uniformLocTransform;
    float quadZoom = 1.0f;
    float xRotAng = 0.0f;
    float yRotAng = 0.0f;
    float zRotAng = 0.0f;
    float moveX = 0.0f;
    float moveY = 0.0f;
    float moveZ = 0.0f;
    float eyeX = 0.0f;
    float eyeY = 0.0f;
    float eyeZ = 4.0f;
    float centerX = 0.0f;
    float centerY = 0.0f;
    float centerZ = 0.0f;
    int textureId;
    int MSAATexture;
    int uniformTimeLoc;
    Material texColMat;
    Texture texture;
    Texture texture2;
    Matrix4f viewProj = new Matrix4f();
    Matrix4f view = new Matrix4f();
    Matrix4f proj = new Matrix4f();
    FreeCamera fpsCam;
    List<Camera> mainCams = new ArrayList<Camera>();
    boolean toggleFreeCam = false;

    public ModelLoaderOGL(String windowTitle, int resolutionWidth, int resolutionHeight, int majorVersion, int minorVersion, boolean fullScreen, boolean vSync, int msaa, int anisotropy) throws IOException, Exception {
        super(windowTitle, resolutionWidth, resolutionHeight, majorVersion, minorVersion, fullScreen, vSync, msaa, anisotropy);
    }

    void initAssets() throws IOException, URISyntaxException {
        this.texture = new Texture("textures/stone_brick_wall1.png", this.anisotropy);
        this.texture2 = new Texture("textures/metal_fence.png", this.anisotropy);
        this.textureShader = this.createShader("shaders/texturedColored.vs", "shaders/texturedColored.fs");
        this.quadShader = this.createShader("shaders/fullScreenQuad.vs", "shaders/fsQuadDepthVis.fs");
        this.texColMat = new Material("textured and colored", this.textureShader);
        this.texColMat.addTexture("tex", this.texture).addTexture("tex2", this.texture2);
        this.texColMat.setParameter("w1", Float.valueOf(1.0f));
        this.texColMat.setParameter("w2", Float.valueOf(0.0f));
        JSONModelLoader loader = new JSONModelLoader("models/test_model.json");
        this.jsonMesh = loader.parseMesh("cube");
        this.jsonMesh.uploadToGPU();
        this.cube1 = new Model("cube1", this.jsonMesh, this.texColMat, null);
        this.cube1.setRotSpd(10.0f, 0.0f, 10.0f);
        Material texColMat2 = new Material("texColMat2", this.textureShader);
        texColMat2.addTexture("tex", this.texture).addTexture("tex2", this.texture2);
        texColMat2.setParameter("w1", Float.valueOf(0.0f));
        texColMat2.setParameter("w2", Float.valueOf(1.0f));
        this.cube2 = new Model("cube2", this.jsonMesh, texColMat2, null);
        this.cube2.setPosition(-4.0f, 2.0f, -4.0f);
        this.cube2.setRotSpd(10.0f, 10.0f, 0.0f);
        this.fpsCam = new FreeCamera(35.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f);
        this.mainCams.add(new LookAtCamera(35.0f, this.resolutionWidth, this.resolutionHeight, 0.01f, 100.0f, new Vector3f(0.0f, 0.0f, 4.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        Random r = new Random(5322L);
        int numCubes = 5000;
        for (int i = 0; i < numCubes; ++i) {
            Model cube = (i & 1) == 0 ? new Model("cube" + i, this.jsonMesh, this.texColMat, null) : new Model("cube" + i, this.jsonMesh, texColMat2, null);
            cube.setPosition(r.nextFloat() * -100.0f + r.nextFloat() * 100.0f, r.nextFloat() * -100.0f + r.nextFloat() * 100.0f, r.nextFloat() * -100.0f + r.nextFloat() * 100.0f);
            this.cubes.add(cube);
        }
        GL11.glDisable(2884);
        GL11.glEnable(32926);
        GL11.glEnable(2929);
    }

    @Override
    public void init() throws Exception {
        this.setClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.initAssets();
        this.quadMesh = this.createFullScreenQuad();
        this.windowVisible(true);
    }

    @Override
    public void renderFrame(double alpha, double time) {
        if (this.toggleFreeCam) {
            this.viewProj = this.fpsCam.getViewProjection();
            this.view = this.fpsCam.getView();
            this.proj = this.fpsCam.getProjection();
        } else {
            this.viewProj = this.mainCams.get(0).getViewProjection();
            this.view = this.mainCams.get(0).getView();
            this.proj = this.mainCams.get(0).getProjection();
        }
        this.cube1.draw(this.viewProj, this.view, this.proj);
        this.cube2.draw(this.viewProj, this.view, this.proj);
        for (Model c : this.cubes) {
            c.draw(this.viewProj, this.view, this.proj);
        }
    }

    @Override
    public void close() throws Exception {
        this.jsonMesh.dispose();
        this.textureShader.dispose();
        super.close();
    }

    @Override
    public void updateFrame(double delta, double time) {
        this.fpsCam.update(delta);
        this.mainCams.get(0).update(delta);
        this.cube1.update(delta, time);
        this.cube2.update(delta, time);
        Random r = new Random(51515L);
        for (Model c : this.cubes) {
            c.setRotation((float)((double)(r.nextFloat() * 10.0f) * time * delta * (double)this.targetUPS) + (float)((double)(r.nextFloat() * -10.0f) * time * delta * (double)this.targetUPS), (float)((double)(r.nextFloat() * 10.0f) * time * delta * (double)this.targetUPS) + (float)((double)(r.nextFloat() * -10.0f) * time * delta * (double)this.targetUPS), (float)((double)(r.nextFloat() * 10.0f) * time * delta * (double)this.targetUPS) + (float)((double)(r.nextFloat() * -10.0f) * time * delta * (double)this.targetUPS));
            c.update(delta, time);
        }
        logger.log(Level.FINEST, "time: {0}", time);
        logger.log(Level.FINEST, "frameTime: {0}", delta * 1000.0);
    }

    @Override
    public void handleKey(int key, int scancode, int action, int mods) {
        if (key == 67 && action == 1) {
            boolean bl = this.toggleFreeCam = !this.toggleFreeCam;
        }
        if (key == 32 && (action == 1 || action == 2) && mods == 0) {
            Random r = new Random();
            this.setClearColor(r.nextFloat(), r.nextFloat(), r.nextFloat(), 1.0f);
        }
        if (key == 257 && action == 0 && mods == 4) {
            this.toggleFullscreen();
        }
        if (this.toggleFreeCam) {
            this.fpsCam.handleKey(key, scancode, action, mods);
        } else if (key == 87 && (action == 1 || action == 2) && mods == 0) {
            this.eyeZ = (float)((double)this.eyeZ - 0.1);
            this.centerZ = (float)((double)this.centerZ - 0.1);
        } else if (key == 83 && (action == 1 || action == 2) && mods == 0) {
            this.eyeZ = (float)((double)this.eyeZ + 0.1);
            this.centerZ = (float)((double)this.centerZ + 0.1);
        } else if (key == 65) {
            this.eyeX = (float)((double)this.eyeX - 0.1);
            this.centerX = (float)((double)this.centerX - 0.1);
        } else if (key == 68) {
            this.eyeX = (float)((double)this.eyeX + 0.1);
            this.centerX = (float)((double)this.centerX + 0.1);
        } else if (key == 82) {
            this.resetTime();
        }
    }

    @Override
    public void handleMouseButton(long window, int button, int action, int mods) {
    }

    @Override
    public void handleCursorPosition(long window, double xpos, double ypos) {
        if (this.toggleFreeCam) {
            GLFW.glfwSetInputMode(window, 208897, 212995);
            this.fpsCam.handleCursorPosition(window, xpos, ypos);
        } else {
            GLFW.glfwSetInputMode(window, 208897, 212993);
        }
    }

    @Override
    public void handleScroll(long window, double xoffset, double yoffset) {
    }

    public static void main(String[] args) throws Exception {
        try (ModelLoaderOGL g = new ModelLoaderOGL("Cube example", 1280, 720, 4, 5, false, true, 8, 16);){
            g.run();
        }
    }

    @Override
    public void postProcessFrame(double time) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("LumTresh", Float.valueOf(0.4f));
        this.postProcessEffect("shaders/postProcessBrightPass.fs", params);
        params.put("dir", new float[]{0.0f, 1.0f});
        this.postProcessEffect("shaders/postProcessBlur.fs", params);
        params.put("dir", new float[]{1.0f, 0.0f});
        Texture blurred = this.postProcessEffect("shaders/postProcessBlur.fs", params, true, null);
        this.resetPostProcess();
        params.clear();
        params.put("exposure", Float.valueOf(2.2f));
        params.put("bloomFactor", Float.valueOf(1.5f));
        this.postProcessEffect("shaders/postProcessTonemap.fs", params, blurred, null);
    }
}

