/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.examples;

import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import net.exitus.gfxlib.ogl.OGLApp;
import net.exitus.gfxlib.resources.RenderToTexture;
import net.exitus.gfxlib.resources.Texture;
import net.exitus.gfxlib.resources.TextureType;
import net.exitus.gfxlib.shader.Shader;

public class TexturedQuadOGL
extends OGLApp {
    int vao;
    int quadProgram;
    int quadProgram_inputPosition;
    int quadProgram_inputTextureCoords;
    Shader quadShader;
    Shader quadShaderMulju;
    int uniformLocTransform;
    float quadZoom = 1.0f;
    float zRotAng = 0.0f;
    int textureId;
    Texture quadTex1;
    RenderToTexture rtt;

    public TexturedQuadOGL(String windowTitle, int resolutionWidth, int resolutionHeight, int majorVersion, int minorVersion, boolean fullScreen, boolean vSync, int msaa, int anisotropy) throws IOException, Exception {
        super(windowTitle, resolutionWidth, resolutionHeight, majorVersion, minorVersion, fullScreen, vSync, msaa, anisotropy);
    }

    void createShaders() throws IOException {
        this.quadShader = this.createShader("shaders/fullScreenQuad.vs", "shaders/fullScreenQuad.fs");
        this.quadShaderMulju = this.createShader("shaders/fullScreenQuad.vs", "shaders/fullScreenQuadMulju.fs");
    }

    void createTexture() throws IOException, Exception {
        this.quadTex1 = new Texture("textures/grid512.bmp", 16);
        this.rtt = new RenderToTexture(new Texture(this.resolutionWidth, this.resolutionHeight, false, 0, TextureType.TEXTURE2D, 0));
    }

    @Override
    public void init() throws Exception {
        this.createTexture();
        this.createShaders();
        this.windowVisible(true);
    }

    @Override
    public void renderFrame(double alpha, double time) {
        HashMap<String, Double> params = new HashMap<String, Double>();
        params.put("time", time);
        this.drawFullScreenQuad("shaders/fullScreenQuad.fs", this.quadTex1, true);
    }

    @Override
    public void close() throws Exception {
        this.quadMesh.dispose();
        this.quadShader.dispose();
        super.close();
    }

    @Override
    public void handleKey(int key, int scancode, int action, int mods) {
        if (key == 32 && (action == 1 || action == 2) && mods == 0) {
            Random r = new Random();
            this.setClearColor(r.nextFloat(), r.nextFloat(), r.nextFloat(), 1.0f);
        } else if (key == 257 && action == 0 && mods == 4) {
            this.toggleFullscreen();
        } else if (key == 87) {
            if (this.quadZoom > 0.1f) {
                this.quadZoom -= 0.01f;
            }
        } else if (key == 83) {
            if (this.quadZoom < 2.0f) {
                this.quadZoom += 0.01f;
            }
        } else if (key == 65) {
            this.zRotAng += 0.01f;
        } else if (key == 68) {
            this.zRotAng -= 0.01f;
        }
    }

    public static void main(String[] args) throws IOException, Exception {
        try (TexturedQuadOGL g = new TexturedQuadOGL("Cube example", 1280, 720, 4, 5, false, true, 8, 16);){
            g.run();
        }
    }

    @Override
    public void updateFrame(double delta, double time) {
    }

    @Override
    public void handleMouseButton(long window, int button, int action, int mods) {
    }

    @Override
    public void handleCursorPosition(long window, double xpos, double ypos) {
    }

    @Override
    public void handleScroll(long window, double xoffset, double yoffset) {
    }

    @Override
    public void postProcessFrame(double time) {
        this.postProcessEffect("shaders/postProcessFishEye.fs");
        this.postProcessEffect("shaders/postProcessCrossHatch.fs");
    }
}

