/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.ogl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.exitus.gfxlib.GfxApp;
import net.exitus.gfxlib.ogl.OGLShader;
import net.exitus.gfxlib.resources.DepthTexture;
import net.exitus.gfxlib.resources.Mesh;
import net.exitus.gfxlib.resources.RenderToTexture;
import net.exitus.gfxlib.resources.Texture;
import net.exitus.gfxlib.resources.TextureType;
import net.exitus.gfxlib.resources.VertexLayout;
import net.exitus.gfxlib.shader.Shader;
import net.exitus.gfxlib.shader.ShaderCache;
import net.exitus.gfxlib.utils.Utils;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;

public abstract class OGLApp
implements GfxApp {
    protected static final Logger logger = Logger.getLogger(OGLApp.class.getName());
    protected int targetUPS = 60;
    protected double g_time = 0.0;
    protected double g_startTime = 0.0;
    protected double g_lastTime = 0.0;
    private GLFWErrorCallback errorCallback;
    private GLFWKeyCallback keyCallback;
    private GLFWFramebufferSizeCallback resizeCallback;
    private GLFWMouseButtonCallback mouseButtonCallback;
    private GLFWCursorPosCallback cursorPosCallback;
    private GLFWScrollCallback scrollCallback;
    protected long window;
    private GLFWVidMode vidmode;
    private int[] wPos;
    private CharSequence windowTitle;
    protected int resolutionWidth = 320;
    protected int resolutionHeight = 240;
    private int openGLMajorVersion = 3;
    private int openGLMinorVersion = 3;
    private boolean fullScreen = false;
    private boolean vSync = true;
    private int MSAALevel = 0;
    protected int anisotropy = 0;
    protected int frameBufferMSAATexture;
    protected int frameBufferMSAAFBO;
    protected int depthBufferTextureMSAA;
    protected Texture depthBufferTextureResolved;
    protected Texture frameBufferResolvedTexture;
    protected int frameBufferResolvedFBO;
    protected Texture frameBufferPostProcessedTexture;
    protected int frameBufferPostProcessedFBO;
    protected RenderToTexture rttFSQuad;
    protected Mesh quadMesh;
    protected RenderToTexture inputPS;
    protected RenderToTexture outputPS;
    protected RenderToTexture savedOutput;
    protected RenderToTexture downSampled2X;
    protected RenderToTexture downSampled4X;
    protected RenderToTexture downSampled8X;
    protected Map<String, Shader> shaderCache;

    public OGLApp() throws IOException {
        System.setProperty("org.lwjgl.librarypath", "lib");
        LogManager.getLogManager().readConfiguration(this.getFileStream("logging.properties"));
        this.shaderCache = new HashMap<String, Shader>();
    }

    public OGLApp(String windowTitle, int resolutionWidth, int resolutionHeight, int majorVersion, int minorVersion, boolean fullScreen, boolean vSync, int msaa, int anisotropy) throws IOException, Exception {
        this();
        this.windowTitle = windowTitle;
        this.resolutionWidth = resolutionWidth;
        this.resolutionHeight = resolutionHeight;
        this.openGLMajorVersion = majorVersion;
        this.openGLMinorVersion = minorVersion;
        this.fullScreen = fullScreen;
        this.vSync = vSync;
        this.MSAALevel = msaa;
        this.anisotropy = anisotropy;
        this.internalInit();
    }

    public void setTargetUPS(int ups) {
        this.targetUPS = ups;
    }

    private void setWindowHints() {
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 0);
        GLFW.glfwWindowHint(139266, this.openGLMajorVersion);
        GLFW.glfwWindowHint(139267, this.openGLMinorVersion);
        GLFW.glfwWindowHint(139270, 1);
        GLFW.glfwWindowHint(139272, 204801);
    }

    private void checkFrameBufferStatus() throws Exception {
        int status = GL30.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            if (status == 36061) {
                logger.log(Level.SEVERE, "Framebuffer format unsupported!");
                throw new Exception("Unsupported framebuffer format!");
            }
            logger.log(Level.SEVERE, "Framebuffer error!");
            throw new Exception("Error creating framebuffer!");
        }
        logger.log(Level.FINEST, "Framebuffer complete!");
    }

    void createMultisamplingFBO(int numSamples) throws Exception {
        this.frameBufferMSAATexture = GL11.glGenTextures();
        GL11.glBindTexture(37120, this.frameBufferMSAATexture);
        GL32.glTexImage2DMultisample(37120, numSamples, 34842, this.resolutionWidth, this.resolutionHeight, false);
        this.depthBufferTextureMSAA = GL11.glGenTextures();
        GL11.glBindTexture(37120, this.depthBufferTextureMSAA);
        GL32.glTexImage2DMultisample(37120, numSamples, 6402, this.resolutionWidth, this.resolutionHeight, false);
        GL11.glBindTexture(37120, 0);
        this.frameBufferMSAAFBO = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.frameBufferMSAAFBO);
        GL30.glFramebufferTexture2D(36160, 36064, 37120, this.frameBufferMSAATexture, 0);
        GL30.glFramebufferTexture2D(36160, 36096, 37120, this.depthBufferTextureMSAA, 0);
        this.checkFrameBufferStatus();
        GL30.glBindFramebuffer(36160, 0);
        GL11.glBindTexture(37120, 0);
        this.frameBufferResolvedTexture = new Texture(this.resolutionWidth, this.resolutionHeight, false, 0, TextureType.TEXTURE2D, 0);
        this.depthBufferTextureResolved = new DepthTexture(this.resolutionWidth, this.resolutionHeight);
        this.frameBufferResolvedFBO = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.frameBufferResolvedFBO);
        GL30.glFramebufferTexture2D(36160, 36064, 3553, this.frameBufferResolvedTexture.getId(), 0);
        GL30.glFramebufferTexture2D(36160, 36096, 3553, this.depthBufferTextureResolved.getId(), 0);
        this.checkFrameBufferStatus();
        GL30.glBindFramebuffer(36160, 0);
        this.frameBufferPostProcessedTexture = new Texture(this.resolutionWidth, this.resolutionHeight, false, 0, TextureType.TEXTURE2D, 0);
        this.frameBufferPostProcessedFBO = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.frameBufferPostProcessedFBO);
        GL30.glFramebufferTexture2D(36160, 36064, 3553, this.frameBufferPostProcessedTexture.getId(), 0);
        this.checkFrameBufferStatus();
        GL30.glBindFramebuffer(36160, 0);
    }

    private void registerCallbacks() {
        this.errorCallback = GLFWErrorCallback.createPrint(System.err);
        GLFW.glfwSetErrorCallback(this.errorCallback);
        this.keyCallback = new GLFWKeyCallback(){

            @Override
            public void invoke(long window, int key, int scancode, int action, int mods) {
                OGLApp.this.handleKey(key, scancode, action, mods);
                logger.finest("char: " + (char)key + " key: " + key + " scancode: " + scancode + " action: " + action + " mods: " + mods);
                if (key == 256 && action == 0) {
                    GLFW.glfwSetWindowShouldClose(window, true);
                }
            }
        };
        GLFW.glfwSetKeyCallback(this.window, this.keyCallback);
        this.resizeCallback = new GLFWFramebufferSizeCallback(){

            @Override
            public void invoke(long window, int width, int height) {
                OGLApp.this.resolutionWidth = width;
                OGLApp.this.resolutionHeight = height;
                logger.finest(window + ": " + width + "x" + height);
            }
        };
        GLFW.glfwSetFramebufferSizeCallback(this.window, this.resizeCallback);
        this.mouseButtonCallback = GLFWMouseButtonCallback.create((window, button, action, mods) -> {
            logger.log(Level.FINEST, "{0},{1},{2},{3}", new Object[]{window, button, action, mods});
            this.handleMouseButton(window, button, action, mods);
        });
        GLFW.glfwSetMouseButtonCallback(this.window, this.mouseButtonCallback);
        this.cursorPosCallback = GLFWCursorPosCallback.create((window, xpos, ypos) -> {
            logger.log(Level.FINEST, window + "," + xpos + "," + ypos);
            this.handleCursorPosition(window, xpos, ypos);
        });
        GLFW.glfwSetCursorPosCallback(this.window, this.cursorPosCallback);
        this.scrollCallback = GLFWScrollCallback.create((window, xoffset, yoffset) -> {
            logger.log(Level.FINEST, window + "," + xoffset + "," + yoffset);
            this.handleScroll(window, xoffset, yoffset);
        });
        GLFW.glfwSetScrollCallback(this.window, this.scrollCallback);
    }

    private void internalInit() throws Exception {
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW!");
        }
        this.setWindowHints();
        this.window = GLFW.glfwCreateWindow(this.resolutionWidth, this.resolutionHeight, this.windowTitle, this.fullScreen ? GLFW.glfwGetPrimaryMonitor() : 0L, 0L);
        if (this.window == 0L) {
            GLFW.glfwTerminate();
            throw new RuntimeException("Failed to create the GLFW window!");
        }
        this.registerCallbacks();
        this.vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        GLFW.glfwMakeContextCurrent(this.window);
        GLFW.glfwSwapInterval(this.vSync ? 1 : 0);
        GL.createCapabilities();
        logger.info("GL_VENDOR: " + GL11.glGetString(7936));
        logger.info("GL_RENDERER: " + GL11.glGetString(7937));
        logger.info("GL_VERSION: " + GL11.glGetString(7938));
        this.setClearColor(0.4f, 0.6f, 0.9f, 1.0f);
        this.createMultisamplingFBO(this.MSAALevel);
        this.rttFSQuad = new RenderToTexture(new Texture(this.resolutionWidth, this.resolutionHeight, false, 0, TextureType.TEXTURE2D, 0));
        this.quadMesh = this.createFullScreenQuad();
        this.inputPS = new RenderToTexture(new Texture(this.resolutionWidth, this.resolutionHeight, false, 0, TextureType.TEXTURE2D, 0));
        this.outputPS = new RenderToTexture(new Texture(this.resolutionWidth, this.resolutionHeight, false, 0, TextureType.TEXTURE2D, 0));
        this.savedOutput = new RenderToTexture(new Texture(this.resolutionWidth, this.resolutionHeight, false, 0, TextureType.TEXTURE2D, 0));
        this.downSampled2X = new RenderToTexture(new Texture(this.resolutionWidth / 2, this.resolutionHeight / 2, false, 0, TextureType.TEXTURE2D, 0));
        this.downSampled4X = new RenderToTexture(new Texture(this.resolutionWidth / 4, this.resolutionHeight / 4, false, 0, TextureType.TEXTURE2D, 0));
        this.downSampled8X = new RenderToTexture(new Texture(this.resolutionWidth / 8, this.resolutionHeight / 8, false, 0, TextureType.TEXTURE2D, 0));
    }

    @Override
    public void windowVisible(boolean flag) {
        if (flag) {
            GLFW.glfwShowWindow(this.window);
        } else {
            GLFW.glfwHideWindow(this.window);
        }
    }

    private boolean shouldExit() {
        return GLFW.glfwWindowShouldClose(this.window);
    }

    protected void exit() {
        GLFW.glfwSetWindowShouldClose(this.window, true);
    }

    protected final void setClearColor(float r, float g, float b, float a) {
        GL11.glClearColor(r, g, b, a);
    }

    protected void setViewport() {
        IntBuffer width = BufferUtils.createIntBuffer(1);
        IntBuffer height = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetFramebufferSize(this.window, width, height);
        this.resolutionWidth = width.get();
        this.resolutionHeight = height.get();
        GL11.glViewport(0, 0, this.resolutionWidth, this.resolutionHeight);
    }

    protected void setViewport(int width, int height) {
        GL11.glViewport(0, 0, width, height);
    }

    protected final int[] getWindowPosition() {
        IntBuffer wPosX = BufferUtils.createIntBuffer(1);
        IntBuffer wPosY = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetWindowPos(this.window, wPosX, wPosY);
        return new int[]{wPosX.get(), wPosY.get()};
    }

    protected final void toggleFullscreen() {
        if (!this.fullScreen) {
            this.wPos = this.getWindowPosition();
        }
        this.fullScreen = !this.fullScreen;
        this.setWindowHints();
        GLFW.glfwSetWindowMonitor(this.window, this.fullScreen ? GLFW.glfwGetPrimaryMonitor() : 0L, this.wPos[0], this.wPos[1], this.resolutionWidth, this.resolutionHeight, this.vidmode.refreshRate());
    }

    protected double getTime() {
        return GLFW.glfwGetTime();
    }

    protected void resetTime() {
        this.g_lastTime = this.g_startTime = this.getTime();
    }

    @Override
    public void postProcessFrame(double time) {
    }

    protected final void run() {
        try {
            this.init();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exiting application...", ex);
            return;
        }
        double t = 0.0;
        double accumulator = 0.0;
        double dt = 1.0f / (float)this.targetUPS;
        this.g_startTime = this.g_lastTime = this.getTime();
        while (!this.shouldExit()) {
            GL30.glBindFramebuffer(36160, this.frameBufferMSAAFBO);
            this.setViewport();
            GL11.glClear(17664);
            this.g_time = this.getTime();
            double frameTime = this.g_time - this.g_lastTime;
            if (frameTime > 0.25) {
                frameTime = 0.25;
            }
            this.g_lastTime = this.g_time;
            accumulator += frameTime;
            while (accumulator >= dt) {
                this.updateFrame(dt, this.g_time - this.g_startTime);
                accumulator -= dt;
            }
            this.renderFrame(accumulator / dt, this.g_time - this.g_startTime);
            GL30.glBindFramebuffer(36160, 0);
            this.copyFrameBuffer(this.resolutionWidth, this.resolutionHeight, this.frameBufferMSAAFBO, this.frameBufferResolvedFBO, 16640);
            this.resetPostProcess();
            this.savedOutput.bind();
            GL11.glClear(16384);
            GL30.glBindFramebuffer(36160, 0);
            this.postProcessFrame(this.g_time - this.g_startTime);
            GL30.glBindFramebuffer(36160, 0);
            GL30.glBindFramebuffer(36009, 0);
            GL30.glBindFramebuffer(36008, this.outputPS.getId());
            GL11.glDrawBuffer(1029);
            GL30.glBlitFramebuffer(0, 0, this.resolutionWidth, this.resolutionHeight, 0, 0, this.resolutionWidth, this.resolutionHeight, 16384, 9728);
            GL30.glBindFramebuffer(36160, 0);
            GLFW.glfwSwapBuffers(this.window);
            GLFW.glfwPollEvents();
        }
    }

    protected final InputStream getFileStream(String name) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResourceAsStream(name);
    }

    protected final String getFilePath(String name) {
        return Utils.getDir(name);
    }

    protected final void printResolutions() {
        logger.info("Primary monitor: " + GLFW.glfwGetMonitorName(GLFW.glfwGetPrimaryMonitor()));
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        for (int i = 0; i < monitors.limit(); ++i) {
            long monitor = monitors.get(i);
            logger.info(GLFW.glfwGetMonitorName(GLFW.glfwGetPrimaryMonitor()));
            logger.info("--------------------------");
            GLFWVidMode.Buffer modes = GLFW.glfwGetVideoModes(monitor);
            for (int j = 0; j < modes.limit(); ++j) {
                GLFWVidMode mode = (GLFWVidMode)modes.get(j);
                logger.info(mode.width() + "x" + mode.height() + "@" + mode.refreshRate());
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.scrollCallback.free();
        this.cursorPosCallback.free();
        this.mouseButtonCallback.free();
        this.keyCallback.free();
        this.resizeCallback.free();
        GLFW.glfwDestroyWindow(this.window);
        GLFW.glfwTerminate();
        this.errorCallback.free();
    }

    @Override
    public void renderDebugText(String text, int x, int y) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Shader createShader(String vsFilename, String fsFilename) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(vsFilename).append("#").append(fsFilename);
        String concShaderName = sb.toString();
        if (this.shaderCache.containsKey(concShaderName)) {
            logger.log(Level.FINEST, "shader in cache: " + concShaderName);
            return this.shaderCache.get(concShaderName);
        }
        int program = GL20.glCreateProgram();
        int vshader = ShaderCache.getVertexShader(vsFilename);
        int fshader = ShaderCache.getFragmentShader(fsFilename);
        GL20.glAttachShader(program, vshader);
        GL20.glAttachShader(program, fshader);
        GL20.glLinkProgram(program);
        int linked = GL20.glGetProgrami(program, 35714);
        String programLog = GL20.glGetProgramInfoLog(program);
        if (programLog != null && programLog.trim().length() > 0) {
            logger.log(Level.SEVERE, programLog);
        }
        if (linked == 0) {
            throw new IOException("Could not link program!");
        }
        OGLShader shader = new OGLShader(program);
        shader.getUniformLocations();
        this.shaderCache.put(concShaderName, shader);
        return shader;
    }

    protected void copyFrameBuffer(int width, int height, int fboIn, int fboOut, int glType) {
        GL30.glBindFramebuffer(36008, fboIn);
        GL30.glBindFramebuffer(36009, fboOut);
        GL30.glBlitFramebuffer(0, 0, width, height, 0, 0, width, height, glType, 9728);
        GL30.glBindFramebuffer(36009, 0);
        GL30.glBindFramebuffer(36008, 0);
    }

    protected Texture downSample2X(RenderToTexture fbo, int filterType) {
        this.downSample(fbo.getTexture().getWidth(), fbo.getTexture().getHeight(), 2, filterType, fbo.getId(), this.downSampled2X.getId());
        return this.downSampled2X.getTexture();
    }

    protected Texture downSample4X(RenderToTexture fbo, int filterType) {
        this.downSample(fbo.getTexture().getWidth(), fbo.getTexture().getHeight(), 4, filterType, fbo.getId(), this.downSampled4X.getId());
        return this.downSampled4X.getTexture();
    }

    protected Texture downSample8X(RenderToTexture fbo, int filterType) {
        this.downSample(fbo.getTexture().getWidth(), fbo.getTexture().getHeight(), 8, filterType, fbo.getId(), this.downSampled8X.getId());
        return this.downSampled8X.getTexture();
    }

    protected void downSample(int width, int height, int scale, int filterType, int fboIn, int fboOut) {
        GL30.glBindFramebuffer(36008, fboIn);
        GL30.glBindFramebuffer(36009, fboOut);
        GL30.glBlitFramebuffer(0, 0, width, height, 0, 0, width / scale, height / scale, 16384, filterType);
        GL30.glBindFramebuffer(36009, 0);
        GL30.glBindFramebuffer(36008, 0);
    }

    protected Mesh createFullScreenQuad() throws IOException {
        float[] vertices = new float[]{1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f};
        int[] indices = new int[]{0, 1, 2, 1, 3, 2};
        ArrayList<VertexLayout> layout = new ArrayList<VertexLayout>();
        layout.add(VertexLayout.POS2);
        layout.add(VertexLayout.TEXCOORD1);
        Mesh m = new Mesh("fullScreenQuad");
        m.setFaces(indices);
        m.setVertices(vertices, layout);
        m.uploadToGPU();
        return m;
    }

    protected Texture drawFullScreenQuad(String shaderName, Texture inputTexture, boolean drawToFrameBuffer) {
        return this.drawFullScreenQuad(shaderName, inputTexture, drawToFrameBuffer, null);
    }

    protected Texture drawFullScreenQuad(String shaderName, Texture inputTexture, boolean drawToFrameBuffer, Map<String, Object> params) {
        GL11.glDisable(2884);
        Texture retTex = null;
        Shader shader = null;
        try {
            shader = this.createShader("shaders/fullScreenQuad.vs", shaderName);
        }
        catch (IOException ex) {
            Logger.getLogger(OGLApp.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        if (!drawToFrameBuffer) {
            this.rttFSQuad.bind();
            this.setViewport();
        } else {
            GL30.glBindFramebuffer(36160, this.frameBufferMSAAFBO);
        }
        shader.bind();
        this.setShaderVariables(shader, params, inputTexture);
        inputTexture.bind(0);
        this.quadMesh.draw();
        inputTexture.unbind();
        shader.unbind();
        if (!drawToFrameBuffer) {
            this.rttFSQuad.unbind();
            retTex = this.rttFSQuad.getTexture();
        }
        return retTex;
    }

    protected void setShaderVariables(Shader shader, Map<String, Object> params, Texture inputTexture) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("time", this.g_time - this.g_startTime);
        params.put("width", inputTexture.getWidth());
        params.put("height", inputTexture.getHeight());
        for (Map.Entry<String, Object> param : params.entrySet()) {
            if (param.getValue() instanceof Integer) {
                shader.setVariable(param.getKey(), (Integer)param.getValue());
                continue;
            }
            if (param.getValue() instanceof Float) {
                shader.setVariable(param.getKey(), ((Float)param.getValue()).floatValue());
                continue;
            }
            if (param.getValue() instanceof Double) {
                shader.setVariable(param.getKey(), ((Double)param.getValue()).floatValue());
                continue;
            }
            if (!(param.getValue() instanceof float[])) continue;
            float[] arr = (float[])param.getValue();
            if (arr.length == 2) {
                shader.setVariable(param.getKey(), arr[0], arr[1]);
                continue;
            }
            if (arr.length == 3) {
                shader.setVariable(param.getKey(), arr[0], arr[1], arr[2]);
                continue;
            }
            if (arr.length != 4) continue;
            shader.setVariable(param.getKey(), arr[0], arr[1], arr[2], arr[3]);
        }
    }

    protected void postProcessEffect(String shaderName) {
        this.postProcessEffect(shaderName, null, null, null);
    }

    protected void postProcessEffect(String shaderName, Texture extraTex) {
        this.postProcessEffect(shaderName, null, extraTex, null);
    }

    protected void postProcessEffect(String shaderName, Map<String, Object> params) {
        this.postProcessEffect(shaderName, params, null, null);
    }

    protected void postProcessEffect(String shaderName, Map<String, Object> params, Texture extraTex, Texture extraTex2) {
        GL11.glDisable(2929);
        GL11.glDisable(2884);
        Shader shader = null;
        try {
            shader = this.createShader("shaders/fullScreenQuad.vs", shaderName);
        }
        catch (IOException ex) {
            Logger.getLogger(OGLApp.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        this.outputPS.bind();
        GL11.glClear(16384);
        shader.bind();
        this.setShaderVariables(shader, params, this.inputPS.getTexture());
        this.inputPS.getTexture().bind(0);
        if (extraTex != null) {
            extraTex.bind(1);
        }
        if (extraTex2 != null) {
            extraTex2.bind(2);
        }
        this.quadMesh.draw();
        if (extraTex != null) {
            extraTex.unbind();
        }
        if (extraTex2 != null) {
            extraTex2.unbind();
        }
        this.inputPS.getTexture().unbind();
        shader.unbind();
        this.outputPS.unbind();
        this.copyFrameBuffer(this.inputPS.getTexture().getWidth(), this.inputPS.getTexture().getHeight(), this.outputPS.getId(), this.inputPS.getId(), 16384);
        GL11.glEnable(2884);
        GL11.glEnable(2929);
    }

    protected Texture postProcessEffect(String shaderName, boolean saveOutput) {
        return this.postProcessEffect(shaderName, null, saveOutput, null);
    }

    protected Texture postProcessEffect(String shaderName, boolean saveOutput, Texture extraTex) {
        return this.postProcessEffect(shaderName, null, saveOutput, extraTex);
    }

    protected Texture postProcessEffect(String shaderName, Map<String, Object> params, boolean saveOutput, Texture extraTex) {
        this.postProcessEffect(shaderName, params, extraTex, null);
        this.copyFrameBuffer(this.savedOutput.getTexture().getWidth(), this.savedOutput.getTexture().getHeight(), this.outputPS.getId(), this.savedOutput.getId(), 16384);
        return this.savedOutput.getTexture();
    }

    protected void resetPostProcess() {
        this.copyFrameBuffer(this.resolutionWidth, this.resolutionHeight, this.frameBufferResolvedFBO, this.inputPS.getId(), 16384);
        this.copyFrameBuffer(this.resolutionWidth, this.resolutionHeight, this.frameBufferResolvedFBO, this.outputPS.getId(), 16384);
    }
}

