/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.ogl;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.exitus.gfxlib.shader.Shader;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public class OGLShader
implements Shader {
    private static final Logger logger = Logger.getLogger(OGLShader.class.getName());
    private boolean isBound;
    private int handle;
    private Map<String, Integer> uniforms;

    OGLShader(int handle) {
        this.handle = handle;
        this.uniforms = new HashMap<String, Integer>();
    }

    @Override
    public void bind() {
        if (this.isBound) {
            return;
        }
        this.isBound = true;
        GL20.glUseProgram(this.handle);
    }

    @Override
    public void unbind() {
        if (!this.isBound) {
            return;
        }
        this.isBound = false;
        GL20.glUseProgram(0);
    }

    @Override
    public int getUniformLocation(String name) {
        if (this.uniforms.containsKey(name)) {
            return this.uniforms.get(name);
        }
        return GL20.glGetUniformLocation(this.handle, name);
    }

    @Override
    public int getVertexAttribLocation(String name) {
        return GL20.glGetAttribLocation(this.handle, name);
    }

    @Override
    public void setVariable(String name, int data) {
        if (this.uniforms.containsKey(name)) {
            GL20.glUniform1i(this.getUniformLocation(name), data);
        }
    }

    @Override
    public void setVariable(String name, float data) {
        if (this.uniforms.containsKey(name)) {
            GL20.glUniform1f(this.getUniformLocation(name), data);
        }
    }

    @Override
    public void setVariable(String name, float x, float y) {
        if (this.uniforms.containsKey(name)) {
            GL20.glUniform2f(this.getUniformLocation(name), x, y);
        }
    }

    @Override
    public void setVariable(String name, float x, float y, float z) {
        if (this.uniforms.containsKey(name)) {
            GL20.glUniform3f(this.getUniformLocation(name), x, y, z);
        }
    }

    @Override
    public void setVariable(String name, float x, float y, float z, float w) {
        if (this.uniforms.containsKey(name)) {
            GL20.glUniform4f(this.getUniformLocation(name), x, y, z, w);
        }
    }

    @Override
    public void setVariable(String name, FloatBuffer fb) {
        if (this.uniforms.containsKey(name)) {
            GL20.glUniformMatrix4fv(this.getUniformLocation(name), false, fb);
        }
    }

    @Override
    public Map<String, Integer> getUniformLocations() {
        if (!this.uniforms.isEmpty()) {
            return this.uniforms;
        }
        int[] count = new int[1];
        GL20.glGetProgramiv(this.handle, 35718, count);
        logger.finest("Active Uniforms: " + count[0]);
        for (int i = 0; i < count[0]; ++i) {
            IntBuffer size = BufferUtils.createIntBuffer(1);
            IntBuffer type = BufferUtils.createIntBuffer(1);
            String name = GL20.glGetActiveUniform(this.handle, i, size, type);
            int loc = this.getUniformLocation(name);
            logger.finest("Type: " + type.get() + ", Name: " + name);
            this.uniforms.put(name, loc);
        }
        return this.uniforms;
    }

    @Override
    public void dispose() {
        GL20.glUseProgram(0);
        GL20.glDeleteProgram(this.handle);
    }
}

