/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.ogl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryUtil;

public class OGLUtils {
    private static final Logger logger = Logger.getLogger(OGLUtils.class.getName());

    public static int createShader(String resource, int type) throws IOException {
        return OGLUtils.createShader(resource, type, null);
    }

    private static ByteBuffer resizeBuffer(ByteBuffer buffer, int newCapacity) {
        ByteBuffer newBuffer = BufferUtils.createByteBuffer(newCapacity);
        buffer.flip();
        newBuffer.put(buffer);
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer ioResourceToByteBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        File file = new File(url.getFile());
        if (file.isFile()) {
            FileInputStream fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            fc.close();
            fis.close();
        } else {
            buffer = BufferUtils.createByteBuffer(bufferSize);
            InputStream source = url.openStream();
            if (source == null) {
                throw new FileNotFoundException(resource);
            }
            try (ReadableByteChannel rbc = Channels.newChannel(source);){
                int bytes;
                while ((bytes = rbc.read(buffer)) != -1) {
                    if (buffer.remaining() != 0) continue;
                    buffer = OGLUtils.resizeBuffer(buffer, buffer.capacity() * 2);
                }
                buffer.flip();
            }
            finally {
                source.close();
            }
        }
        return buffer;
    }

    public static int createShader(String resource, int type, String version) throws IOException {
        IntBuffer lengths;
        PointerBuffer strings;
        int shader = GL20.glCreateShader(type);
        ByteBuffer source = OGLUtils.ioResourceToByteBuffer(resource, 8192);
        if (version == null) {
            strings = BufferUtils.createPointerBuffer(1);
            lengths = BufferUtils.createIntBuffer(1);
            strings.put(0, source);
            lengths.put(0, source.remaining());
            GL20.glShaderSource(shader, strings, lengths);
        } else {
            strings = BufferUtils.createPointerBuffer(2);
            lengths = BufferUtils.createIntBuffer(2);
            ByteBuffer preamble = MemoryUtil.memUTF8("#version " + version + "\n", false);
            strings.put(0, preamble);
            lengths.put(0, preamble.remaining());
            strings.put(1, source);
            lengths.put(1, source.remaining());
            GL20.glShaderSource(shader, strings, lengths);
        }
        GL20.glCompileShader(shader);
        int compiled = GL20.glGetShaderi(shader, 35713);
        String shaderLog = GL20.glGetShaderInfoLog(shader);
        if (shaderLog != null && shaderLog.trim().length() > 0) {
            logger.severe(resource + ":" + shaderLog);
        }
        if (compiled == 0) {
            throw new AssertionError((Object)"Could not compile shader");
        }
        return shader;
    }
}

