/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.exitus.gfxlib.ogl.OGLUtils;
import net.exitus.gfxlib.resources.Texture;
import net.exitus.gfxlib.resources.TextureType;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.stb.STBImage;

public class CubeTexture
extends Texture {
    public CubeTexture(String front, String back, String top, String bottom, String left, String right, boolean insideCube) throws IOException {
        super(TextureType.CUBE_TEXTURE);
        if (insideCube) {
            String tmp = back;
            back = front;
            front = tmp;
        }
        this.bind(0);
        ImageData imgData = this.loadImgData(front, !insideCube);
        GL11.glTexImage2D(34074, 0, 34842, imgData.width, imgData.height, 0, 6408, 5121, imgData.data);
        STBImage.stbi_image_free(imgData.data);
        imgData = this.loadImgData(back, !insideCube);
        GL11.glTexImage2D(34073, 0, 34842, imgData.width, imgData.height, 0, 6408, 5121, imgData.data);
        STBImage.stbi_image_free(imgData.data);
        imgData = this.loadImgData(top, !insideCube);
        GL11.glTexImage2D(34071, 0, 34842, imgData.width, imgData.height, 0, 6408, 5121, imgData.data);
        STBImage.stbi_image_free(imgData.data);
        imgData = this.loadImgData(bottom, !insideCube);
        GL11.glTexImage2D(34072, 0, 34842, imgData.width, imgData.height, 0, 6408, 5121, imgData.data);
        STBImage.stbi_image_free(imgData.data);
        imgData = this.loadImgData(left, !insideCube);
        GL11.glTexImage2D(34070, 0, 34842, imgData.width, imgData.height, 0, 6408, 5121, imgData.data);
        STBImage.stbi_image_free(imgData.data);
        imgData = this.loadImgData(right, !insideCube);
        GL11.glTexImage2D(34069, 0, 34842, imgData.width, imgData.height, 0, 6408, 5121, imgData.data);
        STBImage.stbi_image_free(imgData.data);
        GL11.glTexParameteri(34067, 10240, 9729);
        GL11.glTexParameteri(34067, 10241, 9729);
        GL11.glTexParameteri(34067, 32882, 33071);
        GL11.glTexParameteri(34067, 10242, 33071);
        GL11.glTexParameteri(34067, 10243, 33071);
        this.unbind();
    }

    private ImageData loadImgData(String fileName, boolean flipVert) throws IOException {
        IntBuffer width = BufferUtils.createIntBuffer(1);
        IntBuffer height = BufferUtils.createIntBuffer(1);
        IntBuffer components = BufferUtils.createIntBuffer(1);
        STBImage.stbi_set_flip_vertically_on_load(flipVert);
        ByteBuffer data = STBImage.stbi_load_from_memory(OGLUtils.ioResourceToByteBuffer(fileName, 1024), width, height, components, 4);
        ImageData imgData = new ImageData(width.get(), height.get(), data);
        return imgData;
    }

    private class ImageData {
        int width;
        int height;
        ByteBuffer data;

        public ImageData(int width, int height, ByteBuffer data) {
            this.width = width;
            this.height = height;
            this.data = data;
        }
    }
}

