/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import net.exitus.gfxlib.CursorPositionListener;
import net.exitus.gfxlib.KeyListener;
import net.exitus.gfxlib.resources.Camera;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;

public class FreeCamera
implements KeyListener,
CursorPositionListener,
Camera {
    private float fov;
    private float resolutionWidth;
    private float resolutionHeight;
    private float near;
    private float far;
    private Vector3f position = new Vector3f(0.0f, 0.0f, 10.0f);
    private Vector3f direction = new Vector3f(0.0f, 0.0f, -10.0f);
    private Vector3f right = new Vector3f(1.0f, 0.0f, 0.0f);
    private Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
    float verticalAngle = 0.0f;
    float horizontalAngle = 180.0f;
    float moveSpeedForward = 0.0f;
    float moveSpeedStrafe = 0.0f;
    float moveSpeed = 10.0f;
    private boolean holdingForward;
    private boolean holdingBackward;
    private boolean holdingStrafeLeft;
    private boolean holdingStrafeRight;
    private Matrix4f vp;
    private Matrix4f proj;
    private Matrix4f view;

    public FreeCamera(float fov, int resolutionWidth, int resolutionHeight, float near, float far) {
        this.fov = fov;
        this.resolutionWidth = resolutionWidth;
        this.resolutionHeight = resolutionHeight;
        this.near = near;
        this.far = far;
        this.vp = new Matrix4f();
        this.proj = new Matrix4f();
        this.view = new Matrix4f();
    }

    @Override
    public void update(double delta) {
        this.direction.x = (float)(Math.cos(Math.toRadians(this.verticalAngle)) * Math.sin(Math.toRadians(this.horizontalAngle)));
        this.direction.y = (float)Math.sin(Math.toRadians(this.verticalAngle));
        this.direction.z = (float)(Math.cos(Math.toRadians(this.verticalAngle)) * Math.cos(Math.toRadians(this.horizontalAngle)));
        this.right.x = (float)Math.sin(Math.toRadians(this.horizontalAngle - 90.0f));
        this.right.y = 0.0f;
        this.right.z = (float)Math.cos(Math.toRadians(this.horizontalAngle - 90.0f));
        this.up.set(this.right);
        this.up.cross(this.direction);
        if (this.holdingForward) {
            this.position.add(this.direction.mul((float)(delta * (double)this.moveSpeed)));
        } else if (this.holdingBackward) {
            this.position.sub(this.direction.mul((float)(delta * (double)this.moveSpeed)));
        }
        if (this.holdingStrafeRight) {
            this.position.add(this.right.mul((float)(delta * (double)this.moveSpeed)));
        } else if (this.holdingStrafeLeft) {
            this.position.sub(this.right.mul((float)(delta * (double)this.moveSpeed)));
        }
    }

    @Override
    public Matrix4f getViewProjection() {
        this.vp.identity();
        this.vp.perspective((float)Math.toRadians(this.fov), this.resolutionWidth / this.resolutionHeight, this.near, this.far);
        this.vp.lookAt(this.position.x, this.position.y, this.position.z, this.position.x + this.direction.x, this.position.y + this.direction.y, this.position.z + this.direction.z, this.up.x, this.up.y, this.up.z);
        return this.vp;
    }

    @Override
    public void handleKey(int key, int scancode, int action, int mods) {
        if (action == 1 || action == 2) {
            if (key == 87) {
                this.holdingForward = true;
            } else if (key == 83) {
                this.holdingBackward = true;
            }
            if (key == 65) {
                this.holdingStrafeLeft = true;
            } else if (key == 68) {
                this.holdingStrafeRight = true;
            }
        } else {
            if (key == 87) {
                this.holdingForward = false;
            } else if (key == 83) {
                this.holdingBackward = false;
            }
            if (key == 65) {
                this.holdingStrafeLeft = false;
            } else if (key == 68) {
                this.holdingStrafeRight = false;
            }
        }
    }

    @Override
    public void handleCursorPosition(long window, double xpos, double ypos) {
        int windowMidX = (int)(this.resolutionWidth * 0.5f);
        int windowMidY = (int)(this.resolutionHeight * 0.5f);
        this.horizontalAngle = (float)((double)this.horizontalAngle + ((double)windowMidX - xpos) * (double)0.1f);
        this.verticalAngle = (float)((double)this.verticalAngle + ((double)windowMidY - ypos) * (double)0.1f);
        GLFW.glfwSetCursorPos(window, windowMidX, windowMidY);
    }

    @Override
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    public Vector3f getLookAt() {
        return new Vector3f(this.position).add(this.direction);
    }

    @Override
    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    @Override
    public void setLookAt(float x, float y, float z) {
        this.direction.set(x - this.position.x, y - this.position.y, z - this.position.z);
    }

    @Override
    public Matrix4f getView() {
        this.view.identity();
        this.view.lookAt(this.position.x, this.position.y, this.position.z, this.position.x + this.direction.x, this.position.y + this.direction.y, this.position.z + this.direction.z, this.up.x, this.up.y, this.up.z);
        return this.view;
    }

    @Override
    public Matrix4f getProjection() {
        this.proj.identity();
        this.proj.perspective((float)Math.toRadians(this.fov), this.resolutionWidth / this.resolutionHeight, this.near, this.far);
        return this.proj;
    }
}

