/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.exitus.gfxlib.Disposable;
import net.exitus.gfxlib.resources.VertexLayout;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class GPUBuffer
implements Disposable {
    private final String name;
    private boolean isBound;
    private final int bufferId;
    private final int bufferType;
    private final List<VertexLayout> layout;

    public GPUBuffer(String name, float[] data, List<VertexLayout> layout) {
        this.name = name;
        FloatBuffer fb = BufferUtils.createFloatBuffer(data.length);
        fb.put(data);
        fb.flip();
        this.bufferId = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, this.bufferId);
        GL15.glBufferData(34962, fb, 35044);
        GL15.glBindBuffer(34962, 0);
        this.bufferType = 34962;
        this.layout = layout;
    }

    public GPUBuffer(String name, int[] data) {
        this.name = name;
        IntBuffer fb = BufferUtils.createIntBuffer(data.length);
        fb.put(data);
        fb.flip();
        this.bufferId = GL15.glGenBuffers();
        GL15.glBindBuffer(34963, this.bufferId);
        GL15.glBufferData(34963, fb, 35044);
        GL15.glBindBuffer(34963, 0);
        this.bufferType = 34963;
        this.layout = null;
    }

    private int getStride() {
        int stride = 0;
        for (VertexLayout lo : this.layout) {
            stride += lo.getSize();
        }
        return stride;
    }

    public void enableVertexAttributes() {
        int FLOAT_SIZE_GL = 4;
        int stride = this.getStride();
        int offset = 0;
        for (VertexLayout lo : this.layout) {
            GL20.glEnableVertexAttribArray(lo.getLayout());
            GL20.glVertexAttribPointer(lo.getLayout(), lo.getSize(), 5126, false, stride * 4, offset * 4);
            offset += lo.getSize();
        }
    }

    public void disableVertexAttributes() {
        for (VertexLayout lo : this.layout) {
            GL20.glDisableVertexAttribArray(lo.getLayout());
        }
    }

    public void bind() {
        if (!this.isBound) {
            this.isBound = true;
            GL15.glBindBuffer(this.bufferType, this.bufferId);
        }
    }

    public void unbind() {
        if (this.isBound) {
            this.isBound = false;
            GL15.glBindBuffer(this.bufferType, 0);
        }
    }

    public boolean isBound() {
        return this.isBound;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void dispose() {
        GL15.glDeleteBuffers(this.bufferId);
    }
}

