/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import net.exitus.gfxlib.Disposable;
import net.exitus.gfxlib.resources.GPUBuffer;
import org.lwjgl.opengl.GL30;

public class GPUBufferGroup
implements Disposable {
    private int vaoId = GL30.glGenVertexArrays();
    private GPUBuffer vertexBuffer;
    private GPUBuffer indexBuffer;

    public GPUBufferGroup(GPUBuffer vertexBuffer, GPUBuffer indexBuffer) {
        GL30.glBindVertexArray(this.vaoId);
        vertexBuffer.bind();
        vertexBuffer.enableVertexAttributes();
        if (indexBuffer != null) {
            indexBuffer.bind();
        }
        GL30.glBindVertexArray(0);
        vertexBuffer.unbind();
        vertexBuffer.disableVertexAttributes();
        if (indexBuffer != null) {
            indexBuffer.unbind();
        }
        this.vertexBuffer = vertexBuffer;
        this.indexBuffer = indexBuffer;
    }

    public void bind() {
        GL30.glBindVertexArray(this.vaoId);
    }

    public void unbind() {
        GL30.glBindVertexArray(0);
    }

    @Override
    public void dispose() {
        this.vertexBuffer.unbind();
        this.vertexBuffer.dispose();
        if (this.indexBuffer != null) {
            this.indexBuffer.unbind();
            this.indexBuffer.dispose();
        }
        this.unbind();
        GL30.glDeleteVertexArrays(this.vaoId);
    }
}

