/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import net.exitus.gfxlib.resources.Camera;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class LookAtCamera
implements Camera {
    private float fov;
    private float resolutionWidth;
    private float resolutionHeight;
    private float near;
    private float far;
    private Vector3f position;
    private Vector3f lookAt;
    private Matrix4f vp;
    private Matrix4f view;
    private Matrix4f proj;

    public LookAtCamera(float fov, int resolutionWidth, int resolutionHeight, float near, float far, Vector3f position, Vector3f lookAt) {
        this.fov = fov;
        this.resolutionWidth = resolutionWidth;
        this.resolutionHeight = resolutionHeight;
        this.near = near;
        this.far = far;
        this.position = position;
        this.lookAt = lookAt;
        this.vp = new Matrix4f();
        this.view = new Matrix4f();
        this.proj = new Matrix4f();
    }

    @Override
    public Matrix4f getViewProjection() {
        return this.vp;
    }

    @Override
    public void update(double delta) {
        this.vp.identity();
        this.vp.perspective((float)Math.toRadians(this.fov), this.resolutionWidth / this.resolutionHeight, this.near, this.far).lookAt(this.position.x, this.position.y, this.position.z, this.lookAt.x, this.lookAt.y, this.lookAt.z, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public Vector3f getPosition() {
        return this.position;
    }

    @Override
    public Vector3f getLookAt() {
        return this.lookAt;
    }

    @Override
    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    @Override
    public void setLookAt(float x, float y, float z) {
        this.lookAt.set(x, y, z);
    }

    @Override
    public Matrix4f getView() {
        this.view.identity();
        this.view.lookAt(this.position.x, this.position.y, this.position.z, this.lookAt.x, this.lookAt.y, this.lookAt.z, 0.0f, 1.0f, 0.0f);
        return this.view;
    }

    @Override
    public Matrix4f getProjection() {
        this.proj.identity();
        this.proj.perspective((float)Math.toRadians(this.fov), this.resolutionWidth / this.resolutionHeight, this.near, this.far);
        return this.proj;
    }
}

