/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.exitus.gfxlib.resources.MaterialParam;
import net.exitus.gfxlib.resources.Texture;
import net.exitus.gfxlib.resources.Updateable;
import net.exitus.gfxlib.shader.Shader;

public class Material
implements Updateable {
    private String name;
    private Shader shader;
    private List<Texture> textures;
    private Map<String, Texture> namedTextures;
    private Map<String, MaterialParam> parameters;
    private int textureCount = 0;

    public Material(String name, Shader shader) {
        this.name = name;
        this.shader = shader;
        this.textures = new ArrayList<Texture>();
        this.namedTextures = new HashMap<String, Texture>();
        this.parameters = new HashMap<String, MaterialParam>();
    }

    public void bind() {
        this.shader.bind();
        for (int i = 0; i < this.textures.size(); ++i) {
            this.textures.get(i).bind(i);
        }
    }

    public void unbind() {
        for (int i = 0; i < this.textures.size(); ++i) {
            this.textures.get(i).unbind();
        }
        this.shader.unbind();
    }

    private MaterialParam getParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return this.parameters.get(name);
        }
        MaterialParam p = new MaterialParam(name);
        this.parameters.put(name, p);
        return p;
    }

    public void setParameter(String name, Object data) {
        MaterialParam p = this.getParameter(name);
        p.setData(data);
    }

    public Material addTexture(String nameInShader, Texture tex) {
        this.textures.add(tex);
        this.namedTextures.put(nameInShader, tex);
        return this;
    }

    @Override
    public void update(double delta, double time) {
        this.shader.bind();
        for (Map.Entry<String, MaterialParam> p : this.parameters.entrySet()) {
            MaterialParam param = p.getValue();
            if (param.getData() instanceof Integer) {
                this.shader.setVariable(p.getKey(), (Integer)param.getData());
                continue;
            }
            if (param.getData() instanceof Float || param.getData() instanceof Double) {
                this.shader.setVariable(p.getKey(), ((Float)param.getData()).floatValue());
                continue;
            }
            if (param.getData() instanceof FloatBuffer) {
                this.shader.setVariable(p.getKey(), (FloatBuffer)param.getData());
                continue;
            }
            if (!(param.getData() instanceof float[])) continue;
            float[] arr = (float[])param.getData();
            if (arr.length == 2) {
                this.shader.setVariable(p.getKey(), arr[0], arr[1]);
                continue;
            }
            if (arr.length == 3) {
                this.shader.setVariable(p.getKey(), arr[0], arr[1], arr[2]);
                continue;
            }
            if (arr.length != 4) continue;
            this.shader.setVariable(p.getKey(), arr[0], arr[1], arr[2], arr[3]);
        }
        this.shader.unbind();
    }
}

