/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.util.Arrays;
import java.util.List;
import net.exitus.gfxlib.Disposable;
import net.exitus.gfxlib.resources.GPUBuffer;
import net.exitus.gfxlib.resources.GPUBufferGroup;
import net.exitus.gfxlib.resources.MeshFrontFace;
import net.exitus.gfxlib.resources.MeshType;
import net.exitus.gfxlib.resources.VertexLayout;
import org.lwjgl.opengl.GL11;

public class Mesh
implements Disposable {
    private final String name;
    private List<VertexLayout> layout;
    private float[] vertices;
    private int[] faces;
    private int stride;
    private MeshType meshType;
    private MeshFrontFace frontFace;
    private GPUBufferGroup vao;

    public Mesh(String name, MeshType type, MeshFrontFace frontFace) {
        this.name = name;
        this.meshType = type;
        this.frontFace = frontFace;
    }

    public Mesh(String name) {
        this.name = name;
        this.meshType = MeshType.TRIANGLES;
        this.frontFace = MeshFrontFace.CCW;
    }

    public String getName() {
        return this.name;
    }

    public void setFaces(int[] faces) {
        this.faces = faces;
    }

    public void setVertices(float[] vertices, List<VertexLayout> layout) {
        this.vertices = vertices;
        this.layout = layout;
        for (VertexLayout l : layout) {
            this.stride += l.getSize();
        }
    }

    public void draw() {
        this.vao.bind();
        GL11.glFrontFace(this.frontFace.getGlCode());
        if (this.faces != null) {
            GL11.glDrawElements(this.meshType.getGLCode(), this.faces.length, 5125, 0L);
        } else {
            GL11.glDrawArrays(this.meshType.getGLCode(), 0, this.vertices.length / this.stride);
        }
        this.vao.unbind();
    }

    public void uploadToGPU() {
        GPUBuffer vertexBuffer = new GPUBuffer(this.name + "VBO", this.vertices, this.layout);
        GPUBuffer indexBuffer = null;
        if (this.faces != null) {
            indexBuffer = new GPUBuffer(this.name + "IBO", this.faces);
        }
        this.vao = new GPUBufferGroup(vertexBuffer, indexBuffer);
    }

    public String toString() {
        return "Mesh{name=" + this.name + ",\nvertices=" + Arrays.toString(this.vertices) + "\nfaces=" + Arrays.toString(this.faces) + "\n}";
    }

    @Override
    public void dispose() {
        this.vao.dispose();
    }
}

