/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.exitus.gfxlib.resources.Mesh;
import net.exitus.gfxlib.resources.Vertex;

public class MeshBuilder {
    private String meshName;
    private List<Vertex> vertices;
    private List<Integer> faces;

    public MeshBuilder(String name) {
        this.meshName = name;
        this.vertices = new ArrayList<Vertex>();
        this.faces = new ArrayList<Integer>();
    }

    public String getName() {
        return this.meshName;
    }

    public void addVertex(Vertex v) {
        this.vertices.add(v);
    }

    public void addFace(int i) {
        this.faces.add(i);
    }

    private float[] getVerticesInterleaved() {
        float[] result = new float[this.vertices.get(0).getStructSize() * this.vertices.size()];
        int idx = 0;
        for (Vertex v : this.vertices) {
            float[] datamember = v.getInterleavedArray();
            for (int i = 0; i < datamember.length; ++i) {
                result[idx++] = datamember[i];
            }
        }
        return result;
    }

    public Mesh createMesh() {
        Mesh m = new Mesh(this.meshName);
        int[] facesForMesh = new int[this.faces.size()];
        Iterator<Integer> iterator = this.faces.iterator();
        for (int i = 0; i < facesForMesh.length; ++i) {
            facesForMesh[i] = iterator.next();
        }
        m.setVertices(this.getVerticesInterleaved(), this.vertices.get(0).getLayout());
        m.setFaces(facesForMesh);
        return m;
    }
}

