/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.exitus.gfxlib.resources.Material;
import net.exitus.gfxlib.resources.Mesh;
import net.exitus.gfxlib.resources.Updateable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;

public class Model
implements Updateable {
    private String name;
    private Mesh mesh;
    private Material material;
    private Matrix4f transformation;
    private Vector3f pos = new Vector3f();
    private Vector3f rot = new Vector3f();
    private Vector3f sca = new Vector3f(1.0f, 1.0f, 1.0f);
    private Vector3f moveSpd = new Vector3f();
    private Vector3f rotSpd = new Vector3f();
    private Vector3f scaSpd = new Vector3f();
    private Model parent;
    private List<Model> children;

    public Model(String name, Mesh mesh, Material material, Model parent) {
        this.name = name;
        this.mesh = mesh;
        this.material = material;
        this.parent = parent;
        this.children = new ArrayList<Model>();
        this.transformation = new Matrix4f();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public void setMesh(Mesh mesh) {
        this.mesh = mesh;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Model getParent() {
        return this.parent;
    }

    public void setParent(Model parent) {
        this.parent = parent;
    }

    public void setMoveSpd(float x, float y, float z) {
        this.moveSpd.set(x, y, z);
    }

    public void setRotSpd(float x, float y, float z) {
        this.rotSpd.set(x, y, z);
    }

    public void setScaSpd(float x, float y, float z) {
        this.scaSpd.set(x, y, z);
    }

    public void setPosition(float x, float y, float z) {
        this.pos.set(x, y, z);
    }

    public void setRotation(float x, float y, float z) {
        this.rot.set(x, y, z);
    }

    public void setScale(float x, float y, float z) {
        this.sca.set(x, y, z);
    }

    public Vector3f getPosition() {
        return this.pos;
    }

    @Override
    public void update(double delta, double time) {
        this.pos.add((float)((double)this.moveSpd.x * delta), (float)((double)this.moveSpd.y * delta), (float)((double)this.moveSpd.z * delta));
        this.rot.add((float)((double)this.rotSpd.x * delta), (float)((double)this.rotSpd.y * delta), (float)((double)this.rotSpd.z * delta));
        this.sca.add((float)((double)this.scaSpd.x * delta), (float)((double)this.scaSpd.y * delta), (float)((double)this.scaSpd.z * delta));
        this.material.setParameter("time", Float.valueOf((float)time));
    }

    public void draw(Matrix4f vp, Matrix4f v, Matrix4f p) {
        this.transformation.identity();
        this.transformation.translate(this.pos).rotateXYZ((float)Math.toRadians(this.rot.x), (float)Math.toRadians(this.rot.y), (float)Math.toRadians(this.rot.z)).scale(this.sca);
        Matrix4f mvp = new Matrix4f(vp);
        mvp.mul(this.transformation);
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer fb = stack.callocFloat(16);
            this.material.setParameter("mvp", mvp.get(fb));
            fb = stack.callocFloat(16);
            this.material.setParameter("M", this.transformation.get(fb));
            fb = stack.callocFloat(16);
            this.material.setParameter("V", v.get(fb));
            fb = stack.callocFloat(16);
            this.material.setParameter("P", p.get(fb));
        }
        this.material.update(0.0, 0.0);
        this.material.bind();
        this.mesh.draw();
        this.material.unbind();
    }

    public void draw() {
        this.material.update(0.0, 0.0);
        this.material.bind();
        this.mesh.draw();
        this.material.unbind();
    }
}

