/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.exitus.gfxlib.resources.Texture;
import org.lwjgl.opengl.GL30;

public class RenderToTexture {
    protected static final Logger logger = Logger.getLogger(RenderToTexture.class.getName());
    private int fbo;
    private Texture texture;

    public RenderToTexture(Texture texture) throws Exception {
        this.texture = texture;
        this.fbo = GL30.glGenFramebuffers();
        this.bind();
        GL30.glFramebufferTexture2D(36160, 36064, texture.getTextureType().getGlType(), texture.getId(), 0);
        this.checkFrameBufferStatus();
        this.unbind();
    }

    private void checkFrameBufferStatus() throws Exception {
        int status = GL30.glCheckFramebufferStatus(36160);
        if (status != 36053) {
            if (status == 36061) {
                logger.log(Level.SEVERE, "Framebuffer format unsupported!");
                throw new Exception("Unsupported framebuffer format!");
            }
            logger.log(Level.SEVERE, "Framebuffer error!");
            throw new Exception("Error creating framebuffer!");
        }
        logger.log(Level.FINEST, "Framebuffer complete!");
    }

    public void bind() {
        GL30.glBindFramebuffer(36160, this.fbo);
    }

    public void unbind() {
        GL30.glBindFramebuffer(36160, 0);
    }

    public Texture getTexture() {
        return this.texture;
    }

    public int getId() {
        return this.fbo;
    }
}

