/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.exitus.gfxlib.Disposable;
import net.exitus.gfxlib.ogl.OGLUtils;
import net.exitus.gfxlib.resources.TextureType;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL32;
import org.lwjgl.stb.STBImage;

public class Texture
implements Disposable {
    TextureType textureType;
    private int textureId;
    int width;
    int height;

    public Texture(TextureType type) {
        this.textureType = type;
        this.textureId = GL11.glGenTextures();
    }

    public Texture(String fileName, int aniso) throws IOException {
        this(fileName, TextureType.TEXTURE2D, aniso);
    }

    public Texture(String fileName, TextureType textureType, int aniso) throws IOException {
        this.textureType = textureType;
        IntBuffer width = BufferUtils.createIntBuffer(1);
        IntBuffer height = BufferUtils.createIntBuffer(1);
        IntBuffer components = BufferUtils.createIntBuffer(1);
        STBImage.stbi_set_flip_vertically_on_load(true);
        ByteBuffer data = STBImage.stbi_load_from_memory(OGLUtils.ioResourceToByteBuffer(fileName, 1024), width, height, components, 4);
        this.textureId = GL11.glGenTextures();
        GL11.glBindTexture(this.textureType.getGlType(), this.textureId);
        this.setAnisotropyLevel(aniso);
        GL11.glTexImage2D(this.textureType.getGlType(), 0, 34842, width.get(), height.get(), 0, 6408, 5121, data);
        GL30.glGenerateMipmap(this.textureType.getGlType());
        STBImage.stbi_image_free(data);
        GL11.glBindTexture(this.textureType.getGlType(), 0);
        this.width = width.get(0);
        this.height = height.get(0);
    }

    public Texture(int width, int height, boolean mipmap, int aniso, TextureType textureType, int numSamples) {
        this.textureType = textureType;
        this.textureId = GL11.glGenTextures();
        GL11.glBindTexture(this.textureType.getGlType(), this.textureId);
        if (mipmap) {
            this.setAnisotropyLevel(aniso);
        } else {
            GL11.glTexParameteri(this.textureType.getGlType(), 10240, 9728);
            GL11.glTexParameteri(this.textureType.getGlType(), 10241, 9728);
        }
        GL11.glTexParameteri(3553, 10242, 33071);
        GL11.glTexParameteri(3553, 10243, 33071);
        if (this.textureType == TextureType.TEXTURE2D) {
            GL11.glTexImage2D(this.textureType.getGlType(), 0, 34842, width, height, 0, 6408, 5126, 0L);
        } else if (this.textureType == TextureType.TEXTURE2D_MSAA) {
            GL32.glTexImage2DMultisample(this.textureType.getGlType(), numSamples, 34842, width, height, false);
        }
        if (mipmap) {
            GL30.glGenerateMipmap(this.textureType.getGlType());
        }
        GL11.glBindTexture(this.textureType.getGlType(), 0);
        this.width = width;
        this.height = height;
    }

    private void setAnisotropyLevel(int aniso) {
        if (aniso > 0) {
            GL11.glTexParameterf(this.textureType.getGlType(), 34046, aniso);
            GL11.glTexParameteri(this.textureType.getGlType(), 10241, 9987);
            GL11.glTexParameteri(this.textureType.getGlType(), 10240, 9729);
        } else {
            GL11.glTexParameteri(this.textureType.getGlType(), 10241, 9987);
            GL11.glTexParameteri(this.textureType.getGlType(), 10240, 9987);
        }
    }

    public void bind(int activeUnit) {
        GL13.glActiveTexture(33984 + activeUnit);
        GL11.glBindTexture(this.textureType.getGlType(), this.textureId);
    }

    public void unbind() {
        GL11.glBindTexture(this.textureType.getGlType(), 0);
    }

    @Override
    public void dispose() {
        GL11.glDeleteTextures(this.textureId);
    }

    public int getId() {
        return this.textureId;
    }

    public TextureType getTextureType() {
        return this.textureType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

