/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.resources;

import java.util.ArrayList;
import java.util.Arrays;
import net.exitus.gfxlib.resources.VertexLayout;

public class Vertex {
    float[] pos;
    float[] norm;
    float[] tangent;
    float[] binorm;
    float[] uv1;
    float[] uv2;
    float[] uv3;
    float[] uv4;
    float[] color1;
    float[] color2;
    private int structSize;

    public void setPos(float x, float y, float z) {
        this.pos = new float[]{x, y, z};
    }

    public void setNorm(float nx, float ny, float nz) {
        this.norm = new float[]{nx, ny, nz};
    }

    public void setTangent(float tx, float ty, float tz) {
        this.tangent = new float[]{tx, ty, tz};
    }

    public void setBinorm(float bx, float by, float bz) {
        this.binorm = new float[]{bx, by, bz};
    }

    public void setUv1(float u, float v) {
        this.uv1 = new float[]{u, v};
    }

    public void setUv2(float u, float v) {
        this.uv2 = new float[]{u, v};
    }

    public void setUv3(float u, float v) {
        this.uv3 = new float[]{u, v};
    }

    public void setUv4(float u, float v) {
        this.uv4 = new float[]{u, v};
    }

    public void setColor1(float r, float g, float b, float a) {
        this.color1 = new float[]{r, g, b, a};
    }

    public void setColor2(float r, float g, float b, float a) {
        this.color2 = new float[]{r, g, b, a};
    }

    public float[] getPos() {
        return this.pos;
    }

    public float[] getNorm() {
        return this.norm;
    }

    public float[] getTangent() {
        return this.tangent;
    }

    public float[] getBinorm() {
        return this.binorm;
    }

    public float[] getUv1() {
        return this.uv1;
    }

    public float[] getUv2() {
        return this.uv2;
    }

    public float[] getUv3() {
        return this.uv3;
    }

    public float[] getUv4() {
        return this.uv4;
    }

    public float[] getColor1() {
        return this.color1;
    }

    public float[] getColor2() {
        return this.color2;
    }

    public int getStructSize() {
        ArrayList<VertexLayout> l = this.getLayout();
        return this.structSize;
    }

    public float[] getInterleavedArray() {
        ArrayList<VertexLayout> list = this.getLayout();
        float[] interleaved = new float[this.structSize];
        int index = 0;
        float[] data = null;
        for (VertexLayout lo : list) {
            if (lo == VertexLayout.POS) {
                data = this.pos;
            } else if (lo == VertexLayout.NORMAL) {
                data = this.norm;
            } else if (lo == VertexLayout.TANGENT) {
                data = this.tangent;
            } else if (lo == VertexLayout.BINORMAL) {
                data = this.binorm;
            } else if (lo == VertexLayout.TEXCOORD1) {
                data = this.uv1;
            } else if (lo == VertexLayout.TEXCOORD2) {
                data = this.uv2;
            } else if (lo == VertexLayout.TEXCOORD3) {
                data = this.uv3;
            } else if (lo == VertexLayout.TEXCOORD4) {
                data = this.uv4;
            } else if (lo == VertexLayout.COLOR1) {
                data = this.color1;
            } else if (lo == VertexLayout.COLOR2) {
                data = this.color2;
            }
            for (int i = 0; i < data.length; ++i) {
                interleaved[index++] = data[i];
            }
        }
        return interleaved;
    }

    public ArrayList<VertexLayout> getLayout() {
        ArrayList<VertexLayout> layouts = new ArrayList<VertexLayout>();
        this.structSize = 0;
        if (this.pos != null) {
            layouts.add(VertexLayout.POS);
            this.structSize += VertexLayout.POS.getSize();
        }
        if (this.norm != null) {
            layouts.add(VertexLayout.NORMAL);
            this.structSize += VertexLayout.NORMAL.getSize();
        }
        if (this.tangent != null) {
            layouts.add(VertexLayout.TANGENT);
            this.structSize += VertexLayout.TANGENT.getSize();
        }
        if (this.binorm != null) {
            layouts.add(VertexLayout.BINORMAL);
            this.structSize += VertexLayout.BINORMAL.getSize();
        }
        if (this.uv1 != null) {
            layouts.add(VertexLayout.TEXCOORD1);
            this.structSize += VertexLayout.TEXCOORD1.getSize();
        }
        if (this.uv2 != null) {
            layouts.add(VertexLayout.TEXCOORD2);
            this.structSize += VertexLayout.TEXCOORD2.getSize();
        }
        if (this.uv3 != null) {
            layouts.add(VertexLayout.TEXCOORD3);
            this.structSize += VertexLayout.TEXCOORD3.getSize();
        }
        if (this.uv4 != null) {
            layouts.add(VertexLayout.TEXCOORD4);
            this.structSize += VertexLayout.TEXCOORD4.getSize();
        }
        if (this.color1 != null) {
            layouts.add(VertexLayout.COLOR1);
            this.structSize += VertexLayout.COLOR1.getSize();
        }
        if (this.color2 != null) {
            layouts.add(VertexLayout.COLOR2);
            this.structSize += VertexLayout.COLOR2.getSize();
        }
        return layouts;
    }

    public String toString() {
        return "Vertex{pos=" + Arrays.toString(this.pos) + ", norm=" + Arrays.toString(this.norm) + ", tangent=" + Arrays.toString(this.tangent) + ", binorm=" + Arrays.toString(this.binorm) + ", uv1=" + Arrays.toString(this.uv1) + ", uv2=" + Arrays.toString(this.uv2) + ", uv3=" + Arrays.toString(this.uv3) + ", uv4=" + Arrays.toString(this.uv4) + ", color1=" + Arrays.toString(this.color1) + ", color2=" + Arrays.toString(this.color2) + '}';
    }
}

