/*
 * Decompiled with CFR 0.152.
 */
package net.exitus.gfxlib.utils.loaders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.exitus.gfxlib.resources.Mesh;
import net.exitus.gfxlib.resources.MeshBuilder;
import net.exitus.gfxlib.resources.Vertex;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONModelLoader {
    private static final Logger logger = Logger.getLogger(JSONModelLoader.class.getName());
    private final Path path;
    private final JSONObject root;
    private List<Mesh> meshList = new ArrayList<Mesh>();

    public JSONModelLoader(String fileName) throws IOException, URISyntaxException {
        logger.info("Parsing mesh file: " + fileName);
        this.path = null;
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);){
            this.root = new JSONObject(new String(this.readAllBytes(is)));
        }
    }

    private byte[] readAllBytes(InputStream is) throws IOException {
        byte[] byteArray;
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            int byteInt = -1;
            byteInt = is.read();
            while (byteInt != -1) {
                byteStream.write(byteInt);
                byteInt = is.read();
            }
            byteArray = byteStream.toByteArray();
        }
        return byteArray;
    }

    public Mesh parseMesh(String name) {
        JSONArray meshes = this.root.getJSONArray("meshes");
        for (int i = 0; i < meshes.length(); ++i) {
            JSONObject jsonMesh = meshes.getJSONObject(i);
            if (!name.equals(jsonMesh.getString("name"))) continue;
            MeshBuilder mBuild = new MeshBuilder(jsonMesh.getString("name"));
            this.parseMesh(mBuild, jsonMesh);
            return mBuild.createMesh();
        }
        return null;
    }

    public List<Mesh> parseMeshes() {
        JSONArray meshes = this.root.getJSONArray("meshes");
        for (int i = 0; i < meshes.length(); ++i) {
            JSONObject jsonMesh = meshes.getJSONObject(i);
            MeshBuilder mBuild = new MeshBuilder(jsonMesh.getString("name"));
            this.parseMesh(mBuild, jsonMesh);
            this.meshList.add(mBuild.createMesh());
        }
        return this.meshList;
    }

    private void parseMesh(MeshBuilder mBuild, JSONObject mesh) {
        JSONArray vertices = null;
        JSONArray normals = null;
        JSONArray tangents = null;
        JSONArray binormals = null;
        JSONArray texcoords = null;
        JSONArray colors = null;
        JSONArray faces = null;
        faces = mesh.getJSONArray("faces");
        for (int i = 0; i < faces.length(); ++i) {
            mBuild.addFace(faces.getInt(i));
        }
        vertices = mesh.getJSONArray("positions");
        try {
            normals = mesh.getJSONArray("normals");
        }
        catch (JSONException ex) {
            logger.log(Level.WARNING, "Error while parsing normals: " + ex.getMessage());
        }
        try {
            tangents = mesh.getJSONArray("tangents");
        }
        catch (JSONException ex) {
            logger.log(Level.WARNING, "Error while parsing tangents: " + ex.getMessage());
        }
        try {
            binormals = mesh.getJSONArray("binormals");
        }
        catch (JSONException ex) {
            logger.log(Level.WARNING, "Error while parsing binormals: " + ex.getMessage());
        }
        try {
            texcoords = mesh.getJSONArray("texcoords");
        }
        catch (JSONException ex) {
            logger.log(Level.WARNING, "Error while parsing texcoords: " + ex.getMessage());
        }
        try {
            colors = mesh.getJSONArray("colors");
        }
        catch (JSONException ex) {
            logger.log(Level.WARNING, "Error while parsing colors: " + ex.getMessage());
        }
        int v = 0;
        int i = 0;
        int j = 0;
        while (v < vertices.length()) {
            Vertex ve = new Vertex();
            ve.setPos((float)vertices.getDouble(v), (float)vertices.getDouble(v + 1), (float)vertices.getDouble(v + 2));
            if (normals != null) {
                ve.setNorm((float)normals.getDouble(v), (float)normals.getDouble(v + 1), (float)normals.getDouble(v + 2));
            }
            if (tangents != null) {
                ve.setTangent((float)tangents.getDouble(v), (float)tangents.getDouble(v + 1), (float)tangents.getDouble(v + 2));
            }
            if (binormals != null) {
                ve.setBinorm((float)binormals.getDouble(v), (float)binormals.getDouble(v + 1), (float)binormals.getDouble(v + 2));
            }
            if (texcoords != null && texcoords.length() > 0) {
                ve.setUv1((float)texcoords.getJSONArray(0).getDouble(i), (float)texcoords.getJSONArray(0).getDouble(i + 1));
            }
            if (texcoords != null && texcoords.length() > 1) {
                ve.setUv2((float)texcoords.getJSONArray(1).getDouble(i), (float)texcoords.getJSONArray(1).getDouble(i + 1));
            }
            if (texcoords != null && texcoords.length() > 2) {
                ve.setUv3((float)texcoords.getJSONArray(2).getDouble(i), (float)texcoords.getJSONArray(2).getDouble(i + 1));
            }
            if (texcoords != null && texcoords.length() > 3) {
                ve.setUv4((float)texcoords.getJSONArray(3).getDouble(i), (float)texcoords.getJSONArray(3).getDouble(i + 1));
            }
            if (colors != null && colors.length() > 0) {
                ve.setColor1((float)colors.getJSONArray(0).getDouble(j), (float)colors.getJSONArray(0).getDouble(j + 1), (float)colors.getJSONArray(0).getDouble(j + 2), (float)colors.getJSONArray(0).getDouble(j + 3));
            }
            if (colors != null && colors.length() > 1) {
                ve.setColor2((float)colors.getJSONArray(1).getDouble(j), (float)colors.getJSONArray(1).getDouble(j + 1), (float)colors.getJSONArray(1).getDouble(j + 2), (float)colors.getJSONArray(1).getDouble(j + 3));
            }
            mBuild.addVertex(ve);
            v += 3;
            i += 2;
            j += 4;
        }
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        JSONModelLoader loader = new JSONModelLoader("test_model.json");
        System.out.println(loader.parseMesh("cube"));
    }
}

