/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

public class Math {
    private static final boolean fastMath = Math.hasOption("joml.fastmath");
    private static final boolean sinlookup = Math.hasOption("joml.sinLookup");
    public static final double PI = java.lang.Math.PI;
    private static final double PI2 = java.lang.Math.PI * 2;
    private static final double PIHalf = 1.5707963267948966;
    private static final int lookupBits = Integer.parseInt(System.getProperty("joml.sinLookup.bits", "14"));
    private static final int lookupTableSize = 1 << lookupBits;
    private static final int lookupTableSizeMinus1 = lookupTableSize - 1;
    private static final int lookupTableSizeWithMargin = lookupTableSize + 1;
    private static final double pi2OverLookupSize = java.lang.Math.PI * 2 / (double)lookupTableSize;
    private static final double lookupSizeOverPi2 = (double)lookupTableSize / (java.lang.Math.PI * 2);
    private static final int BIG_ENOUGH_INT = 65536;
    private static final float BIG_ENOUGH_FLOAT = 65536.0f;
    private static final float[] sinTable;

    private static boolean hasOption(String option) {
        String v = System.getProperty(option);
        if (v == null) {
            return false;
        }
        if (v.trim().length() == 0) {
            return true;
        }
        return Boolean.valueOf(v);
    }

    private static int fastFloor(float x) {
        return (int)(x + 65536.0f) - 65536;
    }

    private static double sin_L_Spiro(double rad) {
        int i32I = (int)(rad * 0.3183098861837907);
        double rad_ = rad - (double)i32I * java.lang.Math.PI;
        double rad2 = rad_ * rad_;
        return (i32I & 1) != 0 ? -rad_ * (1.0 + rad2 * (-0.1666666716337204 + rad2 * (0.008333333767950535 + rad2 * ((double)-1.984125E-4f + rad2 * (2.755655714281602E-6 + rad2 * (-2.5036847262072115E-8 + rad2 * (1.5884926707343539E-10 + rad2 * -6.589255508414327E-13))))))) : rad_ * (1.0 + rad2 * (-0.1666666716337204 + rad2 * (0.008333333767950535 + rad2 * ((double)-1.984125E-4f + rad2 * (2.755655714281602E-6 + rad2 * (-2.5036847262072115E-8 + rad2 * (1.5884926707343539E-10 + rad2 * -6.589255508414327E-13)))))));
    }

    private static double sin_theagentd(double rad) {
        float index = (float)(rad * lookupSizeOverPi2);
        int ii = Math.fastFloor(index);
        float alpha = index - (float)ii;
        int i = ii & lookupTableSizeMinus1;
        float sin1 = sinTable[i];
        float sin2 = sinTable[i + 1];
        return sin1 + (sin2 - sin1) * alpha;
    }

    public static double sin(double rad) {
        if (fastMath) {
            if (sinlookup) {
                return Math.sin_theagentd(rad);
            }
            return Math.sin_L_Spiro(rad);
        }
        return java.lang.Math.sin(rad);
    }

    public static double cos(double rad) {
        if (fastMath) {
            return Math.sin(rad + 1.5707963267948966);
        }
        return java.lang.Math.cos(rad);
    }

    public static double sqrt(double r) {
        return java.lang.Math.sqrt(r);
    }

    public static double tan(double r) {
        return java.lang.Math.tan(r);
    }

    public static double acos(double r) {
        return java.lang.Math.acos(r);
    }

    public static double atan2(double y, double x) {
        return java.lang.Math.atan2(y, x);
    }

    public static double asin(double r) {
        return java.lang.Math.asin(r);
    }

    public static double abs(double r) {
        return java.lang.Math.abs(r);
    }

    public static float abs(float r) {
        return java.lang.Math.abs(r);
    }

    public static int max(int x, int y) {
        return java.lang.Math.max(x, y);
    }

    public static int min(int x, int y) {
        return java.lang.Math.min(x, y);
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    static {
        if (fastMath && sinlookup) {
            sinTable = new float[lookupTableSizeWithMargin];
            for (int i = 0; i < lookupTableSizeWithMargin; ++i) {
                double d = (double)i * pi2OverLookupSize;
                Math.sinTable[i] = (float)java.lang.Math.sin(d);
            }
        } else {
            sinTable = null;
        }
    }
}

