/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Matrix4x3f;
import org.joml.MemUtil;
import org.joml.Quaterniond;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Matrix4f
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int PLANE_NX = 0;
    public static final int PLANE_PX = 1;
    public static final int PLANE_NY = 2;
    public static final int PLANE_PY = 3;
    public static final int PLANE_NZ = 4;
    public static final int PLANE_PZ = 5;
    public static final int CORNER_NXNYNZ = 0;
    public static final int CORNER_PXNYNZ = 1;
    public static final int CORNER_PXPYNZ = 2;
    public static final int CORNER_NXPYNZ = 3;
    public static final int CORNER_PXNYPZ = 4;
    public static final int CORNER_NXNYPZ = 5;
    public static final int CORNER_NXPYPZ = 6;
    public static final int CORNER_PXPYPZ = 7;
    float m00;
    float m01;
    float m02;
    float m03;
    float m10;
    float m11;
    float m12;
    float m13;
    float m20;
    float m21;
    float m22;
    float m23;
    float m30;
    float m31;
    float m32;
    float m33;
    byte properties;
    private static final byte PROPERTY_PERSPECTIVE = 1;
    private static final byte PROPERTY_AFFINE = 2;
    private static final byte PROPERTY_IDENTITY = 4;
    private static final byte PROPERTY_TRANSLATION = 8;

    public Matrix4f() {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
        this.m33 = 1.0f;
        this.properties = (byte)14;
    }

    public Matrix4f(Matrix3f mat) {
        MemUtil.INSTANCE.copy(mat, this);
        this.m33 = 1.0f;
        this.properties = (byte)2;
    }

    public Matrix4f(Matrix4f mat) {
        MemUtil.INSTANCE.copy(mat, this);
        this.properties = mat.properties;
    }

    public Matrix4f(Matrix4x3f mat) {
        MemUtil.INSTANCE.copy(mat, this);
        this.properties = (byte)(mat.properties | 2);
    }

    public Matrix4f(Matrix4d mat) {
        this.m00 = (float)mat.m00();
        this.m01 = (float)mat.m01();
        this.m02 = (float)mat.m02();
        this.m03 = (float)mat.m03();
        this.m10 = (float)mat.m10();
        this.m11 = (float)mat.m11();
        this.m12 = (float)mat.m12();
        this.m13 = (float)mat.m13();
        this.m20 = (float)mat.m20();
        this.m21 = (float)mat.m21();
        this.m22 = (float)mat.m22();
        this.m23 = (float)mat.m23();
        this.m30 = (float)mat.m30();
        this.m31 = (float)mat.m31();
        this.m32 = (float)mat.m32();
        this.m33 = (float)mat.m33();
        this.properties = mat.properties;
    }

    public Matrix4f(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
        this.properties = 0;
    }

    public Matrix4f(FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
    }

    public Matrix4f(Vector4f col0, Vector4f col1, Vector4f col2, Vector4f col3) {
        MemUtil.INSTANCE.set(this, col0, col1, col2, col3);
    }

    public Matrix4f assumeNothing() {
        this.properties = 0;
        return this;
    }

    public Matrix4f assumeAffine() {
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f assumePerspective() {
        this.properties = 1;
        return this;
    }

    public float m00() {
        return this.m00;
    }

    public float m01() {
        return this.m01;
    }

    public float m02() {
        return this.m02;
    }

    public float m03() {
        return this.m03;
    }

    public float m10() {
        return this.m10;
    }

    public float m11() {
        return this.m11;
    }

    public float m12() {
        return this.m12;
    }

    public float m13() {
        return this.m13;
    }

    public float m20() {
        return this.m20;
    }

    public float m21() {
        return this.m21;
    }

    public float m22() {
        return this.m22;
    }

    public float m23() {
        return this.m23;
    }

    public float m30() {
        return this.m30;
    }

    public float m31() {
        return this.m31;
    }

    public float m32() {
        return this.m32;
    }

    public float m33() {
        return this.m33;
    }

    public Matrix4f m00(float m00) {
        this.m00 = m00;
        this.properties = (byte)(this.properties & 0xFFFFFFF3);
        return this;
    }

    public Matrix4f m01(float m01) {
        this.m01 = m01;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f m02(float m02) {
        this.m02 = m02;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f m03(float m03) {
        this.m03 = m03;
        this.properties = 0;
        return this;
    }

    public Matrix4f m10(float m10) {
        this.m10 = m10;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f m11(float m11) {
        this.m11 = m11;
        this.properties = (byte)(this.properties & 0xFFFFFFF3);
        return this;
    }

    public Matrix4f m12(float m12) {
        this.m12 = m12;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f m13(float m13) {
        this.m13 = m13;
        this.properties = 0;
        return this;
    }

    public Matrix4f m20(float m20) {
        this.m20 = m20;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f m21(float m21) {
        this.m21 = m21;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f m22(float m22) {
        this.m22 = m22;
        this.properties = (byte)(this.properties & 0xFFFFFFF3);
        return this;
    }

    public Matrix4f m23(float m23) {
        this.m23 = m23;
        this.properties = (byte)(this.properties & 0xFFFFFFF1);
        return this;
    }

    public Matrix4f m30(float m30) {
        this.m30 = m30;
        this.properties = (byte)(this.properties & 0xFFFFFFFA);
        return this;
    }

    public Matrix4f m31(float m31) {
        this.m31 = m31;
        this.properties = (byte)(this.properties & 0xFFFFFFFA);
        return this;
    }

    public Matrix4f m32(float m32) {
        this.m32 = m32;
        this.properties = (byte)(this.properties & 0xFFFFFFFA);
        return this;
    }

    public Matrix4f m33(float m33) {
        this.m33 = m33;
        this.properties = 0;
        return this;
    }

    public Matrix4f identity() {
        if ((this.properties & 4) != 0) {
            return this;
        }
        MemUtil.INSTANCE.identity(this);
        this.properties = (byte)14;
        return this;
    }

    public Matrix4f set(Matrix4f m) {
        MemUtil.INSTANCE.copy(m, this);
        this.properties = m.properties;
        return this;
    }

    public Matrix4f set(Matrix4x3f m) {
        MemUtil.INSTANCE.copy(m, this);
        this.properties = (byte)(m.properties | 2);
        return this;
    }

    public Matrix4f set(Matrix4d m) {
        this.m00 = (float)m.m00();
        this.m01 = (float)m.m01();
        this.m02 = (float)m.m02();
        this.m03 = (float)m.m03();
        this.m10 = (float)m.m10();
        this.m11 = (float)m.m11();
        this.m12 = (float)m.m12();
        this.m13 = (float)m.m13();
        this.m20 = (float)m.m20();
        this.m21 = (float)m.m21();
        this.m22 = (float)m.m22();
        this.m23 = (float)m.m23();
        this.m30 = (float)m.m30();
        this.m31 = (float)m.m31();
        this.m32 = (float)m.m32();
        this.m33 = (float)m.m33();
        this.properties = m.properties;
        return this;
    }

    public Matrix4f set(Matrix3f mat) {
        MemUtil.INSTANCE.copy(mat, this);
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f set(AxisAngle4f axisAngle) {
        float x = axisAngle.x;
        float y = axisAngle.y;
        float z = axisAngle.z;
        double angle = axisAngle.angle;
        double n = Math.sqrt(x * x + y * y + z * z);
        n = 1.0 / n;
        x = (float)((double)x * n);
        y = (float)((double)y * n);
        z = (float)((double)z * n);
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double omc = 1.0 - c;
        this.m00 = (float)(c + (double)(x * x) * omc);
        this.m11 = (float)(c + (double)(y * y) * omc);
        this.m22 = (float)(c + (double)(z * z) * omc);
        double tmp1 = (double)(x * y) * omc;
        double tmp2 = (double)z * s;
        this.m10 = (float)(tmp1 - tmp2);
        this.m01 = (float)(tmp1 + tmp2);
        tmp1 = (double)(x * z) * omc;
        tmp2 = (double)y * s;
        this.m20 = (float)(tmp1 + tmp2);
        this.m02 = (float)(tmp1 - tmp2);
        tmp1 = (double)(y * z) * omc;
        tmp2 = (double)x * s;
        this.m21 = (float)(tmp1 - tmp2);
        this.m12 = (float)(tmp1 + tmp2);
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f set(AxisAngle4d axisAngle) {
        double x = axisAngle.x;
        double y = axisAngle.y;
        double z = axisAngle.z;
        double angle = axisAngle.angle;
        double n = Math.sqrt(x * x + y * y + z * z);
        n = 1.0 / n;
        x *= n;
        y *= n;
        z *= n;
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double omc = 1.0 - c;
        this.m00 = (float)(c + x * x * omc);
        this.m11 = (float)(c + y * y * omc);
        this.m22 = (float)(c + z * z * omc);
        double tmp1 = x * y * omc;
        double tmp2 = z * s;
        this.m10 = (float)(tmp1 - tmp2);
        this.m01 = (float)(tmp1 + tmp2);
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.m20 = (float)(tmp1 + tmp2);
        this.m02 = (float)(tmp1 - tmp2);
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.m21 = (float)(tmp1 - tmp2);
        this.m12 = (float)(tmp1 + tmp2);
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f set(Quaternionf q) {
        return this.rotation(q);
    }

    public Matrix4f set(Quaterniond q) {
        double dx = q.x + q.x;
        double dy = q.y + q.y;
        double dz = q.z + q.z;
        double q00 = dx * q.x;
        double q11 = dy * q.y;
        double q22 = dz * q.z;
        double q01 = dx * q.y;
        double q02 = dx * q.z;
        double q03 = dx * q.w;
        double q12 = dy * q.z;
        double q13 = dy * q.w;
        double q23 = dz * q.w;
        this.m00 = (float)(1.0 - q11 - q22);
        this.m01 = (float)(q01 + q23);
        this.m02 = (float)(q02 - q13);
        this.m03 = 0.0f;
        this.m10 = (float)(q01 - q23);
        this.m11 = (float)(1.0 - q22 - q00);
        this.m12 = (float)(q12 + q03);
        this.m13 = 0.0f;
        this.m20 = (float)(q02 + q13);
        this.m21 = (float)(q12 - q03);
        this.m22 = (float)(1.0 - q11 - q00);
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f set3x3(Matrix4f mat) {
        MemUtil.INSTANCE.copy3x3(mat, this);
        this.properties = (byte)(this.properties & (mat.properties & 0xFFFFFFFE));
        return this;
    }

    public Matrix4f set4x3(Matrix4x3f mat) {
        MemUtil.INSTANCE.copy4x3(mat, this);
        this.properties = (byte)(this.properties & (mat.properties & 0xFFFFFFFE));
        return this;
    }

    public Matrix4f set4x3(Matrix4f mat) {
        MemUtil.INSTANCE.copy4x3(mat, this);
        this.properties = (byte)(this.properties & (mat.properties & 0xFFFFFFFE));
        return this;
    }

    public Matrix4f mul(Matrix4f right) {
        return this.mul(right, this);
    }

    public Matrix4f mul(Matrix4f right, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.set(right);
        }
        if ((right.properties & 4) != 0) {
            return dest.set(this);
        }
        if ((this.properties & 8) != 0 && (right.properties & 2) != 0) {
            return this.mulTranslationAffine(right, dest);
        }
        if ((this.properties & 2) != 0 && (right.properties & 2) != 0) {
            return this.mulAffine(right, dest);
        }
        if ((this.properties & 1) != 0 && (right.properties & 2) != 0) {
            return this.mulPerspectiveAffine(right, dest);
        }
        if ((right.properties & 2) != 0) {
            return this.mulAffineR(right, dest);
        }
        return this.mulGeneric(right, dest);
    }

    private Matrix4f mulGeneric(Matrix4f right, Matrix4f dest) {
        float nm00 = this.m00 * right.m00 + this.m10 * right.m01 + this.m20 * right.m02 + this.m30 * right.m03;
        float nm01 = this.m01 * right.m00 + this.m11 * right.m01 + this.m21 * right.m02 + this.m31 * right.m03;
        float nm02 = this.m02 * right.m00 + this.m12 * right.m01 + this.m22 * right.m02 + this.m32 * right.m03;
        float nm03 = this.m03 * right.m00 + this.m13 * right.m01 + this.m23 * right.m02 + this.m33 * right.m03;
        float nm10 = this.m00 * right.m10 + this.m10 * right.m11 + this.m20 * right.m12 + this.m30 * right.m13;
        float nm11 = this.m01 * right.m10 + this.m11 * right.m11 + this.m21 * right.m12 + this.m31 * right.m13;
        float nm12 = this.m02 * right.m10 + this.m12 * right.m11 + this.m22 * right.m12 + this.m32 * right.m13;
        float nm13 = this.m03 * right.m10 + this.m13 * right.m11 + this.m23 * right.m12 + this.m33 * right.m13;
        float nm20 = this.m00 * right.m20 + this.m10 * right.m21 + this.m20 * right.m22 + this.m30 * right.m23;
        float nm21 = this.m01 * right.m20 + this.m11 * right.m21 + this.m21 * right.m22 + this.m31 * right.m23;
        float nm22 = this.m02 * right.m20 + this.m12 * right.m21 + this.m22 * right.m22 + this.m32 * right.m23;
        float nm23 = this.m03 * right.m20 + this.m13 * right.m21 + this.m23 * right.m22 + this.m33 * right.m23;
        float nm30 = this.m00 * right.m30 + this.m10 * right.m31 + this.m20 * right.m32 + this.m30 * right.m33;
        float nm31 = this.m01 * right.m30 + this.m11 * right.m31 + this.m21 * right.m32 + this.m31 * right.m33;
        float nm32 = this.m02 * right.m30 + this.m12 * right.m31 + this.m22 * right.m32 + this.m32 * right.m33;
        float nm33 = this.m03 * right.m30 + this.m13 * right.m31 + this.m23 * right.m32 + this.m33 * right.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f mul(Matrix4x3f right, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.set(right);
        }
        if ((right.properties & 4) != 0) {
            return dest.set(this);
        }
        if ((this.properties & 1) != 0 && (right.properties & 2) != 0) {
            return this.mulPerspectiveAffine(right, dest);
        }
        return this.mulAffineR(right, dest);
    }

    public Matrix4f mulPerspectiveAffine(Matrix4f view) {
        return this.mulPerspectiveAffine(view, this);
    }

    public Matrix4f mulPerspectiveAffine(Matrix4f view, Matrix4f dest) {
        float nm00 = this.m00 * view.m00;
        float nm01 = this.m11 * view.m01;
        float nm02 = this.m22 * view.m02;
        float nm03 = this.m23 * view.m02;
        float nm10 = this.m00 * view.m10;
        float nm11 = this.m11 * view.m11;
        float nm12 = this.m22 * view.m12;
        float nm13 = this.m23 * view.m12;
        float nm20 = this.m00 * view.m20;
        float nm21 = this.m11 * view.m21;
        float nm22 = this.m22 * view.m22;
        float nm23 = this.m23 * view.m22;
        float nm30 = this.m00 * view.m30;
        float nm31 = this.m11 * view.m31;
        float nm32 = this.m22 * view.m32 + this.m32;
        float nm33 = this.m23 * view.m32;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f mulPerspectiveAffine(Matrix4x3f view) {
        return this.mulPerspectiveAffine(view, this);
    }

    public Matrix4f mulPerspectiveAffine(Matrix4x3f view, Matrix4f dest) {
        float nm00 = this.m00 * view.m00();
        float nm01 = this.m11 * view.m01();
        float nm02 = this.m22 * view.m02();
        float nm03 = this.m23 * view.m02();
        float nm10 = this.m00 * view.m10();
        float nm11 = this.m11 * view.m11();
        float nm12 = this.m22 * view.m12();
        float nm13 = this.m23 * view.m12();
        float nm20 = this.m00 * view.m20();
        float nm21 = this.m11 * view.m21();
        float nm22 = this.m22 * view.m22();
        float nm23 = this.m23 * view.m22();
        float nm30 = this.m00 * view.m30();
        float nm31 = this.m11 * view.m31();
        float nm32 = this.m22 * view.m32() + this.m32;
        float nm33 = this.m23 * view.m32();
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f mulAffineR(Matrix4f right) {
        return this.mulAffineR(right, this);
    }

    public Matrix4f mulAffineR(Matrix4f right, Matrix4f dest) {
        float nm00 = this.m00 * right.m00 + this.m10 * right.m01 + this.m20 * right.m02;
        float nm01 = this.m01 * right.m00 + this.m11 * right.m01 + this.m21 * right.m02;
        float nm02 = this.m02 * right.m00 + this.m12 * right.m01 + this.m22 * right.m02;
        float nm03 = this.m03 * right.m00 + this.m13 * right.m01 + this.m23 * right.m02;
        float nm10 = this.m00 * right.m10 + this.m10 * right.m11 + this.m20 * right.m12;
        float nm11 = this.m01 * right.m10 + this.m11 * right.m11 + this.m21 * right.m12;
        float nm12 = this.m02 * right.m10 + this.m12 * right.m11 + this.m22 * right.m12;
        float nm13 = this.m03 * right.m10 + this.m13 * right.m11 + this.m23 * right.m12;
        float nm20 = this.m00 * right.m20 + this.m10 * right.m21 + this.m20 * right.m22;
        float nm21 = this.m01 * right.m20 + this.m11 * right.m21 + this.m21 * right.m22;
        float nm22 = this.m02 * right.m20 + this.m12 * right.m21 + this.m22 * right.m22;
        float nm23 = this.m03 * right.m20 + this.m13 * right.m21 + this.m23 * right.m22;
        float nm30 = this.m00 * right.m30 + this.m10 * right.m31 + this.m20 * right.m32 + this.m30;
        float nm31 = this.m01 * right.m30 + this.m11 * right.m31 + this.m21 * right.m32 + this.m31;
        float nm32 = this.m02 * right.m30 + this.m12 * right.m31 + this.m22 * right.m32 + this.m32;
        float nm33 = this.m03 * right.m30 + this.m13 * right.m31 + this.m23 * right.m32 + this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f mulAffineR(Matrix4x3f right) {
        return this.mulAffineR(right, this);
    }

    public Matrix4f mulAffineR(Matrix4x3f right, Matrix4f dest) {
        float nm00 = this.m00 * right.m00() + this.m10 * right.m01() + this.m20 * right.m02();
        float nm01 = this.m01 * right.m00() + this.m11 * right.m01() + this.m21 * right.m02();
        float nm02 = this.m02 * right.m00() + this.m12 * right.m01() + this.m22 * right.m02();
        float nm03 = this.m03 * right.m00() + this.m13 * right.m01() + this.m23 * right.m02();
        float nm10 = this.m00 * right.m10() + this.m10 * right.m11() + this.m20 * right.m12();
        float nm11 = this.m01 * right.m10() + this.m11 * right.m11() + this.m21 * right.m12();
        float nm12 = this.m02 * right.m10() + this.m12 * right.m11() + this.m22 * right.m12();
        float nm13 = this.m03 * right.m10() + this.m13 * right.m11() + this.m23 * right.m12();
        float nm20 = this.m00 * right.m20() + this.m10 * right.m21() + this.m20 * right.m22();
        float nm21 = this.m01 * right.m20() + this.m11 * right.m21() + this.m21 * right.m22();
        float nm22 = this.m02 * right.m20() + this.m12 * right.m21() + this.m22 * right.m22();
        float nm23 = this.m03 * right.m20() + this.m13 * right.m21() + this.m23 * right.m22();
        float nm30 = this.m00 * right.m30() + this.m10 * right.m31() + this.m20 * right.m32() + this.m30;
        float nm31 = this.m01 * right.m30() + this.m11 * right.m31() + this.m21 * right.m32() + this.m31;
        float nm32 = this.m02 * right.m30() + this.m12 * right.m31() + this.m22 * right.m32() + this.m32;
        float nm33 = this.m03 * right.m30() + this.m13 * right.m31() + this.m23 * right.m32() + this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f mulAffine(Matrix4f right) {
        return this.mulAffine(right, this);
    }

    public Matrix4f mulAffine(Matrix4f right, Matrix4f dest) {
        float nm00 = this.m00 * right.m00 + this.m10 * right.m01 + this.m20 * right.m02;
        float nm01 = this.m01 * right.m00 + this.m11 * right.m01 + this.m21 * right.m02;
        float nm02 = this.m02 * right.m00 + this.m12 * right.m01 + this.m22 * right.m02;
        float nm03 = this.m03;
        float nm10 = this.m00 * right.m10 + this.m10 * right.m11 + this.m20 * right.m12;
        float nm11 = this.m01 * right.m10 + this.m11 * right.m11 + this.m21 * right.m12;
        float nm12 = this.m02 * right.m10 + this.m12 * right.m11 + this.m22 * right.m12;
        float nm13 = this.m13;
        float nm20 = this.m00 * right.m20 + this.m10 * right.m21 + this.m20 * right.m22;
        float nm21 = this.m01 * right.m20 + this.m11 * right.m21 + this.m21 * right.m22;
        float nm22 = this.m02 * right.m20 + this.m12 * right.m21 + this.m22 * right.m22;
        float nm23 = this.m23;
        float nm30 = this.m00 * right.m30 + this.m10 * right.m31 + this.m20 * right.m32 + this.m30;
        float nm31 = this.m01 * right.m30 + this.m11 * right.m31 + this.m21 * right.m32 + this.m31;
        float nm32 = this.m02 * right.m30 + this.m12 * right.m31 + this.m22 * right.m32 + this.m32;
        float nm33 = this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)2;
        return dest;
    }

    public Matrix4f mulTranslationAffine(Matrix4f right, Matrix4f dest) {
        float nm00 = right.m00;
        float nm01 = right.m01;
        float nm02 = right.m02;
        float nm03 = this.m03;
        float nm10 = right.m10;
        float nm11 = right.m11;
        float nm12 = right.m12;
        float nm13 = this.m13;
        float nm20 = right.m20;
        float nm21 = right.m21;
        float nm22 = right.m22;
        float nm23 = this.m23;
        float nm30 = right.m30 + this.m30;
        float nm31 = right.m31 + this.m31;
        float nm32 = right.m32 + this.m32;
        float nm33 = this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)2;
        return dest;
    }

    public Matrix4f mulOrthoAffine(Matrix4f view) {
        return this.mulOrthoAffine(view, this);
    }

    public Matrix4f mulOrthoAffine(Matrix4f view, Matrix4f dest) {
        float nm00 = this.m00 * view.m00;
        float nm01 = this.m11 * view.m01;
        float nm02 = this.m22 * view.m02;
        float nm03 = 0.0f;
        float nm10 = this.m00 * view.m10;
        float nm11 = this.m11 * view.m11;
        float nm12 = this.m22 * view.m12;
        float nm13 = 0.0f;
        float nm20 = this.m00 * view.m20;
        float nm21 = this.m11 * view.m21;
        float nm22 = this.m22 * view.m22;
        float nm23 = 0.0f;
        float nm30 = this.m00 * view.m30 + this.m30;
        float nm31 = this.m11 * view.m31 + this.m31;
        float nm32 = this.m22 * view.m32 + this.m32;
        float nm33 = 1.0f;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)2;
        return dest;
    }

    public Matrix4f fma4x3(Matrix4f other, float otherFactor) {
        return this.fma4x3(other, otherFactor, this);
    }

    public Matrix4f fma4x3(Matrix4f other, float otherFactor, Matrix4f dest) {
        dest.m00 = this.m00 + other.m00 * otherFactor;
        dest.m01 = this.m01 + other.m01 * otherFactor;
        dest.m02 = this.m02 + other.m02 * otherFactor;
        dest.m03 = this.m03;
        dest.m10 = this.m10 + other.m10 * otherFactor;
        dest.m11 = this.m11 + other.m11 * otherFactor;
        dest.m12 = this.m12 + other.m12 * otherFactor;
        dest.m13 = this.m13;
        dest.m20 = this.m20 + other.m20 * otherFactor;
        dest.m21 = this.m21 + other.m21 * otherFactor;
        dest.m22 = this.m22 + other.m22 * otherFactor;
        dest.m23 = this.m23;
        dest.m30 = this.m30 + other.m30 * otherFactor;
        dest.m31 = this.m31 + other.m31 * otherFactor;
        dest.m32 = this.m32 + other.m32 * otherFactor;
        dest.m33 = this.m33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f add(Matrix4f other) {
        return this.add(other, this);
    }

    public Matrix4f add(Matrix4f other, Matrix4f dest) {
        dest.m00 = this.m00 + other.m00;
        dest.m01 = this.m01 + other.m01;
        dest.m02 = this.m02 + other.m02;
        dest.m03 = this.m03 + other.m03;
        dest.m10 = this.m10 + other.m10;
        dest.m11 = this.m11 + other.m11;
        dest.m12 = this.m12 + other.m12;
        dest.m13 = this.m13 + other.m13;
        dest.m20 = this.m20 + other.m20;
        dest.m21 = this.m21 + other.m21;
        dest.m22 = this.m22 + other.m22;
        dest.m23 = this.m23 + other.m23;
        dest.m30 = this.m30 + other.m30;
        dest.m31 = this.m31 + other.m31;
        dest.m32 = this.m32 + other.m32;
        dest.m33 = this.m33 + other.m33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f sub(Matrix4f subtrahend) {
        return this.sub(subtrahend, this);
    }

    public Matrix4f sub(Matrix4f subtrahend, Matrix4f dest) {
        dest.m00 = this.m00 - subtrahend.m00;
        dest.m01 = this.m01 - subtrahend.m01;
        dest.m02 = this.m02 - subtrahend.m02;
        dest.m03 = this.m03 - subtrahend.m03;
        dest.m10 = this.m10 - subtrahend.m10;
        dest.m11 = this.m11 - subtrahend.m11;
        dest.m12 = this.m12 - subtrahend.m12;
        dest.m13 = this.m13 - subtrahend.m13;
        dest.m20 = this.m20 - subtrahend.m20;
        dest.m21 = this.m21 - subtrahend.m21;
        dest.m22 = this.m22 - subtrahend.m22;
        dest.m23 = this.m23 - subtrahend.m23;
        dest.m30 = this.m30 - subtrahend.m30;
        dest.m31 = this.m31 - subtrahend.m31;
        dest.m32 = this.m32 - subtrahend.m32;
        dest.m33 = this.m33 - subtrahend.m33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f mulComponentWise(Matrix4f other) {
        return this.mulComponentWise(other, this);
    }

    public Matrix4f mulComponentWise(Matrix4f other, Matrix4f dest) {
        dest.m00 = this.m00 * other.m00;
        dest.m01 = this.m01 * other.m01;
        dest.m02 = this.m02 * other.m02;
        dest.m03 = this.m03 * other.m03;
        dest.m10 = this.m10 * other.m10;
        dest.m11 = this.m11 * other.m11;
        dest.m12 = this.m12 * other.m12;
        dest.m13 = this.m13 * other.m13;
        dest.m20 = this.m20 * other.m20;
        dest.m21 = this.m21 * other.m21;
        dest.m22 = this.m22 * other.m22;
        dest.m23 = this.m23 * other.m23;
        dest.m30 = this.m30 * other.m30;
        dest.m31 = this.m31 * other.m31;
        dest.m32 = this.m32 * other.m32;
        dest.m33 = this.m33 * other.m33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f add4x3(Matrix4f other) {
        return this.add4x3(other, this);
    }

    public Matrix4f add4x3(Matrix4f other, Matrix4f dest) {
        dest.m00 = this.m00 + other.m00;
        dest.m01 = this.m01 + other.m01;
        dest.m02 = this.m02 + other.m02;
        dest.m03 = this.m03;
        dest.m10 = this.m10 + other.m10;
        dest.m11 = this.m11 + other.m11;
        dest.m12 = this.m12 + other.m12;
        dest.m13 = this.m13;
        dest.m20 = this.m20 + other.m20;
        dest.m21 = this.m21 + other.m21;
        dest.m22 = this.m22 + other.m22;
        dest.m23 = this.m23;
        dest.m30 = this.m30 + other.m30;
        dest.m31 = this.m31 + other.m31;
        dest.m32 = this.m32 + other.m32;
        dest.m33 = this.m33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f sub4x3(Matrix4f subtrahend) {
        return this.sub4x3(subtrahend, this);
    }

    public Matrix4f sub4x3(Matrix4f subtrahend, Matrix4f dest) {
        dest.m00 = this.m00 - subtrahend.m00;
        dest.m01 = this.m01 - subtrahend.m01;
        dest.m02 = this.m02 - subtrahend.m02;
        dest.m03 = this.m03;
        dest.m10 = this.m10 - subtrahend.m10;
        dest.m11 = this.m11 - subtrahend.m11;
        dest.m12 = this.m12 - subtrahend.m12;
        dest.m13 = this.m13;
        dest.m20 = this.m20 - subtrahend.m20;
        dest.m21 = this.m21 - subtrahend.m21;
        dest.m22 = this.m22 - subtrahend.m22;
        dest.m23 = this.m23;
        dest.m30 = this.m30 - subtrahend.m30;
        dest.m31 = this.m31 - subtrahend.m31;
        dest.m32 = this.m32 - subtrahend.m32;
        dest.m33 = this.m33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f mul4x3ComponentWise(Matrix4f other) {
        return this.mul4x3ComponentWise(other, this);
    }

    public Matrix4f mul4x3ComponentWise(Matrix4f other, Matrix4f dest) {
        dest.m00 = this.m00 * other.m00;
        dest.m01 = this.m01 * other.m01;
        dest.m02 = this.m02 * other.m02;
        dest.m03 = this.m03;
        dest.m10 = this.m10 * other.m10;
        dest.m11 = this.m11 * other.m11;
        dest.m12 = this.m12 * other.m12;
        dest.m13 = this.m13;
        dest.m20 = this.m20 * other.m20;
        dest.m21 = this.m21 * other.m21;
        dest.m22 = this.m22 * other.m22;
        dest.m23 = this.m23;
        dest.m30 = this.m30 * other.m30;
        dest.m31 = this.m31 * other.m31;
        dest.m32 = this.m32 * other.m32;
        dest.m33 = this.m33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f set(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        this.m00 = m00;
        this.m10 = m10;
        this.m20 = m20;
        this.m30 = m30;
        this.m01 = m01;
        this.m11 = m11;
        this.m21 = m21;
        this.m31 = m31;
        this.m02 = m02;
        this.m12 = m12;
        this.m22 = m22;
        this.m32 = m32;
        this.m03 = m03;
        this.m13 = m13;
        this.m23 = m23;
        this.m33 = m33;
        this.properties = 0;
        return this;
    }

    public Matrix4f set(float[] m, int off) {
        MemUtil.INSTANCE.copy(m, off, this);
        this.properties = 0;
        return this;
    }

    public Matrix4f set(float[] m) {
        return this.set(m, 0);
    }

    public Matrix4f set(FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
        this.properties = 0;
        return this;
    }

    public Matrix4f set(ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
        this.properties = 0;
        return this;
    }

    public Matrix4f set(Vector4f col0, Vector4f col1, Vector4f col2, Vector4f col3) {
        MemUtil.INSTANCE.set(this, col0, col1, col2, col3);
        this.properties = 0;
        return this;
    }

    public float determinant() {
        if ((this.properties & 2) != 0) {
            return this.determinantAffine();
        }
        return (this.m00 * this.m11 - this.m01 * this.m10) * (this.m22 * this.m33 - this.m23 * this.m32) + (this.m02 * this.m10 - this.m00 * this.m12) * (this.m21 * this.m33 - this.m23 * this.m31) + (this.m00 * this.m13 - this.m03 * this.m10) * (this.m21 * this.m32 - this.m22 * this.m31) + (this.m01 * this.m12 - this.m02 * this.m11) * (this.m20 * this.m33 - this.m23 * this.m30) + (this.m03 * this.m11 - this.m01 * this.m13) * (this.m20 * this.m32 - this.m22 * this.m30) + (this.m02 * this.m13 - this.m03 * this.m12) * (this.m20 * this.m31 - this.m21 * this.m30);
    }

    public float determinant3x3() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public float determinantAffine() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix4f invert(Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.identity();
        }
        if ((this.properties & 2) != 0) {
            return this.invertAffine(dest);
        }
        if ((this.properties & 1) != 0) {
            return this.invertPerspective(dest);
        }
        return this.invertGeneric(dest);
    }

    private Matrix4f invertGeneric(Matrix4f dest) {
        float a = this.m00 * this.m11 - this.m01 * this.m10;
        float b = this.m00 * this.m12 - this.m02 * this.m10;
        float c = this.m00 * this.m13 - this.m03 * this.m10;
        float d = this.m01 * this.m12 - this.m02 * this.m11;
        float e = this.m01 * this.m13 - this.m03 * this.m11;
        float f = this.m02 * this.m13 - this.m03 * this.m12;
        float g = this.m20 * this.m31 - this.m21 * this.m30;
        float h = this.m20 * this.m32 - this.m22 * this.m30;
        float i = this.m20 * this.m33 - this.m23 * this.m30;
        float j = this.m21 * this.m32 - this.m22 * this.m31;
        float k = this.m21 * this.m33 - this.m23 * this.m31;
        float l = this.m22 * this.m33 - this.m23 * this.m32;
        float det = a * l - b * k + c * j + d * i - e * h + f * g;
        det = 1.0f / det;
        float nm00 = (this.m11 * l - this.m12 * k + this.m13 * j) * det;
        float nm01 = (-this.m01 * l + this.m02 * k - this.m03 * j) * det;
        float nm02 = (this.m31 * f - this.m32 * e + this.m33 * d) * det;
        float nm03 = (-this.m21 * f + this.m22 * e - this.m23 * d) * det;
        float nm10 = (-this.m10 * l + this.m12 * i - this.m13 * h) * det;
        float nm11 = (this.m00 * l - this.m02 * i + this.m03 * h) * det;
        float nm12 = (-this.m30 * f + this.m32 * c - this.m33 * b) * det;
        float nm13 = (this.m20 * f - this.m22 * c + this.m23 * b) * det;
        float nm20 = (this.m10 * k - this.m11 * i + this.m13 * g) * det;
        float nm21 = (-this.m00 * k + this.m01 * i - this.m03 * g) * det;
        float nm22 = (this.m30 * e - this.m31 * c + this.m33 * a) * det;
        float nm23 = (-this.m20 * e + this.m21 * c - this.m23 * a) * det;
        float nm30 = (-this.m10 * j + this.m11 * h - this.m12 * g) * det;
        float nm31 = (this.m00 * j - this.m01 * h + this.m02 * g) * det;
        float nm32 = (-this.m30 * d + this.m31 * b - this.m32 * a) * det;
        float nm33 = (this.m20 * d - this.m21 * b + this.m22 * a) * det;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f invert() {
        return this.invert(this);
    }

    public Matrix4f invertPerspective(Matrix4f dest) {
        float a = 1.0f / (this.m00 * this.m11);
        float l = -1.0f / (this.m23 * this.m32);
        dest.set(this.m11 * a, 0.0f, 0.0f, 0.0f, 0.0f, this.m00 * a, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -this.m23 * l, 0.0f, 0.0f, -this.m32 * l, this.m22 * l);
        dest.properties = 0;
        return dest;
    }

    public Matrix4f invertPerspective() {
        return this.invertPerspective(this);
    }

    public Matrix4f invertFrustum(Matrix4f dest) {
        float invM00 = 1.0f / this.m00;
        float invM11 = 1.0f / this.m11;
        float invM23 = 1.0f / this.m23;
        float invM32 = 1.0f / this.m32;
        dest.set(invM00, 0.0f, 0.0f, 0.0f, 0.0f, invM11, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, invM32, -this.m20 * invM00 * invM23, -this.m21 * invM11 * invM23, invM23, -this.m22 * invM23 * invM32);
        dest.properties = 0;
        return dest;
    }

    public Matrix4f invertFrustum() {
        return this.invertFrustum(this);
    }

    public Matrix4f invertOrtho(Matrix4f dest) {
        float invM00 = 1.0f / this.m00;
        float invM11 = 1.0f / this.m11;
        float invM22 = 1.0f / this.m22;
        dest.set(invM00, 0.0f, 0.0f, 0.0f, 0.0f, invM11, 0.0f, 0.0f, 0.0f, 0.0f, invM22, 0.0f, -this.m30 * invM00, -this.m31 * invM11, -this.m32 * invM22, 1.0f);
        dest.properties = (byte)2;
        return dest;
    }

    public Matrix4f invertOrtho() {
        return this.invertOrtho(this);
    }

    public Matrix4f invertPerspectiveView(Matrix4f view, Matrix4f dest) {
        float a = 1.0f / (this.m00 * this.m11);
        float l = -1.0f / (this.m23 * this.m32);
        float pm00 = this.m11 * a;
        float pm11 = this.m00 * a;
        float pm23 = -this.m23 * l;
        float pm32 = -this.m32 * l;
        float pm33 = this.m22 * l;
        float vm30 = -view.m00 * view.m30 - view.m01 * view.m31 - view.m02 * view.m32;
        float vm31 = -view.m10 * view.m30 - view.m11 * view.m31 - view.m12 * view.m32;
        float vm32 = -view.m20 * view.m30 - view.m21 * view.m31 - view.m22 * view.m32;
        dest.set(view.m00 * pm00, view.m10 * pm00, view.m20 * pm00, 0.0f, view.m01 * pm11, view.m11 * pm11, view.m21 * pm11, 0.0f, vm30 * pm23, vm31 * pm23, vm32 * pm23, pm23, view.m02 * pm32 + vm30 * pm33, view.m12 * pm32 + vm31 * pm33, view.m22 * pm32 + vm32 * pm33, pm33);
        dest.properties = 0;
        return dest;
    }

    public Matrix4f invertPerspectiveView(Matrix4x3f view, Matrix4f dest) {
        float a = 1.0f / (this.m00 * this.m11);
        float l = -1.0f / (this.m23 * this.m32);
        float pm00 = this.m11 * a;
        float pm11 = this.m00 * a;
        float pm23 = -this.m23 * l;
        float pm32 = -this.m32 * l;
        float pm33 = this.m22 * l;
        float vm30 = -view.m00() * view.m30() - view.m01() * view.m31() - view.m02() * view.m32();
        float vm31 = -view.m10() * view.m30() - view.m11() * view.m31() - view.m12() * view.m32();
        float vm32 = -view.m20() * view.m30() - view.m21() * view.m31() - view.m22() * view.m32();
        dest.set(view.m00() * pm00, view.m10() * pm00, view.m20() * pm00, 0.0f, view.m01() * pm11, view.m11() * pm11, view.m21() * pm11, 0.0f, vm30 * pm23, vm31 * pm23, vm32 * pm23, pm23, view.m02() * pm32 + vm30 * pm33, view.m12() * pm32 + vm31 * pm33, view.m22() * pm32 + vm32 * pm33, pm33);
        dest.properties = 0;
        return dest;
    }

    public Matrix4f invertAffine(Matrix4f dest) {
        float s = this.determinantAffine();
        s = 1.0f / s;
        float m10m22 = this.m10 * this.m22;
        float m10m21 = this.m10 * this.m21;
        float m10m02 = this.m10 * this.m02;
        float m10m01 = this.m10 * this.m01;
        float m11m22 = this.m11 * this.m22;
        float m11m20 = this.m11 * this.m20;
        float m11m02 = this.m11 * this.m02;
        float m11m00 = this.m11 * this.m00;
        float m12m21 = this.m12 * this.m21;
        float m12m20 = this.m12 * this.m20;
        float m12m01 = this.m12 * this.m01;
        float m12m00 = this.m12 * this.m00;
        float m20m02 = this.m20 * this.m02;
        float m20m01 = this.m20 * this.m01;
        float m21m02 = this.m21 * this.m02;
        float m21m00 = this.m21 * this.m00;
        float m22m01 = this.m22 * this.m01;
        float m22m00 = this.m22 * this.m00;
        float nm00 = (m11m22 - m12m21) * s;
        float nm01 = (m21m02 - m22m01) * s;
        float nm02 = (m12m01 - m11m02) * s;
        float nm03 = 0.0f;
        float nm10 = (m12m20 - m10m22) * s;
        float nm11 = (m22m00 - m20m02) * s;
        float nm12 = (m10m02 - m12m00) * s;
        float nm13 = 0.0f;
        float nm20 = (m10m21 - m11m20) * s;
        float nm21 = (m20m01 - m21m00) * s;
        float nm22 = (m11m00 - m10m01) * s;
        float nm23 = 0.0f;
        float nm30 = (m10m22 * this.m31 - m10m21 * this.m32 + m11m20 * this.m32 - m11m22 * this.m30 + m12m21 * this.m30 - m12m20 * this.m31) * s;
        float nm31 = (m20m02 * this.m31 - m20m01 * this.m32 + m21m00 * this.m32 - m21m02 * this.m30 + m22m01 * this.m30 - m22m00 * this.m31) * s;
        float nm32 = (m11m02 * this.m30 - m12m01 * this.m30 + m12m00 * this.m31 - m10m02 * this.m31 + m10m01 * this.m32 - m11m00 * this.m32) * s;
        float nm33 = 1.0f;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)2;
        return dest;
    }

    public Matrix4f invertAffine() {
        return this.invertAffine(this);
    }

    public Matrix4f invertAffineUnitScale(Matrix4f dest) {
        dest.set(this.m00, this.m10, this.m20, 0.0f, this.m01, this.m11, this.m21, 0.0f, this.m02, this.m12, this.m22, 0.0f, -this.m00 * this.m30 - this.m01 * this.m31 - this.m02 * this.m32, -this.m10 * this.m30 - this.m11 * this.m31 - this.m12 * this.m32, -this.m20 * this.m30 - this.m21 * this.m31 - this.m22 * this.m32, 1.0f);
        dest.properties = (byte)2;
        return dest;
    }

    public Matrix4f invertAffineUnitScale() {
        return this.invertAffineUnitScale(this);
    }

    public Matrix4f invertLookAt(Matrix4f dest) {
        return this.invertAffineUnitScale(dest);
    }

    public Matrix4f invertLookAt() {
        return this.invertAffineUnitScale(this);
    }

    public Matrix4f transpose(Matrix4f dest) {
        float nm00 = this.m00;
        float nm01 = this.m10;
        float nm02 = this.m20;
        float nm03 = this.m30;
        float nm10 = this.m01;
        float nm11 = this.m11;
        float nm12 = this.m21;
        float nm13 = this.m31;
        float nm20 = this.m02;
        float nm21 = this.m12;
        float nm22 = this.m22;
        float nm23 = this.m32;
        float nm30 = this.m03;
        float nm31 = this.m13;
        float nm32 = this.m23;
        float nm33 = this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)(this.properties & 0xFFFFFFFE);
        return dest;
    }

    public Matrix4f transpose3x3() {
        return this.transpose3x3(this);
    }

    public Matrix4f transpose3x3(Matrix4f dest) {
        float nm00 = this.m00;
        float nm01 = this.m10;
        float nm02 = this.m20;
        float nm10 = this.m01;
        float nm11 = this.m11;
        float nm12 = this.m21;
        float nm20 = this.m02;
        float nm21 = this.m12;
        float nm22 = this.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.properties = 0;
        return dest;
    }

    public Matrix3f transpose3x3(Matrix3f dest) {
        dest.m00 = this.m00;
        dest.m01 = this.m10;
        dest.m02 = this.m20;
        dest.m10 = this.m01;
        dest.m11 = this.m11;
        dest.m12 = this.m21;
        dest.m20 = this.m02;
        dest.m21 = this.m12;
        dest.m22 = this.m22;
        return dest;
    }

    public Matrix4f transpose() {
        return this.transpose(this);
    }

    public Matrix4f translation(float x, float y, float z) {
        MemUtil.INSTANCE.identity(this);
        this.m30 = x;
        this.m31 = y;
        this.m32 = z;
        this.properties = (byte)10;
        return this;
    }

    public Matrix4f translation(Vector3f offset) {
        return this.translation(offset.x, offset.y, offset.z);
    }

    public Matrix4f setTranslation(float x, float y, float z) {
        this.m30 = x;
        this.m31 = y;
        this.m32 = z;
        this.properties = (byte)(this.properties & 0xFFFFFFFA);
        return this;
    }

    public Matrix4f setTranslation(Vector3f xyz) {
        return this.setTranslation(xyz.x, xyz.y, xyz.z);
    }

    public Vector3f getTranslation(Vector3f dest) {
        dest.x = this.m30;
        dest.y = this.m31;
        dest.z = this.m32;
        return dest;
    }

    public Vector3f getScale(Vector3f dest) {
        dest.x = (float)Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        dest.y = (float)Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        dest.z = (float)Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return dest;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat("  0.000E0; -");
        return this.toString(formatter).replaceAll("E(\\d+)", "E+$1");
    }

    public String toString(NumberFormat formatter) {
        return formatter.format(this.m00) + formatter.format(this.m10) + formatter.format(this.m20) + formatter.format(this.m30) + "\n" + formatter.format(this.m01) + formatter.format(this.m11) + formatter.format(this.m21) + formatter.format(this.m31) + "\n" + formatter.format(this.m02) + formatter.format(this.m12) + formatter.format(this.m22) + formatter.format(this.m32) + "\n" + formatter.format(this.m03) + formatter.format(this.m13) + formatter.format(this.m23) + formatter.format(this.m33) + "\n";
    }

    public Matrix4f get(Matrix4f dest) {
        return dest.set(this);
    }

    public Matrix4x3f get4x3(Matrix4x3f dest) {
        return dest.set(this);
    }

    public Matrix4d get(Matrix4d dest) {
        return dest.set(this);
    }

    public Matrix3f get3x3(Matrix3f dest) {
        return dest.set(this);
    }

    public Matrix3d get3x3(Matrix3d dest) {
        return dest.set(this);
    }

    public AxisAngle4f getRotation(AxisAngle4f dest) {
        return dest.set(this);
    }

    public AxisAngle4d getRotation(AxisAngle4d dest) {
        return dest.set(this);
    }

    public Quaternionf getUnnormalizedRotation(Quaternionf dest) {
        return dest.setFromUnnormalized(this);
    }

    public Quaternionf getNormalizedRotation(Quaternionf dest) {
        return dest.setFromNormalized(this);
    }

    public Quaterniond getUnnormalizedRotation(Quaterniond dest) {
        return dest.setFromUnnormalized(this);
    }

    public Quaterniond getNormalizedRotation(Quaterniond dest) {
        return dest.setFromNormalized(this);
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public FloatBuffer getTransposed(FloatBuffer buffer) {
        return this.getTransposed(buffer.position(), buffer);
    }

    public FloatBuffer getTransposed(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.putTransposed(this, index, buffer);
        return buffer;
    }

    public ByteBuffer getTransposed(ByteBuffer buffer) {
        return this.getTransposed(buffer.position(), buffer);
    }

    public ByteBuffer getTransposed(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.putTransposed(this, index, buffer);
        return buffer;
    }

    public FloatBuffer get4x3Transposed(FloatBuffer buffer) {
        return this.get4x3Transposed(buffer.position(), buffer);
    }

    public FloatBuffer get4x3Transposed(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.put4x3Transposed(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get4x3Transposed(ByteBuffer buffer) {
        return this.get4x3Transposed(buffer.position(), buffer);
    }

    public ByteBuffer get4x3Transposed(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put4x3Transposed(this, index, buffer);
        return buffer;
    }

    public float[] get(float[] arr, int offset) {
        MemUtil.INSTANCE.copy(this, arr, offset);
        return arr;
    }

    public float[] get(float[] arr) {
        return this.get(arr, 0);
    }

    public Matrix4f zero() {
        MemUtil.INSTANCE.zero(this);
        this.properties = 0;
        return this;
    }

    public Matrix4f scaling(float factor) {
        return this.scaling(factor, factor, factor);
    }

    public Matrix4f scaling(float x, float y, float z) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = x;
        this.m11 = y;
        this.m22 = z;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f scaling(Vector3f xyz) {
        return this.scaling(xyz.x, xyz.y, xyz.z);
    }

    public Matrix4f rotation(float angle, Vector3f axis) {
        return this.rotation(angle, axis.x, axis.y, axis.z);
    }

    public Matrix4f rotation(AxisAngle4f axisAngle) {
        return this.rotation(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Matrix4f rotation(float angle, float x, float y, float z) {
        float cos = (float)Math.cos(angle);
        float sin = (float)Math.sin(angle);
        float C = 1.0f - cos;
        float xy = x * y;
        float xz = x * z;
        float yz = y * z;
        this.m00 = cos + x * x * C;
        this.m10 = xy * C - z * sin;
        this.m20 = xz * C + y * sin;
        this.m30 = 0.0f;
        this.m01 = xy * C + z * sin;
        this.m11 = cos + y * y * C;
        this.m21 = yz * C - x * sin;
        this.m31 = 0.0f;
        this.m02 = xz * C - y * sin;
        this.m12 = yz * C + x * sin;
        this.m22 = cos + z * z * C;
        this.m32 = 0.0f;
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f rotationX(float ang) {
        float sin = (float)Math.sin(ang);
        float cos = (float)Math.cos(ang);
        MemUtil.INSTANCE.identity(this);
        this.m11 = cos;
        this.m12 = sin;
        this.m21 = -sin;
        this.m22 = cos;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f rotationY(float ang) {
        float sin = (float)Math.sin(ang);
        float cos = (float)Math.cos(ang);
        MemUtil.INSTANCE.identity(this);
        this.m00 = cos;
        this.m02 = -sin;
        this.m20 = sin;
        this.m22 = cos;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f rotationZ(float ang) {
        float sin = (float)Math.sin(ang);
        float cos = (float)Math.cos(ang);
        MemUtil.INSTANCE.identity(this);
        this.m00 = cos;
        this.m01 = sin;
        this.m10 = -sin;
        this.m11 = cos;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f rotationXYZ(float angleX, float angleY, float angleZ) {
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinX = -sinX;
        float m_sinY = -sinY;
        float m_sinZ = -sinZ;
        float nm11 = cosX;
        float nm12 = sinX;
        float nm21 = m_sinX;
        float nm22 = cosX;
        float nm00 = cosY;
        float nm01 = nm21 * m_sinY;
        float nm02 = nm22 * m_sinY;
        this.m20 = sinY;
        this.m21 = nm21 * cosY;
        this.m22 = nm22 * cosY;
        this.m23 = 0.0f;
        this.m00 = nm00 * cosZ;
        this.m01 = nm01 * cosZ + nm11 * sinZ;
        this.m02 = nm02 * cosZ + nm12 * sinZ;
        this.m03 = 0.0f;
        this.m10 = nm00 * m_sinZ;
        this.m11 = nm01 * m_sinZ + nm11 * cosZ;
        this.m12 = nm02 * m_sinZ + nm12 * cosZ;
        this.m13 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f rotationZYX(float angleZ, float angleY, float angleX) {
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float m_sinZ = -sinZ;
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float nm00 = cosZ;
        float nm01 = sinZ;
        float nm10 = m_sinZ;
        float nm11 = cosZ;
        float nm20 = nm00 * sinY;
        float nm21 = nm01 * sinY;
        float nm22 = cosY;
        this.m00 = nm00 * cosY;
        this.m01 = nm01 * cosY;
        this.m02 = m_sinY;
        this.m03 = 0.0f;
        this.m10 = nm10 * cosX + nm20 * sinX;
        this.m11 = nm11 * cosX + nm21 * sinX;
        this.m12 = nm22 * sinX;
        this.m13 = 0.0f;
        this.m20 = nm10 * m_sinX + nm20 * cosX;
        this.m21 = nm11 * m_sinX + nm21 * cosX;
        this.m22 = nm22 * cosX;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f rotationYXZ(float angleY, float angleX, float angleZ) {
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float m_sinZ = -sinZ;
        float nm00 = cosY;
        float nm02 = m_sinY;
        float nm20 = sinY;
        float nm22 = cosY;
        float nm10 = nm20 * sinX;
        float nm11 = cosX;
        float nm12 = nm22 * sinX;
        this.m20 = nm20 * cosX;
        this.m21 = m_sinX;
        this.m22 = nm22 * cosX;
        this.m23 = 0.0f;
        this.m00 = nm00 * cosZ + nm10 * sinZ;
        this.m01 = nm11 * sinZ;
        this.m02 = nm02 * cosZ + nm12 * sinZ;
        this.m03 = 0.0f;
        this.m10 = nm00 * m_sinZ + nm10 * cosZ;
        this.m11 = nm11 * cosZ;
        this.m12 = nm02 * m_sinZ + nm12 * cosZ;
        this.m13 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f setRotationXYZ(float angleX, float angleY, float angleZ) {
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinX = -sinX;
        float m_sinY = -sinY;
        float m_sinZ = -sinZ;
        float nm11 = cosX;
        float nm12 = sinX;
        float nm21 = m_sinX;
        float nm22 = cosX;
        float nm00 = cosY;
        float nm01 = nm21 * m_sinY;
        float nm02 = nm22 * m_sinY;
        this.m20 = sinY;
        this.m21 = nm21 * cosY;
        this.m22 = nm22 * cosY;
        this.m00 = nm00 * cosZ;
        this.m01 = nm01 * cosZ + nm11 * sinZ;
        this.m02 = nm02 * cosZ + nm12 * sinZ;
        this.m10 = nm00 * m_sinZ;
        this.m11 = nm01 * m_sinZ + nm11 * cosZ;
        this.m12 = nm02 * m_sinZ + nm12 * cosZ;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f setRotationZYX(float angleZ, float angleY, float angleX) {
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float m_sinZ = -sinZ;
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float nm00 = cosZ;
        float nm01 = sinZ;
        float nm10 = m_sinZ;
        float nm11 = cosZ;
        float nm20 = nm00 * sinY;
        float nm21 = nm01 * sinY;
        float nm22 = cosY;
        this.m00 = nm00 * cosY;
        this.m01 = nm01 * cosY;
        this.m02 = m_sinY;
        this.m10 = nm10 * cosX + nm20 * sinX;
        this.m11 = nm11 * cosX + nm21 * sinX;
        this.m12 = nm22 * sinX;
        this.m20 = nm10 * m_sinX + nm20 * cosX;
        this.m21 = nm11 * m_sinX + nm21 * cosX;
        this.m22 = nm22 * cosX;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f setRotationYXZ(float angleY, float angleX, float angleZ) {
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float m_sinZ = -sinZ;
        float nm00 = cosY;
        float nm02 = m_sinY;
        float nm20 = sinY;
        float nm22 = cosY;
        float nm10 = nm20 * sinX;
        float nm11 = cosX;
        float nm12 = nm22 * sinX;
        this.m20 = nm20 * cosX;
        this.m21 = m_sinX;
        this.m22 = nm22 * cosX;
        this.m00 = nm00 * cosZ + nm10 * sinZ;
        this.m01 = nm11 * sinZ;
        this.m02 = nm02 * cosZ + nm12 * sinZ;
        this.m10 = nm00 * m_sinZ + nm10 * cosZ;
        this.m11 = nm11 * cosZ;
        this.m12 = nm02 * m_sinZ + nm12 * cosZ;
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Matrix4f rotation(Quaternionf quat) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        this.m00 = 1.0f - q11 - q22;
        this.m01 = q01 + q23;
        this.m02 = q02 - q13;
        this.m03 = 0.0f;
        this.m10 = q01 - q23;
        this.m11 = 1.0f - q22 - q00;
        this.m12 = q12 + q03;
        this.m13 = 0.0f;
        this.m20 = q02 + q13;
        this.m21 = q12 - q03;
        this.m22 = 1.0f - q11 - q00;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f translationRotateScale(float tx, float ty, float tz, float qx, float qy, float qz, float qw, float sx, float sy, float sz) {
        float dqx = qx + qx;
        float dqy = qy + qy;
        float dqz = qz + qz;
        float q00 = dqx * qx;
        float q11 = dqy * qy;
        float q22 = dqz * qz;
        float q01 = dqx * qy;
        float q02 = dqx * qz;
        float q03 = dqx * qw;
        float q12 = dqy * qz;
        float q13 = dqy * qw;
        float q23 = dqz * qw;
        this.m00 = sx - (q11 + q22) * sx;
        this.m01 = (q01 + q23) * sx;
        this.m02 = (q02 - q13) * sx;
        this.m03 = 0.0f;
        this.m10 = (q01 - q23) * sy;
        this.m11 = sy - (q22 + q00) * sy;
        this.m12 = (q12 + q03) * sy;
        this.m13 = 0.0f;
        this.m20 = (q02 + q13) * sz;
        this.m21 = (q12 - q03) * sz;
        this.m22 = sz - (q11 + q00) * sz;
        this.m23 = 0.0f;
        this.m30 = tx;
        this.m31 = ty;
        this.m32 = tz;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f translationRotateScale(Vector3f translation, Quaternionf quat, Vector3f scale) {
        return this.translationRotateScale(translation.x, translation.y, translation.z, quat.x, quat.y, quat.z, quat.w, scale.x, scale.y, scale.z);
    }

    public Matrix4f translationRotateScale(float tx, float ty, float tz, float qx, float qy, float qz, float qw, float scale) {
        return this.translationRotateScale(tx, ty, tz, qx, qy, qz, qw, scale, scale, scale);
    }

    public Matrix4f translationRotateScale(Vector3f translation, Quaternionf quat, float scale) {
        return this.translationRotateScale(translation.x, translation.y, translation.z, quat.x, quat.y, quat.z, quat.w, scale, scale, scale);
    }

    public Matrix4f translationRotateScaleInvert(float tx, float ty, float tz, float qx, float qy, float qz, float qw, float sx, float sy, float sz) {
        float nqx = -qx;
        float nqy = -qy;
        float nqz = -qz;
        float dqx = nqx + nqx;
        float dqy = nqy + nqy;
        float dqz = nqz + nqz;
        float q00 = dqx * nqx;
        float q11 = dqy * nqy;
        float q22 = dqz * nqz;
        float q01 = dqx * nqy;
        float q02 = dqx * nqz;
        float q03 = dqx * qw;
        float q12 = dqy * nqz;
        float q13 = dqy * qw;
        float q23 = dqz * qw;
        float isx = 1.0f / sx;
        float isy = 1.0f / sy;
        float isz = 1.0f / sz;
        this.m00 = isx * (1.0f - q11 - q22);
        this.m01 = isy * (q01 + q23);
        this.m02 = isz * (q02 - q13);
        this.m03 = 0.0f;
        this.m10 = isx * (q01 - q23);
        this.m11 = isy * (1.0f - q22 - q00);
        this.m12 = isz * (q12 + q03);
        this.m13 = 0.0f;
        this.m20 = isx * (q02 + q13);
        this.m21 = isy * (q12 - q03);
        this.m22 = isz * (1.0f - q11 - q00);
        this.m23 = 0.0f;
        this.m30 = -this.m00 * tx - this.m10 * ty - this.m20 * tz;
        this.m31 = -this.m01 * tx - this.m11 * ty - this.m21 * tz;
        this.m32 = -this.m02 * tx - this.m12 * ty - this.m22 * tz;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f translationRotateScaleInvert(Vector3f translation, Quaternionf quat, Vector3f scale) {
        return this.translationRotateScaleInvert(translation.x, translation.y, translation.z, quat.x, quat.y, quat.z, quat.w, scale.x, scale.y, scale.z);
    }

    public Matrix4f translationRotateScaleInvert(Vector3f translation, Quaternionf quat, float scale) {
        return this.translationRotateScaleInvert(translation.x, translation.y, translation.z, quat.x, quat.y, quat.z, quat.w, scale, scale, scale);
    }

    public Matrix4f translationRotateScaleMulAffine(float tx, float ty, float tz, float qx, float qy, float qz, float qw, float sx, float sy, float sz, Matrix4f m) {
        float dqx = qx + qx;
        float dqy = qy + qy;
        float dqz = qz + qz;
        float q00 = dqx * qx;
        float q11 = dqy * qy;
        float q22 = dqz * qz;
        float q01 = dqx * qy;
        float q02 = dqx * qz;
        float q03 = dqx * qw;
        float q12 = dqy * qz;
        float q13 = dqy * qw;
        float q23 = dqz * qw;
        float nm00 = sx - (q11 + q22) * sx;
        float nm01 = (q01 + q23) * sx;
        float nm02 = (q02 - q13) * sx;
        float nm10 = (q01 - q23) * sy;
        float nm11 = sy - (q22 + q00) * sy;
        float nm12 = (q12 + q03) * sy;
        float nm20 = (q02 + q13) * sz;
        float nm21 = (q12 - q03) * sz;
        float nm22 = sz - (q11 + q00) * sz;
        float m00 = nm00 * m.m00 + nm10 * m.m01 + nm20 * m.m02;
        float m01 = nm01 * m.m00 + nm11 * m.m01 + nm21 * m.m02;
        this.m02 = nm02 * m.m00 + nm12 * m.m01 + nm22 * m.m02;
        this.m00 = m00;
        this.m01 = m01;
        this.m03 = 0.0f;
        float m10 = nm00 * m.m10 + nm10 * m.m11 + nm20 * m.m12;
        float m11 = nm01 * m.m10 + nm11 * m.m11 + nm21 * m.m12;
        this.m12 = nm02 * m.m10 + nm12 * m.m11 + nm22 * m.m12;
        this.m10 = m10;
        this.m11 = m11;
        this.m13 = 0.0f;
        float m20 = nm00 * m.m20 + nm10 * m.m21 + nm20 * m.m22;
        float m21 = nm01 * m.m20 + nm11 * m.m21 + nm21 * m.m22;
        this.m22 = nm02 * m.m20 + nm12 * m.m21 + nm22 * m.m22;
        this.m20 = m20;
        this.m21 = m21;
        this.m23 = 0.0f;
        float m30 = nm00 * m.m30 + nm10 * m.m31 + nm20 * m.m32 + tx;
        float m31 = nm01 * m.m30 + nm11 * m.m31 + nm21 * m.m32 + ty;
        this.m32 = nm02 * m.m30 + nm12 * m.m31 + nm22 * m.m32 + tz;
        this.m30 = m30;
        this.m31 = m31;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f translationRotateScaleMulAffine(Vector3f translation, Quaternionf quat, Vector3f scale, Matrix4f m) {
        return this.translationRotateScaleMulAffine(translation.x, translation.y, translation.z, quat.x, quat.y, quat.z, quat.w, scale.x, scale.y, scale.z, m);
    }

    public Matrix4f translationRotate(float tx, float ty, float tz, float qx, float qy, float qz, float qw) {
        float dqx = qx + qx;
        float dqy = qy + qy;
        float dqz = qz + qz;
        float q00 = dqx * qx;
        float q11 = dqy * qy;
        float q22 = dqz * qz;
        float q01 = dqx * qy;
        float q02 = dqx * qz;
        float q03 = dqx * qw;
        float q12 = dqy * qz;
        float q13 = dqy * qw;
        float q23 = dqz * qw;
        this.m00 = 1.0f - (q11 + q22);
        this.m01 = q01 + q23;
        this.m02 = q02 - q13;
        this.m03 = 0.0f;
        this.m10 = q01 - q23;
        this.m11 = 1.0f - (q22 + q00);
        this.m12 = q12 + q03;
        this.m13 = 0.0f;
        this.m20 = q02 + q13;
        this.m21 = q12 - q03;
        this.m22 = 1.0f - (q11 + q00);
        this.m23 = 0.0f;
        this.m30 = tx;
        this.m31 = ty;
        this.m32 = tz;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f translationRotate(float tx, float ty, float tz, Quaternionf quat) {
        return this.translationRotate(tx, ty, tz, quat.x, quat.y, quat.z, quat.w);
    }

    public Matrix4f set3x3(Matrix3f mat) {
        MemUtil.INSTANCE.copy3x3(mat, this);
        this.properties = (byte)(this.properties & 0xFFFFFFF2);
        return this;
    }

    public Vector4f transform(Vector4f v) {
        return v.mul(this);
    }

    public Vector4f transform(Vector4f v, Vector4f dest) {
        return v.mul(this, dest);
    }

    public Vector4f transform(float x, float y, float z, float w, Vector4f dest) {
        dest.set(this.m00 * x + this.m10 * y + this.m20 * z + this.m30 * w, this.m01 * x + this.m11 * y + this.m21 * z + this.m31 * w, this.m02 * x + this.m12 * y + this.m22 * z + this.m32 * w, this.m03 * x + this.m13 * y + this.m23 * z + this.m33 * w);
        return dest;
    }

    public Vector4f transformProject(Vector4f v) {
        return v.mulProject(this);
    }

    public Vector4f transformProject(Vector4f v, Vector4f dest) {
        return v.mulProject(this, dest);
    }

    public Vector4f transformProject(float x, float y, float z, float w, Vector4f dest) {
        float invW = 1.0f / (this.m03 * x + this.m13 * y + this.m23 * z + this.m33 * w);
        dest.set((this.m00 * x + this.m10 * y + this.m20 * z + this.m30 * w) * invW, (this.m01 * x + this.m11 * y + this.m21 * z + this.m31 * w) * invW, (this.m02 * x + this.m12 * y + this.m22 * z + this.m32 * w) * invW, 1.0f);
        return dest;
    }

    public Vector3f transformProject(Vector3f v) {
        return v.mulProject(this);
    }

    public Vector3f transformProject(Vector3f v, Vector3f dest) {
        return v.mulProject(this, dest);
    }

    public Vector3f transformProject(float x, float y, float z, Vector3f dest) {
        float invW = 1.0f / (this.m03 * x + this.m13 * y + this.m23 * z + this.m33);
        dest.set((this.m00 * x + this.m10 * y + this.m20 * z + this.m30) * invW, (this.m01 * x + this.m11 * y + this.m21 * z + this.m31) * invW, (this.m02 * x + this.m12 * y + this.m22 * z + this.m32) * invW);
        return dest;
    }

    public Vector3f transformPosition(Vector3f v) {
        v.set(this.m00 * v.x + this.m10 * v.y + this.m20 * v.z + this.m30, this.m01 * v.x + this.m11 * v.y + this.m21 * v.z + this.m31, this.m02 * v.x + this.m12 * v.y + this.m22 * v.z + this.m32);
        return v;
    }

    public Vector3f transformPosition(Vector3f v, Vector3f dest) {
        return this.transformPosition(v.x, v.y, v.z, dest);
    }

    public Vector3f transformPosition(float x, float y, float z, Vector3f dest) {
        dest.set(this.m00 * x + this.m10 * y + this.m20 * z + this.m30, this.m01 * x + this.m11 * y + this.m21 * z + this.m31, this.m02 * x + this.m12 * y + this.m22 * z + this.m32);
        return dest;
    }

    public Vector3f transformDirection(Vector3f v) {
        v.set(this.m00 * v.x + this.m10 * v.y + this.m20 * v.z, this.m01 * v.x + this.m11 * v.y + this.m21 * v.z, this.m02 * v.x + this.m12 * v.y + this.m22 * v.z);
        return v;
    }

    public Vector3f transformDirection(Vector3f v, Vector3f dest) {
        return this.transformDirection(v.x, v.y, v.z, dest);
    }

    public Vector3f transformDirection(float x, float y, float z, Vector3f dest) {
        dest.set(this.m00 * x + this.m10 * y + this.m20 * z, this.m01 * x + this.m11 * y + this.m21 * z, this.m02 * x + this.m12 * y + this.m22 * z);
        return dest;
    }

    public Vector4f transformAffine(Vector4f v) {
        v.set(this.m00 * v.x + this.m10 * v.y + this.m20 * v.z + this.m30 * v.w, this.m01 * v.x + this.m11 * v.y + this.m21 * v.z + this.m31 * v.w, this.m02 * v.x + this.m12 * v.y + this.m22 * v.z + this.m32 * v.w, v.w);
        return v;
    }

    public Vector4f transformAffine(Vector4f v, Vector4f dest) {
        return this.transformAffine(v.x, v.y, v.z, v.w, dest);
    }

    public Vector4f transformAffine(float x, float y, float z, float w, Vector4f dest) {
        dest.set(this.m00 * x + this.m10 * y + this.m20 * z + this.m30 * w, this.m01 * x + this.m11 * y + this.m21 * z + this.m31 * w, this.m02 * x + this.m12 * y + this.m22 * z + this.m32 * w, w);
        return dest;
    }

    public Matrix4f scale(Vector3f xyz, Matrix4f dest) {
        return this.scale(xyz.x, xyz.y, xyz.z, dest);
    }

    public Matrix4f scale(Vector3f xyz) {
        return this.scale(xyz.x, xyz.y, xyz.z, this);
    }

    public Matrix4f scale(float xyz, Matrix4f dest) {
        return this.scale(xyz, xyz, xyz, dest);
    }

    public Matrix4f scale(float xyz) {
        return this.scale(xyz, xyz, xyz);
    }

    public Matrix4f scale(float x, float y, float z, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.scaling(x, y, z);
        }
        return this.scaleGeneric(x, y, z, dest);
    }

    private Matrix4f scaleGeneric(float x, float y, float z, Matrix4f dest) {
        dest.m00 = this.m00 * x;
        dest.m01 = this.m01 * x;
        dest.m02 = this.m02 * x;
        dest.m03 = this.m03 * x;
        dest.m10 = this.m10 * y;
        dest.m11 = this.m11 * y;
        dest.m12 = this.m12 * y;
        dest.m13 = this.m13 * y;
        dest.m20 = this.m20 * z;
        dest.m21 = this.m21 * z;
        dest.m22 = this.m22 * z;
        dest.m23 = this.m23 * z;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f scale(float x, float y, float z) {
        return this.scale(x, y, z, this);
    }

    public Matrix4f scaleAround(float sx, float sy, float sz, float ox, float oy, float oz, Matrix4f dest) {
        float nm30 = this.m00 * ox + this.m10 * oy + this.m20 * oz + this.m30;
        float nm31 = this.m01 * ox + this.m11 * oy + this.m21 * oz + this.m31;
        float nm32 = this.m02 * ox + this.m12 * oy + this.m22 * oz + this.m32;
        float nm33 = this.m03 * ox + this.m13 * oy + this.m23 * oz + this.m33;
        dest.m00 = this.m00 * sx;
        dest.m01 = this.m01 * sx;
        dest.m02 = this.m02 * sx;
        dest.m03 = this.m03 * sx;
        dest.m10 = this.m10 * sy;
        dest.m11 = this.m11 * sy;
        dest.m12 = this.m12 * sy;
        dest.m13 = this.m13 * sy;
        dest.m20 = this.m20 * sz;
        dest.m21 = this.m21 * sz;
        dest.m22 = this.m22 * sz;
        dest.m23 = this.m23 * sz;
        dest.m30 = -this.m00 * ox - this.m10 * oy - this.m20 * oz + nm30;
        dest.m31 = -this.m01 * ox - this.m11 * oy - this.m21 * oz + nm31;
        dest.m32 = -this.m02 * ox - this.m12 * oy - this.m22 * oz + nm32;
        dest.m33 = -this.m03 * ox - this.m13 * oy - this.m23 * oz + nm33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f scaleAround(float sx, float sy, float sz, float ox, float oy, float oz) {
        return this.scaleAround(sx, sy, sz, ox, oy, oz, this);
    }

    public Matrix4f scaleAround(float factor, float ox, float oy, float oz) {
        return this.scaleAround(factor, factor, factor, ox, oy, oz, this);
    }

    public Matrix4f scaleAround(float factor, float ox, float oy, float oz, Matrix4f dest) {
        return this.scaleAround(factor, factor, factor, ox, oy, oz, dest);
    }

    public Matrix4f scaleLocal(float x, float y, float z, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.scaling(x, y, z);
        }
        float nm00 = x * this.m00;
        float nm01 = y * this.m01;
        float nm02 = z * this.m02;
        float nm03 = this.m03;
        float nm10 = x * this.m10;
        float nm11 = y * this.m11;
        float nm12 = z * this.m12;
        float nm13 = this.m13;
        float nm20 = x * this.m20;
        float nm21 = y * this.m21;
        float nm22 = z * this.m22;
        float nm23 = this.m23;
        float nm30 = x * this.m30;
        float nm31 = y * this.m31;
        float nm32 = z * this.m32;
        float nm33 = this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f scaleLocal(float x, float y, float z) {
        return this.scaleLocal(x, y, z, this);
    }

    public Matrix4f scaleAroundLocal(float sx, float sy, float sz, float ox, float oy, float oz, Matrix4f dest) {
        dest.m00 = sx * (this.m00 - ox * this.m03) + ox * this.m03;
        dest.m01 = sy * (this.m01 - oy * this.m03) + oy * this.m03;
        dest.m02 = sz * (this.m02 - oz * this.m03) + oz * this.m03;
        dest.m03 = this.m03;
        dest.m10 = sx * (this.m10 - ox * this.m13) + ox * this.m13;
        dest.m11 = sy * (this.m11 - oy * this.m13) + oy * this.m13;
        dest.m12 = sz * (this.m12 - oz * this.m13) + oz * this.m13;
        dest.m13 = this.m13;
        dest.m20 = sx * (this.m20 - ox * this.m23) + ox * this.m23;
        dest.m21 = sy * (this.m21 - oy * this.m23) + oy * this.m23;
        dest.m22 = sz * (this.m22 - oz * this.m23) + oz * this.m23;
        dest.m23 = this.m23;
        dest.m30 = sx * (this.m30 - ox * this.m33) + ox * this.m33;
        dest.m31 = sy * (this.m31 - oy * this.m33) + oy * this.m33;
        dest.m32 = sz * (this.m32 - oz * this.m33) + oz * this.m33;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f scaleAroundLocal(float sx, float sy, float sz, float ox, float oy, float oz) {
        return this.scaleAroundLocal(sx, sy, sz, ox, oy, oz, this);
    }

    public Matrix4f scaleAroundLocal(float factor, float ox, float oy, float oz) {
        return this.scaleAroundLocal(factor, factor, factor, ox, oy, oz, this);
    }

    public Matrix4f scaleAroundLocal(float factor, float ox, float oy, float oz, Matrix4f dest) {
        return this.scaleAroundLocal(factor, factor, factor, ox, oy, oz, dest);
    }

    public Matrix4f rotateX(float ang, Matrix4f dest) {
        float cos;
        if ((this.properties & 4) != 0) {
            return dest.rotationX(ang);
        }
        float sin = (float)Math.sin(ang);
        float rm11 = cos = (float)Math.cos(ang);
        float rm12 = sin;
        float rm21 = -sin;
        float rm22 = cos;
        float nm10 = this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m13 * rm21 + this.m23 * rm22;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m00 = this.m00;
        dest.m01 = this.m01;
        dest.m02 = this.m02;
        dest.m03 = this.m03;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateX(float ang) {
        return this.rotateX(ang, this);
    }

    public Matrix4f rotateY(float ang, Matrix4f dest) {
        float cos;
        if ((this.properties & 4) != 0) {
            return dest.rotationY(ang);
        }
        float sin = (float)Math.sin(ang);
        float rm00 = cos = (float)Math.cos(ang);
        float rm02 = -sin;
        float rm20 = sin;
        float rm22 = cos;
        float nm00 = this.m00 * rm00 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m23 * rm02;
        dest.m20 = this.m00 * rm20 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = this.m10;
        dest.m11 = this.m11;
        dest.m12 = this.m12;
        dest.m13 = this.m13;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateY(float ang) {
        return this.rotateY(ang, this);
    }

    public Matrix4f rotateZ(float ang, Matrix4f dest) {
        float cos;
        if ((this.properties & 4) != 0) {
            return dest.rotationZ(ang);
        }
        float sin = (float)Math.sin(ang);
        float rm00 = cos = (float)Math.cos(ang);
        float rm01 = sin;
        float rm10 = -sin;
        float rm11 = cos;
        float nm00 = this.m00 * rm00 + this.m10 * rm01;
        float nm01 = this.m01 * rm00 + this.m11 * rm01;
        float nm02 = this.m02 * rm00 + this.m12 * rm01;
        float nm03 = this.m03 * rm00 + this.m13 * rm01;
        dest.m10 = this.m00 * rm10 + this.m10 * rm11;
        dest.m11 = this.m01 * rm10 + this.m11 * rm11;
        dest.m12 = this.m02 * rm10 + this.m12 * rm11;
        dest.m13 = this.m03 * rm10 + this.m13 * rm11;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        dest.m23 = this.m23;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateZ(float ang) {
        return this.rotateZ(ang, this);
    }

    public Matrix4f rotateXYZ(float angleX, float angleY, float angleZ) {
        return this.rotateXYZ(angleX, angleY, angleZ, this);
    }

    public Matrix4f rotateXYZ(float angleX, float angleY, float angleZ, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.rotationXYZ(angleX, angleY, angleZ);
        }
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinX = -sinX;
        float m_sinY = -sinY;
        float m_sinZ = -sinZ;
        float nm10 = this.m10 * cosX + this.m20 * sinX;
        float nm11 = this.m11 * cosX + this.m21 * sinX;
        float nm12 = this.m12 * cosX + this.m22 * sinX;
        float nm13 = this.m13 * cosX + this.m23 * sinX;
        float nm20 = this.m10 * m_sinX + this.m20 * cosX;
        float nm21 = this.m11 * m_sinX + this.m21 * cosX;
        float nm22 = this.m12 * m_sinX + this.m22 * cosX;
        float nm23 = this.m13 * m_sinX + this.m23 * cosX;
        float nm00 = this.m00 * cosY + nm20 * m_sinY;
        float nm01 = this.m01 * cosY + nm21 * m_sinY;
        float nm02 = this.m02 * cosY + nm22 * m_sinY;
        float nm03 = this.m03 * cosY + nm23 * m_sinY;
        dest.m20 = this.m00 * sinY + nm20 * cosY;
        dest.m21 = this.m01 * sinY + nm21 * cosY;
        dest.m22 = this.m02 * sinY + nm22 * cosY;
        dest.m23 = this.m03 * sinY + nm23 * cosY;
        dest.m00 = nm00 * cosZ + nm10 * sinZ;
        dest.m01 = nm01 * cosZ + nm11 * sinZ;
        dest.m02 = nm02 * cosZ + nm12 * sinZ;
        dest.m03 = nm03 * cosZ + nm13 * sinZ;
        dest.m10 = nm00 * m_sinZ + nm10 * cosZ;
        dest.m11 = nm01 * m_sinZ + nm11 * cosZ;
        dest.m12 = nm02 * m_sinZ + nm12 * cosZ;
        dest.m13 = nm03 * m_sinZ + nm13 * cosZ;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateAffineXYZ(float angleX, float angleY, float angleZ) {
        return this.rotateAffineXYZ(angleX, angleY, angleZ, this);
    }

    public Matrix4f rotateAffineXYZ(float angleX, float angleY, float angleZ, Matrix4f dest) {
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinX = -sinX;
        float m_sinY = -sinY;
        float m_sinZ = -sinZ;
        float nm10 = this.m10 * cosX + this.m20 * sinX;
        float nm11 = this.m11 * cosX + this.m21 * sinX;
        float nm12 = this.m12 * cosX + this.m22 * sinX;
        float nm20 = this.m10 * m_sinX + this.m20 * cosX;
        float nm21 = this.m11 * m_sinX + this.m21 * cosX;
        float nm22 = this.m12 * m_sinX + this.m22 * cosX;
        float nm00 = this.m00 * cosY + nm20 * m_sinY;
        float nm01 = this.m01 * cosY + nm21 * m_sinY;
        float nm02 = this.m02 * cosY + nm22 * m_sinY;
        dest.m20 = this.m00 * sinY + nm20 * cosY;
        dest.m21 = this.m01 * sinY + nm21 * cosY;
        dest.m22 = this.m02 * sinY + nm22 * cosY;
        dest.m23 = 0.0f;
        dest.m00 = nm00 * cosZ + nm10 * sinZ;
        dest.m01 = nm01 * cosZ + nm11 * sinZ;
        dest.m02 = nm02 * cosZ + nm12 * sinZ;
        dest.m03 = 0.0f;
        dest.m10 = nm00 * m_sinZ + nm10 * cosZ;
        dest.m11 = nm01 * m_sinZ + nm11 * cosZ;
        dest.m12 = nm02 * m_sinZ + nm12 * cosZ;
        dest.m13 = 0.0f;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateZYX(float angleZ, float angleY, float angleX) {
        return this.rotateZYX(angleZ, angleY, angleX, this);
    }

    public Matrix4f rotateZYX(float angleZ, float angleY, float angleX, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.rotationZYX(angleZ, angleY, angleX);
        }
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float m_sinZ = -sinZ;
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float nm00 = this.m00 * cosZ + this.m10 * sinZ;
        float nm01 = this.m01 * cosZ + this.m11 * sinZ;
        float nm02 = this.m02 * cosZ + this.m12 * sinZ;
        float nm03 = this.m03 * cosZ + this.m13 * sinZ;
        float nm10 = this.m00 * m_sinZ + this.m10 * cosZ;
        float nm11 = this.m01 * m_sinZ + this.m11 * cosZ;
        float nm12 = this.m02 * m_sinZ + this.m12 * cosZ;
        float nm13 = this.m03 * m_sinZ + this.m13 * cosZ;
        float nm20 = nm00 * sinY + this.m20 * cosY;
        float nm21 = nm01 * sinY + this.m21 * cosY;
        float nm22 = nm02 * sinY + this.m22 * cosY;
        float nm23 = nm03 * sinY + this.m23 * cosY;
        dest.m00 = nm00 * cosY + this.m20 * m_sinY;
        dest.m01 = nm01 * cosY + this.m21 * m_sinY;
        dest.m02 = nm02 * cosY + this.m22 * m_sinY;
        dest.m03 = nm03 * cosY + this.m23 * m_sinY;
        dest.m10 = nm10 * cosX + nm20 * sinX;
        dest.m11 = nm11 * cosX + nm21 * sinX;
        dest.m12 = nm12 * cosX + nm22 * sinX;
        dest.m13 = nm13 * cosX + nm23 * sinX;
        dest.m20 = nm10 * m_sinX + nm20 * cosX;
        dest.m21 = nm11 * m_sinX + nm21 * cosX;
        dest.m22 = nm12 * m_sinX + nm22 * cosX;
        dest.m23 = nm13 * m_sinX + nm23 * cosX;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateAffineZYX(float angleZ, float angleY, float angleX) {
        return this.rotateAffineZYX(angleZ, angleY, angleX, this);
    }

    public Matrix4f rotateAffineZYX(float angleZ, float angleY, float angleX, Matrix4f dest) {
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float m_sinZ = -sinZ;
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float nm00 = this.m00 * cosZ + this.m10 * sinZ;
        float nm01 = this.m01 * cosZ + this.m11 * sinZ;
        float nm02 = this.m02 * cosZ + this.m12 * sinZ;
        float nm10 = this.m00 * m_sinZ + this.m10 * cosZ;
        float nm11 = this.m01 * m_sinZ + this.m11 * cosZ;
        float nm12 = this.m02 * m_sinZ + this.m12 * cosZ;
        float nm20 = nm00 * sinY + this.m20 * cosY;
        float nm21 = nm01 * sinY + this.m21 * cosY;
        float nm22 = nm02 * sinY + this.m22 * cosY;
        dest.m00 = nm00 * cosY + this.m20 * m_sinY;
        dest.m01 = nm01 * cosY + this.m21 * m_sinY;
        dest.m02 = nm02 * cosY + this.m22 * m_sinY;
        dest.m03 = 0.0f;
        dest.m10 = nm10 * cosX + nm20 * sinX;
        dest.m11 = nm11 * cosX + nm21 * sinX;
        dest.m12 = nm12 * cosX + nm22 * sinX;
        dest.m13 = 0.0f;
        dest.m20 = nm10 * m_sinX + nm20 * cosX;
        dest.m21 = nm11 * m_sinX + nm21 * cosX;
        dest.m22 = nm12 * m_sinX + nm22 * cosX;
        dest.m23 = 0.0f;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateYXZ(float angleY, float angleX, float angleZ) {
        return this.rotateYXZ(angleY, angleX, angleZ, this);
    }

    public Matrix4f rotateYXZ(float angleY, float angleX, float angleZ, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.rotationYXZ(angleY, angleX, angleZ);
        }
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float m_sinZ = -sinZ;
        float nm20 = this.m00 * sinY + this.m20 * cosY;
        float nm21 = this.m01 * sinY + this.m21 * cosY;
        float nm22 = this.m02 * sinY + this.m22 * cosY;
        float nm23 = this.m03 * sinY + this.m23 * cosY;
        float nm00 = this.m00 * cosY + this.m20 * m_sinY;
        float nm01 = this.m01 * cosY + this.m21 * m_sinY;
        float nm02 = this.m02 * cosY + this.m22 * m_sinY;
        float nm03 = this.m03 * cosY + this.m23 * m_sinY;
        float nm10 = this.m10 * cosX + nm20 * sinX;
        float nm11 = this.m11 * cosX + nm21 * sinX;
        float nm12 = this.m12 * cosX + nm22 * sinX;
        float nm13 = this.m13 * cosX + nm23 * sinX;
        dest.m20 = this.m10 * m_sinX + nm20 * cosX;
        dest.m21 = this.m11 * m_sinX + nm21 * cosX;
        dest.m22 = this.m12 * m_sinX + nm22 * cosX;
        dest.m23 = this.m13 * m_sinX + nm23 * cosX;
        dest.m00 = nm00 * cosZ + nm10 * sinZ;
        dest.m01 = nm01 * cosZ + nm11 * sinZ;
        dest.m02 = nm02 * cosZ + nm12 * sinZ;
        dest.m03 = nm03 * cosZ + nm13 * sinZ;
        dest.m10 = nm00 * m_sinZ + nm10 * cosZ;
        dest.m11 = nm01 * m_sinZ + nm11 * cosZ;
        dest.m12 = nm02 * m_sinZ + nm12 * cosZ;
        dest.m13 = nm03 * m_sinZ + nm13 * cosZ;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateAffineYXZ(float angleY, float angleX, float angleZ) {
        return this.rotateAffineYXZ(angleY, angleX, angleZ, this);
    }

    public Matrix4f rotateAffineYXZ(float angleY, float angleX, float angleZ, Matrix4f dest) {
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float m_sinY = -sinY;
        float m_sinX = -sinX;
        float m_sinZ = -sinZ;
        float nm20 = this.m00 * sinY + this.m20 * cosY;
        float nm21 = this.m01 * sinY + this.m21 * cosY;
        float nm22 = this.m02 * sinY + this.m22 * cosY;
        float nm00 = this.m00 * cosY + this.m20 * m_sinY;
        float nm01 = this.m01 * cosY + this.m21 * m_sinY;
        float nm02 = this.m02 * cosY + this.m22 * m_sinY;
        float nm10 = this.m10 * cosX + nm20 * sinX;
        float nm11 = this.m11 * cosX + nm21 * sinX;
        float nm12 = this.m12 * cosX + nm22 * sinX;
        dest.m20 = this.m10 * m_sinX + nm20 * cosX;
        dest.m21 = this.m11 * m_sinX + nm21 * cosX;
        dest.m22 = this.m12 * m_sinX + nm22 * cosX;
        dest.m23 = 0.0f;
        dest.m00 = nm00 * cosZ + nm10 * sinZ;
        dest.m01 = nm01 * cosZ + nm11 * sinZ;
        dest.m02 = nm02 * cosZ + nm12 * sinZ;
        dest.m03 = 0.0f;
        dest.m10 = nm00 * m_sinZ + nm10 * cosZ;
        dest.m11 = nm01 * m_sinZ + nm11 * cosZ;
        dest.m12 = nm02 * m_sinZ + nm12 * cosZ;
        dest.m13 = 0.0f;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotate(float ang, float x, float y, float z, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.rotation(ang, x, y, z);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(ang, x, y, z, dest);
        }
        if ((this.properties & 2) != 0) {
            return this.rotateAffine(ang, x, y, z, dest);
        }
        return this.rotateGeneric(ang, x, y, z, dest);
    }

    private Matrix4f rotateGeneric(float ang, float x, float y, float z, Matrix4f dest) {
        float s = (float)Math.sin(ang);
        float c = (float)Math.cos(ang);
        float C = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float rm00 = xx * C + c;
        float rm01 = xy * C + z * s;
        float rm02 = xz * C - y * s;
        float rm10 = xy * C - z * s;
        float rm11 = yy * C + c;
        float rm12 = yz * C + x * s;
        float rm20 = xz * C + y * s;
        float rm21 = yz * C - x * s;
        float rm22 = zz * C + c;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotate(float ang, float x, float y, float z) {
        return this.rotate(ang, x, y, z, this);
    }

    public Matrix4f rotateTranslation(float ang, float x, float y, float z, Matrix4f dest) {
        float s = (float)Math.sin(ang);
        float c = (float)Math.cos(ang);
        float C = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float rm00 = xx * C + c;
        float rm01 = xy * C + z * s;
        float rm02 = xz * C - y * s;
        float rm10 = xy * C - z * s;
        float rm11 = yy * C + c;
        float rm12 = yz * C + x * s;
        float rm20 = xz * C + y * s;
        float rm21 = yz * C - x * s;
        float rm22 = zz * C + c;
        float nm00 = rm00;
        float nm01 = rm01;
        float nm02 = rm02;
        float nm10 = rm10;
        float nm11 = rm11;
        float nm12 = rm12;
        dest.m20 = rm20;
        dest.m21 = rm21;
        dest.m22 = rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = 0.0f;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = 0.0f;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateAffine(float ang, float x, float y, float z, Matrix4f dest) {
        float s = (float)Math.sin(ang);
        float c = (float)Math.cos(ang);
        float C = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float rm00 = xx * C + c;
        float rm01 = xy * C + z * s;
        float rm02 = xz * C - y * s;
        float rm10 = xy * C - z * s;
        float rm11 = yy * C + c;
        float rm12 = yz * C + x * s;
        float rm20 = xz * C + y * s;
        float rm21 = yz * C - x * s;
        float rm22 = zz * C + c;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = 0.0f;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = 0.0f;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = 0.0f;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateAffine(float ang, float x, float y, float z) {
        return this.rotateAffine(ang, x, y, z, this);
    }

    public Matrix4f rotateLocal(float ang, float x, float y, float z, Matrix4f dest) {
        float s = (float)Math.sin(ang);
        float c = (float)Math.cos(ang);
        float C = 1.0f - c;
        float xx = x * x;
        float xy = x * y;
        float xz = x * z;
        float yy = y * y;
        float yz = y * z;
        float zz = z * z;
        float lm00 = xx * C + c;
        float lm01 = xy * C + z * s;
        float lm02 = xz * C - y * s;
        float lm10 = xy * C - z * s;
        float lm11 = yy * C + c;
        float lm12 = yz * C + x * s;
        float lm20 = xz * C + y * s;
        float lm21 = yz * C - x * s;
        float lm22 = zz * C + c;
        float nm00 = lm00 * this.m00 + lm10 * this.m01 + lm20 * this.m02;
        float nm01 = lm01 * this.m00 + lm11 * this.m01 + lm21 * this.m02;
        float nm02 = lm02 * this.m00 + lm12 * this.m01 + lm22 * this.m02;
        float nm03 = this.m03;
        float nm10 = lm00 * this.m10 + lm10 * this.m11 + lm20 * this.m12;
        float nm11 = lm01 * this.m10 + lm11 * this.m11 + lm21 * this.m12;
        float nm12 = lm02 * this.m10 + lm12 * this.m11 + lm22 * this.m12;
        float nm13 = this.m13;
        float nm20 = lm00 * this.m20 + lm10 * this.m21 + lm20 * this.m22;
        float nm21 = lm01 * this.m20 + lm11 * this.m21 + lm21 * this.m22;
        float nm22 = lm02 * this.m20 + lm12 * this.m21 + lm22 * this.m22;
        float nm23 = this.m23;
        float nm30 = lm00 * this.m30 + lm10 * this.m31 + lm20 * this.m32;
        float nm31 = lm01 * this.m30 + lm11 * this.m31 + lm21 * this.m32;
        float nm32 = lm02 * this.m30 + lm12 * this.m31 + lm22 * this.m32;
        float nm33 = this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateLocal(float ang, float x, float y, float z) {
        return this.rotateLocal(ang, x, y, z, this);
    }

    public Matrix4f translate(Vector3f offset) {
        return this.translate(offset.x, offset.y, offset.z);
    }

    public Matrix4f translate(Vector3f offset, Matrix4f dest) {
        return this.translate(offset.x, offset.y, offset.z, dest);
    }

    public Matrix4f translate(float x, float y, float z, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.translation(x, y, z);
        }
        return this.translateGeneric(x, y, z, dest);
    }

    private Matrix4f translateGeneric(float x, float y, float z, Matrix4f dest) {
        dest.m00 = this.m00;
        dest.m01 = this.m01;
        dest.m02 = this.m02;
        dest.m03 = this.m03;
        dest.m10 = this.m10;
        dest.m11 = this.m11;
        dest.m12 = this.m12;
        dest.m13 = this.m13;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        dest.m23 = this.m23;
        dest.m30 = this.m00 * x + this.m10 * y + this.m20 * z + this.m30;
        dest.m31 = this.m01 * x + this.m11 * y + this.m21 * z + this.m31;
        dest.m32 = this.m02 * x + this.m12 * y + this.m22 * z + this.m32;
        dest.m33 = this.m03 * x + this.m13 * y + this.m23 * z + this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFFA);
        return dest;
    }

    public Matrix4f translate(float x, float y, float z) {
        if ((this.properties & 4) != 0) {
            return this.translation(x, y, z);
        }
        Matrix4f c = this;
        c.m30 = c.m00 * x + c.m10 * y + c.m20 * z + c.m30;
        c.m31 = c.m01 * x + c.m11 * y + c.m21 * z + c.m31;
        c.m32 = c.m02 * x + c.m12 * y + c.m22 * z + c.m32;
        c.m33 = c.m03 * x + c.m13 * y + c.m23 * z + c.m33;
        c.properties = (byte)(c.properties & 0xFFFFFFFA);
        return this;
    }

    public Matrix4f translateLocal(Vector3f offset) {
        return this.translateLocal(offset.x, offset.y, offset.z);
    }

    public Matrix4f translateLocal(Vector3f offset, Matrix4f dest) {
        return this.translateLocal(offset.x, offset.y, offset.z, dest);
    }

    public Matrix4f translateLocal(float x, float y, float z, Matrix4f dest) {
        float nm00 = this.m00 + x * this.m03;
        float nm01 = this.m01 + y * this.m03;
        float nm02 = this.m02 + z * this.m03;
        float nm03 = this.m03;
        float nm10 = this.m10 + x * this.m13;
        float nm11 = this.m11 + y * this.m13;
        float nm12 = this.m12 + z * this.m13;
        float nm13 = this.m13;
        float nm20 = this.m20 + x * this.m23;
        float nm21 = this.m21 + y * this.m23;
        float nm22 = this.m22 + z * this.m23;
        float nm23 = this.m23;
        float nm30 = this.m30 + x * this.m33;
        float nm31 = this.m31 + y * this.m33;
        float nm32 = this.m32 + z * this.m33;
        float nm33 = this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)(this.properties & 0xFFFFFFFA);
        return dest;
    }

    public Matrix4f translateLocal(float x, float y, float z) {
        return this.translateLocal(x, y, z, this);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.m00);
        out.writeFloat(this.m01);
        out.writeFloat(this.m02);
        out.writeFloat(this.m03);
        out.writeFloat(this.m10);
        out.writeFloat(this.m11);
        out.writeFloat(this.m12);
        out.writeFloat(this.m13);
        out.writeFloat(this.m20);
        out.writeFloat(this.m21);
        out.writeFloat(this.m22);
        out.writeFloat(this.m23);
        out.writeFloat(this.m30);
        out.writeFloat(this.m31);
        out.writeFloat(this.m32);
        out.writeFloat(this.m33);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m00 = in.readFloat();
        this.m01 = in.readFloat();
        this.m02 = in.readFloat();
        this.m03 = in.readFloat();
        this.m10 = in.readFloat();
        this.m11 = in.readFloat();
        this.m12 = in.readFloat();
        this.m13 = in.readFloat();
        this.m20 = in.readFloat();
        this.m21 = in.readFloat();
        this.m22 = in.readFloat();
        this.m23 = in.readFloat();
        this.m30 = in.readFloat();
        this.m31 = in.readFloat();
        this.m32 = in.readFloat();
        this.m33 = in.readFloat();
        this.properties = 0;
    }

    public Matrix4f ortho(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        float rm00 = 2.0f / (right - left);
        float rm11 = 2.0f / (top - bottom);
        float rm22 = (zZeroToOne ? 1.0f : 2.0f) / (zNear - zFar);
        float rm30 = (left + right) / (left - right);
        float rm31 = (top + bottom) / (bottom - top);
        float rm32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        dest.m30 = this.m00 * rm30 + this.m10 * rm31 + this.m20 * rm32 + this.m30;
        dest.m31 = this.m01 * rm30 + this.m11 * rm31 + this.m21 * rm32 + this.m31;
        dest.m32 = this.m02 * rm30 + this.m12 * rm31 + this.m22 * rm32 + this.m32;
        dest.m33 = this.m03 * rm30 + this.m13 * rm31 + this.m23 * rm32 + this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m20 = this.m20 * rm22;
        dest.m21 = this.m21 * rm22;
        dest.m22 = this.m22 * rm22;
        dest.m23 = this.m23 * rm22;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f ortho(float left, float right, float bottom, float top, float zNear, float zFar, Matrix4f dest) {
        return this.ortho(left, right, bottom, top, zNear, zFar, false, dest);
    }

    public Matrix4f ortho(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        return this.ortho(left, right, bottom, top, zNear, zFar, zZeroToOne, this);
    }

    public Matrix4f ortho(float left, float right, float bottom, float top, float zNear, float zFar) {
        return this.ortho(left, right, bottom, top, zNear, zFar, false);
    }

    public Matrix4f orthoLH(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        float rm00 = 2.0f / (right - left);
        float rm11 = 2.0f / (top - bottom);
        float rm22 = (zZeroToOne ? 1.0f : 2.0f) / (zFar - zNear);
        float rm30 = (left + right) / (left - right);
        float rm31 = (top + bottom) / (bottom - top);
        float rm32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        dest.m30 = this.m00 * rm30 + this.m10 * rm31 + this.m20 * rm32 + this.m30;
        dest.m31 = this.m01 * rm30 + this.m11 * rm31 + this.m21 * rm32 + this.m31;
        dest.m32 = this.m02 * rm30 + this.m12 * rm31 + this.m22 * rm32 + this.m32;
        dest.m33 = this.m03 * rm30 + this.m13 * rm31 + this.m23 * rm32 + this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m20 = this.m20 * rm22;
        dest.m21 = this.m21 * rm22;
        dest.m22 = this.m22 * rm22;
        dest.m23 = this.m23 * rm22;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f orthoLH(float left, float right, float bottom, float top, float zNear, float zFar, Matrix4f dest) {
        return this.orthoLH(left, right, bottom, top, zNear, zFar, false, dest);
    }

    public Matrix4f orthoLH(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        return this.orthoLH(left, right, bottom, top, zNear, zFar, zZeroToOne, this);
    }

    public Matrix4f orthoLH(float left, float right, float bottom, float top, float zNear, float zFar) {
        return this.orthoLH(left, right, bottom, top, zNear, zFar, false);
    }

    public Matrix4f setOrtho(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (right - left);
        this.m11 = 2.0f / (top - bottom);
        this.m22 = (zZeroToOne ? 1.0f : 2.0f) / (zNear - zFar);
        this.m30 = (right + left) / (left - right);
        this.m31 = (top + bottom) / (bottom - top);
        this.m32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f setOrtho(float left, float right, float bottom, float top, float zNear, float zFar) {
        return this.setOrtho(left, right, bottom, top, zNear, zFar, false);
    }

    public Matrix4f setOrthoLH(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (right - left);
        this.m11 = 2.0f / (top - bottom);
        this.m22 = (zZeroToOne ? 1.0f : 2.0f) / (zFar - zNear);
        this.m30 = (right + left) / (left - right);
        this.m31 = (top + bottom) / (bottom - top);
        this.m32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f setOrthoLH(float left, float right, float bottom, float top, float zNear, float zFar) {
        return this.setOrthoLH(left, right, bottom, top, zNear, zFar, false);
    }

    public Matrix4f orthoSymmetric(float width, float height, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        float rm00 = 2.0f / width;
        float rm11 = 2.0f / height;
        float rm22 = (zZeroToOne ? 1.0f : 2.0f) / (zNear - zFar);
        float rm32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        dest.m30 = this.m20 * rm32 + this.m30;
        dest.m31 = this.m21 * rm32 + this.m31;
        dest.m32 = this.m22 * rm32 + this.m32;
        dest.m33 = this.m23 * rm32 + this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m20 = this.m20 * rm22;
        dest.m21 = this.m21 * rm22;
        dest.m22 = this.m22 * rm22;
        dest.m23 = this.m23 * rm22;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f orthoSymmetric(float width, float height, float zNear, float zFar, Matrix4f dest) {
        return this.orthoSymmetric(width, height, zNear, zFar, false, dest);
    }

    public Matrix4f orthoSymmetric(float width, float height, float zNear, float zFar, boolean zZeroToOne) {
        return this.orthoSymmetric(width, height, zNear, zFar, zZeroToOne, this);
    }

    public Matrix4f orthoSymmetric(float width, float height, float zNear, float zFar) {
        return this.orthoSymmetric(width, height, zNear, zFar, false, this);
    }

    public Matrix4f orthoSymmetricLH(float width, float height, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        float rm00 = 2.0f / width;
        float rm11 = 2.0f / height;
        float rm22 = (zZeroToOne ? 1.0f : 2.0f) / (zFar - zNear);
        float rm32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        dest.m30 = this.m20 * rm32 + this.m30;
        dest.m31 = this.m21 * rm32 + this.m31;
        dest.m32 = this.m22 * rm32 + this.m32;
        dest.m33 = this.m23 * rm32 + this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m20 = this.m20 * rm22;
        dest.m21 = this.m21 * rm22;
        dest.m22 = this.m22 * rm22;
        dest.m23 = this.m23 * rm22;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f orthoSymmetricLH(float width, float height, float zNear, float zFar, Matrix4f dest) {
        return this.orthoSymmetricLH(width, height, zNear, zFar, false, dest);
    }

    public Matrix4f orthoSymmetricLH(float width, float height, float zNear, float zFar, boolean zZeroToOne) {
        return this.orthoSymmetricLH(width, height, zNear, zFar, zZeroToOne, this);
    }

    public Matrix4f orthoSymmetricLH(float width, float height, float zNear, float zFar) {
        return this.orthoSymmetricLH(width, height, zNear, zFar, false, this);
    }

    public Matrix4f setOrthoSymmetric(float width, float height, float zNear, float zFar, boolean zZeroToOne) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / width;
        this.m11 = 2.0f / height;
        this.m22 = (zZeroToOne ? 1.0f : 2.0f) / (zNear - zFar);
        this.m32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f setOrthoSymmetric(float width, float height, float zNear, float zFar) {
        return this.setOrthoSymmetric(width, height, zNear, zFar, false);
    }

    public Matrix4f setOrthoSymmetricLH(float width, float height, float zNear, float zFar, boolean zZeroToOne) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / width;
        this.m11 = 2.0f / height;
        this.m22 = (zZeroToOne ? 1.0f : 2.0f) / (zFar - zNear);
        this.m32 = (zZeroToOne ? zNear : zFar + zNear) / (zNear - zFar);
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f setOrthoSymmetricLH(float width, float height, float zNear, float zFar) {
        return this.setOrthoSymmetricLH(width, height, zNear, zFar, false);
    }

    public Matrix4f ortho2D(float left, float right, float bottom, float top, Matrix4f dest) {
        float rm00 = 2.0f / (right - left);
        float rm11 = 2.0f / (top - bottom);
        float rm30 = -(right + left) / (right - left);
        float rm31 = -(top + bottom) / (top - bottom);
        dest.m30 = this.m00 * rm30 + this.m10 * rm31 + this.m30;
        dest.m31 = this.m01 * rm30 + this.m11 * rm31 + this.m31;
        dest.m32 = this.m02 * rm30 + this.m12 * rm31 + this.m32;
        dest.m33 = this.m03 * rm30 + this.m13 * rm31 + this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m20 = -this.m20;
        dest.m21 = -this.m21;
        dest.m22 = -this.m22;
        dest.m23 = -this.m23;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f ortho2D(float left, float right, float bottom, float top) {
        return this.ortho2D(left, right, bottom, top, this);
    }

    public Matrix4f ortho2DLH(float left, float right, float bottom, float top, Matrix4f dest) {
        float rm00 = 2.0f / (right - left);
        float rm11 = 2.0f / (top - bottom);
        float rm30 = -(right + left) / (right - left);
        float rm31 = -(top + bottom) / (top - bottom);
        dest.m30 = this.m00 * rm30 + this.m10 * rm31 + this.m30;
        dest.m31 = this.m01 * rm30 + this.m11 * rm31 + this.m31;
        dest.m32 = this.m02 * rm30 + this.m12 * rm31 + this.m32;
        dest.m33 = this.m03 * rm30 + this.m13 * rm31 + this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        dest.m23 = this.m23;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f ortho2DLH(float left, float right, float bottom, float top) {
        return this.ortho2DLH(left, right, bottom, top, this);
    }

    public Matrix4f setOrtho2D(float left, float right, float bottom, float top) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (right - left);
        this.m11 = 2.0f / (top - bottom);
        this.m22 = -1.0f;
        this.m30 = -(right + left) / (right - left);
        this.m31 = -(top + bottom) / (top - bottom);
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f setOrtho2DLH(float left, float right, float bottom, float top) {
        MemUtil.INSTANCE.identity(this);
        this.m00 = 2.0f / (right - left);
        this.m11 = 2.0f / (top - bottom);
        this.m22 = 1.0f;
        this.m30 = -(right + left) / (right - left);
        this.m31 = -(top + bottom) / (top - bottom);
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f lookAlong(Vector3f dir, Vector3f up) {
        return this.lookAlong(dir.x, dir.y, dir.z, up.x, up.y, up.z, this);
    }

    public Matrix4f lookAlong(Vector3f dir, Vector3f up, Matrix4f dest) {
        return this.lookAlong(dir.x, dir.y, dir.z, up.x, up.y, up.z, dest);
    }

    public Matrix4f lookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return this.setLookAlong(dirX, dirY, dirZ, upX, upY, upZ);
        }
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float dirnX = dirX * invDirLength;
        float dirnY = dirY * invDirLength;
        float dirnZ = dirZ * invDirLength;
        float rightX = dirnY * upZ - dirnZ * upY;
        float rightY = dirnZ * upX - dirnX * upZ;
        float rightZ = dirnX * upY - dirnY * upX;
        float invRightLength = 1.0f / (float)Math.sqrt(rightX * rightX + rightY * rightY + rightZ * rightZ);
        float upnX = (rightY *= invRightLength) * dirnZ - (rightZ *= invRightLength) * dirnY;
        float upnY = rightZ * dirnX - (rightX *= invRightLength) * dirnZ;
        float upnZ = rightX * dirnY - rightY * dirnX;
        float rm00 = rightX;
        float rm01 = upnX;
        float rm02 = -dirnX;
        float rm10 = rightY;
        float rm11 = upnY;
        float rm12 = -dirnY;
        float rm20 = rightZ;
        float rm21 = upnZ;
        float rm22 = -dirnZ;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f lookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ) {
        return this.lookAlong(dirX, dirY, dirZ, upX, upY, upZ, this);
    }

    public Matrix4f setLookAlong(Vector3f dir, Vector3f up) {
        return this.setLookAlong(dir.x, dir.y, dir.z, up.x, up.y, up.z);
    }

    public Matrix4f setLookAlong(float dirX, float dirY, float dirZ, float upX, float upY, float upZ) {
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float dirnX = dirX * invDirLength;
        float dirnY = dirY * invDirLength;
        float dirnZ = dirZ * invDirLength;
        float rightX = dirnY * upZ - dirnZ * upY;
        float rightY = dirnZ * upX - dirnX * upZ;
        float rightZ = dirnX * upY - dirnY * upX;
        float invRightLength = 1.0f / (float)Math.sqrt(rightX * rightX + rightY * rightY + rightZ * rightZ);
        float upnX = (rightY *= invRightLength) * dirnZ - (rightZ *= invRightLength) * dirnY;
        float upnY = rightZ * dirnX - (rightX *= invRightLength) * dirnZ;
        float upnZ = rightX * dirnY - rightY * dirnX;
        this.m00 = rightX;
        this.m01 = upnX;
        this.m02 = -dirnX;
        this.m03 = 0.0f;
        this.m10 = rightY;
        this.m11 = upnY;
        this.m12 = -dirnY;
        this.m13 = 0.0f;
        this.m20 = rightZ;
        this.m21 = upnZ;
        this.m22 = -dirnZ;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f setLookAt(Vector3f eye, Vector3f center, Vector3f up) {
        return this.setLookAt(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z);
    }

    public Matrix4f setLookAt(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float dirX = eyeX - centerX;
        float dirY = eyeY - centerY;
        float dirZ = eyeZ - centerZ;
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float leftX = upY * (dirZ *= invDirLength) - upZ * (dirY *= invDirLength);
        float leftY = upZ * (dirX *= invDirLength) - upX * dirZ;
        float leftZ = upX * dirY - upY * dirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = dirY * (leftZ *= invLeftLength) - dirZ * (leftY *= invLeftLength);
        float upnY = dirZ * (leftX *= invLeftLength) - dirX * leftZ;
        float upnZ = dirX * leftY - dirY * leftX;
        this.m00 = leftX;
        this.m01 = upnX;
        this.m02 = dirX;
        this.m03 = 0.0f;
        this.m10 = leftY;
        this.m11 = upnY;
        this.m12 = dirY;
        this.m13 = 0.0f;
        this.m20 = leftZ;
        this.m21 = upnZ;
        this.m22 = dirZ;
        this.m23 = 0.0f;
        this.m30 = -(leftX * eyeX + leftY * eyeY + leftZ * eyeZ);
        this.m31 = -(upnX * eyeX + upnY * eyeY + upnZ * eyeZ);
        this.m32 = -(dirX * eyeX + dirY * eyeY + dirZ * eyeZ);
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f lookAt(Vector3f eye, Vector3f center, Vector3f up, Matrix4f dest) {
        return this.lookAt(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z, dest);
    }

    public Matrix4f lookAt(Vector3f eye, Vector3f center, Vector3f up) {
        return this.lookAt(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z, this);
    }

    public Matrix4f lookAt(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.setLookAt(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
        }
        if ((this.properties & 1) != 0) {
            return this.lookAtPerspective(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ, dest);
        }
        return this.lookAtGeneric(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ, dest);
    }

    private Matrix4f lookAtGeneric(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ, Matrix4f dest) {
        float dirX = eyeX - centerX;
        float dirY = eyeY - centerY;
        float dirZ = eyeZ - centerZ;
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float leftX = upY * (dirZ *= invDirLength) - upZ * (dirY *= invDirLength);
        float leftY = upZ * (dirX *= invDirLength) - upX * dirZ;
        float leftZ = upX * dirY - upY * dirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = dirY * (leftZ *= invLeftLength) - dirZ * (leftY *= invLeftLength);
        float upnY = dirZ * (leftX *= invLeftLength) - dirX * leftZ;
        float upnZ = dirX * leftY - dirY * leftX;
        float rm00 = leftX;
        float rm01 = upnX;
        float rm02 = dirX;
        float rm10 = leftY;
        float rm11 = upnY;
        float rm12 = dirY;
        float rm20 = leftZ;
        float rm21 = upnZ;
        float rm22 = dirZ;
        float rm30 = -(leftX * eyeX + leftY * eyeY + leftZ * eyeZ);
        float rm31 = -(upnX * eyeX + upnY * eyeY + upnZ * eyeZ);
        float rm32 = -(dirX * eyeX + dirY * eyeY + dirZ * eyeZ);
        dest.m30 = this.m00 * rm30 + this.m10 * rm31 + this.m20 * rm32 + this.m30;
        dest.m31 = this.m01 * rm30 + this.m11 * rm31 + this.m21 * rm32 + this.m31;
        dest.m32 = this.m02 * rm30 + this.m12 * rm31 + this.m22 * rm32 + this.m32;
        dest.m33 = this.m03 * rm30 + this.m13 * rm31 + this.m23 * rm32 + this.m33;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f lookAtPerspective(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ, Matrix4f dest) {
        float dirX = eyeX - centerX;
        float dirY = eyeY - centerY;
        float dirZ = eyeZ - centerZ;
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float leftX = upY * (dirZ *= invDirLength) - upZ * (dirY *= invDirLength);
        float leftY = upZ * (dirX *= invDirLength) - upX * dirZ;
        float leftZ = upX * dirY - upY * dirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = dirY * (leftZ *= invLeftLength) - dirZ * (leftY *= invLeftLength);
        float upnY = dirZ * (leftX *= invLeftLength) - dirX * leftZ;
        float upnZ = dirX * leftY - dirY * leftX;
        float rm00 = leftX;
        float rm01 = upnX;
        float rm02 = dirX;
        float rm10 = leftY;
        float rm11 = upnY;
        float rm12 = dirY;
        float rm20 = leftZ;
        float rm21 = upnZ;
        float rm22 = dirZ;
        float rm30 = -(leftX * eyeX + leftY * eyeY + leftZ * eyeZ);
        float rm31 = -(upnX * eyeX + upnY * eyeY + upnZ * eyeZ);
        float rm32 = -(dirX * eyeX + dirY * eyeY + dirZ * eyeZ);
        float nm00 = this.m00 * rm00;
        float nm01 = this.m11 * rm01;
        float nm02 = this.m22 * rm02;
        float nm03 = this.m23 * rm02;
        float nm10 = this.m00 * rm10;
        float nm11 = this.m11 * rm11;
        float nm12 = this.m22 * rm12;
        float nm13 = this.m23 * rm12;
        float nm20 = this.m00 * rm20;
        float nm21 = this.m11 * rm21;
        float nm22 = this.m22 * rm22;
        float nm23 = this.m23 * rm22;
        float nm30 = this.m00 * rm30;
        float nm31 = this.m11 * rm31;
        float nm32 = this.m22 * rm32 + this.m32;
        float nm33 = this.m23 * rm32;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f lookAt(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        return this.lookAt(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ, this);
    }

    public Matrix4f setLookAtLH(Vector3f eye, Vector3f center, Vector3f up) {
        return this.setLookAtLH(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z);
    }

    public Matrix4f setLookAtLH(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float dirX = centerX - eyeX;
        float dirY = centerY - eyeY;
        float dirZ = centerZ - eyeZ;
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float leftX = upY * (dirZ *= invDirLength) - upZ * (dirY *= invDirLength);
        float leftY = upZ * (dirX *= invDirLength) - upX * dirZ;
        float leftZ = upX * dirY - upY * dirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = dirY * (leftZ *= invLeftLength) - dirZ * (leftY *= invLeftLength);
        float upnY = dirZ * (leftX *= invLeftLength) - dirX * leftZ;
        float upnZ = dirX * leftY - dirY * leftX;
        this.m00 = leftX;
        this.m01 = upnX;
        this.m02 = dirX;
        this.m03 = 0.0f;
        this.m10 = leftY;
        this.m11 = upnY;
        this.m12 = dirY;
        this.m13 = 0.0f;
        this.m20 = leftZ;
        this.m21 = upnZ;
        this.m22 = dirZ;
        this.m23 = 0.0f;
        this.m30 = -(leftX * eyeX + leftY * eyeY + leftZ * eyeZ);
        this.m31 = -(upnX * eyeX + upnY * eyeY + upnZ * eyeZ);
        this.m32 = -(dirX * eyeX + dirY * eyeY + dirZ * eyeZ);
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f lookAtLH(Vector3f eye, Vector3f center, Vector3f up, Matrix4f dest) {
        return this.lookAtLH(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z, dest);
    }

    public Matrix4f lookAtLH(Vector3f eye, Vector3f center, Vector3f up) {
        return this.lookAtLH(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z, this);
    }

    public Matrix4f lookAtLH(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.setLookAtLH(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
        }
        if ((this.properties & 1) != 0) {
            return this.lookAtPerspectiveLH(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ, dest);
        }
        return this.lookAtLHGeneric(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ, dest);
    }

    private Matrix4f lookAtLHGeneric(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ, Matrix4f dest) {
        float dirX = centerX - eyeX;
        float dirY = centerY - eyeY;
        float dirZ = centerZ - eyeZ;
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float leftX = upY * (dirZ *= invDirLength) - upZ * (dirY *= invDirLength);
        float leftY = upZ * (dirX *= invDirLength) - upX * dirZ;
        float leftZ = upX * dirY - upY * dirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = dirY * (leftZ *= invLeftLength) - dirZ * (leftY *= invLeftLength);
        float upnY = dirZ * (leftX *= invLeftLength) - dirX * leftZ;
        float upnZ = dirX * leftY - dirY * leftX;
        float rm00 = leftX;
        float rm01 = upnX;
        float rm02 = dirX;
        float rm10 = leftY;
        float rm11 = upnY;
        float rm12 = dirY;
        float rm20 = leftZ;
        float rm21 = upnZ;
        float rm22 = dirZ;
        float rm30 = -(leftX * eyeX + leftY * eyeY + leftZ * eyeZ);
        float rm31 = -(upnX * eyeX + upnY * eyeY + upnZ * eyeZ);
        float rm32 = -(dirX * eyeX + dirY * eyeY + dirZ * eyeZ);
        dest.m30 = this.m00 * rm30 + this.m10 * rm31 + this.m20 * rm32 + this.m30;
        dest.m31 = this.m01 * rm30 + this.m11 * rm31 + this.m21 * rm32 + this.m31;
        dest.m32 = this.m02 * rm30 + this.m12 * rm31 + this.m22 * rm32 + this.m32;
        dest.m33 = this.m03 * rm30 + this.m13 * rm31 + this.m23 * rm32 + this.m33;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f lookAtLH(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        return this.lookAtLH(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ, this);
    }

    public Matrix4f lookAtPerspectiveLH(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ, Matrix4f dest) {
        float dirX = centerX - eyeX;
        float dirY = centerY - eyeY;
        float dirZ = centerZ - eyeZ;
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float leftX = upY * (dirZ *= invDirLength) - upZ * (dirY *= invDirLength);
        float leftY = upZ * (dirX *= invDirLength) - upX * dirZ;
        float leftZ = upX * dirY - upY * dirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = dirY * (leftZ *= invLeftLength) - dirZ * (leftY *= invLeftLength);
        float upnY = dirZ * (leftX *= invLeftLength) - dirX * leftZ;
        float upnZ = dirX * leftY - dirY * leftX;
        float rm00 = leftX;
        float rm01 = upnX;
        float rm02 = dirX;
        float rm10 = leftY;
        float rm11 = upnY;
        float rm12 = dirY;
        float rm20 = leftZ;
        float rm21 = upnZ;
        float rm22 = dirZ;
        float rm30 = -(leftX * eyeX + leftY * eyeY + leftZ * eyeZ);
        float rm31 = -(upnX * eyeX + upnY * eyeY + upnZ * eyeZ);
        float rm32 = -(dirX * eyeX + dirY * eyeY + dirZ * eyeZ);
        float nm00 = this.m00 * rm00;
        float nm01 = this.m11 * rm01;
        float nm02 = this.m22 * rm02;
        float nm03 = this.m23 * rm02;
        float nm10 = this.m00 * rm10;
        float nm11 = this.m11 * rm11;
        float nm12 = this.m22 * rm12;
        float nm13 = this.m23 * rm12;
        float nm20 = this.m00 * rm20;
        float nm21 = this.m11 * rm21;
        float nm22 = this.m22 * rm22;
        float nm23 = this.m23 * rm22;
        float nm30 = this.m00 * rm30;
        float nm31 = this.m11 * rm31;
        float nm32 = this.m22 * rm32 + this.m32;
        float nm33 = this.m23 * rm32;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f perspective(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.setPerspective(fovy, aspect, zNear, zFar, zZeroToOne);
        }
        return this.perspectiveGeneric(fovy, aspect, zNear, zFar, zZeroToOne, dest);
    }

    private Matrix4f perspectiveGeneric(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        float rm32;
        float rm22;
        float e;
        boolean nearInf;
        float h = (float)Math.tan(fovy * 0.5f);
        float rm00 = 1.0f / (h * aspect);
        float rm11 = 1.0f / h;
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            e = 1.0E-6f;
            rm22 = e - 1.0f;
            rm32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            e = 1.0E-6f;
            rm22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            rm32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            rm22 = (zZeroToOne ? zFar : zFar + zNear) / (zNear - zFar);
            rm32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        float nm20 = this.m20 * rm22 - this.m30;
        float nm21 = this.m21 * rm22 - this.m31;
        float nm22 = this.m22 * rm22 - this.m32;
        float nm23 = this.m23 * rm22 - this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m30 = this.m20 * rm32;
        dest.m31 = this.m21 * rm32;
        dest.m32 = this.m22 * rm32;
        dest.m33 = this.m23 * rm32;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.properties = (byte)(this.properties & 0xFFFFFFF1);
        return dest;
    }

    public Matrix4f perspective(float fovy, float aspect, float zNear, float zFar, Matrix4f dest) {
        return this.perspective(fovy, aspect, zNear, zFar, false, dest);
    }

    public Matrix4f perspective(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne) {
        return this.perspective(fovy, aspect, zNear, zFar, zZeroToOne, this);
    }

    public Matrix4f perspective(float fovy, float aspect, float zNear, float zFar) {
        return this.perspective(fovy, aspect, zNear, zFar, this);
    }

    public Matrix4f setPerspective(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne) {
        boolean nearInf;
        MemUtil.INSTANCE.zero(this);
        float h = (float)Math.tan(fovy * 0.5f);
        this.m00 = 1.0f / (h * aspect);
        this.m11 = 1.0f / h;
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            float e = 1.0E-6f;
            this.m22 = e - 1.0f;
            this.m32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            float e = 1.0E-6f;
            this.m22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            this.m32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            this.m22 = (zZeroToOne ? zFar : zFar + zNear) / (zNear - zFar);
            this.m32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        this.m23 = -1.0f;
        this.properties = 1;
        return this;
    }

    public Matrix4f setPerspective(float fovy, float aspect, float zNear, float zFar) {
        return this.setPerspective(fovy, aspect, zNear, zFar, false);
    }

    public Matrix4f perspectiveLH(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.setPerspectiveLH(fovy, aspect, zNear, zFar, zZeroToOne);
        }
        return this.perspectiveLHGeneric(fovy, aspect, zNear, zFar, zZeroToOne, dest);
    }

    private Matrix4f perspectiveLHGeneric(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        float rm32;
        float rm22;
        float e;
        boolean nearInf;
        float h = (float)Math.tan(fovy * 0.5f);
        float rm00 = 1.0f / (h * aspect);
        float rm11 = 1.0f / h;
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            e = 1.0E-6f;
            rm22 = 1.0f - e;
            rm32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            e = 1.0E-6f;
            rm22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            rm32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            rm22 = (zZeroToOne ? zFar : zFar + zNear) / (zFar - zNear);
            rm32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        float nm20 = this.m20 * rm22 + this.m30;
        float nm21 = this.m21 * rm22 + this.m31;
        float nm22 = this.m22 * rm22 + this.m32;
        float nm23 = this.m23 * rm22 + this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m30 = this.m20 * rm32;
        dest.m31 = this.m21 * rm32;
        dest.m32 = this.m22 * rm32;
        dest.m33 = this.m23 * rm32;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.properties = (byte)(this.properties & 0xFFFFFFF1);
        return dest;
    }

    public Matrix4f perspectiveLH(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne) {
        return this.perspectiveLH(fovy, aspect, zNear, zFar, zZeroToOne, this);
    }

    public Matrix4f perspectiveLH(float fovy, float aspect, float zNear, float zFar, Matrix4f dest) {
        return this.perspectiveLH(fovy, aspect, zNear, zFar, false, dest);
    }

    public Matrix4f perspectiveLH(float fovy, float aspect, float zNear, float zFar) {
        return this.perspectiveLH(fovy, aspect, zNear, zFar, this);
    }

    public Matrix4f setPerspectiveLH(float fovy, float aspect, float zNear, float zFar, boolean zZeroToOne) {
        boolean nearInf;
        MemUtil.INSTANCE.zero(this);
        float h = (float)Math.tan(fovy * 0.5f);
        this.m00 = 1.0f / (h * aspect);
        this.m11 = 1.0f / h;
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            float e = 1.0E-6f;
            this.m22 = 1.0f - e;
            this.m32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            float e = 1.0E-6f;
            this.m22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            this.m32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            this.m22 = (zZeroToOne ? zFar : zFar + zNear) / (zFar - zNear);
            this.m32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        this.m23 = 1.0f;
        this.properties = 1;
        return this;
    }

    public Matrix4f setPerspectiveLH(float fovy, float aspect, float zNear, float zFar) {
        return this.setPerspectiveLH(fovy, aspect, zNear, zFar, false);
    }

    public Matrix4f frustum(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        float rm32;
        float rm22;
        float e;
        boolean nearInf;
        float rm00 = (zNear + zNear) / (right - left);
        float rm11 = (zNear + zNear) / (top - bottom);
        float rm20 = (right + left) / (right - left);
        float rm21 = (top + bottom) / (top - bottom);
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            e = 1.0E-6f;
            rm22 = e - 1.0f;
            rm32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            e = 1.0E-6f;
            rm22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            rm32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            rm22 = (zZeroToOne ? zFar : zFar + zNear) / (zNear - zFar);
            rm32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        float nm20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22 - this.m30;
        float nm21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22 - this.m31;
        float nm22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22 - this.m32;
        float nm23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22 - this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m30 = this.m20 * rm32;
        dest.m31 = this.m21 * rm32;
        dest.m32 = this.m22 * rm32;
        dest.m33 = this.m23 * rm32;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f frustum(float left, float right, float bottom, float top, float zNear, float zFar, Matrix4f dest) {
        return this.frustum(left, right, bottom, top, zNear, zFar, false, dest);
    }

    public Matrix4f frustum(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        return this.frustum(left, right, bottom, top, zNear, zFar, zZeroToOne, this);
    }

    public Matrix4f frustum(float left, float right, float bottom, float top, float zNear, float zFar) {
        return this.frustum(left, right, bottom, top, zNear, zFar, this);
    }

    public Matrix4f setFrustum(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        boolean nearInf;
        MemUtil.INSTANCE.zero(this);
        this.m00 = (zNear + zNear) / (right - left);
        this.m11 = (zNear + zNear) / (top - bottom);
        this.m20 = (right + left) / (right - left);
        this.m21 = (top + bottom) / (top - bottom);
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            float e = 1.0E-6f;
            this.m22 = e - 1.0f;
            this.m32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            float e = 1.0E-6f;
            this.m22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            this.m32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            this.m22 = (zZeroToOne ? zFar : zFar + zNear) / (zNear - zFar);
            this.m32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        this.m23 = -1.0f;
        this.properties = 0;
        return this;
    }

    public Matrix4f setFrustum(float left, float right, float bottom, float top, float zNear, float zFar) {
        return this.setFrustum(left, right, bottom, top, zNear, zFar, false);
    }

    public Matrix4f frustumLH(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne, Matrix4f dest) {
        float rm32;
        float rm22;
        float e;
        boolean nearInf;
        float rm00 = (zNear + zNear) / (right - left);
        float rm11 = (zNear + zNear) / (top - bottom);
        float rm20 = (right + left) / (right - left);
        float rm21 = (top + bottom) / (top - bottom);
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            e = 1.0E-6f;
            rm22 = 1.0f - e;
            rm32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            e = 1.0E-6f;
            rm22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            rm32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            rm22 = (zZeroToOne ? zFar : zFar + zNear) / (zFar - zNear);
            rm32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        float nm20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22 + this.m30;
        float nm21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22 + this.m31;
        float nm22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22 + this.m32;
        float nm23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22 + this.m33;
        dest.m00 = this.m00 * rm00;
        dest.m01 = this.m01 * rm00;
        dest.m02 = this.m02 * rm00;
        dest.m03 = this.m03 * rm00;
        dest.m10 = this.m10 * rm11;
        dest.m11 = this.m11 * rm11;
        dest.m12 = this.m12 * rm11;
        dest.m13 = this.m13 * rm11;
        dest.m30 = this.m20 * rm32;
        dest.m31 = this.m21 * rm32;
        dest.m32 = this.m22 * rm32;
        dest.m33 = this.m23 * rm32;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        this.properties = 0;
        return dest;
    }

    public Matrix4f frustumLH(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        return this.frustumLH(left, right, bottom, top, zNear, zFar, zZeroToOne, this);
    }

    public Matrix4f frustumLH(float left, float right, float bottom, float top, float zNear, float zFar, Matrix4f dest) {
        return this.frustumLH(left, right, bottom, top, zNear, zFar, false, dest);
    }

    public Matrix4f frustumLH(float left, float right, float bottom, float top, float zNear, float zFar) {
        return this.frustumLH(left, right, bottom, top, zNear, zFar, this);
    }

    public Matrix4f setFrustumLH(float left, float right, float bottom, float top, float zNear, float zFar, boolean zZeroToOne) {
        boolean nearInf;
        MemUtil.INSTANCE.zero(this);
        this.m00 = (zNear + zNear) / (right - left);
        this.m11 = (zNear + zNear) / (top - bottom);
        this.m20 = (right + left) / (right - left);
        this.m21 = (top + bottom) / (top - bottom);
        boolean farInf = zFar > 0.0f && Float.isInfinite(zFar);
        boolean bl = nearInf = zNear > 0.0f && Float.isInfinite(zNear);
        if (farInf) {
            float e = 1.0E-6f;
            this.m22 = 1.0f - e;
            this.m32 = (e - (zZeroToOne ? 1.0f : 2.0f)) * zNear;
        } else if (nearInf) {
            float e = 1.0E-6f;
            this.m22 = (zZeroToOne ? 0.0f : 1.0f) - e;
            this.m32 = ((zZeroToOne ? 1.0f : 2.0f) - e) * zFar;
        } else {
            this.m22 = (zZeroToOne ? zFar : zFar + zNear) / (zFar - zNear);
            this.m32 = (zZeroToOne ? zFar : zFar + zFar) * zNear / (zNear - zFar);
        }
        this.m23 = 1.0f;
        this.properties = 0;
        return this;
    }

    public Matrix4f setFrustumLH(float left, float right, float bottom, float top, float zNear, float zFar) {
        return this.setFrustumLH(left, right, bottom, top, zNear, zFar, false);
    }

    public Matrix4f rotate(Quaternionf quat, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.rotation(quat);
        }
        if ((this.properties & 8) != 0) {
            return this.rotateTranslation(quat, dest);
        }
        if ((this.properties & 2) != 0) {
            return this.rotateAffine(quat, dest);
        }
        return this.rotateGeneric(quat, dest);
    }

    private Matrix4f rotateGeneric(Quaternionf quat, Matrix4f dest) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        float rm00 = 1.0f - q11 - q22;
        float rm01 = q01 + q23;
        float rm02 = q02 - q13;
        float rm10 = q01 - q23;
        float rm11 = 1.0f - q22 - q00;
        float rm12 = q12 + q03;
        float rm20 = q02 + q13;
        float rm21 = q12 - q03;
        float rm22 = 1.0f - q11 - q00;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotate(Quaternionf quat) {
        return this.rotate(quat, this);
    }

    public Matrix4f rotateAffine(Quaternionf quat, Matrix4f dest) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        float rm00 = 1.0f - q11 - q22;
        float rm01 = q01 + q23;
        float rm02 = q02 - q13;
        float rm10 = q01 - q23;
        float rm11 = 1.0f - q22 - q00;
        float rm12 = q12 + q03;
        float rm20 = q02 + q13;
        float rm21 = q12 - q03;
        float rm22 = 1.0f - q11 - q00;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = 0.0f;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = 0.0f;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = 0.0f;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateAffine(Quaternionf quat) {
        return this.rotateAffine(quat, this);
    }

    public Matrix4f rotateTranslation(Quaternionf quat, Matrix4f dest) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        float rm00 = 1.0f - q11 - q22;
        float rm01 = q01 + q23;
        float rm02 = q02 - q13;
        float rm10 = q01 - q23;
        float rm11 = 1.0f - q22 - q00;
        float rm12 = q12 + q03;
        float rm20 = q02 + q13;
        float rm21 = q12 - q03;
        float rm22 = 1.0f - q11 - q00;
        float nm00 = rm00;
        float nm01 = rm01;
        float nm02 = rm02;
        float nm10 = rm10;
        float nm11 = rm11;
        float nm12 = rm12;
        dest.m20 = rm20;
        dest.m21 = rm21;
        dest.m22 = rm22;
        dest.m23 = 0.0f;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = 0.0f;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = 0.0f;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateAround(Quaternionf quat, float ox, float oy, float oz) {
        return this.rotateAround(quat, ox, oy, oz, this);
    }

    public Matrix4f rotateAround(Quaternionf quat, float ox, float oy, float oz, Matrix4f dest) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        float rm00 = 1.0f - q11 - q22;
        float rm01 = q01 + q23;
        float rm02 = q02 - q13;
        float rm10 = q01 - q23;
        float rm11 = 1.0f - q22 - q00;
        float rm12 = q12 + q03;
        float rm20 = q02 + q13;
        float rm21 = q12 - q03;
        float rm22 = 1.0f - q11 - q00;
        float tm30 = this.m00 * ox + this.m10 * oy + this.m20 * oz + this.m30;
        float tm31 = this.m01 * ox + this.m11 * oy + this.m21 * oz + this.m31;
        float tm32 = this.m02 * ox + this.m12 * oy + this.m22 * oz + this.m32;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m30 = -nm00 * ox - nm10 * oy - this.m20 * oz + tm30;
        dest.m31 = -nm01 * ox - nm11 * oy - this.m21 * oz + tm31;
        dest.m32 = -nm02 * ox - nm12 * oy - this.m22 * oz + tm32;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateLocal(Quaternionf quat, Matrix4f dest) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        float lm00 = 1.0f - q11 - q22;
        float lm01 = q01 + q23;
        float lm02 = q02 - q13;
        float lm10 = q01 - q23;
        float lm11 = 1.0f - q22 - q00;
        float lm12 = q12 + q03;
        float lm20 = q02 + q13;
        float lm21 = q12 - q03;
        float lm22 = 1.0f - q11 - q00;
        float nm00 = lm00 * this.m00 + lm10 * this.m01 + lm20 * this.m02;
        float nm01 = lm01 * this.m00 + lm11 * this.m01 + lm21 * this.m02;
        float nm02 = lm02 * this.m00 + lm12 * this.m01 + lm22 * this.m02;
        float nm03 = this.m03;
        float nm10 = lm00 * this.m10 + lm10 * this.m11 + lm20 * this.m12;
        float nm11 = lm01 * this.m10 + lm11 * this.m11 + lm21 * this.m12;
        float nm12 = lm02 * this.m10 + lm12 * this.m11 + lm22 * this.m12;
        float nm13 = this.m13;
        float nm20 = lm00 * this.m20 + lm10 * this.m21 + lm20 * this.m22;
        float nm21 = lm01 * this.m20 + lm11 * this.m21 + lm21 * this.m22;
        float nm22 = lm02 * this.m20 + lm12 * this.m21 + lm22 * this.m22;
        float nm23 = this.m23;
        float nm30 = lm00 * this.m30 + lm10 * this.m31 + lm20 * this.m32;
        float nm31 = lm01 * this.m30 + lm11 * this.m31 + lm21 * this.m32;
        float nm32 = lm02 * this.m30 + lm12 * this.m31 + lm22 * this.m32;
        float nm33 = this.m33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m30 = nm30;
        dest.m31 = nm31;
        dest.m32 = nm32;
        dest.m33 = nm33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateLocal(Quaternionf quat) {
        return this.rotateLocal(quat, this);
    }

    public Matrix4f rotateAroundLocal(Quaternionf quat, float ox, float oy, float oz, Matrix4f dest) {
        float dqx = quat.x + quat.x;
        float dqy = quat.y + quat.y;
        float dqz = quat.z + quat.z;
        float q00 = dqx * quat.x;
        float q11 = dqy * quat.y;
        float q22 = dqz * quat.z;
        float q01 = dqx * quat.y;
        float q02 = dqx * quat.z;
        float q03 = dqx * quat.w;
        float q12 = dqy * quat.z;
        float q13 = dqy * quat.w;
        float q23 = dqz * quat.w;
        float lm00 = 1.0f - q11 - q22;
        float lm01 = q01 + q23;
        float lm02 = q02 - q13;
        float lm10 = q01 - q23;
        float lm11 = 1.0f - q22 - q00;
        float lm12 = q12 + q03;
        float lm20 = q02 + q13;
        float lm21 = q12 - q03;
        float lm22 = 1.0f - q11 - q00;
        float tm00 = this.m00 - ox * this.m03;
        float tm01 = this.m01 - oy * this.m03;
        float tm02 = this.m02 - oz * this.m03;
        float tm10 = this.m10 - ox * this.m13;
        float tm11 = this.m11 - oy * this.m13;
        float tm12 = this.m12 - oz * this.m13;
        float tm20 = this.m20 - ox * this.m23;
        float tm21 = this.m21 - oy * this.m23;
        float tm22 = this.m22 - oz * this.m23;
        float tm30 = this.m30 - ox * this.m33;
        float tm31 = this.m31 - oy * this.m33;
        float tm32 = this.m32 - oz * this.m33;
        dest.m00 = lm00 * tm00 + lm10 * tm01 + lm20 * tm02 + ox * this.m03;
        dest.m01 = lm01 * tm00 + lm11 * tm01 + lm21 * tm02 + oy * this.m03;
        dest.m02 = lm02 * tm00 + lm12 * tm01 + lm22 * tm02 + oz * this.m03;
        dest.m03 = this.m03;
        dest.m10 = lm00 * tm10 + lm10 * tm11 + lm20 * tm12 + ox * this.m13;
        dest.m11 = lm01 * tm10 + lm11 * tm11 + lm21 * tm12 + oy * this.m13;
        dest.m12 = lm02 * tm10 + lm12 * tm11 + lm22 * tm12 + oz * this.m13;
        dest.m13 = this.m13;
        dest.m20 = lm00 * tm20 + lm10 * tm21 + lm20 * tm22 + ox * this.m23;
        dest.m21 = lm01 * tm20 + lm11 * tm21 + lm21 * tm22 + oy * this.m23;
        dest.m22 = lm02 * tm20 + lm12 * tm21 + lm22 * tm22 + oz * this.m23;
        dest.m23 = this.m23;
        dest.m30 = lm00 * tm30 + lm10 * tm31 + lm20 * tm32 + ox * this.m33;
        dest.m31 = lm01 * tm30 + lm11 * tm31 + lm21 * tm32 + oy * this.m33;
        dest.m32 = lm02 * tm30 + lm12 * tm31 + lm22 * tm32 + oz * this.m33;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotateAroundLocal(Quaternionf quat, float ox, float oy, float oz) {
        return this.rotateAroundLocal(quat, ox, oy, oz, this);
    }

    public Matrix4f rotate(AxisAngle4f axisAngle) {
        return this.rotate(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Matrix4f rotate(AxisAngle4f axisAngle, Matrix4f dest) {
        return this.rotate(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z, dest);
    }

    public Matrix4f rotate(float angle, Vector3f axis) {
        return this.rotate(angle, axis.x, axis.y, axis.z);
    }

    public Matrix4f rotate(float angle, Vector3f axis, Matrix4f dest) {
        return this.rotate(angle, axis.x, axis.y, axis.z, dest);
    }

    public Vector4f unproject(float winX, float winY, float winZ, int[] viewport, Vector4f dest) {
        float a = this.m00 * this.m11 - this.m01 * this.m10;
        float b = this.m00 * this.m12 - this.m02 * this.m10;
        float c = this.m00 * this.m13 - this.m03 * this.m10;
        float d = this.m01 * this.m12 - this.m02 * this.m11;
        float e = this.m01 * this.m13 - this.m03 * this.m11;
        float f = this.m02 * this.m13 - this.m03 * this.m12;
        float g = this.m20 * this.m31 - this.m21 * this.m30;
        float h = this.m20 * this.m32 - this.m22 * this.m30;
        float i = this.m20 * this.m33 - this.m23 * this.m30;
        float j = this.m21 * this.m32 - this.m22 * this.m31;
        float k = this.m21 * this.m33 - this.m23 * this.m31;
        float l = this.m22 * this.m33 - this.m23 * this.m32;
        float det = a * l - b * k + c * j + d * i - e * h + f * g;
        det = 1.0f / det;
        float im00 = (this.m11 * l - this.m12 * k + this.m13 * j) * det;
        float im01 = (-this.m01 * l + this.m02 * k - this.m03 * j) * det;
        float im02 = (this.m31 * f - this.m32 * e + this.m33 * d) * det;
        float im03 = (-this.m21 * f + this.m22 * e - this.m23 * d) * det;
        float im10 = (-this.m10 * l + this.m12 * i - this.m13 * h) * det;
        float im11 = (this.m00 * l - this.m02 * i + this.m03 * h) * det;
        float im12 = (-this.m30 * f + this.m32 * c - this.m33 * b) * det;
        float im13 = (this.m20 * f - this.m22 * c + this.m23 * b) * det;
        float im20 = (this.m10 * k - this.m11 * i + this.m13 * g) * det;
        float im21 = (-this.m00 * k + this.m01 * i - this.m03 * g) * det;
        float im22 = (this.m30 * e - this.m31 * c + this.m33 * a) * det;
        float im23 = (-this.m20 * e + this.m21 * c - this.m23 * a) * det;
        float im30 = (-this.m10 * j + this.m11 * h - this.m12 * g) * det;
        float im31 = (this.m00 * j - this.m01 * h + this.m02 * g) * det;
        float im32 = (-this.m30 * d + this.m31 * b - this.m32 * a) * det;
        float im33 = (this.m20 * d - this.m21 * b + this.m22 * a) * det;
        float ndcX = (winX - (float)viewport[0]) / (float)viewport[2] * 2.0f - 1.0f;
        float ndcY = (winY - (float)viewport[1]) / (float)viewport[3] * 2.0f - 1.0f;
        float ndcZ = winZ + winZ - 1.0f;
        dest.x = im00 * ndcX + im10 * ndcY + im20 * ndcZ + im30;
        dest.y = im01 * ndcX + im11 * ndcY + im21 * ndcZ + im31;
        dest.z = im02 * ndcX + im12 * ndcY + im22 * ndcZ + im32;
        dest.w = im03 * ndcX + im13 * ndcY + im23 * ndcZ + im33;
        dest.div(dest.w);
        return dest;
    }

    public Vector3f unproject(float winX, float winY, float winZ, int[] viewport, Vector3f dest) {
        float a = this.m00 * this.m11 - this.m01 * this.m10;
        float b = this.m00 * this.m12 - this.m02 * this.m10;
        float c = this.m00 * this.m13 - this.m03 * this.m10;
        float d = this.m01 * this.m12 - this.m02 * this.m11;
        float e = this.m01 * this.m13 - this.m03 * this.m11;
        float f = this.m02 * this.m13 - this.m03 * this.m12;
        float g = this.m20 * this.m31 - this.m21 * this.m30;
        float h = this.m20 * this.m32 - this.m22 * this.m30;
        float i = this.m20 * this.m33 - this.m23 * this.m30;
        float j = this.m21 * this.m32 - this.m22 * this.m31;
        float k = this.m21 * this.m33 - this.m23 * this.m31;
        float l = this.m22 * this.m33 - this.m23 * this.m32;
        float det = a * l - b * k + c * j + d * i - e * h + f * g;
        det = 1.0f / det;
        float im00 = (this.m11 * l - this.m12 * k + this.m13 * j) * det;
        float im01 = (-this.m01 * l + this.m02 * k - this.m03 * j) * det;
        float im02 = (this.m31 * f - this.m32 * e + this.m33 * d) * det;
        float im03 = (-this.m21 * f + this.m22 * e - this.m23 * d) * det;
        float im10 = (-this.m10 * l + this.m12 * i - this.m13 * h) * det;
        float im11 = (this.m00 * l - this.m02 * i + this.m03 * h) * det;
        float im12 = (-this.m30 * f + this.m32 * c - this.m33 * b) * det;
        float im13 = (this.m20 * f - this.m22 * c + this.m23 * b) * det;
        float im20 = (this.m10 * k - this.m11 * i + this.m13 * g) * det;
        float im21 = (-this.m00 * k + this.m01 * i - this.m03 * g) * det;
        float im22 = (this.m30 * e - this.m31 * c + this.m33 * a) * det;
        float im23 = (-this.m20 * e + this.m21 * c - this.m23 * a) * det;
        float im30 = (-this.m10 * j + this.m11 * h - this.m12 * g) * det;
        float im31 = (this.m00 * j - this.m01 * h + this.m02 * g) * det;
        float im32 = (-this.m30 * d + this.m31 * b - this.m32 * a) * det;
        float im33 = (this.m20 * d - this.m21 * b + this.m22 * a) * det;
        float ndcX = (winX - (float)viewport[0]) / (float)viewport[2] * 2.0f - 1.0f;
        float ndcY = (winY - (float)viewport[1]) / (float)viewport[3] * 2.0f - 1.0f;
        float ndcZ = winZ + winZ - 1.0f;
        dest.x = im00 * ndcX + im10 * ndcY + im20 * ndcZ + im30;
        dest.y = im01 * ndcX + im11 * ndcY + im21 * ndcZ + im31;
        dest.z = im02 * ndcX + im12 * ndcY + im22 * ndcZ + im32;
        float w = im03 * ndcX + im13 * ndcY + im23 * ndcZ + im33;
        dest.div(w);
        return dest;
    }

    public Vector4f unproject(Vector3f winCoords, int[] viewport, Vector4f dest) {
        return this.unproject(winCoords.x, winCoords.y, winCoords.z, viewport, dest);
    }

    public Vector3f unproject(Vector3f winCoords, int[] viewport, Vector3f dest) {
        return this.unproject(winCoords.x, winCoords.y, winCoords.z, viewport, dest);
    }

    public Matrix4f unprojectRay(float winX, float winY, int[] viewport, Vector3f originDest, Vector3f dirDest) {
        float a = this.m00 * this.m11 - this.m01 * this.m10;
        float b = this.m00 * this.m12 - this.m02 * this.m10;
        float c = this.m00 * this.m13 - this.m03 * this.m10;
        float d = this.m01 * this.m12 - this.m02 * this.m11;
        float e = this.m01 * this.m13 - this.m03 * this.m11;
        float f = this.m02 * this.m13 - this.m03 * this.m12;
        float g = this.m20 * this.m31 - this.m21 * this.m30;
        float h = this.m20 * this.m32 - this.m22 * this.m30;
        float i = this.m20 * this.m33 - this.m23 * this.m30;
        float j = this.m21 * this.m32 - this.m22 * this.m31;
        float k = this.m21 * this.m33 - this.m23 * this.m31;
        float l = this.m22 * this.m33 - this.m23 * this.m32;
        float det = a * l - b * k + c * j + d * i - e * h + f * g;
        det = 1.0f / det;
        float im00 = (this.m11 * l - this.m12 * k + this.m13 * j) * det;
        float im01 = (-this.m01 * l + this.m02 * k - this.m03 * j) * det;
        float im02 = (this.m31 * f - this.m32 * e + this.m33 * d) * det;
        float im03 = (-this.m21 * f + this.m22 * e - this.m23 * d) * det;
        float im10 = (-this.m10 * l + this.m12 * i - this.m13 * h) * det;
        float im11 = (this.m00 * l - this.m02 * i + this.m03 * h) * det;
        float im12 = (-this.m30 * f + this.m32 * c - this.m33 * b) * det;
        float im13 = (this.m20 * f - this.m22 * c + this.m23 * b) * det;
        float im20 = (this.m10 * k - this.m11 * i + this.m13 * g) * det;
        float im21 = (-this.m00 * k + this.m01 * i - this.m03 * g) * det;
        float im22 = (this.m30 * e - this.m31 * c + this.m33 * a) * det;
        float im23 = (-this.m20 * e + this.m21 * c - this.m23 * a) * det;
        float im30 = (-this.m10 * j + this.m11 * h - this.m12 * g) * det;
        float im31 = (this.m00 * j - this.m01 * h + this.m02 * g) * det;
        float im32 = (-this.m30 * d + this.m31 * b - this.m32 * a) * det;
        float im33 = (this.m20 * d - this.m21 * b + this.m22 * a) * det;
        float ndcX = (winX - (float)viewport[0]) / (float)viewport[2] * 2.0f - 1.0f;
        float ndcY = (winY - (float)viewport[1]) / (float)viewport[3] * 2.0f - 1.0f;
        float nearX = im00 * ndcX + im10 * ndcY - im20 + im30;
        float nearY = im01 * ndcX + im11 * ndcY - im21 + im31;
        float nearZ = im02 * ndcX + im12 * ndcY - im22 + im32;
        float invNearW = 1.0f / (im03 * ndcX + im13 * ndcY - im23 + im33);
        nearX *= invNearW;
        nearY *= invNearW;
        nearZ *= invNearW;
        float farX = im00 * ndcX + im10 * ndcY + im20 + im30;
        float farY = im01 * ndcX + im11 * ndcY + im21 + im31;
        float farZ = im02 * ndcX + im12 * ndcY + im22 + im32;
        float invFarW = 1.0f / (im03 * ndcX + im13 * ndcY + im23 + im33);
        farX *= invFarW;
        farY *= invFarW;
        farZ *= invFarW;
        originDest.x = nearX;
        originDest.y = nearY;
        originDest.z = nearZ;
        dirDest.x = farX - nearX;
        dirDest.y = farY - nearY;
        dirDest.z = farZ - nearZ;
        return this;
    }

    public Matrix4f unprojectRay(Vector2f winCoords, int[] viewport, Vector3f originDest, Vector3f dirDest) {
        return this.unprojectRay(winCoords.x, winCoords.y, viewport, originDest, dirDest);
    }

    public Vector4f unprojectInv(Vector3f winCoords, int[] viewport, Vector4f dest) {
        return this.unprojectInv(winCoords.x, winCoords.y, winCoords.z, viewport, dest);
    }

    public Vector4f unprojectInv(float winX, float winY, float winZ, int[] viewport, Vector4f dest) {
        float ndcX = (winX - (float)viewport[0]) / (float)viewport[2] * 2.0f - 1.0f;
        float ndcY = (winY - (float)viewport[1]) / (float)viewport[3] * 2.0f - 1.0f;
        float ndcZ = winZ + winZ - 1.0f;
        dest.x = this.m00 * ndcX + this.m10 * ndcY + this.m20 * ndcZ + this.m30;
        dest.y = this.m01 * ndcX + this.m11 * ndcY + this.m21 * ndcZ + this.m31;
        dest.z = this.m02 * ndcX + this.m12 * ndcY + this.m22 * ndcZ + this.m32;
        dest.w = this.m03 * ndcX + this.m13 * ndcY + this.m23 * ndcZ + this.m33;
        dest.div(dest.w);
        return dest;
    }

    public Matrix4f unprojectInvRay(Vector2f winCoords, int[] viewport, Vector3f originDest, Vector3f dirDest) {
        return this.unprojectInvRay(winCoords.x, winCoords.y, viewport, originDest, dirDest);
    }

    public Matrix4f unprojectInvRay(float winX, float winY, int[] viewport, Vector3f originDest, Vector3f dirDest) {
        float ndcX = (winX - (float)viewport[0]) / (float)viewport[2] * 2.0f - 1.0f;
        float ndcY = (winY - (float)viewport[1]) / (float)viewport[3] * 2.0f - 1.0f;
        float nearX = this.m00 * ndcX + this.m10 * ndcY - this.m20 + this.m30;
        float nearY = this.m01 * ndcX + this.m11 * ndcY - this.m21 + this.m31;
        float nearZ = this.m02 * ndcX + this.m12 * ndcY - this.m22 + this.m32;
        float invNearW = 1.0f / (this.m03 * ndcX + this.m13 * ndcY - this.m23 + this.m33);
        nearX *= invNearW;
        nearY *= invNearW;
        nearZ *= invNearW;
        float farX = this.m00 * ndcX + this.m10 * ndcY + this.m20 + this.m30;
        float farY = this.m01 * ndcX + this.m11 * ndcY + this.m21 + this.m31;
        float farZ = this.m02 * ndcX + this.m12 * ndcY + this.m22 + this.m32;
        float invFarW = 1.0f / (this.m03 * ndcX + this.m13 * ndcY + this.m23 + this.m33);
        farX *= invFarW;
        farY *= invFarW;
        farZ *= invFarW;
        originDest.x = nearX;
        originDest.y = nearY;
        originDest.z = nearZ;
        dirDest.x = farX - nearX;
        dirDest.y = farY - nearY;
        dirDest.z = farZ - nearZ;
        return this;
    }

    public Vector3f unprojectInv(Vector3f winCoords, int[] viewport, Vector3f dest) {
        return this.unprojectInv(winCoords.x, winCoords.y, winCoords.z, viewport, dest);
    }

    public Vector3f unprojectInv(float winX, float winY, float winZ, int[] viewport, Vector3f dest) {
        float ndcX = (winX - (float)viewport[0]) / (float)viewport[2] * 2.0f - 1.0f;
        float ndcY = (winY - (float)viewport[1]) / (float)viewport[3] * 2.0f - 1.0f;
        float ndcZ = winZ + winZ - 1.0f;
        dest.x = this.m00 * ndcX + this.m10 * ndcY + this.m20 * ndcZ + this.m30;
        dest.y = this.m01 * ndcX + this.m11 * ndcY + this.m21 * ndcZ + this.m31;
        dest.z = this.m02 * ndcX + this.m12 * ndcY + this.m22 * ndcZ + this.m32;
        float w = this.m03 * ndcX + this.m13 * ndcY + this.m23 * ndcZ + this.m33;
        dest.div(w);
        return dest;
    }

    public Vector4f project(float x, float y, float z, int[] viewport, Vector4f winCoordsDest) {
        winCoordsDest.x = this.m00 * x + this.m10 * y + this.m20 * z + this.m30;
        winCoordsDest.y = this.m01 * x + this.m11 * y + this.m21 * z + this.m31;
        winCoordsDest.z = this.m02 * x + this.m12 * y + this.m22 * z + this.m32;
        winCoordsDest.w = this.m03 * x + this.m13 * y + this.m23 * z + this.m33;
        winCoordsDest.div(winCoordsDest.w);
        winCoordsDest.x = (winCoordsDest.x * 0.5f + 0.5f) * (float)viewport[2] + (float)viewport[0];
        winCoordsDest.y = (winCoordsDest.y * 0.5f + 0.5f) * (float)viewport[3] + (float)viewport[1];
        winCoordsDest.z = (1.0f + winCoordsDest.z) * 0.5f;
        return winCoordsDest;
    }

    public Vector3f project(float x, float y, float z, int[] viewport, Vector3f winCoordsDest) {
        winCoordsDest.x = this.m00 * x + this.m10 * y + this.m20 * z + this.m30;
        winCoordsDest.y = this.m01 * x + this.m11 * y + this.m21 * z + this.m31;
        winCoordsDest.z = this.m02 * x + this.m12 * y + this.m22 * z + this.m32;
        float w = this.m03 * x + this.m13 * y + this.m23 * z + this.m33;
        winCoordsDest.div(w);
        winCoordsDest.x = (winCoordsDest.x * 0.5f + 0.5f) * (float)viewport[2] + (float)viewport[0];
        winCoordsDest.y = (winCoordsDest.y * 0.5f + 0.5f) * (float)viewport[3] + (float)viewport[1];
        winCoordsDest.z = (1.0f + winCoordsDest.z) * 0.5f;
        return winCoordsDest;
    }

    public Vector4f project(Vector3f position, int[] viewport, Vector4f winCoordsDest) {
        return this.project(position.x, position.y, position.z, viewport, winCoordsDest);
    }

    public Vector3f project(Vector3f position, int[] viewport, Vector3f winCoordsDest) {
        return this.project(position.x, position.y, position.z, viewport, winCoordsDest);
    }

    public Matrix4f reflect(float a, float b, float c, float d, Matrix4f dest) {
        if ((this.properties & 4) != 0) {
            return dest.reflection(a, b, c, d);
        }
        float da = a + a;
        float db = b + b;
        float dc = c + c;
        float dd = d + d;
        float rm00 = 1.0f - da * a;
        float rm01 = -da * b;
        float rm02 = -da * c;
        float rm10 = -db * a;
        float rm11 = 1.0f - db * b;
        float rm12 = -db * c;
        float rm20 = -dc * a;
        float rm21 = -dc * b;
        float rm22 = 1.0f - dc * c;
        float rm30 = -dd * a;
        float rm31 = -dd * b;
        float rm32 = -dd * c;
        dest.m30 = this.m00 * rm30 + this.m10 * rm31 + this.m20 * rm32 + this.m30;
        dest.m31 = this.m01 * rm30 + this.m11 * rm31 + this.m21 * rm32 + this.m31;
        dest.m32 = this.m02 * rm30 + this.m12 * rm31 + this.m22 * rm32 + this.m32;
        dest.m33 = this.m03 * rm30 + this.m13 * rm31 + this.m23 * rm32 + this.m33;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f reflect(float a, float b, float c, float d) {
        return this.reflect(a, b, c, d, this);
    }

    public Matrix4f reflect(float nx, float ny, float nz, float px, float py, float pz) {
        return this.reflect(nx, ny, nz, px, py, pz, this);
    }

    public Matrix4f reflect(float nx, float ny, float nz, float px, float py, float pz, Matrix4f dest) {
        float invLength = 1.0f / (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        float nnx = nx * invLength;
        float nny = ny * invLength;
        float nnz = nz * invLength;
        return this.reflect(nnx, nny, nnz, -nnx * px - nny * py - nnz * pz, dest);
    }

    public Matrix4f reflect(Vector3f normal, Vector3f point) {
        return this.reflect(normal.x, normal.y, normal.z, point.x, point.y, point.z);
    }

    public Matrix4f reflect(Quaternionf orientation, Vector3f point) {
        return this.reflect(orientation, point, this);
    }

    public Matrix4f reflect(Quaternionf orientation, Vector3f point, Matrix4f dest) {
        double num1 = orientation.x + orientation.x;
        double num2 = orientation.y + orientation.y;
        double num3 = orientation.z + orientation.z;
        float normalX = (float)((double)orientation.x * num3 + (double)orientation.w * num2);
        float normalY = (float)((double)orientation.y * num3 - (double)orientation.w * num1);
        float normalZ = (float)(1.0 - ((double)orientation.x * num1 + (double)orientation.y * num2));
        return this.reflect(normalX, normalY, normalZ, point.x, point.y, point.z, dest);
    }

    public Matrix4f reflect(Vector3f normal, Vector3f point, Matrix4f dest) {
        return this.reflect(normal.x, normal.y, normal.z, point.x, point.y, point.z, dest);
    }

    public Matrix4f reflection(float a, float b, float c, float d) {
        float da = a + a;
        float db = b + b;
        float dc = c + c;
        float dd = d + d;
        this.m00 = 1.0f - da * a;
        this.m01 = -da * b;
        this.m02 = -da * c;
        this.m03 = 0.0f;
        this.m10 = -db * a;
        this.m11 = 1.0f - db * b;
        this.m12 = -db * c;
        this.m13 = 0.0f;
        this.m20 = -dc * a;
        this.m21 = -dc * b;
        this.m22 = 1.0f - dc * c;
        this.m23 = 0.0f;
        this.m30 = -dd * a;
        this.m31 = -dd * b;
        this.m32 = -dd * c;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f reflection(float nx, float ny, float nz, float px, float py, float pz) {
        float invLength = 1.0f / (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        float nnx = nx * invLength;
        float nny = ny * invLength;
        float nnz = nz * invLength;
        return this.reflection(nnx, nny, nnz, -nnx * px - nny * py - nnz * pz);
    }

    public Matrix4f reflection(Vector3f normal, Vector3f point) {
        return this.reflection(normal.x, normal.y, normal.z, point.x, point.y, point.z);
    }

    public Matrix4f reflection(Quaternionf orientation, Vector3f point) {
        double num1 = orientation.x + orientation.x;
        double num2 = orientation.y + orientation.y;
        double num3 = orientation.z + orientation.z;
        float normalX = (float)((double)orientation.x * num3 + (double)orientation.w * num2);
        float normalY = (float)((double)orientation.y * num3 - (double)orientation.w * num1);
        float normalZ = (float)(1.0 - ((double)orientation.x * num1 + (double)orientation.y * num2));
        return this.reflection(normalX, normalY, normalZ, point.x, point.y, point.z);
    }

    public Vector4f getRow(int row, Vector4f dest) throws IndexOutOfBoundsException {
        switch (row) {
            case 0: {
                dest.x = this.m00;
                dest.y = this.m10;
                dest.z = this.m20;
                dest.w = this.m30;
                break;
            }
            case 1: {
                dest.x = this.m01;
                dest.y = this.m11;
                dest.z = this.m21;
                dest.w = this.m31;
                break;
            }
            case 2: {
                dest.x = this.m02;
                dest.y = this.m12;
                dest.z = this.m22;
                dest.w = this.m32;
                break;
            }
            case 3: {
                dest.x = this.m03;
                dest.y = this.m13;
                dest.z = this.m23;
                dest.w = this.m33;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return dest;
    }

    public Vector4f getColumn(int column, Vector4f dest) throws IndexOutOfBoundsException {
        switch (column) {
            case 0: {
                MemUtil.INSTANCE.putColumn0(this, dest);
                break;
            }
            case 1: {
                MemUtil.INSTANCE.putColumn1(this, dest);
                break;
            }
            case 2: {
                MemUtil.INSTANCE.putColumn2(this, dest);
                break;
            }
            case 3: {
                MemUtil.INSTANCE.putColumn3(this, dest);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return dest;
    }

    public Matrix4f normal() {
        return this.normal(this);
    }

    public Matrix4f normal(Matrix4f dest) {
        float m00m11 = this.m00 * this.m11;
        float m01m10 = this.m01 * this.m10;
        float m02m10 = this.m02 * this.m10;
        float m00m12 = this.m00 * this.m12;
        float m01m12 = this.m01 * this.m12;
        float m02m11 = this.m02 * this.m11;
        float det = (m00m11 - m01m10) * this.m22 + (m02m10 - m00m12) * this.m21 + (m01m12 - m02m11) * this.m20;
        float s = 1.0f / det;
        float nm00 = (this.m11 * this.m22 - this.m21 * this.m12) * s;
        float nm01 = (this.m20 * this.m12 - this.m10 * this.m22) * s;
        float nm02 = (this.m10 * this.m21 - this.m20 * this.m11) * s;
        float nm10 = (this.m21 * this.m02 - this.m01 * this.m22) * s;
        float nm11 = (this.m00 * this.m22 - this.m20 * this.m02) * s;
        float nm12 = (this.m20 * this.m01 - this.m00 * this.m21) * s;
        float nm20 = (m01m12 - m02m11) * s;
        float nm21 = (m02m10 - m00m12) * s;
        float nm22 = (m00m11 - m01m10) * s;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = 0.0f;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = 0.0f;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = 0.0f;
        dest.m30 = 0.0f;
        dest.m31 = 0.0f;
        dest.m32 = 0.0f;
        dest.m33 = 1.0f;
        dest.properties = (byte)2;
        return dest;
    }

    public Matrix3f normal(Matrix3f dest) {
        float m00m11 = this.m00 * this.m11;
        float m01m10 = this.m01 * this.m10;
        float m02m10 = this.m02 * this.m10;
        float m00m12 = this.m00 * this.m12;
        float m01m12 = this.m01 * this.m12;
        float m02m11 = this.m02 * this.m11;
        float det = (m00m11 - m01m10) * this.m22 + (m02m10 - m00m12) * this.m21 + (m01m12 - m02m11) * this.m20;
        float s = 1.0f / det;
        dest.m00 = (this.m11 * this.m22 - this.m21 * this.m12) * s;
        dest.m01 = (this.m20 * this.m12 - this.m10 * this.m22) * s;
        dest.m02 = (this.m10 * this.m21 - this.m20 * this.m11) * s;
        dest.m10 = (this.m21 * this.m02 - this.m01 * this.m22) * s;
        dest.m11 = (this.m00 * this.m22 - this.m20 * this.m02) * s;
        dest.m12 = (this.m20 * this.m01 - this.m00 * this.m21) * s;
        dest.m20 = (m01m12 - m02m11) * s;
        dest.m21 = (m02m10 - m00m12) * s;
        dest.m22 = (m00m11 - m01m10) * s;
        return dest;
    }

    public Matrix4f normalize3x3() {
        return this.normalize3x3(this);
    }

    public Matrix4f normalize3x3(Matrix4f dest) {
        float invXlen = (float)(1.0 / Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02));
        float invYlen = (float)(1.0 / Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12));
        float invZlen = (float)(1.0 / Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22));
        dest.m00 = this.m00 * invXlen;
        dest.m01 = this.m01 * invXlen;
        dest.m02 = this.m02 * invXlen;
        dest.m10 = this.m10 * invYlen;
        dest.m11 = this.m11 * invYlen;
        dest.m12 = this.m12 * invYlen;
        dest.m20 = this.m20 * invZlen;
        dest.m21 = this.m21 * invZlen;
        dest.m22 = this.m22 * invZlen;
        dest.properties = this.properties;
        return dest;
    }

    public Matrix3f normalize3x3(Matrix3f dest) {
        float invXlen = (float)(1.0 / Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02));
        float invYlen = (float)(1.0 / Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12));
        float invZlen = (float)(1.0 / Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22));
        dest.m00 = this.m00 * invXlen;
        dest.m01 = this.m01 * invXlen;
        dest.m02 = this.m02 * invXlen;
        dest.m10 = this.m10 * invYlen;
        dest.m11 = this.m11 * invYlen;
        dest.m12 = this.m12 * invYlen;
        dest.m20 = this.m20 * invZlen;
        dest.m21 = this.m21 * invZlen;
        dest.m22 = this.m22 * invZlen;
        return dest;
    }

    public Vector4f frustumPlane(int plane, Vector4f planeEquation) {
        switch (plane) {
            case 0: {
                planeEquation.set(this.m03 + this.m00, this.m13 + this.m10, this.m23 + this.m20, this.m33 + this.m30).normalize3();
                break;
            }
            case 1: {
                planeEquation.set(this.m03 - this.m00, this.m13 - this.m10, this.m23 - this.m20, this.m33 - this.m30).normalize3();
                break;
            }
            case 2: {
                planeEquation.set(this.m03 + this.m01, this.m13 + this.m11, this.m23 + this.m21, this.m33 + this.m31).normalize3();
                break;
            }
            case 3: {
                planeEquation.set(this.m03 - this.m01, this.m13 - this.m11, this.m23 - this.m21, this.m33 - this.m31).normalize3();
                break;
            }
            case 4: {
                planeEquation.set(this.m03 + this.m02, this.m13 + this.m12, this.m23 + this.m22, this.m33 + this.m32).normalize3();
                break;
            }
            case 5: {
                planeEquation.set(this.m03 - this.m02, this.m13 - this.m12, this.m23 - this.m22, this.m33 - this.m32).normalize3();
                break;
            }
            default: {
                throw new IllegalArgumentException("plane");
            }
        }
        return planeEquation;
    }

    public Vector3f frustumCorner(int corner, Vector3f point) {
        float d3;
        float n3z;
        float n3y;
        float n3x;
        float d2;
        float n2z;
        float n2y;
        float n2x;
        float d1;
        float n1z;
        float n1y;
        float n1x;
        switch (corner) {
            case 0: {
                n1x = this.m03 + this.m00;
                n1y = this.m13 + this.m10;
                n1z = this.m23 + this.m20;
                d1 = this.m33 + this.m30;
                n2x = this.m03 + this.m01;
                n2y = this.m13 + this.m11;
                n2z = this.m23 + this.m21;
                d2 = this.m33 + this.m31;
                n3x = this.m03 + this.m02;
                n3y = this.m13 + this.m12;
                n3z = this.m23 + this.m22;
                d3 = this.m33 + this.m32;
                break;
            }
            case 1: {
                n1x = this.m03 - this.m00;
                n1y = this.m13 - this.m10;
                n1z = this.m23 - this.m20;
                d1 = this.m33 - this.m30;
                n2x = this.m03 + this.m01;
                n2y = this.m13 + this.m11;
                n2z = this.m23 + this.m21;
                d2 = this.m33 + this.m31;
                n3x = this.m03 + this.m02;
                n3y = this.m13 + this.m12;
                n3z = this.m23 + this.m22;
                d3 = this.m33 + this.m32;
                break;
            }
            case 2: {
                n1x = this.m03 - this.m00;
                n1y = this.m13 - this.m10;
                n1z = this.m23 - this.m20;
                d1 = this.m33 - this.m30;
                n2x = this.m03 - this.m01;
                n2y = this.m13 - this.m11;
                n2z = this.m23 - this.m21;
                d2 = this.m33 - this.m31;
                n3x = this.m03 + this.m02;
                n3y = this.m13 + this.m12;
                n3z = this.m23 + this.m22;
                d3 = this.m33 + this.m32;
                break;
            }
            case 3: {
                n1x = this.m03 + this.m00;
                n1y = this.m13 + this.m10;
                n1z = this.m23 + this.m20;
                d1 = this.m33 + this.m30;
                n2x = this.m03 - this.m01;
                n2y = this.m13 - this.m11;
                n2z = this.m23 - this.m21;
                d2 = this.m33 - this.m31;
                n3x = this.m03 + this.m02;
                n3y = this.m13 + this.m12;
                n3z = this.m23 + this.m22;
                d3 = this.m33 + this.m32;
                break;
            }
            case 4: {
                n1x = this.m03 - this.m00;
                n1y = this.m13 - this.m10;
                n1z = this.m23 - this.m20;
                d1 = this.m33 - this.m30;
                n2x = this.m03 + this.m01;
                n2y = this.m13 + this.m11;
                n2z = this.m23 + this.m21;
                d2 = this.m33 + this.m31;
                n3x = this.m03 - this.m02;
                n3y = this.m13 - this.m12;
                n3z = this.m23 - this.m22;
                d3 = this.m33 - this.m32;
                break;
            }
            case 5: {
                n1x = this.m03 + this.m00;
                n1y = this.m13 + this.m10;
                n1z = this.m23 + this.m20;
                d1 = this.m33 + this.m30;
                n2x = this.m03 + this.m01;
                n2y = this.m13 + this.m11;
                n2z = this.m23 + this.m21;
                d2 = this.m33 + this.m31;
                n3x = this.m03 - this.m02;
                n3y = this.m13 - this.m12;
                n3z = this.m23 - this.m22;
                d3 = this.m33 - this.m32;
                break;
            }
            case 6: {
                n1x = this.m03 + this.m00;
                n1y = this.m13 + this.m10;
                n1z = this.m23 + this.m20;
                d1 = this.m33 + this.m30;
                n2x = this.m03 - this.m01;
                n2y = this.m13 - this.m11;
                n2z = this.m23 - this.m21;
                d2 = this.m33 - this.m31;
                n3x = this.m03 - this.m02;
                n3y = this.m13 - this.m12;
                n3z = this.m23 - this.m22;
                d3 = this.m33 - this.m32;
                break;
            }
            case 7: {
                n1x = this.m03 - this.m00;
                n1y = this.m13 - this.m10;
                n1z = this.m23 - this.m20;
                d1 = this.m33 - this.m30;
                n2x = this.m03 - this.m01;
                n2y = this.m13 - this.m11;
                n2z = this.m23 - this.m21;
                d2 = this.m33 - this.m31;
                n3x = this.m03 - this.m02;
                n3y = this.m13 - this.m12;
                n3z = this.m23 - this.m22;
                d3 = this.m33 - this.m32;
                break;
            }
            default: {
                throw new IllegalArgumentException("corner");
            }
        }
        float c23x = n2y * n3z - n2z * n3y;
        float c23y = n2z * n3x - n2x * n3z;
        float c23z = n2x * n3y - n2y * n3x;
        float c31x = n3y * n1z - n3z * n1y;
        float c31y = n3z * n1x - n3x * n1z;
        float c31z = n3x * n1y - n3y * n1x;
        float c12x = n1y * n2z - n1z * n2y;
        float c12y = n1z * n2x - n1x * n2z;
        float c12z = n1x * n2y - n1y * n2x;
        float invDot = 1.0f / (n1x * c23x + n1y * c23y + n1z * c23z);
        point.x = (-c23x * d1 - c31x * d2 - c12x * d3) * invDot;
        point.y = (-c23y * d1 - c31y * d2 - c12y * d3) * invDot;
        point.z = (-c23z * d1 - c31z * d2 - c12z * d3) * invDot;
        return point;
    }

    public Vector3f perspectiveOrigin(Vector3f origin) {
        float n1x = this.m03 + this.m00;
        float n1y = this.m13 + this.m10;
        float n1z = this.m23 + this.m20;
        float d1 = this.m33 + this.m30;
        float n2x = this.m03 - this.m00;
        float n2y = this.m13 - this.m10;
        float n2z = this.m23 - this.m20;
        float d2 = this.m33 - this.m30;
        float n3x = this.m03 - this.m01;
        float n3y = this.m13 - this.m11;
        float n3z = this.m23 - this.m21;
        float d3 = this.m33 - this.m31;
        float c23x = n2y * n3z - n2z * n3y;
        float c23y = n2z * n3x - n2x * n3z;
        float c23z = n2x * n3y - n2y * n3x;
        float c31x = n3y * n1z - n3z * n1y;
        float c31y = n3z * n1x - n3x * n1z;
        float c31z = n3x * n1y - n3y * n1x;
        float c12x = n1y * n2z - n1z * n2y;
        float c12y = n1z * n2x - n1x * n2z;
        float c12z = n1x * n2y - n1y * n2x;
        float invDot = 1.0f / (n1x * c23x + n1y * c23y + n1z * c23z);
        origin.x = (-c23x * d1 - c31x * d2 - c12x * d3) * invDot;
        origin.y = (-c23y * d1 - c31y * d2 - c12y * d3) * invDot;
        origin.z = (-c23z * d1 - c31z * d2 - c12z * d3) * invDot;
        return origin;
    }

    public float perspectiveFov() {
        float n1x = this.m03 + this.m01;
        float n1y = this.m13 + this.m11;
        float n1z = this.m23 + this.m21;
        float n2x = this.m01 - this.m03;
        float n2y = this.m11 - this.m13;
        float n2z = this.m21 - this.m23;
        float n1len = (float)Math.sqrt(n1x * n1x + n1y * n1y + n1z * n1z);
        float n2len = (float)Math.sqrt(n2x * n2x + n2y * n2y + n2z * n2z);
        return (float)Math.acos((n1x * n2x + n1y * n2y + n1z * n2z) / (n1len * n2len));
    }

    public float perspectiveNear() {
        return this.m32 / (this.m23 + this.m22);
    }

    public float perspectiveFar() {
        return this.m32 / (this.m22 - this.m23);
    }

    public Vector3f frustumRayDir(float x, float y, Vector3f dir) {
        float a = this.m10 * this.m23;
        float b = this.m13 * this.m21;
        float c = this.m10 * this.m21;
        float d = this.m11 * this.m23;
        float e = this.m13 * this.m20;
        float f = this.m11 * this.m20;
        float g = this.m03 * this.m20;
        float h = this.m01 * this.m23;
        float i = this.m01 * this.m20;
        float j = this.m03 * this.m21;
        float k = this.m00 * this.m23;
        float l = this.m00 * this.m21;
        float m = this.m00 * this.m13;
        float n = this.m03 * this.m11;
        float o = this.m00 * this.m11;
        float p = this.m01 * this.m13;
        float q = this.m03 * this.m10;
        float r = this.m01 * this.m10;
        float m1x = (d + e + f - a - b - c) * (1.0f - y) + (a - b - c + d - e + f) * y;
        float m1y = (j + k + l - g - h - i) * (1.0f - y) + (g - h - i + j - k + l) * y;
        float m1z = (p + q + r - m - n - o) * (1.0f - y) + (m - n - o + p - q + r) * y;
        float m2x = (b - c - d + e + f - a) * (1.0f - y) + (a + b - c - d - e + f) * y;
        float m2y = (h - i - j + k + l - g) * (1.0f - y) + (g + h - i - j - k + l) * y;
        float m2z = (n - o - p + q + r - m) * (1.0f - y) + (m + n - o - p - q + r) * y;
        dir.x = m1x + (m2x - m1x) * x;
        dir.y = m1y + (m2y - m1y) * x;
        dir.z = m1z + (m2z - m1z) * x;
        dir.normalize();
        return dir;
    }

    public Vector3f positiveZ(Vector3f dir) {
        dir.x = this.m10 * this.m21 - this.m11 * this.m20;
        dir.y = this.m20 * this.m01 - this.m21 * this.m00;
        dir.z = this.m00 * this.m11 - this.m01 * this.m10;
        dir.normalize();
        return dir;
    }

    public Vector3f normalizedPositiveZ(Vector3f dir) {
        dir.x = this.m02;
        dir.y = this.m12;
        dir.z = this.m22;
        return dir;
    }

    public Vector3f positiveX(Vector3f dir) {
        dir.x = this.m11 * this.m22 - this.m12 * this.m21;
        dir.y = this.m02 * this.m21 - this.m01 * this.m22;
        dir.z = this.m01 * this.m12 - this.m02 * this.m11;
        dir.normalize();
        return dir;
    }

    public Vector3f normalizedPositiveX(Vector3f dir) {
        dir.x = this.m00;
        dir.y = this.m10;
        dir.z = this.m20;
        return dir;
    }

    public Vector3f positiveY(Vector3f dir) {
        dir.x = this.m12 * this.m20 - this.m10 * this.m22;
        dir.y = this.m00 * this.m22 - this.m02 * this.m20;
        dir.z = this.m02 * this.m10 - this.m00 * this.m12;
        dir.normalize();
        return dir;
    }

    public Vector3f normalizedPositiveY(Vector3f dir) {
        dir.x = this.m01;
        dir.y = this.m11;
        dir.z = this.m21;
        return dir;
    }

    public Vector3f originAffine(Vector3f origin) {
        float a = this.m00 * this.m11 - this.m01 * this.m10;
        float b = this.m00 * this.m12 - this.m02 * this.m10;
        float d = this.m01 * this.m12 - this.m02 * this.m11;
        float g = this.m20 * this.m31 - this.m21 * this.m30;
        float h = this.m20 * this.m32 - this.m22 * this.m30;
        float j = this.m21 * this.m32 - this.m22 * this.m31;
        origin.x = -this.m10 * j + this.m11 * h - this.m12 * g;
        origin.y = this.m00 * j - this.m01 * h + this.m02 * g;
        origin.z = -this.m30 * d + this.m31 * b - this.m32 * a;
        return origin;
    }

    public Vector3f origin(Vector3f origin) {
        float a = this.m00 * this.m11 - this.m01 * this.m10;
        float b = this.m00 * this.m12 - this.m02 * this.m10;
        float c = this.m00 * this.m13 - this.m03 * this.m10;
        float d = this.m01 * this.m12 - this.m02 * this.m11;
        float e = this.m01 * this.m13 - this.m03 * this.m11;
        float f = this.m02 * this.m13 - this.m03 * this.m12;
        float g = this.m20 * this.m31 - this.m21 * this.m30;
        float h = this.m20 * this.m32 - this.m22 * this.m30;
        float i = this.m20 * this.m33 - this.m23 * this.m30;
        float j = this.m21 * this.m32 - this.m22 * this.m31;
        float k = this.m21 * this.m33 - this.m23 * this.m31;
        float l = this.m22 * this.m33 - this.m23 * this.m32;
        float det = a * l - b * k + c * j + d * i - e * h + f * g;
        float invDet = 1.0f / det;
        float nm30 = (-this.m10 * j + this.m11 * h - this.m12 * g) * invDet;
        float nm31 = (this.m00 * j - this.m01 * h + this.m02 * g) * invDet;
        float nm32 = (-this.m30 * d + this.m31 * b - this.m32 * a) * invDet;
        float nm33 = det / (this.m20 * d - this.m21 * b + this.m22 * a);
        float x = nm30 * nm33;
        float y = nm31 * nm33;
        float z = nm32 * nm33;
        return origin.set(x, y, z);
    }

    public Matrix4f shadow(Vector4f light, float a, float b, float c, float d) {
        return this.shadow(light.x, light.y, light.z, light.w, a, b, c, d, this);
    }

    public Matrix4f shadow(Vector4f light, float a, float b, float c, float d, Matrix4f dest) {
        return this.shadow(light.x, light.y, light.z, light.w, a, b, c, d, dest);
    }

    public Matrix4f shadow(float lightX, float lightY, float lightZ, float lightW, float a, float b, float c, float d) {
        return this.shadow(lightX, lightY, lightZ, lightW, a, b, c, d, this);
    }

    public Matrix4f shadow(float lightX, float lightY, float lightZ, float lightW, float a, float b, float c, float d, Matrix4f dest) {
        float invPlaneLen = (float)(1.0 / Math.sqrt(a * a + b * b + c * c));
        float an = a * invPlaneLen;
        float bn = b * invPlaneLen;
        float cn = c * invPlaneLen;
        float dn = d * invPlaneLen;
        float dot = an * lightX + bn * lightY + cn * lightZ + dn * lightW;
        float rm00 = dot - an * lightX;
        float rm01 = -an * lightY;
        float rm02 = -an * lightZ;
        float rm03 = -an * lightW;
        float rm10 = -bn * lightX;
        float rm11 = dot - bn * lightY;
        float rm12 = -bn * lightZ;
        float rm13 = -bn * lightW;
        float rm20 = -cn * lightX;
        float rm21 = -cn * lightY;
        float rm22 = dot - cn * lightZ;
        float rm23 = -cn * lightW;
        float rm30 = -dn * lightX;
        float rm31 = -dn * lightY;
        float rm32 = -dn * lightZ;
        float rm33 = dot - dn * lightW;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02 + this.m30 * rm03;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02 + this.m31 * rm03;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02 + this.m32 * rm03;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02 + this.m33 * rm03;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12 + this.m30 * rm13;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12 + this.m31 * rm13;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12 + this.m32 * rm13;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12 + this.m33 * rm13;
        float nm20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22 + this.m30 * rm23;
        float nm21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22 + this.m31 * rm23;
        float nm22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22 + this.m32 * rm23;
        float nm23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22 + this.m33 * rm23;
        dest.m30 = this.m00 * rm30 + this.m10 * rm31 + this.m20 * rm32 + this.m30 * rm33;
        dest.m31 = this.m01 * rm30 + this.m11 * rm31 + this.m21 * rm32 + this.m31 * rm33;
        dest.m32 = this.m02 * rm30 + this.m12 * rm31 + this.m22 * rm32 + this.m32 * rm33;
        dest.m33 = this.m03 * rm30 + this.m13 * rm31 + this.m23 * rm32 + this.m33 * rm33;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f shadow(Vector4f light, Matrix4f planeTransform, Matrix4f dest) {
        float a = planeTransform.m10;
        float b = planeTransform.m11;
        float c = planeTransform.m12;
        float d = -a * planeTransform.m30 - b * planeTransform.m31 - c * planeTransform.m32;
        return this.shadow(light.x, light.y, light.z, light.w, a, b, c, d, dest);
    }

    public Matrix4f shadow(Vector4f light, Matrix4f planeTransform) {
        return this.shadow(light, planeTransform, this);
    }

    public Matrix4f shadow(float lightX, float lightY, float lightZ, float lightW, Matrix4f planeTransform, Matrix4f dest) {
        float a = planeTransform.m10;
        float b = planeTransform.m11;
        float c = planeTransform.m12;
        float d = -a * planeTransform.m30 - b * planeTransform.m31 - c * planeTransform.m32;
        return this.shadow(lightX, lightY, lightZ, lightW, a, b, c, d, dest);
    }

    public Matrix4f shadow(float lightX, float lightY, float lightZ, float lightW, Matrix4f planeTransform) {
        return this.shadow(lightX, lightY, lightZ, lightW, planeTransform, this);
    }

    public Matrix4f billboardCylindrical(Vector3f objPos, Vector3f targetPos, Vector3f up) {
        float dirX = targetPos.x - objPos.x;
        float dirY = targetPos.y - objPos.y;
        float dirZ = targetPos.z - objPos.z;
        float leftX = up.y * dirZ - up.z * dirY;
        float leftY = up.z * dirX - up.x * dirZ;
        float leftZ = up.x * dirY - up.y * dirX;
        float invLeftLen = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        dirX = (leftY *= invLeftLen) * up.z - (leftZ *= invLeftLen) * up.y;
        dirY = leftZ * up.x - (leftX *= invLeftLen) * up.z;
        dirZ = leftX * up.y - leftY * up.x;
        float invDirLen = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        dirX *= invDirLen;
        dirY *= invDirLen;
        dirZ *= invDirLen;
        this.m00 = leftX;
        this.m01 = leftY;
        this.m02 = leftZ;
        this.m03 = 0.0f;
        this.m10 = up.x;
        this.m11 = up.y;
        this.m12 = up.z;
        this.m13 = 0.0f;
        this.m20 = dirX;
        this.m21 = dirY;
        this.m22 = dirZ;
        this.m23 = 0.0f;
        this.m30 = objPos.x;
        this.m31 = objPos.y;
        this.m32 = objPos.z;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f billboardSpherical(Vector3f objPos, Vector3f targetPos, Vector3f up) {
        float dirX = targetPos.x - objPos.x;
        float dirY = targetPos.y - objPos.y;
        float dirZ = targetPos.z - objPos.z;
        float invDirLen = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float leftX = up.y * (dirZ *= invDirLen) - up.z * (dirY *= invDirLen);
        float leftY = up.z * (dirX *= invDirLen) - up.x * dirZ;
        float leftZ = up.x * dirY - up.y * dirX;
        float invLeftLen = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upX = dirY * (leftZ *= invLeftLen) - dirZ * (leftY *= invLeftLen);
        float upY = dirZ * (leftX *= invLeftLen) - dirX * leftZ;
        float upZ = dirX * leftY - dirY * leftX;
        this.m00 = leftX;
        this.m01 = leftY;
        this.m02 = leftZ;
        this.m03 = 0.0f;
        this.m10 = upX;
        this.m11 = upY;
        this.m12 = upZ;
        this.m13 = 0.0f;
        this.m20 = dirX;
        this.m21 = dirY;
        this.m22 = dirZ;
        this.m23 = 0.0f;
        this.m30 = objPos.x;
        this.m31 = objPos.y;
        this.m32 = objPos.z;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f billboardSpherical(Vector3f objPos, Vector3f targetPos) {
        float toDirX = targetPos.x - objPos.x;
        float toDirY = targetPos.y - objPos.y;
        float toDirZ = targetPos.z - objPos.z;
        float x = -toDirY;
        float y = toDirX;
        float w = (float)Math.sqrt(toDirX * toDirX + toDirY * toDirY + toDirZ * toDirZ) + toDirZ;
        float invNorm = (float)(1.0 / Math.sqrt(x * x + y * y + w * w));
        float q00 = ((x *= invNorm) + x) * x;
        float q11 = ((y *= invNorm) + y) * y;
        float q01 = (x + x) * y;
        float q03 = (x + x) * (w *= invNorm);
        float q13 = (y + y) * w;
        this.m00 = 1.0f - q11;
        this.m01 = q01;
        this.m02 = -q13;
        this.m03 = 0.0f;
        this.m10 = q01;
        this.m11 = 1.0f - q00;
        this.m12 = q03;
        this.m13 = 0.0f;
        this.m20 = q13;
        this.m21 = -q03;
        this.m22 = 1.0f - q11 - q00;
        this.m23 = 0.0f;
        this.m30 = objPos.x;
        this.m31 = objPos.y;
        this.m32 = objPos.z;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.m00);
        result = 31 * result + Float.floatToIntBits(this.m01);
        result = 31 * result + Float.floatToIntBits(this.m02);
        result = 31 * result + Float.floatToIntBits(this.m03);
        result = 31 * result + Float.floatToIntBits(this.m10);
        result = 31 * result + Float.floatToIntBits(this.m11);
        result = 31 * result + Float.floatToIntBits(this.m12);
        result = 31 * result + Float.floatToIntBits(this.m13);
        result = 31 * result + Float.floatToIntBits(this.m20);
        result = 31 * result + Float.floatToIntBits(this.m21);
        result = 31 * result + Float.floatToIntBits(this.m22);
        result = 31 * result + Float.floatToIntBits(this.m23);
        result = 31 * result + Float.floatToIntBits(this.m30);
        result = 31 * result + Float.floatToIntBits(this.m31);
        result = 31 * result + Float.floatToIntBits(this.m32);
        result = 31 * result + Float.floatToIntBits(this.m33);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matrix4f)) {
            return false;
        }
        Matrix4f other = (Matrix4f)obj;
        if (Float.floatToIntBits(this.m00) != Float.floatToIntBits(other.m00)) {
            return false;
        }
        if (Float.floatToIntBits(this.m01) != Float.floatToIntBits(other.m01)) {
            return false;
        }
        if (Float.floatToIntBits(this.m02) != Float.floatToIntBits(other.m02)) {
            return false;
        }
        if (Float.floatToIntBits(this.m03) != Float.floatToIntBits(other.m03)) {
            return false;
        }
        if (Float.floatToIntBits(this.m10) != Float.floatToIntBits(other.m10)) {
            return false;
        }
        if (Float.floatToIntBits(this.m11) != Float.floatToIntBits(other.m11)) {
            return false;
        }
        if (Float.floatToIntBits(this.m12) != Float.floatToIntBits(other.m12)) {
            return false;
        }
        if (Float.floatToIntBits(this.m13) != Float.floatToIntBits(other.m13)) {
            return false;
        }
        if (Float.floatToIntBits(this.m20) != Float.floatToIntBits(other.m20)) {
            return false;
        }
        if (Float.floatToIntBits(this.m21) != Float.floatToIntBits(other.m21)) {
            return false;
        }
        if (Float.floatToIntBits(this.m22) != Float.floatToIntBits(other.m22)) {
            return false;
        }
        if (Float.floatToIntBits(this.m23) != Float.floatToIntBits(other.m23)) {
            return false;
        }
        if (Float.floatToIntBits(this.m30) != Float.floatToIntBits(other.m30)) {
            return false;
        }
        if (Float.floatToIntBits(this.m31) != Float.floatToIntBits(other.m31)) {
            return false;
        }
        if (Float.floatToIntBits(this.m32) != Float.floatToIntBits(other.m32)) {
            return false;
        }
        return Float.floatToIntBits(this.m33) == Float.floatToIntBits(other.m33);
    }

    public Matrix4f pick(float x, float y, float width, float height, int[] viewport, Matrix4f dest) {
        float sx = (float)viewport[2] / width;
        float sy = (float)viewport[3] / height;
        float tx = ((float)viewport[2] + 2.0f * ((float)viewport[0] - x)) / width;
        float ty = ((float)viewport[3] + 2.0f * ((float)viewport[1] - y)) / height;
        dest.m30 = this.m00 * tx + this.m10 * ty + this.m30;
        dest.m31 = this.m01 * tx + this.m11 * ty + this.m31;
        dest.m32 = this.m02 * tx + this.m12 * ty + this.m32;
        dest.m33 = this.m03 * tx + this.m13 * ty + this.m33;
        dest.m00 = this.m00 * sx;
        dest.m01 = this.m01 * sx;
        dest.m02 = this.m02 * sx;
        dest.m03 = this.m03 * sx;
        dest.m10 = this.m10 * sy;
        dest.m11 = this.m11 * sy;
        dest.m12 = this.m12 * sy;
        dest.m13 = this.m13 * sy;
        dest.properties = 0;
        return dest;
    }

    public Matrix4f pick(float x, float y, float width, float height, int[] viewport) {
        return this.pick(x, y, width, height, viewport, this);
    }

    public boolean isAffine() {
        return this.m03 == 0.0f && this.m13 == 0.0f && this.m23 == 0.0f && this.m33 == 1.0f;
    }

    public Matrix4f swap(Matrix4f other) {
        MemUtil.INSTANCE.swap(this, other);
        byte props = this.properties;
        this.properties = other.properties;
        other.properties = props;
        return this;
    }

    public Matrix4f arcball(float radius, float centerX, float centerY, float centerZ, float angleX, float angleY, Matrix4f dest) {
        float m30 = this.m20 * -radius + this.m30;
        float m31 = this.m21 * -radius + this.m31;
        float m32 = this.m22 * -radius + this.m32;
        float m33 = this.m23 * -radius + this.m33;
        float cos = (float)Math.cos(angleX);
        float sin = (float)Math.sin(angleX);
        float nm10 = this.m10 * cos + this.m20 * sin;
        float nm11 = this.m11 * cos + this.m21 * sin;
        float nm12 = this.m12 * cos + this.m22 * sin;
        float nm13 = this.m13 * cos + this.m23 * sin;
        float m20 = this.m20 * cos - this.m10 * sin;
        float m21 = this.m21 * cos - this.m11 * sin;
        float m22 = this.m22 * cos - this.m12 * sin;
        float m23 = this.m23 * cos - this.m13 * sin;
        cos = (float)Math.cos(angleY);
        sin = (float)Math.sin(angleY);
        float nm00 = this.m00 * cos - m20 * sin;
        float nm01 = this.m01 * cos - m21 * sin;
        float nm02 = this.m02 * cos - m22 * sin;
        float nm03 = this.m03 * cos - m23 * sin;
        float nm20 = this.m00 * sin + m20 * cos;
        float nm21 = this.m01 * sin + m21 * cos;
        float nm22 = this.m02 * sin + m22 * cos;
        float nm23 = this.m03 * sin + m23 * cos;
        dest.m30 = -nm00 * centerX - nm10 * centerY - nm20 * centerZ + m30;
        dest.m31 = -nm01 * centerX - nm11 * centerY - nm21 * centerZ + m31;
        dest.m32 = -nm02 * centerX - nm12 * centerY - nm22 * centerZ + m32;
        dest.m33 = -nm03 * centerX - nm13 * centerY - nm23 * centerZ + m33;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        dest.m23 = nm23;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f arcball(float radius, Vector3f center, float angleX, float angleY, Matrix4f dest) {
        return this.arcball(radius, center.x, center.y, center.z, angleX, angleY, dest);
    }

    public Matrix4f arcball(float radius, float centerX, float centerY, float centerZ, float angleX, float angleY) {
        return this.arcball(radius, centerX, centerY, centerZ, angleX, angleY, this);
    }

    public Matrix4f arcball(float radius, Vector3f center, float angleX, float angleY) {
        return this.arcball(radius, center.x, center.y, center.z, angleX, angleY, this);
    }

    public Matrix4f frustumAabb(Vector3f min, Vector3f max) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float maxZ = -3.4028235E38f;
        for (int t = 0; t < 8; ++t) {
            float x = (float)((t & 1) << 1) - 1.0f;
            float y = (float)((t >>> 1 & 1) << 1) - 1.0f;
            float z = (float)((t >>> 2 & 1) << 1) - 1.0f;
            float invW = 1.0f / (this.m03 * x + this.m13 * y + this.m23 * z + this.m33);
            float nx = (this.m00 * x + this.m10 * y + this.m20 * z + this.m30) * invW;
            float ny = (this.m01 * x + this.m11 * y + this.m21 * z + this.m31) * invW;
            float nz = (this.m02 * x + this.m12 * y + this.m22 * z + this.m32) * invW;
            minX = minX < nx ? minX : nx;
            minY = minY < ny ? minY : ny;
            minZ = minZ < nz ? minZ : nz;
            maxX = maxX > nx ? maxX : nx;
            maxY = maxY > ny ? maxY : ny;
            maxZ = maxZ > nz ? maxZ : nz;
        }
        min.x = minX;
        min.y = minY;
        min.z = minZ;
        max.x = maxX;
        max.y = maxY;
        max.z = maxZ;
        return this;
    }

    public Matrix4f projectedGridRange(Matrix4f projector, float sLower, float sUpper, Matrix4f dest) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        boolean intersection = false;
        for (int t = 0; t < 12; ++t) {
            float c0Z;
            float c1Z;
            float c0Y;
            float c1Y;
            float c1X;
            float c0X;
            if (t < 4) {
                c0X = -1.0f;
                c1X = 1.0f;
                c0Y = c1Y = (float)((t & 1) << 1) - 1.0f;
                c0Z = c1Z = (float)((t >>> 1 & 1) << 1) - 1.0f;
            } else if (t < 8) {
                c0Y = -1.0f;
                c1Y = 1.0f;
                c0X = c1X = (float)((t & 1) << 1) - 1.0f;
                c0Z = c1Z = (float)((t >>> 1 & 1) << 1) - 1.0f;
            } else {
                c0Z = -1.0f;
                c1Z = 1.0f;
                c0X = c1X = (float)((t & 1) << 1) - 1.0f;
                c0Y = c1Y = (float)((t >>> 1 & 1) << 1) - 1.0f;
            }
            float invW = 1.0f / (this.m03 * c0X + this.m13 * c0Y + this.m23 * c0Z + this.m33);
            float p0x = (this.m00 * c0X + this.m10 * c0Y + this.m20 * c0Z + this.m30) * invW;
            float p0y = (this.m01 * c0X + this.m11 * c0Y + this.m21 * c0Z + this.m31) * invW;
            float p0z = (this.m02 * c0X + this.m12 * c0Y + this.m22 * c0Z + this.m32) * invW;
            invW = 1.0f / (this.m03 * c1X + this.m13 * c1Y + this.m23 * c1Z + this.m33);
            float p1x = (this.m00 * c1X + this.m10 * c1Y + this.m20 * c1Z + this.m30) * invW;
            float p1y = (this.m01 * c1X + this.m11 * c1Y + this.m21 * c1Z + this.m31) * invW;
            float p1z = (this.m02 * c1X + this.m12 * c1Y + this.m22 * c1Z + this.m32) * invW;
            float dirX = p1x - p0x;
            float dirY = p1y - p0y;
            float dirZ = p1z - p0z;
            float invDenom = 1.0f / dirY;
            for (int s = 0; s < 2; ++s) {
                float isectT = -(p0y + (s == 0 ? sLower : sUpper)) * invDenom;
                if (!(isectT >= 0.0f) || !(isectT <= 1.0f)) continue;
                intersection = true;
                float ix = p0x + isectT * dirX;
                float iz = p0z + isectT * dirZ;
                invW = 1.0f / (projector.m03 * ix + projector.m23 * iz + projector.m33);
                float px = (projector.m00 * ix + projector.m20 * iz + projector.m30) * invW;
                float py = (projector.m01 * ix + projector.m21 * iz + projector.m31) * invW;
                minX = minX < px ? minX : px;
                minY = minY < py ? minY : py;
                maxX = maxX > px ? maxX : px;
                maxY = maxY > py ? maxY : py;
            }
        }
        if (!intersection) {
            return null;
        }
        dest.set(maxX - minX, 0.0f, 0.0f, 0.0f, 0.0f, maxY - minY, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, minX, minY, 0.0f, 1.0f);
        dest.properties = (byte)2;
        return dest;
    }

    public Matrix4f perspectiveFrustumSlice(float near, float far, Matrix4f dest) {
        float invOldNear = (this.m23 + this.m22) / this.m32;
        float invNearFar = 1.0f / (near - far);
        dest.m00 = this.m00 * invOldNear * near;
        dest.m01 = this.m01;
        dest.m02 = this.m02;
        dest.m03 = this.m03;
        dest.m10 = this.m10;
        dest.m11 = this.m11 * invOldNear * near;
        dest.m12 = this.m12;
        dest.m13 = this.m13;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = (far + near) * invNearFar;
        dest.m23 = this.m23;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = (far + far) * near * invNearFar;
        dest.m33 = this.m33;
        dest.properties = (byte)(this.properties & 0xFFFFFFF3);
        return dest;
    }

    public Matrix4f orthoCrop(Matrix4f view, Matrix4f dest) {
        float minX = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float minY = Float.MAX_VALUE;
        float maxY = -3.4028235E38f;
        float minZ = Float.MAX_VALUE;
        float maxZ = -3.4028235E38f;
        for (int t = 0; t < 8; ++t) {
            float x = (float)((t & 1) << 1) - 1.0f;
            float y = (float)((t >>> 1 & 1) << 1) - 1.0f;
            float z = (float)((t >>> 2 & 1) << 1) - 1.0f;
            float invW = 1.0f / (this.m03 * x + this.m13 * y + this.m23 * z + this.m33);
            float wx = (this.m00 * x + this.m10 * y + this.m20 * z + this.m30) * invW;
            float wy = (this.m01 * x + this.m11 * y + this.m21 * z + this.m31) * invW;
            float wz = (this.m02 * x + this.m12 * y + this.m22 * z + this.m32) * invW;
            invW = 1.0f / (view.m03 * wx + view.m13 * wy + view.m23 * wz + view.m33);
            float vx = view.m00 * wx + view.m10 * wy + view.m20 * wz + view.m30;
            float vy = view.m01 * wx + view.m11 * wy + view.m21 * wz + view.m31;
            float vz = (view.m02 * wx + view.m12 * wy + view.m22 * wz + view.m32) * invW;
            minX = minX < vx ? minX : vx;
            maxX = maxX > vx ? maxX : vx;
            minY = minY < vy ? minY : vy;
            maxY = maxY > vy ? maxY : vy;
            minZ = minZ < vz ? minZ : vz;
            maxZ = maxZ > vz ? maxZ : vz;
        }
        return dest.setOrtho(minX, maxX, minY, maxY, -maxZ, -minZ);
    }

    public Matrix4f trapezoidCrop(float p0x, float p0y, float p1x, float p1y, float p2x, float p2y, float p3x, float p3y) {
        float aY;
        float aX = p1y - p0y;
        float m00 = aY = p0x - p1x;
        float m10 = -aX;
        float m30 = aX * p0y - aY * p0x;
        float m01 = aX;
        float m11 = aY;
        float m31 = -(aX * p0x + aY * p0y);
        float c3x = m00 * p3x + m10 * p3y + m30;
        float c3y = m01 * p3x + m11 * p3y + m31;
        float s = -c3x / c3y;
        float d1x = (m00 += s * m01) * p1x + (m10 += s * m11) * p1y + (m30 += s * m31);
        float d2x = m00 * p2x + m10 * p2y + m30;
        float d = d1x * c3y / (d2x - d1x);
        m31 += d;
        float sx = 2.0f / d2x;
        float sy = 1.0f / (c3y + d);
        float u = (sy + sy) * d / (1.0f - sy * d);
        float m03 = m01 * sy;
        float m13 = m11 * sy;
        float m33 = m31 * sy;
        m01 = (u + 1.0f) * m03;
        m11 = (u + 1.0f) * m13;
        m31 = (u + 1.0f) * m33 - u;
        m00 = sx * m00 - m03;
        m10 = sx * m10 - m13;
        m30 = sx * m30 - m33;
        this.set(m00, m01, 0.0f, m03, m10, m11, 0.0f, m13, 0.0f, 0.0f, 1.0f, 0.0f, m30, m31, 0.0f, m33);
        this.properties = 0;
        return this;
    }

    public Matrix4f transformAab(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Vector3f outMin, Vector3f outMax) {
        float zmaxz;
        float zminz;
        float zmaxy;
        float zminy;
        float zmaxx;
        float zminx;
        float ymaxz;
        float yminz;
        float ymaxy;
        float yminy;
        float ymaxx;
        float yminx;
        float xmaxz;
        float xminz;
        float xmaxy;
        float xminy;
        float xmaxx;
        float xminx;
        float xax = this.m00 * minX;
        float xay = this.m01 * minX;
        float xaz = this.m02 * minX;
        float xbx = this.m00 * maxX;
        float xby = this.m01 * maxX;
        float xbz = this.m02 * maxX;
        float yax = this.m10 * minY;
        float yay = this.m11 * minY;
        float yaz = this.m12 * minY;
        float ybx = this.m10 * maxY;
        float yby = this.m11 * maxY;
        float ybz = this.m12 * maxY;
        float zax = this.m20 * minZ;
        float zay = this.m21 * minZ;
        float zaz = this.m22 * minZ;
        float zbx = this.m20 * maxZ;
        float zby = this.m21 * maxZ;
        float zbz = this.m22 * maxZ;
        if (xax < xbx) {
            xminx = xax;
            xmaxx = xbx;
        } else {
            xminx = xbx;
            xmaxx = xax;
        }
        if (xay < xby) {
            xminy = xay;
            xmaxy = xby;
        } else {
            xminy = xby;
            xmaxy = xay;
        }
        if (xaz < xbz) {
            xminz = xaz;
            xmaxz = xbz;
        } else {
            xminz = xbz;
            xmaxz = xaz;
        }
        if (yax < ybx) {
            yminx = yax;
            ymaxx = ybx;
        } else {
            yminx = ybx;
            ymaxx = yax;
        }
        if (yay < yby) {
            yminy = yay;
            ymaxy = yby;
        } else {
            yminy = yby;
            ymaxy = yay;
        }
        if (yaz < ybz) {
            yminz = yaz;
            ymaxz = ybz;
        } else {
            yminz = ybz;
            ymaxz = yaz;
        }
        if (zax < zbx) {
            zminx = zax;
            zmaxx = zbx;
        } else {
            zminx = zbx;
            zmaxx = zax;
        }
        if (zay < zby) {
            zminy = zay;
            zmaxy = zby;
        } else {
            zminy = zby;
            zmaxy = zay;
        }
        if (zaz < zbz) {
            zminz = zaz;
            zmaxz = zbz;
        } else {
            zminz = zbz;
            zmaxz = zaz;
        }
        outMin.x = xminx + yminx + zminx + this.m30;
        outMin.y = xminy + yminy + zminy + this.m31;
        outMin.z = xminz + yminz + zminz + this.m32;
        outMax.x = xmaxx + ymaxx + zmaxx + this.m30;
        outMax.y = xmaxy + ymaxy + zmaxy + this.m31;
        outMax.z = xmaxz + ymaxz + zmaxz + this.m32;
        return this;
    }

    public Matrix4f transformAab(Vector3f min, Vector3f max, Vector3f outMin, Vector3f outMax) {
        return this.transformAab(min.x, min.y, min.z, max.x, max.y, max.z, outMin, outMax);
    }

    public Matrix4f lerp(Matrix4f other, float t) {
        return this.lerp(other, t, this);
    }

    public Matrix4f lerp(Matrix4f other, float t, Matrix4f dest) {
        dest.m00 = this.m00 + (other.m00 - this.m00) * t;
        dest.m01 = this.m01 + (other.m01 - this.m01) * t;
        dest.m02 = this.m02 + (other.m02 - this.m02) * t;
        dest.m03 = this.m03 + (other.m03 - this.m03) * t;
        dest.m10 = this.m10 + (other.m10 - this.m10) * t;
        dest.m11 = this.m11 + (other.m11 - this.m11) * t;
        dest.m12 = this.m12 + (other.m12 - this.m12) * t;
        dest.m13 = this.m13 + (other.m13 - this.m13) * t;
        dest.m20 = this.m20 + (other.m20 - this.m20) * t;
        dest.m21 = this.m21 + (other.m21 - this.m21) * t;
        dest.m22 = this.m22 + (other.m22 - this.m22) * t;
        dest.m23 = this.m23 + (other.m23 - this.m23) * t;
        dest.m30 = this.m30 + (other.m30 - this.m30) * t;
        dest.m31 = this.m31 + (other.m31 - this.m31) * t;
        dest.m32 = this.m32 + (other.m32 - this.m32) * t;
        dest.m33 = this.m33 + (other.m33 - this.m33) * t;
        return dest;
    }

    public Matrix4f rotateTowards(Vector3f dir, Vector3f up, Matrix4f dest) {
        return this.rotateTowards(dir.x, dir.y, dir.z, up.x, up.y, up.z, dest);
    }

    public Matrix4f rotateTowards(Vector3f dir, Vector3f up) {
        return this.rotateTowards(dir.x, dir.y, dir.z, up.x, up.y, up.z, this);
    }

    public Matrix4f rotateTowards(float dirX, float dirY, float dirZ, float upX, float upY, float upZ) {
        return this.rotateTowards(dirX, dirY, dirZ, upX, upY, upZ, this);
    }

    public Matrix4f rotateTowards(float dirX, float dirY, float dirZ, float upX, float upY, float upZ, Matrix4f dest) {
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float ndirX = dirX * invDirLength;
        float ndirY = dirY * invDirLength;
        float ndirZ = dirZ * invDirLength;
        float leftX = upY * ndirZ - upZ * ndirY;
        float leftY = upZ * ndirX - upX * ndirZ;
        float leftZ = upX * ndirY - upY * ndirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = ndirY * (leftZ *= invLeftLength) - ndirZ * (leftY *= invLeftLength);
        float upnY = ndirZ * (leftX *= invLeftLength) - ndirX * leftZ;
        float upnZ = ndirX * leftY - ndirY * leftX;
        float rm00 = leftX;
        float rm01 = leftY;
        float rm02 = leftZ;
        float rm10 = upnX;
        float rm11 = upnY;
        float rm12 = upnZ;
        float rm20 = ndirX;
        float rm21 = ndirY;
        float rm22 = ndirZ;
        dest.m30 = this.m30;
        dest.m31 = this.m31;
        dest.m32 = this.m32;
        dest.m33 = this.m33;
        float nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        float nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        float nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        float nm03 = this.m03 * rm00 + this.m13 * rm01 + this.m23 * rm02;
        float nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        float nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        float nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        float nm13 = this.m03 * rm10 + this.m13 * rm11 + this.m23 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m23 = this.m03 * rm20 + this.m13 * rm21 + this.m23 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m03 = nm03;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m13 = nm13;
        dest.properties = (byte)(this.properties & 0xFFFFFFF2);
        return dest;
    }

    public Matrix4f rotationTowards(Vector3f dir, Vector3f up) {
        return this.rotationTowards(dir.x, dir.y, dir.z, up.x, up.y, up.z);
    }

    public Matrix4f rotationTowards(float dirX, float dirY, float dirZ, float upX, float upY, float upZ) {
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float ndirX = dirX * invDirLength;
        float ndirY = dirY * invDirLength;
        float ndirZ = dirZ * invDirLength;
        float leftX = upY * ndirZ - upZ * ndirY;
        float leftY = upZ * ndirX - upX * ndirZ;
        float leftZ = upX * ndirY - upY * ndirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = ndirY * (leftZ *= invLeftLength) - ndirZ * (leftY *= invLeftLength);
        float upnY = ndirZ * (leftX *= invLeftLength) - ndirX * leftZ;
        float upnZ = ndirX * leftY - ndirY * leftX;
        this.m00 = leftX;
        this.m01 = leftY;
        this.m02 = leftZ;
        this.m03 = 0.0f;
        this.m10 = upnX;
        this.m11 = upnY;
        this.m12 = upnZ;
        this.m13 = 0.0f;
        this.m20 = ndirX;
        this.m21 = ndirY;
        this.m22 = ndirZ;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }

    public Matrix4f translationRotateTowards(Vector3f pos, Vector3f dir, Vector3f up) {
        return this.translationRotateTowards(pos.x, pos.y, pos.z, dir.x, dir.y, dir.z, up.x, up.y, up.z);
    }

    public Matrix4f translationRotateTowards(float posX, float posY, float posZ, float dirX, float dirY, float dirZ, float upX, float upY, float upZ) {
        float invDirLength = 1.0f / (float)Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        float ndirX = dirX * invDirLength;
        float ndirY = dirY * invDirLength;
        float ndirZ = dirZ * invDirLength;
        float leftX = upY * ndirZ - upZ * ndirY;
        float leftY = upZ * ndirX - upX * ndirZ;
        float leftZ = upX * ndirY - upY * ndirX;
        float invLeftLength = 1.0f / (float)Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        float upnX = ndirY * (leftZ *= invLeftLength) - ndirZ * (leftY *= invLeftLength);
        float upnY = ndirZ * (leftX *= invLeftLength) - ndirX * leftZ;
        float upnZ = ndirX * leftY - ndirY * leftX;
        this.m00 = leftX;
        this.m01 = leftY;
        this.m02 = leftZ;
        this.m03 = 0.0f;
        this.m10 = upnX;
        this.m11 = upnY;
        this.m12 = upnZ;
        this.m13 = 0.0f;
        this.m20 = ndirX;
        this.m21 = ndirY;
        this.m22 = ndirZ;
        this.m23 = 0.0f;
        this.m30 = posX;
        this.m31 = posY;
        this.m32 = posZ;
        this.m33 = 1.0f;
        this.properties = (byte)2;
        return this;
    }
}

