/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.joml.Matrix3d;
import org.joml.Matrix3f;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4x3d;
import org.joml.Matrix4x3f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4d;
import org.joml.Vector4f;
import org.joml.Vector4i;
import sun.misc.Unsafe;

abstract class MemUtil {
    private static final boolean nounsafe = MemUtil.hasOption("joml.nounsafe");
    public static final MemUtil INSTANCE = MemUtil.createInstance();
    static /* synthetic */ Class class$java$nio$Buffer;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$sun$misc$Unsafe;
    static /* synthetic */ Class class$org$joml$Matrix4f;
    static /* synthetic */ Class class$org$joml$Matrix4x3f;
    static /* synthetic */ Class class$org$joml$Matrix3f;
    static /* synthetic */ Class class$org$joml$Vector4f;
    static /* synthetic */ Class class$org$joml$Vector4d;
    static /* synthetic */ Class class$org$joml$Vector4i;
    static /* synthetic */ Class class$org$joml$Vector3f;
    static /* synthetic */ Class class$org$joml$Quaternionf;

    MemUtil() {
    }

    private static boolean hasOption(String option) {
        String v = System.getProperty(option);
        if (v == null) {
            return false;
        }
        if (v.trim().length() == 0) {
            return true;
        }
        return Boolean.valueOf(v);
    }

    private static final MemUtil createInstance() {
        MemUtil accessor;
        try {
            accessor = nounsafe ? new MemUtilNIO() : new MemUtilUnsafe();
        }
        catch (Throwable e) {
            accessor = new MemUtilNIO();
        }
        return accessor;
    }

    public abstract MemUtilUnsafe UNSAFE();

    public abstract void put(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void put4x4(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void put4x4(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void put4x3Transposed(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void put4x3Transposed(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void putTransposed(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void put4x3Transposed(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void put4x3Transposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putTransposed(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void putTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void putfTransposed(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void putfTransposed(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void put(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void put(Matrix3d var1, int var2, DoubleBuffer var3);

    public abstract void put(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void putf(Matrix3d var1, int var2, FloatBuffer var3);

    public abstract void putf(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4d var1, int var2, DoubleBuffer var3);

    public abstract void put(Vector4d var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4f var1, int var2, FloatBuffer var3);

    public abstract void put(Vector4f var1, int var2, ByteBuffer var3);

    public abstract void put(Vector4i var1, int var2, IntBuffer var3);

    public abstract void put(Vector4i var1, int var2, ByteBuffer var3);

    public abstract void put(Vector3f var1, int var2, FloatBuffer var3);

    public abstract void put(Vector3f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix4f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4x3f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix4x3f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix4x3d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix4d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix4d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix4x3d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix4x3d var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3f var1, int var2, FloatBuffer var3);

    public abstract void get(Matrix3f var1, int var2, ByteBuffer var3);

    public abstract void get(Matrix3d var1, int var2, DoubleBuffer var3);

    public abstract void get(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void getf(Matrix3d var1, int var2, FloatBuffer var3);

    public abstract void getf(Matrix3d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4d var1, int var2, DoubleBuffer var3);

    public abstract void get(Vector4d var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4f var1, int var2, FloatBuffer var3);

    public abstract void get(Vector4f var1, int var2, ByteBuffer var3);

    public abstract void get(Vector4i var1, int var2, IntBuffer var3);

    public abstract void get(Vector4i var1, int var2, ByteBuffer var3);

    public abstract void get(Vector3f var1, int var2, FloatBuffer var3);

    public abstract void get(Vector3f var1, int var2, ByteBuffer var3);

    public abstract void copy(Matrix4f var1, Matrix4f var2);

    public abstract void copy(Matrix4x3f var1, Matrix4x3f var2);

    public abstract void copy(Matrix4f var1, Matrix4x3f var2);

    public abstract void copy(Matrix4x3f var1, Matrix4f var2);

    public abstract void copy(Matrix3f var1, Matrix3f var2);

    public abstract void copy(Matrix3f var1, Matrix4f var2);

    public abstract void copy(Matrix4f var1, Matrix3f var2);

    public abstract void copy(Matrix3f var1, Matrix4x3f var2);

    public abstract void copy3x3(Matrix4f var1, Matrix4f var2);

    public abstract void copy3x3(Matrix4x3f var1, Matrix4x3f var2);

    public abstract void copy3x3(Matrix3f var1, Matrix4x3f var2);

    public abstract void copy3x3(Matrix3f var1, Matrix4f var2);

    public abstract void copy4x3(Matrix4f var1, Matrix4f var2);

    public abstract void copy4x3(Matrix4x3f var1, Matrix4f var2);

    public abstract void copy(Vector4f var1, Vector4f var2);

    public abstract void copy(Vector4i var1, Vector4i var2);

    public abstract void copy(Quaternionf var1, Quaternionf var2);

    public abstract void copy(float[] var1, int var2, Matrix4f var3);

    public abstract void copy(float[] var1, int var2, Matrix3f var3);

    public abstract void copy(float[] var1, int var2, Matrix4x3f var3);

    public abstract void copy(Matrix4f var1, float[] var2, int var3);

    public abstract void copy(Matrix3f var1, float[] var2, int var3);

    public abstract void copy(Matrix4x3f var1, float[] var2, int var3);

    public abstract void identity(Matrix4f var1);

    public abstract void identity(Matrix4x3f var1);

    public abstract void identity(Matrix3f var1);

    public abstract void identity(Quaternionf var1);

    public abstract void swap(Matrix4f var1, Matrix4f var2);

    public abstract void swap(Matrix4x3f var1, Matrix4x3f var2);

    public abstract void swap(Matrix3f var1, Matrix3f var2);

    public abstract void zero(Matrix4f var1);

    public abstract void zero(Matrix4x3f var1);

    public abstract void zero(Matrix3f var1);

    public abstract void zero(Vector4f var1);

    public abstract void zero(Vector4i var1);

    public abstract void putMatrix3f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix3f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract void putMatrix4f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix4f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract void putMatrix4x3f(Quaternionf var1, int var2, ByteBuffer var3);

    public abstract void putMatrix4x3f(Quaternionf var1, int var2, FloatBuffer var3);

    public abstract void set(Matrix4f var1, Vector4f var2, Vector4f var3, Vector4f var4, Vector4f var5);

    public abstract void set(Matrix4x3f var1, Vector3f var2, Vector3f var3, Vector3f var4, Vector3f var5);

    public abstract void set(Matrix3f var1, Vector3f var2, Vector3f var3, Vector3f var4);

    public abstract void putColumn0(Matrix4f var1, Vector4f var2);

    public abstract void putColumn1(Matrix4f var1, Vector4f var2);

    public abstract void putColumn2(Matrix4f var1, Vector4f var2);

    public abstract void putColumn3(Matrix4f var1, Vector4f var2);

    public abstract void broadcast(float var1, Vector4f var2);

    public abstract void broadcast(int var1, Vector4i var2);

    public static final class MemUtilUnsafe
    extends MemUtil {
        private static final Unsafe UNSAFE = MemUtilUnsafe.getUnsafeInstance();
        private static final long ADDRESS;
        private static final long Matrix3f_m00;
        private static final long Matrix4f_m00;
        private static final long Matrix4x3f_m00;
        private static final long Vector4f_x;
        private static final long Vector4d_x;
        private static final long Vector4i_x;
        private static final long Vector3f_x;
        private static final long Quaternionf_x;
        private static final long floatArrayOffset;

        public MemUtilUnsafe UNSAFE() {
            return this;
        }

        private static long checkMatrix4f() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Matrix4f == null ? (class$org$joml$Matrix4f = MemUtil.class$("org.joml.Matrix4f")) : class$org$joml$Matrix4f).getDeclaredField("m00");
            long Matrix4f_m00 = UNSAFE.objectFieldOffset(f);
            for (int i = 1; i < 16; ++i) {
                int c = i >>> 2;
                int r = i & 3;
                f = (class$org$joml$Matrix4f == null ? MemUtil.class$("org.joml.Matrix4f") : class$org$joml$Matrix4f).getDeclaredField("m" + c + r);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Matrix4f_m00 + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Matrix4f_m00;
        }

        private static long checkMatrix4x3f() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Matrix4x3f == null ? (class$org$joml$Matrix4x3f = MemUtil.class$("org.joml.Matrix4x3f")) : class$org$joml$Matrix4x3f).getDeclaredField("m00");
            long Matrix4x3f_m00 = UNSAFE.objectFieldOffset(f);
            for (int i = 1; i < 12; ++i) {
                int c = i / 3;
                int r = i % 3;
                f = (class$org$joml$Matrix4x3f == null ? MemUtil.class$("org.joml.Matrix4x3f") : class$org$joml$Matrix4x3f).getDeclaredField("m" + c + r);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Matrix4x3f_m00 + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Matrix4x3f_m00;
        }

        private static long checkMatrix3f() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Matrix3f == null ? (class$org$joml$Matrix3f = MemUtil.class$("org.joml.Matrix3f")) : class$org$joml$Matrix3f).getDeclaredField("m00");
            long Matrix3f_m00 = UNSAFE.objectFieldOffset(f);
            for (int i = 1; i < 9; ++i) {
                int c = i / 3;
                int r = i % 3;
                f = (class$org$joml$Matrix3f == null ? MemUtil.class$("org.joml.Matrix3f") : class$org$joml$Matrix3f).getDeclaredField("m" + c + r);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Matrix3f_m00 + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Matrix3f_m00;
        }

        private static long checkVector4f() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Vector4f == null ? (class$org$joml$Vector4f = MemUtil.class$("org.joml.Vector4f")) : class$org$joml$Vector4f).getDeclaredField("x");
            long Vector4f_x = UNSAFE.objectFieldOffset(f);
            String[] names = new String[]{"y", "z", "w"};
            for (int i = 1; i < 4; ++i) {
                f = (class$org$joml$Vector4f == null ? MemUtil.class$("org.joml.Vector4f") : class$org$joml$Vector4f).getDeclaredField(names[i - 1]);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Vector4f_x + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Vector4f_x;
        }

        private static long checkVector4d() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Vector4d == null ? (class$org$joml$Vector4d = MemUtil.class$("org.joml.Vector4d")) : class$org$joml$Vector4d).getDeclaredField("x");
            long Vector4d_x = UNSAFE.objectFieldOffset(f);
            String[] names = new String[]{"y", "z", "w"};
            for (int i = 1; i < 4; ++i) {
                f = (class$org$joml$Vector4d == null ? MemUtil.class$("org.joml.Vector4d") : class$org$joml$Vector4d).getDeclaredField(names[i - 1]);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Vector4d_x + (long)(i << 3)) continue;
                throw new UnsupportedOperationException();
            }
            return Vector4d_x;
        }

        private static long checkVector4i() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Vector4i == null ? (class$org$joml$Vector4i = MemUtil.class$("org.joml.Vector4i")) : class$org$joml$Vector4i).getDeclaredField("x");
            long Vector4i_x = UNSAFE.objectFieldOffset(f);
            String[] names = new String[]{"y", "z", "w"};
            for (int i = 1; i < 4; ++i) {
                f = (class$org$joml$Vector4i == null ? MemUtil.class$("org.joml.Vector4i") : class$org$joml$Vector4i).getDeclaredField(names[i - 1]);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Vector4i_x + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Vector4i_x;
        }

        private static long checkVector3f() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Vector3f == null ? (class$org$joml$Vector3f = MemUtil.class$("org.joml.Vector3f")) : class$org$joml$Vector3f).getDeclaredField("x");
            long Vector3f_x = UNSAFE.objectFieldOffset(f);
            String[] names = new String[]{"y", "z"};
            for (int i = 1; i < 3; ++i) {
                f = (class$org$joml$Vector3f == null ? MemUtil.class$("org.joml.Vector3f") : class$org$joml$Vector3f).getDeclaredField(names[i - 1]);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Vector3f_x + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Vector3f_x;
        }

        private static long checkQuaternionf() throws NoSuchFieldException, SecurityException {
            Field f = (class$org$joml$Quaternionf == null ? (class$org$joml$Quaternionf = MemUtil.class$("org.joml.Quaternionf")) : class$org$joml$Quaternionf).getDeclaredField("x");
            long Quaternionf_x = UNSAFE.objectFieldOffset(f);
            String[] names = new String[]{"y", "z", "w"};
            for (int i = 1; i < 4; ++i) {
                f = (class$org$joml$Quaternionf == null ? MemUtil.class$("org.joml.Quaternionf") : class$org$joml$Quaternionf).getDeclaredField(names[i - 1]);
                long offset = UNSAFE.objectFieldOffset(f);
                if (offset == Quaternionf_x + (long)(i << 2)) continue;
                throw new UnsupportedOperationException();
            }
            return Quaternionf_x;
        }

        private static final Field getDeclaredField(Class root, String fieldName) throws NoSuchFieldException {
            Class type = root;
            do {
                try {
                    Field field = type.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field;
                }
                catch (NoSuchFieldException e) {
                    type = type.getSuperclass();
                }
                catch (SecurityException e) {
                    type = type.getSuperclass();
                }
            } while (type != null);
            throw new NoSuchFieldException(fieldName + " does not exist in " + root.getName() + " or any of its superclasses.");
        }

        private static final Unsafe getUnsafeInstance() throws SecurityException {
            Field[] fields = (class$sun$misc$Unsafe == null ? (class$sun$misc$Unsafe = MemUtil.class$("sun.misc.Unsafe")) : class$sun$misc$Unsafe).getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                int modifiers;
                Field field = fields[i];
                if (!field.getType().equals(class$sun$misc$Unsafe == null ? MemUtil.class$("sun.misc.Unsafe") : class$sun$misc$Unsafe) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers)) continue;
                field.setAccessible(true);
                try {
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break;
                }
            }
            throw new UnsupportedOperationException();
        }

        public final long addressOf(Buffer buffer) {
            return UNSAFE.getLong(buffer, ADDRESS);
        }

        public final void put(Matrix4f m, long destAddr) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 3), UNSAFE.getLong(m, Matrix4f_m00 + (long)(i << 3)));
            }
        }

        public final void put(Matrix4x3f m, long destAddr) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 3), UNSAFE.getLong(m, Matrix4x3f_m00 + (long)(i << 3)));
            }
        }

        public final void put4x4(Matrix4x3f m, long destAddr) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 4), UNSAFE.getLong(m, Matrix4x3f_m00 + (long)(12 * i)));
                long lng = (long)UNSAFE.getInt(m, Matrix4x3f_m00 + 8L + (long)(12 * i)) & 0xFFFFFFFFL;
                UNSAFE.putOrderedLong(null, destAddr + 8L + (long)(i << 4), lng);
            }
            UNSAFE.putFloat(null, destAddr + 60L, 1.0f);
        }

        public final void putTransposed(Matrix4f m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, m.m32);
            UNSAFE.putFloat(null, destAddr + 48L, m.m03);
            UNSAFE.putFloat(null, destAddr + 52L, m.m13);
            UNSAFE.putFloat(null, destAddr + 56L, m.m23);
            UNSAFE.putFloat(null, destAddr + 60L, m.m33);
        }

        public final void put4x3Transposed(Matrix4f m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, m.m32);
        }

        public final void putTransposed(Matrix4x3f m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, m.m32);
        }

        public final void put(Matrix4d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m01);
            UNSAFE.putDouble(null, destAddr + 16L, m.m02);
            UNSAFE.putDouble(null, destAddr + 24L, m.m03);
            UNSAFE.putDouble(null, destAddr + 32L, m.m10);
            UNSAFE.putDouble(null, destAddr + 40L, m.m11);
            UNSAFE.putDouble(null, destAddr + 48L, m.m12);
            UNSAFE.putDouble(null, destAddr + 56L, m.m13);
            UNSAFE.putDouble(null, destAddr + 64L, m.m20);
            UNSAFE.putDouble(null, destAddr + 72L, m.m21);
            UNSAFE.putDouble(null, destAddr + 80L, m.m22);
            UNSAFE.putDouble(null, destAddr + 88L, m.m23);
            UNSAFE.putDouble(null, destAddr + 96L, m.m30);
            UNSAFE.putDouble(null, destAddr + 104L, m.m31);
            UNSAFE.putDouble(null, destAddr + 112L, m.m32);
            UNSAFE.putDouble(null, destAddr + 120L, m.m33);
        }

        public final void put(Matrix4x3d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m01);
            UNSAFE.putDouble(null, destAddr + 16L, m.m02);
            UNSAFE.putDouble(null, destAddr + 24L, m.m10);
            UNSAFE.putDouble(null, destAddr + 32L, m.m11);
            UNSAFE.putDouble(null, destAddr + 40L, m.m12);
            UNSAFE.putDouble(null, destAddr + 48L, m.m20);
            UNSAFE.putDouble(null, destAddr + 56L, m.m21);
            UNSAFE.putDouble(null, destAddr + 64L, m.m22);
            UNSAFE.putDouble(null, destAddr + 72L, m.m30);
            UNSAFE.putDouble(null, destAddr + 80L, m.m31);
            UNSAFE.putDouble(null, destAddr + 88L, m.m32);
        }

        public final void putTransposed(Matrix4d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m10);
            UNSAFE.putDouble(null, destAddr + 16L, m.m20);
            UNSAFE.putDouble(null, destAddr + 24L, m.m30);
            UNSAFE.putDouble(null, destAddr + 32L, m.m01);
            UNSAFE.putDouble(null, destAddr + 40L, m.m11);
            UNSAFE.putDouble(null, destAddr + 48L, m.m21);
            UNSAFE.putDouble(null, destAddr + 56L, m.m31);
            UNSAFE.putDouble(null, destAddr + 64L, m.m02);
            UNSAFE.putDouble(null, destAddr + 72L, m.m12);
            UNSAFE.putDouble(null, destAddr + 80L, m.m22);
            UNSAFE.putDouble(null, destAddr + 88L, m.m32);
            UNSAFE.putDouble(null, destAddr + 96L, m.m03);
            UNSAFE.putDouble(null, destAddr + 104L, m.m13);
            UNSAFE.putDouble(null, destAddr + 112L, m.m23);
            UNSAFE.putDouble(null, destAddr + 120L, m.m33);
        }

        public final void putfTransposed(Matrix4d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, (float)m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, (float)m.m32);
            UNSAFE.putFloat(null, destAddr + 48L, (float)m.m03);
            UNSAFE.putFloat(null, destAddr + 52L, (float)m.m13);
            UNSAFE.putFloat(null, destAddr + 56L, (float)m.m23);
            UNSAFE.putFloat(null, destAddr + 60L, (float)m.m33);
        }

        public final void put4x3Transposed(Matrix4d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m10);
            UNSAFE.putDouble(null, destAddr + 16L, m.m20);
            UNSAFE.putDouble(null, destAddr + 24L, m.m30);
            UNSAFE.putDouble(null, destAddr + 32L, m.m01);
            UNSAFE.putDouble(null, destAddr + 40L, m.m11);
            UNSAFE.putDouble(null, destAddr + 48L, m.m21);
            UNSAFE.putDouble(null, destAddr + 56L, m.m31);
            UNSAFE.putDouble(null, destAddr + 64L, m.m02);
            UNSAFE.putDouble(null, destAddr + 72L, m.m12);
            UNSAFE.putDouble(null, destAddr + 80L, m.m22);
            UNSAFE.putDouble(null, destAddr + 88L, m.m32);
        }

        public final void putTransposed(Matrix4x3d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m10);
            UNSAFE.putDouble(null, destAddr + 16L, m.m20);
            UNSAFE.putDouble(null, destAddr + 24L, m.m30);
            UNSAFE.putDouble(null, destAddr + 32L, m.m01);
            UNSAFE.putDouble(null, destAddr + 40L, m.m11);
            UNSAFE.putDouble(null, destAddr + 48L, m.m21);
            UNSAFE.putDouble(null, destAddr + 56L, m.m31);
            UNSAFE.putDouble(null, destAddr + 64L, m.m02);
            UNSAFE.putDouble(null, destAddr + 72L, m.m12);
            UNSAFE.putDouble(null, destAddr + 80L, m.m22);
            UNSAFE.putDouble(null, destAddr + 88L, m.m32);
        }

        public final void putfTransposed(Matrix4x3d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m30);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m31);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 36L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 40L, (float)m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, (float)m.m32);
        }

        public final void putf(Matrix4d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m03);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m13);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 36L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 40L, (float)m.m22);
            UNSAFE.putFloat(null, destAddr + 44L, (float)m.m23);
            UNSAFE.putFloat(null, destAddr + 48L, (float)m.m30);
            UNSAFE.putFloat(null, destAddr + 52L, (float)m.m31);
            UNSAFE.putFloat(null, destAddr + 56L, (float)m.m32);
            UNSAFE.putFloat(null, destAddr + 60L, (float)m.m33);
        }

        public final void putf(Matrix4x3d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m22);
            UNSAFE.putFloat(null, destAddr + 36L, (float)m.m30);
            UNSAFE.putFloat(null, destAddr + 40L, (float)m.m31);
            UNSAFE.putFloat(null, destAddr + 44L, (float)m.m32);
        }

        public final void put(Matrix3f m, long destAddr) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 3), UNSAFE.getLong(m, Matrix3f_m00 + (long)(i << 3)));
            }
            UNSAFE.putFloat(null, destAddr + 32L, m.m22);
        }

        public final void put(Matrix3d m, long destAddr) {
            UNSAFE.putDouble(null, destAddr, m.m00);
            UNSAFE.putDouble(null, destAddr + 8L, m.m01);
            UNSAFE.putDouble(null, destAddr + 16L, m.m02);
            UNSAFE.putDouble(null, destAddr + 24L, m.m10);
            UNSAFE.putDouble(null, destAddr + 32L, m.m11);
            UNSAFE.putDouble(null, destAddr + 40L, m.m12);
            UNSAFE.putDouble(null, destAddr + 48L, m.m20);
            UNSAFE.putDouble(null, destAddr + 56L, m.m21);
            UNSAFE.putDouble(null, destAddr + 64L, m.m22);
        }

        public final void putf(Matrix3d m, long destAddr) {
            UNSAFE.putFloat(null, destAddr, (float)m.m00);
            UNSAFE.putFloat(null, destAddr + 4L, (float)m.m01);
            UNSAFE.putFloat(null, destAddr + 8L, (float)m.m02);
            UNSAFE.putFloat(null, destAddr + 12L, (float)m.m10);
            UNSAFE.putFloat(null, destAddr + 16L, (float)m.m11);
            UNSAFE.putFloat(null, destAddr + 20L, (float)m.m12);
            UNSAFE.putFloat(null, destAddr + 24L, (float)m.m20);
            UNSAFE.putFloat(null, destAddr + 28L, (float)m.m21);
            UNSAFE.putFloat(null, destAddr + 32L, (float)m.m22);
        }

        public final void put(Vector4d src, long destAddr) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(null, destAddr + (long)(i << 3), UNSAFE.getLong(src, Vector4d_x + (long)(i << 3)));
            }
        }

        public final void put(Vector4f src, long destAddr) {
            UNSAFE.putOrderedLong(null, destAddr, UNSAFE.getLong(src, Vector4f_x));
            UNSAFE.putOrderedLong(null, destAddr + 8L, UNSAFE.getLong(src, Vector4f_x + 8L));
        }

        public final void put(Vector4i src, long destAddr) {
            UNSAFE.putOrderedLong(null, destAddr, UNSAFE.getLong(src, Vector4i_x));
            UNSAFE.putOrderedLong(null, destAddr + 8L, UNSAFE.getLong(src, Vector4i_x + 8L));
        }

        public final void put(Vector3f src, long destAddr) {
            UNSAFE.putOrderedLong(null, destAddr, UNSAFE.getLong(src, Vector4f_x));
            UNSAFE.putFloat(null, destAddr + 8L, UNSAFE.getFloat(src, Vector4f_x + 8L));
        }

        public final void get(Matrix4f m, long srcAddr) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(m, Matrix4f_m00 + (long)(i << 3), UNSAFE.getLong(srcAddr + (long)(i << 3)));
            }
        }

        public final void get(Matrix4x3f m, long srcAddr) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(m, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(srcAddr + (long)(i << 3)));
            }
        }

        public final void get(Matrix4d m, long srcAddr) {
            m.m00 = UNSAFE.getDouble(null, srcAddr);
            m.m01 = UNSAFE.getDouble(null, srcAddr + 8L);
            m.m02 = UNSAFE.getDouble(null, srcAddr + 16L);
            m.m03 = UNSAFE.getDouble(null, srcAddr + 24L);
            m.m10 = UNSAFE.getDouble(null, srcAddr + 32L);
            m.m11 = UNSAFE.getDouble(null, srcAddr + 40L);
            m.m12 = UNSAFE.getDouble(null, srcAddr + 48L);
            m.m13 = UNSAFE.getDouble(null, srcAddr + 56L);
            m.m20 = UNSAFE.getDouble(null, srcAddr + 64L);
            m.m21 = UNSAFE.getDouble(null, srcAddr + 72L);
            m.m22 = UNSAFE.getDouble(null, srcAddr + 80L);
            m.m23 = UNSAFE.getDouble(null, srcAddr + 88L);
            m.m30 = UNSAFE.getDouble(null, srcAddr + 96L);
            m.m31 = UNSAFE.getDouble(null, srcAddr + 104L);
            m.m32 = UNSAFE.getDouble(null, srcAddr + 112L);
            m.m33 = UNSAFE.getDouble(null, srcAddr + 120L);
        }

        public final void get(Matrix4x3d m, long srcAddr) {
            m.m00 = UNSAFE.getDouble(null, srcAddr);
            m.m01 = UNSAFE.getDouble(null, srcAddr + 8L);
            m.m02 = UNSAFE.getDouble(null, srcAddr + 16L);
            m.m10 = UNSAFE.getDouble(null, srcAddr + 24L);
            m.m11 = UNSAFE.getDouble(null, srcAddr + 32L);
            m.m12 = UNSAFE.getDouble(null, srcAddr + 40L);
            m.m20 = UNSAFE.getDouble(null, srcAddr + 48L);
            m.m21 = UNSAFE.getDouble(null, srcAddr + 56L);
            m.m22 = UNSAFE.getDouble(null, srcAddr + 64L);
            m.m30 = UNSAFE.getDouble(null, srcAddr + 72L);
            m.m31 = UNSAFE.getDouble(null, srcAddr + 80L);
            m.m32 = UNSAFE.getDouble(null, srcAddr + 88L);
        }

        public final void getf(Matrix4d m, long srcAddr) {
            m.m00 = UNSAFE.getFloat(null, srcAddr);
            m.m01 = UNSAFE.getFloat(null, srcAddr + 4L);
            m.m02 = UNSAFE.getFloat(null, srcAddr + 8L);
            m.m03 = UNSAFE.getFloat(null, srcAddr + 12L);
            m.m10 = UNSAFE.getFloat(null, srcAddr + 16L);
            m.m11 = UNSAFE.getFloat(null, srcAddr + 20L);
            m.m12 = UNSAFE.getFloat(null, srcAddr + 24L);
            m.m13 = UNSAFE.getFloat(null, srcAddr + 28L);
            m.m20 = UNSAFE.getFloat(null, srcAddr + 32L);
            m.m21 = UNSAFE.getFloat(null, srcAddr + 36L);
            m.m22 = UNSAFE.getFloat(null, srcAddr + 40L);
            m.m23 = UNSAFE.getFloat(null, srcAddr + 44L);
            m.m30 = UNSAFE.getFloat(null, srcAddr + 48L);
            m.m31 = UNSAFE.getFloat(null, srcAddr + 52L);
            m.m32 = UNSAFE.getFloat(null, srcAddr + 56L);
            m.m33 = UNSAFE.getFloat(null, srcAddr + 60L);
        }

        public final void getf(Matrix4x3d m, long srcAddr) {
            m.m00 = UNSAFE.getFloat(null, srcAddr);
            m.m01 = UNSAFE.getFloat(null, srcAddr + 4L);
            m.m02 = UNSAFE.getFloat(null, srcAddr + 8L);
            m.m10 = UNSAFE.getFloat(null, srcAddr + 12L);
            m.m11 = UNSAFE.getFloat(null, srcAddr + 16L);
            m.m12 = UNSAFE.getFloat(null, srcAddr + 20L);
            m.m20 = UNSAFE.getFloat(null, srcAddr + 24L);
            m.m21 = UNSAFE.getFloat(null, srcAddr + 28L);
            m.m22 = UNSAFE.getFloat(null, srcAddr + 32L);
            m.m30 = UNSAFE.getFloat(null, srcAddr + 36L);
            m.m31 = UNSAFE.getFloat(null, srcAddr + 40L);
            m.m32 = UNSAFE.getFloat(null, srcAddr + 44L);
        }

        public final void get(Matrix3f m, long srcAddr) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(m, Matrix3f_m00 + (long)(i << 3), UNSAFE.getLong(null, srcAddr + (long)(i << 3)));
            }
            m.m22 = UNSAFE.getFloat(null, srcAddr + 32L);
        }

        public final void get(Matrix3d m, long srcAddr) {
            m.m00 = UNSAFE.getDouble(null, srcAddr);
            m.m01 = UNSAFE.getDouble(null, srcAddr + 8L);
            m.m02 = UNSAFE.getDouble(null, srcAddr + 16L);
            m.m10 = UNSAFE.getDouble(null, srcAddr + 24L);
            m.m11 = UNSAFE.getDouble(null, srcAddr + 32L);
            m.m12 = UNSAFE.getDouble(null, srcAddr + 40L);
            m.m20 = UNSAFE.getDouble(null, srcAddr + 48L);
            m.m21 = UNSAFE.getDouble(null, srcAddr + 56L);
            m.m22 = UNSAFE.getDouble(null, srcAddr + 64L);
        }

        public final void getf(Matrix3d m, long srcAddr) {
            m.m00 = UNSAFE.getFloat(null, srcAddr);
            m.m01 = UNSAFE.getFloat(null, srcAddr + 4L);
            m.m02 = UNSAFE.getFloat(null, srcAddr + 8L);
            m.m10 = UNSAFE.getFloat(null, srcAddr + 12L);
            m.m11 = UNSAFE.getFloat(null, srcAddr + 16L);
            m.m12 = UNSAFE.getFloat(null, srcAddr + 20L);
            m.m20 = UNSAFE.getFloat(null, srcAddr + 24L);
            m.m21 = UNSAFE.getFloat(null, srcAddr + 28L);
            m.m22 = UNSAFE.getFloat(null, srcAddr + 32L);
        }

        public final void get(Vector4d dst, long srcAddr) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dst, Vector4d_x + (long)(i << 3), UNSAFE.getLong(null, srcAddr + (long)(i << 3)));
            }
        }

        public final void get(Vector4f dst, long srcAddr) {
            UNSAFE.putOrderedLong(dst, Vector4f_x, UNSAFE.getLong(null, srcAddr));
            UNSAFE.putOrderedLong(dst, Vector4f_x + 8L, UNSAFE.getLong(null, srcAddr + 8L));
        }

        public final void get(Vector4i dst, long srcAddr) {
            UNSAFE.putOrderedLong(dst, Vector4i_x, UNSAFE.getLong(null, srcAddr));
            UNSAFE.putOrderedLong(dst, Vector4i_x + 8L, UNSAFE.getLong(null, srcAddr + 8L));
        }

        public final void get(Vector3f dst, long srcAddr) {
            UNSAFE.putOrderedLong(dst, Vector4f_x, UNSAFE.getLong(null, srcAddr));
            UNSAFE.putFloat(dst, Vector4f_x + 8L, UNSAFE.getFloat(null, srcAddr + 8L));
        }

        public final void copy(Matrix4f src, Matrix4f dest) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 3)));
            }
        }

        public final void copy(Matrix3f src, Matrix4f dest) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix3f_m00 + (long)(12 * i)));
                long lng = (long)UNSAFE.getInt(src, Matrix3f_m00 + 8L + (long)(12 * i)) & 0xFFFFFFFFL;
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 8L + (long)(i << 4), lng);
            }
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 48L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 56L, 4575657221408423936L);
        }

        public final void copy(Matrix4f src, Matrix3f dest) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix3f_m00 + (long)(12 * i), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 4)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
        }

        public final void copy(Matrix3f src, Matrix4x3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix3f_m00 + (long)(i << 3)));
            }
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 32L, (long)UNSAFE.getInt(src, Matrix3f_m00 + 32L) & 0xFFFFFFFFL);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 40L, 0L);
        }

        public final void copy3x3(Matrix4f src, Matrix4f dest) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 4)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
        }

        public final void copy3x3(Matrix4x3f src, Matrix4x3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix4x3f_m00 + (long)(i << 3)));
            }
            dest.m22 = src.m22;
        }

        public final void copy3x3(Matrix3f src, Matrix4x3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix3f_m00 + (long)(i << 3)));
            }
            dest.m22 = src.m22;
        }

        public final void copy3x3(Matrix3f src, Matrix4f dest) {
            for (int i = 0; i < 3; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix3f_m00 + (long)(12 * i)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
        }

        public final void copy4x3(Matrix4x3f src, Matrix4f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix4x3f_m00 + (long)(12 * i)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
            dest.m32 = src.m32;
        }

        public final void copy4x3(Matrix4f src, Matrix4f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 4)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
            dest.m32 = src.m32;
        }

        public final void copy(Matrix4f src, Matrix4x3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(12 * i), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 4)));
            }
            dest.m02 = src.m02;
            dest.m12 = src.m12;
            dest.m22 = src.m22;
            dest.m32 = src.m32;
        }

        public final void copy(Matrix4x3f src, Matrix4f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 4), UNSAFE.getLong(src, Matrix4x3f_m00 + (long)(12 * i)));
            }
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 8L, (long)UNSAFE.getInt(src, Matrix4x3f_m00 + 8L) & 0xFFFFFFFFL);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 24L, (long)UNSAFE.getInt(src, Matrix4x3f_m00 + 20L) & 0xFFFFFFFFL);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 40L, (long)UNSAFE.getInt(src, Matrix4x3f_m00 + 32L) & 0xFFFFFFFFL);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 56L, 0x3F80000000000000L | (long)UNSAFE.getInt(src, Matrix4x3f_m00 + 44L) & 0xFFFFFFFFL);
        }

        public final void copy(Matrix4x3f src, Matrix4x3f dest) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix4x3f_m00 + (long)(i << 3)));
            }
        }

        public final void copy(Matrix3f src, Matrix3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix3f_m00 + (long)(i << 3), UNSAFE.getLong(src, Matrix3f_m00 + (long)(i << 3)));
            }
            dest.m22 = src.m22;
        }

        public final void copy(Vector4f src, Vector4f dest) {
            UNSAFE.putOrderedLong(dest, Vector4f_x, UNSAFE.getLong(src, Vector4f_x));
            UNSAFE.putOrderedLong(dest, Vector4f_x + 8L, UNSAFE.getLong(src, Vector4f_x + 8L));
        }

        public final void copy(Vector4i src, Vector4i dest) {
            UNSAFE.putOrderedLong(dest, Vector4i_x, UNSAFE.getLong(src, Vector4i_x));
            UNSAFE.putOrderedLong(dest, Vector4i_x + 8L, UNSAFE.getLong(src, Vector4i_x + 8L));
        }

        public final void copy(Quaternionf src, Quaternionf dest) {
            UNSAFE.putOrderedLong(dest, Quaternionf_x, UNSAFE.getLong(src, Quaternionf_x));
            UNSAFE.putOrderedLong(dest, Quaternionf_x + 8L, UNSAFE.getLong(src, Quaternionf_x + 8L));
        }

        public final void copy(float[] arr, int off, Matrix4f dest) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 3), UNSAFE.getLong(arr, floatArrayOffset + (long)(off << 2) + (long)(i << 3)));
            }
        }

        public final void copy(float[] arr, int off, Matrix3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix3f_m00 + (long)(i << 3), UNSAFE.getLong(arr, floatArrayOffset + (long)(off << 2) + (long)(i << 3)));
            }
            UNSAFE.putFloat(dest, Matrix3f_m00 + 32L, UNSAFE.getFloat(arr, floatArrayOffset + (long)(off << 2) + 32L));
        }

        public final void copy(float[] arr, int off, Matrix4x3f dest) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(arr, floatArrayOffset + (long)(off << 2) + (long)(i << 3)));
            }
        }

        public final void copy(Matrix4f src, float[] dest, int off) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(dest, floatArrayOffset + (long)(off << 2) + (long)(i << 3), UNSAFE.getLong(src, Matrix4f_m00 + (long)(i << 3)));
            }
        }

        public final void copy(Matrix3f src, float[] dest, int off) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, floatArrayOffset + (long)(off << 2) + (long)(i << 3), UNSAFE.getLong(src, Matrix3f_m00 + (long)(i << 3)));
            }
            UNSAFE.putFloat(dest, floatArrayOffset + (long)(off << 2) + 32L, UNSAFE.getLong(src, Matrix3f_m00 + 32L));
        }

        public final void copy(Matrix4x3f src, float[] dest, int off) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(dest, floatArrayOffset + (long)(off << 2) + (long)(i << 3), UNSAFE.getLong(src, Matrix4x3f_m00 + (long)(i << 3)));
            }
        }

        public final void identity(Matrix4f dest) {
            UNSAFE.putOrderedLong(dest, Matrix4f_m00, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 8L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 16L, 4575657221408423936L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 24L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 32L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 40L, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 48L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4f_m00 + 56L, 4575657221408423936L);
        }

        public final void identity(Matrix4x3f dest) {
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 8L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 16L, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 24L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 32L, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + 40L, 0L);
        }

        public final void identity(Matrix3f dest) {
            UNSAFE.putOrderedLong(dest, Matrix3f_m00, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix3f_m00 + 8L, 0L);
            UNSAFE.putOrderedLong(dest, Matrix3f_m00 + 16L, 1065353216L);
            UNSAFE.putOrderedLong(dest, Matrix3f_m00 + 24L, 0L);
            dest.m22 = 1.0f;
        }

        public final void identity(Quaternionf dest) {
            UNSAFE.putOrderedLong(dest, Quaternionf_x, 0L);
            UNSAFE.putOrderedLong(dest, Quaternionf_x + 8L, 4575657221408423936L);
        }

        public final void swap(Matrix4f m1, Matrix4f m2) {
            for (int i = 0; i < 8; ++i) {
                long tmp = UNSAFE.getLong(m1, Matrix4f_m00 + (long)(i << 3));
                UNSAFE.putOrderedLong(m1, Matrix4f_m00 + (long)(i << 3), UNSAFE.getLong(m2, Matrix4f_m00 + (long)(i << 3)));
                UNSAFE.putOrderedLong(m2, Matrix4f_m00 + (long)(i << 3), tmp);
            }
        }

        public final void swap(Matrix4x3f m1, Matrix4x3f m2) {
            for (int i = 0; i < 6; ++i) {
                long tmp = UNSAFE.getLong(m1, Matrix4x3f_m00 + (long)(i << 3));
                UNSAFE.putOrderedLong(m1, Matrix4x3f_m00 + (long)(i << 3), UNSAFE.getLong(m2, Matrix4x3f_m00 + (long)(i << 3)));
                UNSAFE.putOrderedLong(m2, Matrix4x3f_m00 + (long)(i << 3), tmp);
            }
        }

        public final void swap(Matrix3f m1, Matrix3f m2) {
            for (int i = 0; i < 4; ++i) {
                long tmp = UNSAFE.getLong(m1, Matrix3f_m00 + (long)(i << 3));
                UNSAFE.putOrderedLong(m1, Matrix3f_m00 + (long)(i << 3), UNSAFE.getLong(m2, Matrix3f_m00 + (long)(i << 3)));
                UNSAFE.putOrderedLong(m2, Matrix3f_m00 + (long)(i << 3), tmp);
            }
            float tmp2 = m1.m22;
            m1.m22 = m2.m22;
            m2.m22 = tmp2;
        }

        public final void zero(Matrix4f dest) {
            for (int i = 0; i < 8; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4f_m00 + (long)(i << 3), 0L);
            }
        }

        public final void zero(Matrix4x3f dest) {
            for (int i = 0; i < 6; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix4x3f_m00 + (long)(i << 3), 0L);
            }
        }

        public final void zero(Matrix3f dest) {
            for (int i = 0; i < 4; ++i) {
                UNSAFE.putOrderedLong(dest, Matrix3f_m00 + (long)(i << 3), 0L);
            }
            dest.m22 = 0.0f;
        }

        public final void zero(Vector4f dest) {
            UNSAFE.putOrderedLong(dest, Vector4f_x, 0L);
            UNSAFE.putOrderedLong(dest, Vector4f_x + 8L, 0L);
        }

        public final void zero(Vector4i dest) {
            UNSAFE.putOrderedLong(dest, Vector4i_x, 0L);
            UNSAFE.putOrderedLong(dest, Vector4i_x + 8L, 0L);
        }

        private void putMatrix3f(Quaternionf q, long addr) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            UNSAFE.putFloat(null, addr, 1.0f - q11 - q22);
            UNSAFE.putFloat(null, addr + 4L, q01 + q23);
            UNSAFE.putFloat(null, addr + 8L, q02 - q13);
            UNSAFE.putFloat(null, addr + 12L, q01 - q23);
            UNSAFE.putFloat(null, addr + 16L, 1.0f - q22 - q00);
            UNSAFE.putFloat(null, addr + 20L, q12 + q03);
            UNSAFE.putFloat(null, addr + 24L, q02 + q13);
            UNSAFE.putFloat(null, addr + 28L, q12 - q03);
            UNSAFE.putFloat(null, addr + 32L, 1.0f - q11 - q00);
        }

        private void putMatrix4f(Quaternionf q, long addr) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            UNSAFE.putFloat(null, addr, 1.0f - q11 - q22);
            UNSAFE.putFloat(null, addr + 4L, q01 + q23);
            UNSAFE.putOrderedLong(null, addr + 8L, (long)Float.floatToRawIntBits(q02 - q13) & 0xFFFFFFFFL);
            UNSAFE.putFloat(null, addr + 16L, q01 - q23);
            UNSAFE.putFloat(null, addr + 20L, 1.0f - q22 - q00);
            UNSAFE.putOrderedLong(null, addr + 24L, (long)Float.floatToRawIntBits(q12 + q03) & 0xFFFFFFFFL);
            UNSAFE.putFloat(null, addr + 32L, q02 + q13);
            UNSAFE.putFloat(null, addr + 36L, q12 - q03);
            UNSAFE.putOrderedLong(null, addr + 40L, (long)Float.floatToRawIntBits(1.0f - q11 - q00) & 0xFFFFFFFFL);
            UNSAFE.putOrderedLong(null, addr + 48L, 0L);
            UNSAFE.putOrderedLong(null, addr + 56L, 4575657221408423936L);
        }

        private void putMatrix4x3f(Quaternionf q, long addr) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            UNSAFE.putFloat(null, addr, 1.0f - q11 - q22);
            UNSAFE.putFloat(null, addr + 4L, q01 + q23);
            UNSAFE.putFloat(null, addr + 8L, q02 - q13);
            UNSAFE.putFloat(null, addr + 12L, q01 - q23);
            UNSAFE.putFloat(null, addr + 16L, 1.0f - q22 - q00);
            UNSAFE.putFloat(null, addr + 20L, q12 + q03);
            UNSAFE.putFloat(null, addr + 24L, q02 + q13);
            UNSAFE.putFloat(null, addr + 28L, q12 - q03);
            UNSAFE.putFloat(null, addr + 32L, 1.0f - q11 - q00);
            UNSAFE.putOrderedLong(null, addr + 36L, 0L);
            UNSAFE.putFloat(null, addr + 44L, 0.0f);
        }

        public final void putMatrix3f(Quaternionf q, int position, ByteBuffer dest) {
            long addr = this.addressOf(dest) + (long)position;
            this.putMatrix3f(q, addr);
        }

        public final void putMatrix3f(Quaternionf q, int position, FloatBuffer dest) {
            long addr = this.addressOf(dest) + (long)(position << 2);
            this.putMatrix3f(q, addr);
        }

        public final void putMatrix4f(Quaternionf q, int position, ByteBuffer dest) {
            long addr = this.addressOf(dest) + (long)position;
            this.putMatrix4f(q, addr);
        }

        public final void putMatrix4f(Quaternionf q, int position, FloatBuffer dest) {
            long addr = this.addressOf(dest) + (long)(position << 2);
            this.putMatrix4f(q, addr);
        }

        public final void putMatrix4x3f(Quaternionf q, int position, ByteBuffer dest) {
            long addr = this.addressOf(dest) + (long)position;
            this.putMatrix4x3f(q, addr);
        }

        public final void putMatrix4x3f(Quaternionf q, int position, FloatBuffer dest) {
            long addr = this.addressOf(dest) + (long)(position << 2);
            this.putMatrix4x3f(q, addr);
        }

        public final void put(Matrix4f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void put(Matrix4f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        public final void put(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void put(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        public final void put4x4(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.put4x4(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void put4x4(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.put4x4(m, this.addressOf(dest) + (long)offset);
        }

        public final void putTransposed(Matrix4f m, int offset, FloatBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void putTransposed(Matrix4f m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        public final void put4x3Transposed(Matrix4f m, int offset, FloatBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void put4x3Transposed(Matrix4f m, int offset, ByteBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)offset);
        }

        public final void putTransposed(Matrix4x3f m, int offset, FloatBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void putTransposed(Matrix4x3f m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        public final void put(Matrix4d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        public final void put(Matrix4d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        public final void put(Matrix4x3d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        public final void put(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        public final void putf(Matrix4d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void putf(Matrix4d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        public final void putf(Matrix4x3d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void putf(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        public final void putTransposed(Matrix4d m, int offset, DoubleBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        public final void putTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        public final void put4x3Transposed(Matrix4d m, int offset, DoubleBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        public final void put4x3Transposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.put4x3Transposed(m, this.addressOf(dest) + (long)offset);
        }

        public final void putTransposed(Matrix4x3d m, int offset, DoubleBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)(offset << 3));
        }

        public final void putTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putTransposed(m, this.addressOf(dest) + (long)offset);
        }

        public final void putfTransposed(Matrix4d m, int offset, FloatBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void putfTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)offset);
        }

        public final void putfTransposed(Matrix4x3d m, int offset, FloatBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void putfTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            this.putfTransposed(m, this.addressOf(dest) + (long)offset);
        }

        public final void put(Matrix3f m, int offset, FloatBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void put(Matrix3f m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        public final void put(Matrix3d m, int offset, DoubleBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)(offset << 3));
        }

        public final void put(Matrix3d m, int offset, ByteBuffer dest) {
            this.put(m, this.addressOf(dest) + (long)offset);
        }

        public final void putf(Matrix3d m, int offset, FloatBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void putf(Matrix3d m, int offset, ByteBuffer dest) {
            this.putf(m, this.addressOf(dest) + (long)offset);
        }

        public final void put(Vector4d src, int offset, DoubleBuffer dest) {
            this.put(src, this.addressOf(dest) + (long)(offset << 3));
        }

        public final void put(Vector4d src, int offset, ByteBuffer dest) {
            this.put(src, this.addressOf(dest) + (long)offset);
        }

        public final void put(Vector4f src, int offset, FloatBuffer dest) {
            this.put(src, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void put(Vector4f src, int offset, ByteBuffer dest) {
            this.put(src, this.addressOf(dest) + (long)offset);
        }

        public final void put(Vector4i src, int offset, IntBuffer dest) {
            this.put(src, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void put(Vector4i src, int offset, ByteBuffer dest) {
            this.put(src, this.addressOf(dest) + (long)offset);
        }

        public final void put(Vector3f src, int offset, FloatBuffer dest) {
            this.put(src, this.addressOf(dest) + (long)(offset << 2));
        }

        public final void put(Vector3f src, int offset, ByteBuffer dest) {
            this.put(src, this.addressOf(dest) + (long)offset);
        }

        public final void get(Matrix4f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        public final void get(Matrix4f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        public final void get(Matrix4x3f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        public final void get(Matrix4x3f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        public final void get(Matrix4d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        public final void get(Matrix4d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        public final void get(Matrix4x3d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        public final void get(Matrix4x3d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        public final void getf(Matrix4d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        public final void getf(Matrix4d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }

        public final void getf(Matrix4x3d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        public final void getf(Matrix4x3d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }

        public final void get(Matrix3f m, int offset, FloatBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 2));
        }

        public final void get(Matrix3f m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        public final void get(Matrix3d m, int offset, DoubleBuffer src) {
            this.get(m, this.addressOf(src) + (long)(offset << 3));
        }

        public final void get(Matrix3d m, int offset, ByteBuffer src) {
            this.get(m, this.addressOf(src) + (long)offset);
        }

        public final void getf(Matrix3d m, int offset, FloatBuffer src) {
            this.getf(m, this.addressOf(src) + (long)(offset << 2));
        }

        public final void getf(Matrix3d m, int offset, ByteBuffer src) {
            this.getf(m, this.addressOf(src) + (long)offset);
        }

        public final void get(Vector4d dst, int offset, DoubleBuffer src) {
            this.get(dst, this.addressOf(src) + (long)(offset << 3));
        }

        public final void get(Vector4d dst, int offset, ByteBuffer src) {
            this.get(dst, this.addressOf(src) + (long)offset);
        }

        public final void get(Vector4f dst, int offset, FloatBuffer src) {
            this.get(dst, this.addressOf(src) + (long)(offset << 2));
        }

        public final void get(Vector4f dst, int offset, ByteBuffer src) {
            this.get(dst, this.addressOf(src) + (long)offset);
        }

        public final void get(Vector4i dst, int offset, IntBuffer src) {
            this.get(dst, this.addressOf(src) + (long)(offset << 2));
        }

        public final void get(Vector4i dst, int offset, ByteBuffer src) {
            this.get(dst, this.addressOf(src) + (long)offset);
        }

        public final void get(Vector3f dst, int offset, FloatBuffer src) {
            this.get(dst, this.addressOf(src) + (long)(offset << 2));
        }

        public final void get(Vector3f dst, int offset, ByteBuffer src) {
            this.get(dst, this.addressOf(src) + (long)offset);
        }

        public final void set(Matrix4f m, Vector4f col0, Vector4f col1, Vector4f col2, Vector4f col3) {
            UNSAFE.putOrderedLong(m, Matrix4f_m00, UNSAFE.getLong(col0, Vector4f_x));
            UNSAFE.putOrderedLong(m, Matrix4f_m00 + 8L, UNSAFE.getLong(col0, Vector4f_x + 8L));
            UNSAFE.putOrderedLong(m, Matrix4f_m00 + 16L, UNSAFE.getLong(col1, Vector4f_x));
            UNSAFE.putOrderedLong(m, Matrix4f_m00 + 24L, UNSAFE.getLong(col1, Vector4f_x + 8L));
            UNSAFE.putOrderedLong(m, Matrix4f_m00 + 32L, UNSAFE.getLong(col2, Vector4f_x));
            UNSAFE.putOrderedLong(m, Matrix4f_m00 + 40L, UNSAFE.getLong(col2, Vector4f_x + 8L));
            UNSAFE.putOrderedLong(m, Matrix4f_m00 + 48L, UNSAFE.getLong(col3, Vector4f_x));
            UNSAFE.putOrderedLong(m, Matrix4f_m00 + 56L, UNSAFE.getLong(col3, Vector4f_x + 8L));
        }

        public final void set(Matrix4x3f m, Vector3f col0, Vector3f col1, Vector3f col2, Vector3f col3) {
            UNSAFE.putOrderedLong(m, Matrix4x3f_m00, UNSAFE.getLong(col0, Vector3f_x));
            UNSAFE.putOrderedLong(m, Matrix4x3f_m00 + 12L, UNSAFE.getLong(col1, Vector3f_x));
            UNSAFE.putOrderedLong(m, Matrix4x3f_m00 + 24L, UNSAFE.getLong(col2, Vector3f_x));
            UNSAFE.putOrderedLong(m, Matrix4x3f_m00 + 36L, UNSAFE.getLong(col3, Vector3f_x));
            m.m02 = col0.z;
            m.m12 = col1.z;
            m.m22 = col2.z;
            m.m32 = col3.z;
        }

        public final void set(Matrix3f m, Vector3f col0, Vector3f col1, Vector3f col2) {
            UNSAFE.putOrderedLong(m, Matrix3f_m00, UNSAFE.getLong(col0, Vector3f_x));
            UNSAFE.putOrderedLong(m, Matrix3f_m00 + 12L, UNSAFE.getLong(col1, Vector3f_x));
            UNSAFE.putOrderedLong(m, Matrix3f_m00 + 24L, UNSAFE.getLong(col2, Vector3f_x));
            m.m02 = col0.z;
            m.m12 = col1.z;
            m.m22 = col2.z;
        }

        public final void putColumn0(Matrix4f src, Vector4f dest) {
            UNSAFE.putOrderedLong(dest, Vector4f_x, UNSAFE.getLong(src, Matrix4f_m00));
            UNSAFE.putOrderedLong(dest, Vector4f_x + 8L, UNSAFE.getLong(src, Matrix4f_m00 + 8L));
        }

        public final void putColumn1(Matrix4f src, Vector4f dest) {
            UNSAFE.putOrderedLong(dest, Vector4f_x, UNSAFE.getLong(src, Matrix4f_m00 + 16L));
            UNSAFE.putOrderedLong(dest, Vector4f_x + 8L, UNSAFE.getLong(src, Matrix4f_m00 + 24L));
        }

        public final void putColumn2(Matrix4f src, Vector4f dest) {
            UNSAFE.putOrderedLong(dest, Vector4f_x, UNSAFE.getLong(src, Matrix4f_m00 + 32L));
            UNSAFE.putOrderedLong(dest, Vector4f_x + 8L, UNSAFE.getLong(src, Matrix4f_m00 + 40L));
        }

        public final void putColumn3(Matrix4f src, Vector4f dest) {
            UNSAFE.putOrderedLong(dest, Vector4f_x, UNSAFE.getLong(src, Matrix4f_m00 + 48L));
            UNSAFE.putOrderedLong(dest, Vector4f_x + 8L, UNSAFE.getLong(src, Matrix4f_m00 + 56L));
        }

        public final void broadcast(float c, Vector4f dest) {
            int i = Float.floatToRawIntBits(c);
            long one = (long)i & 0xFFFFFFFFL;
            long two = one | one << 32;
            UNSAFE.putOrderedLong(dest, Vector4f_x, two);
            UNSAFE.putOrderedLong(dest, Vector4f_x + 8L, two);
        }

        public final void broadcast(int c, Vector4i dest) {
            long one = (long)c & 0xFFFFFFFFL;
            long two = one | one << 32;
            UNSAFE.putOrderedLong(dest, Vector4i_x, two);
            UNSAFE.putOrderedLong(dest, Vector4i_x + 8L, two);
        }

        static {
            try {
                ADDRESS = UNSAFE.objectFieldOffset(MemUtilUnsafe.getDeclaredField(class$java$nio$Buffer == null ? (class$java$nio$Buffer = MemUtil.class$("java.nio.Buffer")) : class$java$nio$Buffer, "address"));
                Matrix4f_m00 = MemUtilUnsafe.checkMatrix4f();
                Matrix4x3f_m00 = MemUtilUnsafe.checkMatrix4x3f();
                Matrix3f_m00 = MemUtilUnsafe.checkMatrix3f();
                Vector4f_x = MemUtilUnsafe.checkVector4f();
                Vector4d_x = MemUtilUnsafe.checkVector4d();
                Vector4i_x = MemUtilUnsafe.checkVector4i();
                Vector3f_x = MemUtilUnsafe.checkVector3f();
                Quaternionf_x = MemUtilUnsafe.checkQuaternionf();
                floatArrayOffset = UNSAFE.arrayBaseOffset(array$F == null ? (array$F = MemUtil.class$("[F")) : array$F);
                (class$sun$misc$Unsafe == null ? (class$sun$misc$Unsafe = MemUtil.class$("sun.misc.Unsafe")) : class$sun$misc$Unsafe).getDeclaredMethod("getLong", class$java$lang$Object == null ? (class$java$lang$Object = MemUtil.class$("java.lang.Object")) : class$java$lang$Object, Long.TYPE);
                (class$sun$misc$Unsafe == null ? (class$sun$misc$Unsafe = MemUtil.class$("sun.misc.Unsafe")) : class$sun$misc$Unsafe).getDeclaredMethod("putOrderedLong", class$java$lang$Object == null ? (class$java$lang$Object = MemUtil.class$("java.lang.Object")) : class$java$lang$Object, Long.TYPE, Long.TYPE);
            }
            catch (NoSuchFieldException e) {
                throw new UnsupportedOperationException();
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static final class MemUtilNIO
    extends MemUtil {
        public MemUtilUnsafe UNSAFE() {
            return null;
        }

        public final void put(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m03);
            dest.put(offset + 4, m.m10);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m12);
            dest.put(offset + 7, m.m13);
            dest.put(offset + 8, m.m20);
            dest.put(offset + 9, m.m21);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m23);
            dest.put(offset + 12, m.m30);
            dest.put(offset + 13, m.m31);
            dest.put(offset + 14, m.m32);
            dest.put(offset + 15, m.m33);
        }

        public final void put(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, m.m03);
            dest.putFloat(offset + 16, m.m10);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m12);
            dest.putFloat(offset + 28, m.m13);
            dest.putFloat(offset + 32, m.m20);
            dest.putFloat(offset + 36, m.m21);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, m.m23);
            dest.putFloat(offset + 48, m.m30);
            dest.putFloat(offset + 52, m.m31);
            dest.putFloat(offset + 56, m.m32);
            dest.putFloat(offset + 60, m.m33);
        }

        public final void put(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
            dest.put(offset + 9, m.m30);
            dest.put(offset + 10, m.m31);
            dest.put(offset + 11, m.m32);
        }

        public final void put(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, m.m10);
            dest.putFloat(offset + 16, m.m11);
            dest.putFloat(offset + 20, m.m12);
            dest.putFloat(offset + 24, m.m20);
            dest.putFloat(offset + 28, m.m21);
            dest.putFloat(offset + 32, m.m22);
            dest.putFloat(offset + 36, m.m30);
            dest.putFloat(offset + 40, m.m31);
            dest.putFloat(offset + 44, m.m32);
        }

        public final void put4x4(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, 0.0f);
            dest.put(offset + 4, m.m10);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m12);
            dest.put(offset + 7, 0.0f);
            dest.put(offset + 8, m.m20);
            dest.put(offset + 9, m.m21);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, 0.0f);
            dest.put(offset + 12, m.m30);
            dest.put(offset + 13, m.m31);
            dest.put(offset + 14, m.m32);
            dest.put(offset + 15, 1.0f);
        }

        public final void put4x4(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, 0.0f);
            dest.putFloat(offset + 16, m.m10);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m12);
            dest.putFloat(offset + 28, 0.0f);
            dest.putFloat(offset + 32, m.m20);
            dest.putFloat(offset + 36, m.m21);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, 0.0f);
            dest.putFloat(offset + 48, m.m30);
            dest.putFloat(offset + 52, m.m31);
            dest.putFloat(offset + 56, m.m32);
            dest.putFloat(offset + 60, 1.0f);
        }

        public final void putTransposed(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
            dest.put(offset + 12, m.m03);
            dest.put(offset + 13, m.m13);
            dest.put(offset + 14, m.m23);
            dest.put(offset + 15, m.m33);
        }

        public final void putTransposed(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m10);
            dest.putFloat(offset + 8, m.m20);
            dest.putFloat(offset + 12, m.m30);
            dest.putFloat(offset + 16, m.m01);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m21);
            dest.putFloat(offset + 28, m.m31);
            dest.putFloat(offset + 32, m.m02);
            dest.putFloat(offset + 36, m.m12);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, m.m32);
            dest.putFloat(offset + 48, m.m03);
            dest.putFloat(offset + 52, m.m13);
            dest.putFloat(offset + 56, m.m23);
            dest.putFloat(offset + 60, m.m33);
        }

        public final void put4x3Transposed(Matrix4f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
        }

        public final void put4x3Transposed(Matrix4f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m10);
            dest.putFloat(offset + 8, m.m20);
            dest.putFloat(offset + 12, m.m30);
            dest.putFloat(offset + 16, m.m01);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m21);
            dest.putFloat(offset + 28, m.m31);
            dest.putFloat(offset + 32, m.m02);
            dest.putFloat(offset + 36, m.m12);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, m.m32);
        }

        public final void putTransposed(Matrix4x3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
        }

        public final void putTransposed(Matrix4x3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m10);
            dest.putFloat(offset + 8, m.m20);
            dest.putFloat(offset + 12, m.m30);
            dest.putFloat(offset + 16, m.m01);
            dest.putFloat(offset + 20, m.m11);
            dest.putFloat(offset + 24, m.m21);
            dest.putFloat(offset + 28, m.m31);
            dest.putFloat(offset + 32, m.m02);
            dest.putFloat(offset + 36, m.m12);
            dest.putFloat(offset + 40, m.m22);
            dest.putFloat(offset + 44, m.m32);
        }

        public final void put(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m03);
            dest.put(offset + 4, m.m10);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m12);
            dest.put(offset + 7, m.m13);
            dest.put(offset + 8, m.m20);
            dest.put(offset + 9, m.m21);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m23);
            dest.put(offset + 12, m.m30);
            dest.put(offset + 13, m.m31);
            dest.put(offset + 14, m.m32);
            dest.put(offset + 15, m.m33);
        }

        public final void put(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 4, m.m01);
            dest.putDouble(offset + 8, m.m02);
            dest.putDouble(offset + 12, m.m03);
            dest.putDouble(offset + 16, m.m10);
            dest.putDouble(offset + 20, m.m11);
            dest.putDouble(offset + 24, m.m12);
            dest.putDouble(offset + 28, m.m13);
            dest.putDouble(offset + 32, m.m20);
            dest.putDouble(offset + 36, m.m21);
            dest.putDouble(offset + 40, m.m22);
            dest.putDouble(offset + 44, m.m23);
            dest.putDouble(offset + 48, m.m30);
            dest.putDouble(offset + 52, m.m31);
            dest.putDouble(offset + 56, m.m32);
            dest.putDouble(offset + 60, m.m33);
        }

        public final void put(Matrix4x3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
            dest.put(offset + 9, m.m30);
            dest.put(offset + 10, m.m31);
            dest.put(offset + 11, m.m32);
        }

        public final void put(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 4, m.m01);
            dest.putDouble(offset + 8, m.m02);
            dest.putDouble(offset + 12, m.m10);
            dest.putDouble(offset + 16, m.m11);
            dest.putDouble(offset + 20, m.m12);
            dest.putDouble(offset + 24, m.m20);
            dest.putDouble(offset + 28, m.m21);
            dest.putDouble(offset + 32, m.m22);
            dest.putDouble(offset + 36, m.m30);
            dest.putDouble(offset + 40, m.m31);
            dest.putDouble(offset + 44, m.m32);
        }

        public final void putf(Matrix4d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m01);
            dest.put(offset + 2, (float)m.m02);
            dest.put(offset + 3, (float)m.m03);
            dest.put(offset + 4, (float)m.m10);
            dest.put(offset + 5, (float)m.m11);
            dest.put(offset + 6, (float)m.m12);
            dest.put(offset + 7, (float)m.m13);
            dest.put(offset + 8, (float)m.m20);
            dest.put(offset + 9, (float)m.m21);
            dest.put(offset + 10, (float)m.m22);
            dest.put(offset + 11, (float)m.m23);
            dest.put(offset + 12, (float)m.m30);
            dest.put(offset + 13, (float)m.m31);
            dest.put(offset + 14, (float)m.m32);
            dest.put(offset + 15, (float)m.m33);
        }

        public final void putf(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m01);
            dest.putFloat(offset + 8, (float)m.m02);
            dest.putFloat(offset + 12, (float)m.m03);
            dest.putFloat(offset + 16, (float)m.m10);
            dest.putFloat(offset + 20, (float)m.m11);
            dest.putFloat(offset + 24, (float)m.m12);
            dest.putFloat(offset + 28, (float)m.m13);
            dest.putFloat(offset + 32, (float)m.m20);
            dest.putFloat(offset + 36, (float)m.m21);
            dest.putFloat(offset + 40, (float)m.m22);
            dest.putFloat(offset + 44, (float)m.m23);
            dest.putFloat(offset + 48, (float)m.m30);
            dest.putFloat(offset + 52, (float)m.m31);
            dest.putFloat(offset + 56, (float)m.m32);
            dest.putFloat(offset + 60, (float)m.m33);
        }

        public final void putf(Matrix4x3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m01);
            dest.put(offset + 2, (float)m.m02);
            dest.put(offset + 3, (float)m.m10);
            dest.put(offset + 4, (float)m.m11);
            dest.put(offset + 5, (float)m.m12);
            dest.put(offset + 6, (float)m.m20);
            dest.put(offset + 7, (float)m.m21);
            dest.put(offset + 8, (float)m.m22);
            dest.put(offset + 9, (float)m.m30);
            dest.put(offset + 10, (float)m.m31);
            dest.put(offset + 11, (float)m.m32);
        }

        public final void putf(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m01);
            dest.putFloat(offset + 8, (float)m.m02);
            dest.putFloat(offset + 12, (float)m.m10);
            dest.putFloat(offset + 16, (float)m.m11);
            dest.putFloat(offset + 20, (float)m.m12);
            dest.putFloat(offset + 24, (float)m.m20);
            dest.putFloat(offset + 28, (float)m.m21);
            dest.putFloat(offset + 32, (float)m.m22);
            dest.putFloat(offset + 36, (float)m.m30);
            dest.putFloat(offset + 40, (float)m.m31);
            dest.putFloat(offset + 44, (float)m.m32);
        }

        public final void putTransposed(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
            dest.put(offset + 12, m.m03);
            dest.put(offset + 13, m.m13);
            dest.put(offset + 14, m.m23);
            dest.put(offset + 15, m.m33);
        }

        public final void putTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 8, m.m10);
            dest.putDouble(offset + 16, m.m20);
            dest.putDouble(offset + 24, m.m30);
            dest.putDouble(offset + 32, m.m01);
            dest.putDouble(offset + 40, m.m11);
            dest.putDouble(offset + 48, m.m21);
            dest.putDouble(offset + 56, m.m31);
            dest.putDouble(offset + 64, m.m02);
            dest.putDouble(offset + 72, m.m12);
            dest.putDouble(offset + 80, m.m22);
            dest.putDouble(offset + 88, m.m32);
            dest.putDouble(offset + 96, m.m03);
            dest.putDouble(offset + 104, m.m13);
            dest.putDouble(offset + 112, m.m23);
            dest.putDouble(offset + 120, m.m33);
        }

        public final void put4x3Transposed(Matrix4d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
        }

        public final void put4x3Transposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 8, m.m10);
            dest.putDouble(offset + 16, m.m20);
            dest.putDouble(offset + 24, m.m30);
            dest.putDouble(offset + 32, m.m01);
            dest.putDouble(offset + 40, m.m11);
            dest.putDouble(offset + 48, m.m21);
            dest.putDouble(offset + 56, m.m31);
            dest.putDouble(offset + 64, m.m02);
            dest.putDouble(offset + 72, m.m12);
            dest.putDouble(offset + 80, m.m22);
            dest.putDouble(offset + 88, m.m32);
        }

        public final void putTransposed(Matrix4x3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m10);
            dest.put(offset + 2, m.m20);
            dest.put(offset + 3, m.m30);
            dest.put(offset + 4, m.m01);
            dest.put(offset + 5, m.m11);
            dest.put(offset + 6, m.m21);
            dest.put(offset + 7, m.m31);
            dest.put(offset + 8, m.m02);
            dest.put(offset + 9, m.m12);
            dest.put(offset + 10, m.m22);
            dest.put(offset + 11, m.m32);
        }

        public final void putTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 4, m.m10);
            dest.putDouble(offset + 8, m.m20);
            dest.putDouble(offset + 12, m.m30);
            dest.putDouble(offset + 16, m.m01);
            dest.putDouble(offset + 20, m.m11);
            dest.putDouble(offset + 24, m.m21);
            dest.putDouble(offset + 28, m.m31);
            dest.putDouble(offset + 32, m.m02);
            dest.putDouble(offset + 36, m.m12);
            dest.putDouble(offset + 40, m.m22);
            dest.putDouble(offset + 44, m.m32);
        }

        public final void putfTransposed(Matrix4x3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m10);
            dest.put(offset + 2, (float)m.m20);
            dest.put(offset + 3, (float)m.m30);
            dest.put(offset + 4, (float)m.m01);
            dest.put(offset + 5, (float)m.m11);
            dest.put(offset + 6, (float)m.m21);
            dest.put(offset + 7, (float)m.m31);
            dest.put(offset + 8, (float)m.m02);
            dest.put(offset + 9, (float)m.m12);
            dest.put(offset + 10, (float)m.m22);
            dest.put(offset + 11, (float)m.m32);
        }

        public final void putfTransposed(Matrix4x3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m10);
            dest.putFloat(offset + 8, (float)m.m20);
            dest.putFloat(offset + 12, (float)m.m30);
            dest.putFloat(offset + 16, (float)m.m01);
            dest.putFloat(offset + 20, (float)m.m11);
            dest.putFloat(offset + 24, (float)m.m21);
            dest.putFloat(offset + 28, (float)m.m31);
            dest.putFloat(offset + 32, (float)m.m02);
            dest.putFloat(offset + 36, (float)m.m12);
            dest.putFloat(offset + 40, (float)m.m22);
            dest.putFloat(offset + 44, (float)m.m32);
        }

        public final void putfTransposed(Matrix4d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m10);
            dest.put(offset + 2, (float)m.m20);
            dest.put(offset + 3, (float)m.m30);
            dest.put(offset + 4, (float)m.m01);
            dest.put(offset + 5, (float)m.m11);
            dest.put(offset + 6, (float)m.m21);
            dest.put(offset + 7, (float)m.m31);
            dest.put(offset + 8, (float)m.m02);
            dest.put(offset + 9, (float)m.m12);
            dest.put(offset + 10, (float)m.m22);
            dest.put(offset + 11, (float)m.m32);
            dest.put(offset + 12, (float)m.m03);
            dest.put(offset + 13, (float)m.m13);
            dest.put(offset + 14, (float)m.m23);
            dest.put(offset + 15, (float)m.m33);
        }

        public final void putfTransposed(Matrix4d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m10);
            dest.putFloat(offset + 8, (float)m.m20);
            dest.putFloat(offset + 12, (float)m.m30);
            dest.putFloat(offset + 16, (float)m.m01);
            dest.putFloat(offset + 20, (float)m.m11);
            dest.putFloat(offset + 24, (float)m.m21);
            dest.putFloat(offset + 28, (float)m.m31);
            dest.putFloat(offset + 32, (float)m.m02);
            dest.putFloat(offset + 36, (float)m.m12);
            dest.putFloat(offset + 40, (float)m.m22);
            dest.putFloat(offset + 44, (float)m.m32);
            dest.putFloat(offset + 48, (float)m.m03);
            dest.putFloat(offset + 52, (float)m.m13);
            dest.putFloat(offset + 56, (float)m.m23);
            dest.putFloat(offset + 60, (float)m.m33);
        }

        public final void put(Matrix3f m, int offset, FloatBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
        }

        public final void put(Matrix3f m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, m.m00);
            dest.putFloat(offset + 4, m.m01);
            dest.putFloat(offset + 8, m.m02);
            dest.putFloat(offset + 12, m.m10);
            dest.putFloat(offset + 16, m.m11);
            dest.putFloat(offset + 20, m.m12);
            dest.putFloat(offset + 24, m.m20);
            dest.putFloat(offset + 28, m.m21);
            dest.putFloat(offset + 32, m.m22);
        }

        public final void put(Matrix3d m, int offset, DoubleBuffer dest) {
            dest.put(offset, m.m00);
            dest.put(offset + 1, m.m01);
            dest.put(offset + 2, m.m02);
            dest.put(offset + 3, m.m10);
            dest.put(offset + 4, m.m11);
            dest.put(offset + 5, m.m12);
            dest.put(offset + 6, m.m20);
            dest.put(offset + 7, m.m21);
            dest.put(offset + 8, m.m22);
        }

        public final void put(Matrix3d m, int offset, ByteBuffer dest) {
            dest.putDouble(offset, m.m00);
            dest.putDouble(offset + 8, m.m01);
            dest.putDouble(offset + 16, m.m02);
            dest.putDouble(offset + 24, m.m10);
            dest.putDouble(offset + 32, m.m11);
            dest.putDouble(offset + 40, m.m12);
            dest.putDouble(offset + 48, m.m20);
            dest.putDouble(offset + 56, m.m21);
            dest.putDouble(offset + 64, m.m22);
        }

        public final void putf(Matrix3d m, int offset, FloatBuffer dest) {
            dest.put(offset, (float)m.m00);
            dest.put(offset + 1, (float)m.m01);
            dest.put(offset + 2, (float)m.m02);
            dest.put(offset + 3, (float)m.m10);
            dest.put(offset + 4, (float)m.m11);
            dest.put(offset + 5, (float)m.m12);
            dest.put(offset + 6, (float)m.m20);
            dest.put(offset + 7, (float)m.m21);
            dest.put(offset + 8, (float)m.m22);
        }

        public final void putf(Matrix3d m, int offset, ByteBuffer dest) {
            dest.putFloat(offset, (float)m.m00);
            dest.putFloat(offset + 4, (float)m.m01);
            dest.putFloat(offset + 8, (float)m.m02);
            dest.putFloat(offset + 12, (float)m.m10);
            dest.putFloat(offset + 16, (float)m.m11);
            dest.putFloat(offset + 20, (float)m.m12);
            dest.putFloat(offset + 24, (float)m.m20);
            dest.putFloat(offset + 28, (float)m.m21);
            dest.putFloat(offset + 32, (float)m.m22);
        }

        public final void put(Vector4d src, int offset, DoubleBuffer dest) {
            dest.put(offset, src.x);
            dest.put(offset + 1, src.y);
            dest.put(offset + 2, src.z);
            dest.put(offset + 3, src.w);
        }

        public final void put(Vector4d src, int offset, ByteBuffer dest) {
            dest.putDouble(offset, src.x);
            dest.putDouble(offset + 8, src.y);
            dest.putDouble(offset + 16, src.z);
            dest.putDouble(offset + 24, src.w);
        }

        public final void put(Vector4f src, int offset, FloatBuffer dest) {
            dest.put(offset, src.x);
            dest.put(offset + 1, src.y);
            dest.put(offset + 2, src.z);
            dest.put(offset + 3, src.w);
        }

        public final void put(Vector4f src, int offset, ByteBuffer dest) {
            dest.putFloat(offset, src.x);
            dest.putFloat(offset + 4, src.y);
            dest.putFloat(offset + 8, src.z);
            dest.putFloat(offset + 12, src.w);
        }

        public final void put(Vector4i src, int offset, IntBuffer dest) {
            dest.put(offset, src.x);
            dest.put(offset + 1, src.y);
            dest.put(offset + 2, src.z);
            dest.put(offset + 3, src.w);
        }

        public final void put(Vector4i src, int offset, ByteBuffer dest) {
            dest.putInt(offset, src.x);
            dest.putInt(offset + 4, src.y);
            dest.putInt(offset + 8, src.z);
            dest.putInt(offset + 12, src.w);
        }

        public final void put(Vector3f src, int offset, FloatBuffer dest) {
            dest.put(offset, src.x);
            dest.put(offset + 1, src.y);
            dest.put(offset + 2, src.z);
        }

        public final void put(Vector3f src, int offset, ByteBuffer dest) {
            dest.putFloat(offset, src.x);
            dest.putFloat(offset + 4, src.y);
            dest.putFloat(offset + 8, src.z);
        }

        public final void get(Matrix4f m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m03 = src.get(offset + 3);
            m.m10 = src.get(offset + 4);
            m.m11 = src.get(offset + 5);
            m.m12 = src.get(offset + 6);
            m.m13 = src.get(offset + 7);
            m.m20 = src.get(offset + 8);
            m.m21 = src.get(offset + 9);
            m.m22 = src.get(offset + 10);
            m.m23 = src.get(offset + 11);
            m.m30 = src.get(offset + 12);
            m.m31 = src.get(offset + 13);
            m.m32 = src.get(offset + 14);
            m.m33 = src.get(offset + 15);
        }

        public final void get(Matrix4f m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m03 = src.getFloat(offset + 12);
            m.m10 = src.getFloat(offset + 16);
            m.m11 = src.getFloat(offset + 20);
            m.m12 = src.getFloat(offset + 24);
            m.m13 = src.getFloat(offset + 28);
            m.m20 = src.getFloat(offset + 32);
            m.m21 = src.getFloat(offset + 36);
            m.m22 = src.getFloat(offset + 40);
            m.m23 = src.getFloat(offset + 44);
            m.m30 = src.getFloat(offset + 48);
            m.m31 = src.getFloat(offset + 52);
            m.m32 = src.getFloat(offset + 56);
            m.m33 = src.getFloat(offset + 60);
        }

        public final void get(Matrix4x3f m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
            m.m30 = src.get(offset + 9);
            m.m31 = src.get(offset + 10);
            m.m32 = src.get(offset + 11);
        }

        public final void get(Matrix4x3f m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
            m.m30 = src.getFloat(offset + 36);
            m.m31 = src.getFloat(offset + 40);
            m.m32 = src.getFloat(offset + 44);
        }

        public final void get(Matrix4d m, int offset, DoubleBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m03 = src.get(offset + 3);
            m.m10 = src.get(offset + 4);
            m.m11 = src.get(offset + 5);
            m.m12 = src.get(offset + 6);
            m.m13 = src.get(offset + 7);
            m.m20 = src.get(offset + 8);
            m.m21 = src.get(offset + 9);
            m.m22 = src.get(offset + 10);
            m.m23 = src.get(offset + 11);
            m.m30 = src.get(offset + 12);
            m.m31 = src.get(offset + 13);
            m.m32 = src.get(offset + 14);
            m.m33 = src.get(offset + 15);
        }

        public final void get(Matrix4d m, int offset, ByteBuffer src) {
            m.m00 = src.getDouble(offset);
            m.m01 = src.getDouble(offset + 8);
            m.m02 = src.getDouble(offset + 16);
            m.m03 = src.getDouble(offset + 24);
            m.m10 = src.getDouble(offset + 32);
            m.m11 = src.getDouble(offset + 40);
            m.m12 = src.getDouble(offset + 48);
            m.m13 = src.getDouble(offset + 56);
            m.m20 = src.getDouble(offset + 64);
            m.m21 = src.getDouble(offset + 72);
            m.m22 = src.getDouble(offset + 80);
            m.m23 = src.getDouble(offset + 88);
            m.m30 = src.getDouble(offset + 96);
            m.m31 = src.getDouble(offset + 104);
            m.m32 = src.getDouble(offset + 112);
            m.m33 = src.getDouble(offset + 120);
        }

        public final void get(Matrix4x3d m, int offset, DoubleBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
            m.m30 = src.get(offset + 9);
            m.m31 = src.get(offset + 10);
            m.m32 = src.get(offset + 11);
        }

        public final void get(Matrix4x3d m, int offset, ByteBuffer src) {
            m.m00 = src.getDouble(offset);
            m.m01 = src.getDouble(offset + 8);
            m.m02 = src.getDouble(offset + 16);
            m.m10 = src.getDouble(offset + 24);
            m.m11 = src.getDouble(offset + 32);
            m.m12 = src.getDouble(offset + 40);
            m.m20 = src.getDouble(offset + 48);
            m.m21 = src.getDouble(offset + 56);
            m.m22 = src.getDouble(offset + 64);
            m.m30 = src.getDouble(offset + 72);
            m.m31 = src.getDouble(offset + 80);
            m.m32 = src.getDouble(offset + 88);
        }

        public final void getf(Matrix4d m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m03 = src.get(offset + 3);
            m.m10 = src.get(offset + 4);
            m.m11 = src.get(offset + 5);
            m.m12 = src.get(offset + 6);
            m.m13 = src.get(offset + 7);
            m.m20 = src.get(offset + 8);
            m.m21 = src.get(offset + 9);
            m.m22 = src.get(offset + 10);
            m.m23 = src.get(offset + 11);
            m.m30 = src.get(offset + 12);
            m.m31 = src.get(offset + 13);
            m.m32 = src.get(offset + 14);
            m.m33 = src.get(offset + 15);
        }

        public final void getf(Matrix4d m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m03 = src.getFloat(offset + 12);
            m.m10 = src.getFloat(offset + 16);
            m.m11 = src.getFloat(offset + 20);
            m.m12 = src.getFloat(offset + 24);
            m.m13 = src.getFloat(offset + 28);
            m.m20 = src.getFloat(offset + 32);
            m.m21 = src.getFloat(offset + 36);
            m.m22 = src.getFloat(offset + 40);
            m.m23 = src.getFloat(offset + 44);
            m.m30 = src.getFloat(offset + 48);
            m.m31 = src.getFloat(offset + 52);
            m.m32 = src.getFloat(offset + 56);
            m.m33 = src.getFloat(offset + 60);
        }

        public final void getf(Matrix4x3d m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
            m.m30 = src.get(offset + 9);
            m.m31 = src.get(offset + 10);
            m.m32 = src.get(offset + 11);
        }

        public final void getf(Matrix4x3d m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
            m.m30 = src.getFloat(offset + 36);
            m.m31 = src.getFloat(offset + 40);
            m.m32 = src.getFloat(offset + 44);
        }

        public final void get(Matrix3f m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        public final void get(Matrix3f m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
        }

        public final void get(Matrix3d m, int offset, DoubleBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        public final void get(Matrix3d m, int offset, ByteBuffer src) {
            m.m00 = src.getDouble(offset);
            m.m01 = src.getDouble(offset + 8);
            m.m02 = src.getDouble(offset + 16);
            m.m10 = src.getDouble(offset + 24);
            m.m11 = src.getDouble(offset + 32);
            m.m12 = src.getDouble(offset + 40);
            m.m20 = src.getDouble(offset + 48);
            m.m21 = src.getDouble(offset + 56);
            m.m22 = src.getDouble(offset + 64);
        }

        public final void getf(Matrix3d m, int offset, FloatBuffer src) {
            m.m00 = src.get(offset);
            m.m01 = src.get(offset + 1);
            m.m02 = src.get(offset + 2);
            m.m10 = src.get(offset + 3);
            m.m11 = src.get(offset + 4);
            m.m12 = src.get(offset + 5);
            m.m20 = src.get(offset + 6);
            m.m21 = src.get(offset + 7);
            m.m22 = src.get(offset + 8);
        }

        public final void getf(Matrix3d m, int offset, ByteBuffer src) {
            m.m00 = src.getFloat(offset);
            m.m01 = src.getFloat(offset + 4);
            m.m02 = src.getFloat(offset + 8);
            m.m10 = src.getFloat(offset + 12);
            m.m11 = src.getFloat(offset + 16);
            m.m12 = src.getFloat(offset + 20);
            m.m20 = src.getFloat(offset + 24);
            m.m21 = src.getFloat(offset + 28);
            m.m22 = src.getFloat(offset + 32);
        }

        public final void get(Vector4d dst, int offset, DoubleBuffer src) {
            dst.x = src.get(offset);
            dst.y = src.get(offset + 1);
            dst.z = src.get(offset + 2);
            dst.w = src.get(offset + 3);
        }

        public final void get(Vector4d dst, int offset, ByteBuffer src) {
            dst.x = src.getDouble(offset);
            dst.y = src.getDouble(offset + 8);
            dst.z = src.getDouble(offset + 16);
            dst.w = src.getDouble(offset + 24);
        }

        public final void get(Vector4f dst, int offset, FloatBuffer src) {
            dst.x = src.get(offset);
            dst.y = src.get(offset + 1);
            dst.z = src.get(offset + 2);
            dst.w = src.get(offset + 3);
        }

        public final void get(Vector4f dst, int offset, ByteBuffer src) {
            dst.x = src.getFloat(offset);
            dst.y = src.getFloat(offset + 4);
            dst.z = src.getFloat(offset + 8);
            dst.w = src.getFloat(offset + 12);
        }

        public final void get(Vector4i dst, int offset, IntBuffer src) {
            dst.x = src.get(offset);
            dst.y = src.get(offset + 1);
            dst.z = src.get(offset + 2);
            dst.w = src.get(offset + 3);
        }

        public final void get(Vector4i dst, int offset, ByteBuffer src) {
            dst.x = src.getInt(offset);
            dst.y = src.getInt(offset + 4);
            dst.z = src.getInt(offset + 8);
            dst.w = src.getInt(offset + 12);
        }

        public final void get(Vector3f dst, int offset, FloatBuffer src) {
            dst.x = src.get(offset);
            dst.y = src.get(offset + 1);
            dst.z = src.get(offset + 2);
        }

        public final void get(Vector3f dst, int offset, ByteBuffer src) {
            dst.x = src.getFloat(offset);
            dst.y = src.getFloat(offset + 4);
            dst.z = src.getFloat(offset + 8);
        }

        public final void copy(Matrix4f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m03 = src.m03;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m13 = src.m13;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m23 = src.m23;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
            dest.m33 = src.m33;
        }

        public final void copy(Matrix3f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m03 = 0.0f;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m13 = 0.0f;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m23 = 0.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
            dest.m33 = 1.0f;
        }

        public final void copy(Matrix4f src, Matrix3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        public final void copy(Matrix3f src, Matrix4x3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
        }

        public final void copy3x3(Matrix4f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        public final void copy3x3(Matrix4x3f src, Matrix4x3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        public final void copy3x3(Matrix3f src, Matrix4x3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        public final void copy3x3(Matrix3f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        public final void copy4x3(Matrix4x3f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
        }

        public final void copy(Vector4f src, Vector4f dst) {
            dst.x = src.x;
            dst.y = src.y;
            dst.z = src.z;
            dst.w = src.w;
        }

        public final void copy(Vector4i src, Vector4i dst) {
            dst.x = src.x;
            dst.y = src.y;
            dst.z = src.z;
            dst.w = src.w;
        }

        public final void copy(Quaternionf src, Quaternionf dst) {
            dst.x = src.x;
            dst.y = src.y;
            dst.z = src.z;
            dst.w = src.w;
        }

        public final void copy4x3(Matrix4f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
        }

        public final void copy(Matrix4f src, Matrix4x3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
        }

        public final void copy(Matrix4x3f src, Matrix4f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m03 = 0.0f;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m13 = 0.0f;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m23 = 0.0f;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
            dest.m33 = 1.0f;
        }

        public final void copy(Matrix4x3f src, Matrix4x3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
            dest.m30 = src.m30;
            dest.m31 = src.m31;
            dest.m32 = src.m32;
        }

        public final void copy(Matrix3f src, Matrix3f dest) {
            dest.m00 = src.m00;
            dest.m01 = src.m01;
            dest.m02 = src.m02;
            dest.m10 = src.m10;
            dest.m11 = src.m11;
            dest.m12 = src.m12;
            dest.m20 = src.m20;
            dest.m21 = src.m21;
            dest.m22 = src.m22;
        }

        public final void copy(float[] arr, int off, Matrix4f dest) {
            dest.m00 = arr[off + 0];
            dest.m01 = arr[off + 1];
            dest.m02 = arr[off + 2];
            dest.m03 = arr[off + 3];
            dest.m10 = arr[off + 4];
            dest.m11 = arr[off + 5];
            dest.m12 = arr[off + 6];
            dest.m13 = arr[off + 7];
            dest.m20 = arr[off + 8];
            dest.m21 = arr[off + 9];
            dest.m22 = arr[off + 10];
            dest.m23 = arr[off + 11];
            dest.m30 = arr[off + 12];
            dest.m31 = arr[off + 13];
            dest.m32 = arr[off + 14];
            dest.m33 = arr[off + 15];
        }

        public final void copy(float[] arr, int off, Matrix3f dest) {
            dest.m00 = arr[off + 0];
            dest.m01 = arr[off + 1];
            dest.m02 = arr[off + 2];
            dest.m10 = arr[off + 3];
            dest.m11 = arr[off + 4];
            dest.m12 = arr[off + 5];
            dest.m20 = arr[off + 6];
            dest.m21 = arr[off + 7];
            dest.m22 = arr[off + 8];
        }

        public final void copy(float[] arr, int off, Matrix4x3f dest) {
            dest.m00 = arr[off + 0];
            dest.m01 = arr[off + 1];
            dest.m02 = arr[off + 2];
            dest.m10 = arr[off + 3];
            dest.m11 = arr[off + 4];
            dest.m12 = arr[off + 5];
            dest.m20 = arr[off + 6];
            dest.m21 = arr[off + 7];
            dest.m22 = arr[off + 8];
            dest.m30 = arr[off + 9];
            dest.m31 = arr[off + 10];
            dest.m32 = arr[off + 11];
        }

        public final void copy(Matrix4f src, float[] dest, int off) {
            dest[off + 0] = src.m00;
            dest[off + 1] = src.m01;
            dest[off + 2] = src.m02;
            dest[off + 3] = src.m03;
            dest[off + 4] = src.m10;
            dest[off + 5] = src.m11;
            dest[off + 6] = src.m12;
            dest[off + 7] = src.m13;
            dest[off + 8] = src.m20;
            dest[off + 9] = src.m21;
            dest[off + 10] = src.m22;
            dest[off + 11] = src.m23;
            dest[off + 12] = src.m30;
            dest[off + 13] = src.m31;
            dest[off + 14] = src.m32;
            dest[off + 15] = src.m33;
        }

        public final void copy(Matrix3f src, float[] dest, int off) {
            dest[off + 0] = src.m00;
            dest[off + 1] = src.m01;
            dest[off + 2] = src.m02;
            dest[off + 3] = src.m10;
            dest[off + 4] = src.m11;
            dest[off + 5] = src.m12;
            dest[off + 6] = src.m20;
            dest[off + 7] = src.m21;
            dest[off + 8] = src.m22;
        }

        public final void copy(Matrix4x3f src, float[] dest, int off) {
            dest[off + 0] = src.m00;
            dest[off + 1] = src.m01;
            dest[off + 2] = src.m02;
            dest[off + 3] = src.m10;
            dest[off + 4] = src.m11;
            dest[off + 5] = src.m12;
            dest[off + 6] = src.m20;
            dest[off + 7] = src.m21;
            dest[off + 8] = src.m22;
            dest[off + 9] = src.m30;
            dest[off + 10] = src.m31;
            dest[off + 11] = src.m32;
        }

        public final void identity(Matrix4f dest) {
            dest.m00 = 1.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m03 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 1.0f;
            dest.m12 = 0.0f;
            dest.m13 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 1.0f;
            dest.m23 = 0.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
            dest.m33 = 1.0f;
        }

        public final void identity(Matrix4x3f dest) {
            dest.m00 = 1.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 1.0f;
            dest.m12 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 1.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
        }

        public final void identity(Matrix3f dest) {
            dest.m00 = 1.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 1.0f;
            dest.m12 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 1.0f;
        }

        public final void identity(Quaternionf dest) {
            dest.x = 0.0f;
            dest.y = 0.0f;
            dest.z = 0.0f;
            dest.w = 1.0f;
        }

        public final void swap(Matrix4f m1, Matrix4f m2) {
            float tmp = m1.m00;
            m1.m00 = m2.m00;
            m2.m00 = tmp;
            tmp = m1.m01;
            m1.m01 = m2.m01;
            m2.m01 = tmp;
            tmp = m1.m02;
            m1.m02 = m2.m02;
            m2.m02 = tmp;
            tmp = m1.m03;
            m1.m03 = m2.m03;
            m2.m03 = tmp;
            tmp = m1.m10;
            m1.m10 = m2.m10;
            m2.m10 = tmp;
            tmp = m1.m11;
            m1.m11 = m2.m11;
            m2.m11 = tmp;
            tmp = m1.m12;
            m1.m12 = m2.m12;
            m2.m12 = tmp;
            tmp = m1.m13;
            m1.m13 = m2.m13;
            m2.m13 = tmp;
            tmp = m1.m20;
            m1.m20 = m2.m20;
            m2.m20 = tmp;
            tmp = m1.m21;
            m1.m21 = m2.m21;
            m2.m21 = tmp;
            tmp = m1.m22;
            m1.m22 = m2.m22;
            m2.m22 = tmp;
            tmp = m1.m23;
            m1.m23 = m2.m23;
            m2.m23 = tmp;
            tmp = m1.m30;
            m1.m30 = m2.m30;
            m2.m30 = tmp;
            tmp = m1.m31;
            m1.m31 = m2.m31;
            m2.m31 = tmp;
            tmp = m1.m32;
            m1.m32 = m2.m32;
            m2.m32 = tmp;
            tmp = m1.m33;
            m1.m33 = m2.m33;
            m2.m33 = tmp;
        }

        public final void swap(Matrix4x3f m1, Matrix4x3f m2) {
            float tmp = m1.m00;
            m1.m00 = m2.m00;
            m2.m00 = tmp;
            tmp = m1.m01;
            m1.m01 = m2.m01;
            m2.m01 = tmp;
            tmp = m1.m02;
            m1.m02 = m2.m02;
            m2.m02 = tmp;
            tmp = m1.m10;
            m1.m10 = m2.m10;
            m2.m10 = tmp;
            tmp = m1.m11;
            m1.m11 = m2.m11;
            m2.m11 = tmp;
            tmp = m1.m12;
            m1.m12 = m2.m12;
            m2.m12 = tmp;
            tmp = m1.m20;
            m1.m20 = m2.m20;
            m2.m20 = tmp;
            tmp = m1.m21;
            m1.m21 = m2.m21;
            m2.m21 = tmp;
            tmp = m1.m22;
            m1.m22 = m2.m22;
            m2.m22 = tmp;
            tmp = m1.m30;
            m1.m30 = m2.m30;
            m2.m30 = tmp;
            tmp = m1.m31;
            m1.m31 = m2.m31;
            m2.m31 = tmp;
            tmp = m1.m32;
            m1.m32 = m2.m32;
            m2.m32 = tmp;
        }

        public final void swap(Matrix3f m1, Matrix3f m2) {
            float tmp = m1.m00;
            m1.m00 = m2.m00;
            m2.m00 = tmp;
            tmp = m1.m01;
            m1.m01 = m2.m01;
            m2.m01 = tmp;
            tmp = m1.m02;
            m1.m02 = m2.m02;
            m2.m02 = tmp;
            tmp = m1.m10;
            m1.m10 = m2.m10;
            m2.m10 = tmp;
            tmp = m1.m11;
            m1.m11 = m2.m11;
            m2.m11 = tmp;
            tmp = m1.m12;
            m1.m12 = m2.m12;
            m2.m12 = tmp;
            tmp = m1.m20;
            m1.m20 = m2.m20;
            m2.m20 = tmp;
            tmp = m1.m21;
            m1.m21 = m2.m21;
            m2.m21 = tmp;
            tmp = m1.m22;
            m1.m22 = m2.m22;
            m2.m22 = tmp;
        }

        public final void zero(Matrix4f dest) {
            dest.m00 = 0.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m03 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 0.0f;
            dest.m12 = 0.0f;
            dest.m13 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 0.0f;
            dest.m23 = 0.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
            dest.m33 = 0.0f;
        }

        public final void zero(Matrix4x3f dest) {
            dest.m00 = 0.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 0.0f;
            dest.m12 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 0.0f;
            dest.m30 = 0.0f;
            dest.m31 = 0.0f;
            dest.m32 = 0.0f;
        }

        public final void zero(Matrix3f dest) {
            dest.m00 = 0.0f;
            dest.m01 = 0.0f;
            dest.m02 = 0.0f;
            dest.m10 = 0.0f;
            dest.m11 = 0.0f;
            dest.m12 = 0.0f;
            dest.m20 = 0.0f;
            dest.m21 = 0.0f;
            dest.m22 = 0.0f;
        }

        public final void zero(Vector4f dest) {
            dest.x = 0.0f;
            dest.y = 0.0f;
            dest.z = 0.0f;
            dest.w = 0.0f;
        }

        public final void zero(Vector4i dest) {
            dest.x = 0;
            dest.y = 0;
            dest.z = 0;
            dest.w = 0;
        }

        public final void putMatrix3f(Quaternionf q, int position, ByteBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.putFloat(position, 1.0f - q11 - q22);
            dest.putFloat(position + 4, q01 + q23);
            dest.putFloat(position + 8, q02 - q13);
            dest.putFloat(position + 12, q01 - q23);
            dest.putFloat(position + 16, 1.0f - q22 - q00);
            dest.putFloat(position + 20, q12 + q03);
            dest.putFloat(position + 24, q02 + q13);
            dest.putFloat(position + 28, q12 - q03);
            dest.putFloat(position + 32, 1.0f - q11 - q00);
        }

        public final void putMatrix3f(Quaternionf q, int position, FloatBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.put(position, 1.0f - q11 - q22);
            dest.put(position + 1, q01 + q23);
            dest.put(position + 2, q02 - q13);
            dest.put(position + 3, q01 - q23);
            dest.put(position + 4, 1.0f - q22 - q00);
            dest.put(position + 5, q12 + q03);
            dest.put(position + 6, q02 + q13);
            dest.put(position + 7, q12 - q03);
            dest.put(position + 8, 1.0f - q11 - q00);
        }

        public final void putMatrix4f(Quaternionf q, int position, ByteBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.putFloat(position, 1.0f - q11 - q22);
            dest.putFloat(position + 4, q01 + q23);
            dest.putFloat(position + 8, q02 - q13);
            dest.putFloat(position + 12, 0.0f);
            dest.putFloat(position + 16, q01 - q23);
            dest.putFloat(position + 20, 1.0f - q22 - q00);
            dest.putFloat(position + 24, q12 + q03);
            dest.putFloat(position + 28, 0.0f);
            dest.putFloat(position + 32, q02 + q13);
            dest.putFloat(position + 36, q12 - q03);
            dest.putFloat(position + 40, 1.0f - q11 - q00);
            dest.putFloat(position + 44, 0.0f);
            dest.putLong(position + 48, 0L);
            dest.putLong(position + 56, 4575657221408423936L);
        }

        public final void putMatrix4f(Quaternionf q, int position, FloatBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.put(position, 1.0f - q11 - q22);
            dest.put(position + 1, q01 + q23);
            dest.put(position + 2, q02 - q13);
            dest.put(position + 3, 0.0f);
            dest.put(position + 4, q01 - q23);
            dest.put(position + 5, 1.0f - q22 - q00);
            dest.put(position + 6, q12 + q03);
            dest.put(position + 7, 0.0f);
            dest.put(position + 8, q02 + q13);
            dest.put(position + 9, q12 - q03);
            dest.put(position + 10, 1.0f - q11 - q00);
            dest.put(position + 11, 0.0f);
            dest.put(position + 12, 0.0f);
            dest.put(position + 13, 0.0f);
            dest.put(position + 14, 0.0f);
            dest.put(position + 15, 1.0f);
        }

        public final void putMatrix4x3f(Quaternionf q, int position, ByteBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.putFloat(position, 1.0f - q11 - q22);
            dest.putFloat(position + 4, q01 + q23);
            dest.putFloat(position + 8, q02 - q13);
            dest.putFloat(position + 12, q01 - q23);
            dest.putFloat(position + 16, 1.0f - q22 - q00);
            dest.putFloat(position + 20, q12 + q03);
            dest.putFloat(position + 24, q02 + q13);
            dest.putFloat(position + 28, q12 - q03);
            dest.putFloat(position + 32, 1.0f - q11 - q00);
            dest.putLong(position + 36, 0L);
            dest.putFloat(position + 44, 0.0f);
        }

        public final void putMatrix4x3f(Quaternionf q, int position, FloatBuffer dest) {
            float dx = q.x + q.x;
            float dy = q.y + q.y;
            float dz = q.z + q.z;
            float q00 = dx * q.x;
            float q11 = dy * q.y;
            float q22 = dz * q.z;
            float q01 = dx * q.y;
            float q02 = dx * q.z;
            float q03 = dx * q.w;
            float q12 = dy * q.z;
            float q13 = dy * q.w;
            float q23 = dz * q.w;
            dest.put(position, 1.0f - q11 - q22);
            dest.put(position + 1, q01 + q23);
            dest.put(position + 2, q02 - q13);
            dest.put(position + 3, q01 - q23);
            dest.put(position + 4, 1.0f - q22 - q00);
            dest.put(position + 5, q12 + q03);
            dest.put(position + 6, q02 + q13);
            dest.put(position + 7, q12 - q03);
            dest.put(position + 8, 1.0f - q11 - q00);
            dest.put(position + 9, 0.0f);
            dest.put(position + 10, 0.0f);
            dest.put(position + 11, 0.0f);
        }

        public final void set(Matrix4f m, Vector4f col0, Vector4f col1, Vector4f col2, Vector4f col3) {
            m.m00 = col0.x;
            m.m01 = col0.y;
            m.m02 = col0.z;
            m.m03 = col0.w;
            m.m10 = col1.x;
            m.m11 = col1.y;
            m.m12 = col1.z;
            m.m13 = col1.w;
            m.m20 = col2.x;
            m.m21 = col2.y;
            m.m22 = col2.z;
            m.m23 = col2.w;
            m.m30 = col3.x;
            m.m31 = col3.y;
            m.m32 = col3.z;
            m.m33 = col3.w;
        }

        public final void set(Matrix4x3f m, Vector3f col0, Vector3f col1, Vector3f col2, Vector3f col3) {
            m.m00 = col0.x;
            m.m01 = col0.y;
            m.m02 = col0.z;
            m.m10 = col1.x;
            m.m11 = col1.y;
            m.m12 = col1.z;
            m.m20 = col2.x;
            m.m21 = col2.y;
            m.m22 = col2.z;
            m.m30 = col3.x;
            m.m31 = col3.y;
            m.m32 = col3.z;
        }

        public final void set(Matrix3f m, Vector3f col0, Vector3f col1, Vector3f col2) {
            m.m00 = col0.x;
            m.m01 = col0.y;
            m.m02 = col0.z;
            m.m10 = col1.x;
            m.m11 = col1.y;
            m.m12 = col1.z;
            m.m20 = col2.x;
            m.m21 = col2.y;
            m.m22 = col2.z;
        }

        public final void putColumn0(Matrix4f src, Vector4f dest) {
            dest.x = src.m00;
            dest.y = src.m01;
            dest.z = src.m02;
            dest.w = src.m03;
        }

        public final void putColumn1(Matrix4f src, Vector4f dest) {
            dest.x = src.m10;
            dest.y = src.m11;
            dest.z = src.m12;
            dest.w = src.m13;
        }

        public final void putColumn2(Matrix4f src, Vector4f dest) {
            dest.x = src.m20;
            dest.y = src.m21;
            dest.z = src.m22;
            dest.w = src.m23;
        }

        public final void putColumn3(Matrix4f src, Vector4f dest) {
            dest.x = src.m30;
            dest.y = src.m31;
            dest.z = src.m32;
            dest.w = src.m33;
        }

        public final void broadcast(float c, Vector4f dest) {
            dest.x = c;
            dest.y = c;
            dest.z = c;
            dest.w = c;
        }

        public final void broadcast(int c, Vector4i dest) {
            dest.x = c;
            dest.y = c;
            dest.z = c;
            dest.w = c;
        }
    }
}

