/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.util.Arrays;
import java.util.Comparator;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector2f;

public class TrapezoidOrthoCrop {
    public static float START_PRECENTAGE = 0.95f;
    public static float FOCUS_LINE_FRACTION = 0.3f;
    private static final Vector2fComparator cmp = new Vector2fComparator();
    private final Vector2f[] projectedFrustumCorners = new Vector2f[8];
    private final Vector2f[] convexHull;
    private int convexHullSize;
    private final Vector2f[] projectedConvexHull;
    private float Nx;
    private float Ny;
    private float Fx;
    private float Fy;
    private final Matrix4f invCamViewProj;
    private final Matrix4f work;

    public TrapezoidOrthoCrop() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.projectedFrustumCorners[i] = new Vector2f();
        }
        this.convexHull = new Vector2f[16];
        this.projectedConvexHull = new Vector2f[6];
        for (i = 0; i < 6; ++i) {
            this.projectedConvexHull[i] = new Vector2f();
        }
        this.invCamViewProj = new Matrix4f();
        this.work = new Matrix4f();
    }

    public Matrix4f compute(Matrix4f camViewProj, Matrix4f lightView, Matrix4f dest) {
        camViewProj.invert(this.invCamViewProj);
        this.projectFrustumCorners(lightView);
        this.computeConvexHull();
        this.computeMatrix(dest);
        return dest;
    }

    private static float convexPolygonArea(Vector2f[] vs, int count) {
        float sum0 = 0.0f;
        float sum1 = 0.0f;
        for (int i0 = 0; i0 < count; ++i0) {
            int i1 = (i0 + 1) % count;
            Vector2f v0 = vs[i0];
            Vector2f v1 = vs[i1];
            sum0 += v0.x * v1.y;
            sum1 += v0.y * v1.x;
        }
        return 0.5f * (sum0 - sum1);
    }

    private void computeMatrix(Matrix4f dest) {
        float aX = this.Fx - this.Nx;
        float aY = this.Fy - this.Ny;
        float aLen = (float)Math.sqrt(aX * aX + aY * aY);
        float invLen = 1.0f / aLen;
        aX *= invLen;
        aY *= invLen;
        float tTop = 0.0f;
        float tBase = 0.0f;
        for (int i = 0; i < this.convexHullSize; ++i) {
            float x = this.convexHull[i].x - this.Nx;
            float y = this.convexHull[i].y - this.Ny;
            float ti = x * aX + y * aY;
            tTop = tTop < ti ? tTop : ti;
            tBase = tBase > ti ? tBase : ti;
        }
        float lambda = tBase - tTop;
        float projectedArea = 0.0f;
        float delta = aLen * FOCUS_LINE_FRACTION - tTop;
        for (float frac = START_PRECENTAGE; frac > 0.0f; frac -= 0.02f) {
            float xi = 1.0f - 2.0f * frac;
            float eta = (lambda * delta + lambda * delta * xi) / (lambda - 2.0f * delta - lambda * xi);
            float qX = this.Nx + (tTop - eta) * aX;
            float qY = this.Ny + (tTop - eta) * aY;
            float maxS = -3.4028235E38f;
            float minS = Float.MAX_VALUE;
            float uLx = 0.0f;
            float uLy = 0.0f;
            float uRx = 0.0f;
            float uRy = 0.0f;
            for (int i = 0; i < this.convexHullSize; ++i) {
                float aPerpY;
                float si;
                float uX = this.convexHull[i].x - qX;
                float uY = this.convexHull[i].y - qY;
                float aPerpX = -aY;
                if ((si = aPerpX * (uX *= (invLen = 1.0f / (float)Math.sqrt(uX * uX + uY * uY))) + (aPerpY = aX) * (uY *= invLen)) > maxS) {
                    maxS = si;
                    uLx = uX;
                    uLy = uY;
                }
                if (!(si < minS)) continue;
                minS = si;
                uRx = uX;
                uRy = uY;
            }
            float tB = eta + lambda;
            float tT = eta;
            float invULdotA = 1.0f / (uLx * aX + uLy * aY);
            float invURdotA = 1.0f / (uRx * aX + uRy * aY);
            float p3x = qX + tB * invULdotA * uLx;
            float p3y = qY + tB * invULdotA * uLy;
            float p2x = qX + tB * invURdotA * uRx;
            float p2y = qY + tB * invURdotA * uRy;
            float p1x = qX + tT * invURdotA * uRx;
            float p1y = qY + tT * invURdotA * uRy;
            float p0x = qX + tT * invULdotA * uLx;
            float p0y = qY + tT * invULdotA * uLy;
            this.work.trapezoidCrop(p0x, p0y, p1x, p1y, p2x, p2y, p3x, p3y);
            for (int c = 0; c < this.convexHullSize; ++c) {
                float x = this.convexHull[c].x;
                float y = this.convexHull[c].y;
                float invW = 1.0f / (this.work.m03() * x + this.work.m13() * y + this.work.m33());
                float tx = (this.work.m00() * x + this.work.m10() * y + this.work.m30()) * invW;
                float ty = (this.work.m01() * x + this.work.m11() * y + this.work.m31()) * invW;
                this.projectedConvexHull[c].set(tx, ty);
            }
            float area = TrapezoidOrthoCrop.convexPolygonArea(this.projectedConvexHull, this.convexHullSize);
            if (!(area > projectedArea)) break;
            projectedArea = area;
            dest.set(this.work);
        }
    }

    private void projectFrustumCorners(Matrix4f view) {
        for (int t = 0; t < 8; ++t) {
            float x = (float)((t & 1) << 1) - 1.0f;
            float y = (float)((t >>> 1 & 1) << 1) - 1.0f;
            float z = (float)((t >>> 2 & 1) << 1) - 1.0f;
            float invW = 1.0f / (this.invCamViewProj.m03() * x + this.invCamViewProj.m13() * y + this.invCamViewProj.m23() * z + this.invCamViewProj.m33());
            float wx = (this.invCamViewProj.m00() * x + this.invCamViewProj.m10() * y + this.invCamViewProj.m20() * z + this.invCamViewProj.m30()) * invW;
            float wy = (this.invCamViewProj.m01() * x + this.invCamViewProj.m11() * y + this.invCamViewProj.m21() * z + this.invCamViewProj.m31()) * invW;
            float wz = (this.invCamViewProj.m02() * x + this.invCamViewProj.m12() * y + this.invCamViewProj.m22() * z + this.invCamViewProj.m32()) * invW;
            invW = 1.0f / (view.m03() * wx + view.m13() * wy + view.m23() * wz + view.m33());
            float pvx = view.m00() * wx + view.m10() * wy + view.m20() * wz + view.m30();
            float pvy = view.m01() * wx + view.m11() * wy + view.m21() * wz + view.m31();
            this.projectedFrustumCorners[t].set(pvx, pvy);
        }
        this.Ny = 0.0f;
        this.Nx = 0.0f;
        this.Fy = 0.0f;
        this.Fx = 0.0f;
        for (int i = 0; i < 4; ++i) {
            this.Nx += this.projectedFrustumCorners[i].x;
            this.Ny += this.projectedFrustumCorners[i].y;
            this.Fx += this.projectedFrustumCorners[i + 4].x;
            this.Fy += this.projectedFrustumCorners[i + 4].y;
        }
        this.Fx *= 0.25f;
        this.Fy *= 0.25f;
        this.Nx *= 0.25f;
        this.Ny *= 0.25f;
    }

    private void computeConvexHull() {
        float x2;
        float y1;
        float y2;
        float x1;
        float c;
        Vector2f p;
        int i;
        Arrays.sort(this.projectedFrustumCorners, cmp);
        int k = 0;
        int start = 0;
        for (i = 0; i < 8; ++i) {
            p = this.projectedFrustumCorners[i];
            while (k - start >= 2 && !((c = (x1 = p.x - this.convexHull[k - 1].x) * (y2 = p.y - this.convexHull[k - 2].y) - (y1 = p.y - this.convexHull[k - 1].y) * (x2 = p.x - this.convexHull[k - 2].x)) < 0.0f)) {
                --k;
            }
            this.convexHull[k++] = p;
        }
        start = --k;
        for (i = 7; i >= 0; --i) {
            p = this.projectedFrustumCorners[i];
            while (k - start >= 2 && !((c = (x1 = p.x - this.convexHull[k - 1].x) * (y2 = p.y - this.convexHull[k - 2].y) - (y1 = p.y - this.convexHull[k - 1].y) * (x2 = p.x - this.convexHull[k - 2].x)) < 0.0f)) {
                --k;
            }
            this.convexHull[k++] = p;
        }
        this.convexHullSize = --k;
    }

    private static final class Vector2fComparator
    implements Comparator {
        Vector2fComparator() {
        }

        public int compare(Object a, Object b) {
            Vector2f p1 = (Vector2f)a;
            Vector2f p2 = (Vector2f)b;
            if (p1.x == p2.x) {
                return p1.y > p2.y ? 1 : (p1.y < p2.y ? -1 : 0);
            }
            return p1.x > p2.x ? 1 : (p1.x < p2.x ? -1 : 0);
        }
    }
}

