/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.MemUtil;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3d;

public class Vector3f
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;

    public Vector3f() {
    }

    public Vector3f(float d) {
        this(d, d, d);
    }

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3f(Vector3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public Vector3f(Vector2f v, float z) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
    }

    public Vector3f(ByteBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3f(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector3f(FloatBuffer buffer) {
        this(buffer.position(), buffer);
    }

    public Vector3f(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
    }

    public Vector3f set(Vector3f v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        return this;
    }

    public Vector3f set(Vector3d v) {
        this.x = (float)v.x;
        this.y = (float)v.y;
        this.z = (float)v.z;
        return this;
    }

    public Vector3f set(Vector2f v, float z) {
        this.x = v.x;
        this.y = v.y;
        this.z = z;
        return this;
    }

    public Vector3f set(float d) {
        return this.set(d, d, d);
    }

    public Vector3f set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vector3f set(ByteBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3f set(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public Vector3f set(FloatBuffer buffer) {
        return this.set(buffer.position(), buffer);
    }

    public Vector3f set(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.get(this, index, buffer);
        return this;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public Vector3f sub(Vector3f v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Vector3f sub(Vector3f v, Vector3f dest) {
        dest.x = this.x - v.x;
        dest.y = this.y - v.y;
        dest.z = this.z - v.z;
        return dest;
    }

    public Vector3f sub(float x, float y, float z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vector3f sub(float x, float y, float z, Vector3f dest) {
        dest.x = this.x - x;
        dest.y = this.y - y;
        dest.z = this.z - z;
        return dest;
    }

    public Vector3f add(Vector3f v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Vector3f add(Vector3f v, Vector3f dest) {
        dest.x = this.x + v.x;
        dest.y = this.y + v.y;
        dest.z = this.z + v.z;
        return dest;
    }

    public Vector3f add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3f add(float x, float y, float z, Vector3f dest) {
        dest.x = this.x + x;
        dest.y = this.y + y;
        dest.z = this.z + z;
        return dest;
    }

    public Vector3f fma(Vector3f a, Vector3f b) {
        this.x += a.x * b.x;
        this.y += a.y * b.y;
        this.z += a.z * b.z;
        return this;
    }

    public Vector3f fma(float a, Vector3f b) {
        this.x += a * b.x;
        this.y += a * b.y;
        this.z += a * b.z;
        return this;
    }

    public Vector3f fma(Vector3f a, Vector3f b, Vector3f dest) {
        dest.x = this.x + a.x * b.x;
        dest.y = this.y + a.y * b.y;
        dest.z = this.z + a.z * b.z;
        return dest;
    }

    public Vector3f fma(float a, Vector3f b, Vector3f dest) {
        dest.x = this.x + a * b.x;
        dest.y = this.y + a * b.y;
        dest.z = this.z + a * b.z;
        return dest;
    }

    public Vector3f mul(Vector3f v) {
        this.x *= v.x;
        this.y *= v.y;
        this.z *= v.z;
        return this;
    }

    public Vector3f mul(Vector3f v, Vector3f dest) {
        dest.x = this.x * v.x;
        dest.y = this.y * v.y;
        dest.z = this.z * v.z;
        return dest;
    }

    public Vector3f div(Vector3f v) {
        this.x /= v.x;
        this.y /= v.y;
        this.z /= v.z;
        return this;
    }

    public Vector3f div(Vector3f v, Vector3f dest) {
        dest.x = this.x / v.x;
        dest.y = this.y / v.y;
        dest.z = this.z / v.z;
        return dest;
    }

    public Vector3f mulProject(Matrix4f mat, Vector3f dest) {
        float invW = 1.0f / (mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33());
        dest.set((mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30()) * invW, (mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31()) * invW, (mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32()) * invW);
        return dest;
    }

    public Vector3f mulProject(Matrix4f mat) {
        return this.mulProject(mat, this);
    }

    public Vector3f mul(Matrix3f mat) {
        return this.mul(mat, this);
    }

    public Vector3f mul(Matrix3f mat, Vector3f dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3f mulTranspose(Matrix3f mat) {
        return this.mul(mat, this);
    }

    public Vector3f mulTranspose(Matrix3f mat, Vector3f dest) {
        dest.set(mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z, mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z, mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3f mulPosition(Matrix4f mat) {
        return this.mulPosition(mat, this);
    }

    public Vector3f mulPosition(Matrix4f mat, Vector3f dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30(), mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31(), mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32());
        return dest;
    }

    public Vector3f mulTransposePosition(Matrix4f mat) {
        return this.mulTransposePosition(mat, this);
    }

    public Vector3f mulTransposePosition(Matrix4f mat, Vector3f dest) {
        dest.set(mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z + mat.m03(), mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z + mat.m13(), mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z + mat.m23());
        return dest;
    }

    public float mulPositionW(Matrix4f mat) {
        return this.mulPositionW(mat, this);
    }

    public float mulPositionW(Matrix4f mat, Vector3f dest) {
        float w = mat.m03() * this.x + mat.m13() * this.y + mat.m23() * this.z + mat.m33();
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z + mat.m30(), mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z + mat.m31(), mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z + mat.m32());
        return w;
    }

    public Vector3f mulDirection(Matrix4f mat) {
        return this.mulDirection(mat, this);
    }

    public Vector3f mulDirection(Matrix4f mat, Vector3f dest) {
        dest.set(mat.m00() * this.x + mat.m10() * this.y + mat.m20() * this.z, mat.m01() * this.x + mat.m11() * this.y + mat.m21() * this.z, mat.m02() * this.x + mat.m12() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3f mulTransposeDirection(Matrix4f mat) {
        return this.mulTransposeDirection(mat, this);
    }

    public Vector3f mulTransposeDirection(Matrix4f mat, Vector3f dest) {
        dest.set(mat.m00() * this.x + mat.m01() * this.y + mat.m02() * this.z, mat.m10() * this.x + mat.m11() * this.y + mat.m12() * this.z, mat.m20() * this.x + mat.m21() * this.y + mat.m22() * this.z);
        return dest;
    }

    public Vector3f mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        return this;
    }

    public Vector3f mul(float scalar, Vector3f dest) {
        dest.x = this.x * scalar;
        dest.y = this.y * scalar;
        dest.z = this.z * scalar;
        return dest;
    }

    public Vector3f mul(float x, float y, float z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vector3f mul(float x, float y, float z, Vector3f dest) {
        dest.x = this.x * x;
        dest.y = this.y * y;
        dest.z = this.z * z;
        return dest;
    }

    public Vector3f div(float scalar) {
        this.x /= scalar;
        this.y /= scalar;
        this.z /= scalar;
        return this;
    }

    public Vector3f div(float scalar, Vector3f dest) {
        dest.x = this.x / scalar;
        dest.y = this.y / scalar;
        dest.z = this.z / scalar;
        return dest;
    }

    public Vector3f div(float x, float y, float z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
        return this;
    }

    public Vector3f div(float x, float y, float z, Vector3f dest) {
        dest.x = this.x / x;
        dest.y = this.y / y;
        dest.z = this.z / z;
        return dest;
    }

    public Vector3f rotate(Quaternionf quat) {
        quat.transform(this, this);
        return this;
    }

    public Vector3f rotate(Quaternionf quat, Vector3f dest) {
        quat.transform(this, dest);
        return dest;
    }

    public Quaternionf rotationTo(Vector3f toDir, Quaternionf dest) {
        return dest.rotationTo(this, toDir);
    }

    public Quaternionf rotationTo(float toDirX, float toDirY, float toDirZ, Quaternionf dest) {
        return dest.rotationTo(this.x, this.y, this.z, toDirX, toDirY, toDirZ);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public Vector3f normalize() {
        float invLength = 1.0f / this.length();
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        return this;
    }

    public Vector3f normalize(Vector3f dest) {
        float invLength = 1.0f / this.length();
        dest.x = this.x * invLength;
        dest.y = this.y * invLength;
        dest.z = this.z * invLength;
        return dest;
    }

    public Vector3f cross(Vector3f v) {
        return this.set(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public Vector3f cross(float x, float y, float z) {
        return this.set(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public Vector3f cross(Vector3f v, Vector3f dest) {
        return dest.set(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public Vector3f cross(float x, float y, float z, Vector3f dest) {
        return dest.set(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public float distance(Vector3f v) {
        float dx = v.x - this.x;
        float dy = v.y - this.y;
        float dz = v.z - this.z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public float distance(float x, float y, float z) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public float distanceSquared(Vector3f v) {
        float dx = v.x - this.x;
        float dy = v.y - this.y;
        float dz = v.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceSquared(float x, float y, float z) {
        float dx = this.x - x;
        float dy = this.y - y;
        float dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public float dot(Vector3f v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public float dot(float x, float y, float z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public float angleCos(Vector3f v) {
        double length1Sqared = this.x * this.x + this.y * this.y + this.z * this.z;
        double length2Sqared = v.x * v.x + v.y * v.y + v.z * v.z;
        double dot = this.x * v.x + this.y * v.y + this.z * v.z;
        return (float)(dot / Math.sqrt(length1Sqared * length2Sqared));
    }

    public float angle(Vector3f v) {
        float cos = this.angleCos(v);
        cos = cos < 1.0f ? cos : 1.0f;
        cos = cos > -1.0f ? cos : -1.0f;
        return (float)Math.acos(cos);
    }

    public Vector3f min(Vector3f v) {
        this.x = this.x < v.x ? this.x : v.x;
        this.y = this.y < v.y ? this.y : v.y;
        this.z = this.z < v.z ? this.z : v.z;
        return this;
    }

    public Vector3f max(Vector3f v) {
        this.x = this.x > v.x ? this.x : v.x;
        this.y = this.y > v.y ? this.y : v.y;
        this.z = this.z > v.z ? this.z : v.z;
        return this;
    }

    public Vector3f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        return this;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        return this.toString(formatter).replaceAll("E(\\d+)", "E+$1");
    }

    public String toString(NumberFormat formatter) {
        return "(" + formatter.format(this.x) + " " + formatter.format(this.y) + " " + formatter.format(this.z) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
    }

    public Vector3f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3f negate(Vector3f dest) {
        dest.x = -this.x;
        dest.y = -this.y;
        dest.z = -this.z;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3f other = (Vector3f)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public Vector3f reflect(Vector3f normal) {
        float dot = this.dot(normal);
        this.x -= (dot + dot) * normal.x;
        this.y -= (dot + dot) * normal.y;
        this.z -= (dot + dot) * normal.z;
        return this;
    }

    public Vector3f reflect(float x, float y, float z) {
        float dot = this.dot(x, y, z);
        this.x -= (dot + dot) * x;
        this.y -= (dot + dot) * y;
        this.z -= (dot + dot) * z;
        return this;
    }

    public Vector3f reflect(Vector3f normal, Vector3f dest) {
        float dot = this.dot(normal);
        dest.x = this.x - (dot + dot) * normal.x;
        dest.y = this.y - (dot + dot) * normal.y;
        dest.z = this.z - (dot + dot) * normal.z;
        return dest;
    }

    public Vector3f reflect(float x, float y, float z, Vector3f dest) {
        float dot = this.dot(x, y, z);
        dest.x = this.x - (dot + dot) * x;
        dest.y = this.y - (dot + dot) * y;
        dest.z = this.z - (dot + dot) * z;
        return dest;
    }

    public Vector3f half(Vector3f other) {
        return this.add(other).normalize();
    }

    public Vector3f half(float x, float y, float z) {
        return this.add(x, y, z).normalize();
    }

    public Vector3f half(Vector3f other, Vector3f dest) {
        return dest.set(this).add(other).normalize();
    }

    public Vector3f half(float x, float y, float z, Vector3f dest) {
        return dest.set(this).add(x, y, z).normalize();
    }

    public Vector3f smoothStep(Vector3f v, float t, Vector3f dest) {
        float t2 = t * t;
        float t3 = t2 * t;
        dest.x = (this.x + this.x - v.x - v.x) * t3 + (3.0f * v.x - 3.0f * this.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v.y - v.y) * t3 + (3.0f * v.y - 3.0f * this.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v.z - v.z) * t3 + (3.0f * v.z - 3.0f * this.z) * t2 + this.z * t + this.z;
        return dest;
    }

    public Vector3f hermite(Vector3f t0, Vector3f v1, Vector3f t1, float t, Vector3f dest) {
        float t2 = t * t;
        float t3 = t2 * t;
        dest.x = (this.x + this.x - v1.x - v1.x + t1.x + t0.x) * t3 + (3.0f * v1.x - 3.0f * this.x - t0.x - t0.x - t1.x) * t2 + this.x * t + this.x;
        dest.y = (this.y + this.y - v1.y - v1.y + t1.y + t0.y) * t3 + (3.0f * v1.y - 3.0f * this.y - t0.y - t0.y - t1.y) * t2 + this.y * t + this.y;
        dest.z = (this.z + this.z - v1.z - v1.z + t1.z + t0.z) * t3 + (3.0f * v1.z - 3.0f * this.z - t0.z - t0.z - t1.z) * t2 + this.z * t + this.z;
        return dest;
    }

    public Vector3f lerp(Vector3f other, float t) {
        return this.lerp(other, t, this);
    }

    public Vector3f lerp(Vector3f other, float t, Vector3f dest) {
        dest.x = this.x + (other.x - this.x) * t;
        dest.y = this.y + (other.y - this.y) * t;
        dest.z = this.z + (other.z - this.z) * t;
        return dest;
    }

    public float get(int component) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector3f set(int component, float value) throws IllegalArgumentException {
        switch (component) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public int maxComponent() {
        float absX = Math.abs(this.x);
        float absY = Math.abs(this.y);
        float absZ = Math.abs(this.z);
        if (absX >= absY && absX >= absZ) {
            return 0;
        }
        if (absY >= absZ) {
            return 1;
        }
        return 2;
    }

    public int minComponent() {
        float absX = Math.abs(this.x);
        float absY = Math.abs(this.y);
        float absZ = Math.abs(this.z);
        if (absX < absY && absX < absZ) {
            return 0;
        }
        if (absY < absZ) {
            return 1;
        }
        return 2;
    }

    public Vector3f orthogonalize(Vector3f v, Vector3f dest) {
        float invLenV = 1.0f / (float)Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
        float vx = v.x * invLenV;
        float vy = v.y * invLenV;
        float vz = v.z * invLenV;
        float dot = vx * this.x + vy * this.y + vz * this.z;
        float rx = this.x - dot * vx;
        float ry = this.y - dot * vy;
        float rz = this.z - dot * vz;
        float invLen = 1.0f / (float)Math.sqrt(rx * rx + ry * ry + rz * rz);
        dest.x = rx * invLen;
        dest.y = ry * invLen;
        dest.z = rz * invLen;
        return dest;
    }

    public Vector3f orthogonalize(Vector3f v) {
        return this.orthogonalize(v, this);
    }

    public Vector3f orthogonalizeUnit(Vector3f v, Vector3f dest) {
        float vx = v.x;
        float vy = v.y;
        float vz = v.z;
        float dot = vx * this.x + vy * this.y + vz * this.z;
        float rx = this.x - dot * vx;
        float ry = this.y - dot * vy;
        float rz = this.z - dot * vz;
        float invLen = 1.0f / (float)Math.sqrt(rx * rx + ry * ry + rz * rz);
        dest.x = rx * invLen;
        dest.y = ry * invLen;
        dest.z = rz * invLen;
        return dest;
    }

    public Vector3f orthogonalizeUnit(Vector3f v) {
        return this.orthogonalizeUnit(v, this);
    }
}

