/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class PointerBuffer
extends CustomBuffer<PointerBuffer>
implements Comparable<PointerBuffer> {
    protected PointerBuffer(long address, ByteBuffer container, int mark, int position, int limit, int capacity) {
        super(address, container, mark, position, limit, capacity);
    }

    public static PointerBuffer allocateDirect(int capacity) {
        ByteBuffer source = BufferUtils.createByteBuffer(capacity << POINTER_SHIFT);
        return new PointerBuffer(MemoryUtil.memAddress(source), source, -1, 0, capacity, capacity);
    }

    public static PointerBuffer create(long address, int capacity) {
        return new PointerBuffer(address, null, -1, 0, capacity, capacity);
    }

    public static PointerBuffer create(ByteBuffer source) {
        int capacity = source.remaining() >> POINTER_SHIFT;
        return new PointerBuffer(MemoryUtil.memAddress(source), source, -1, 0, capacity, capacity);
    }

    @Override
    protected PointerBuffer self() {
        return this;
    }

    @Override
    protected int sizeof() {
        return Pointer.POINTER_SIZE;
    }

    @Override
    protected PointerBuffer newBufferInstance(long address, ByteBuffer container, int mark, int position, int limit, int capacity) {
        return new PointerBuffer(address, container, mark, position, limit, capacity);
    }

    public long get() {
        return MemoryUtil.memGetAddress(this.address + (long)(this.nextGetIndex() << POINTER_SHIFT));
    }

    public static long get(ByteBuffer source) {
        if (source.limit() < source.position() + POINTER_SIZE) {
            throw new BufferUnderflowException();
        }
        try {
            long l = MemoryUtil.memGetAddress(MemoryUtil.memAddress(source));
            return l;
        }
        finally {
            source.position(source.position() + POINTER_SIZE);
        }
    }

    @Override
    public PointerBuffer put(long p) {
        MemoryUtil.memPutAddress(this.address + (long)(this.nextPutIndex() << POINTER_SHIFT), p);
        return this;
    }

    public static void put(ByteBuffer target, long p) {
        if (target.limit() < target.position() + POINTER_SIZE) {
            throw new BufferOverflowException();
        }
        try {
            MemoryUtil.memPutAddress(MemoryUtil.memAddress(target), p);
        }
        finally {
            target.position(target.position() + POINTER_SIZE);
        }
    }

    public long get(int index) {
        return MemoryUtil.memGetAddress(this.address + (long)(this.checkIndex(index) << POINTER_SHIFT));
    }

    public static long get(ByteBuffer source, int index) {
        if (index < 0 || source.limit() < index + POINTER_SIZE) {
            throw new IndexOutOfBoundsException();
        }
        return MemoryUtil.memGetAddress(MemoryUtil.memAddress0(source) + (long)index);
    }

    public PointerBuffer put(int index, long p) {
        MemoryUtil.memPutAddress(this.address + (long)(this.checkIndex(index) << POINTER_SHIFT), p);
        return this;
    }

    public static void put(ByteBuffer target, int index, long p) {
        if (index < 0 || target.limit() < index + POINTER_SIZE) {
            throw new IndexOutOfBoundsException();
        }
        MemoryUtil.memPutAddress(MemoryUtil.memAddress0(target) + (long)index, p);
    }

    @Override
    public PointerBuffer put(Pointer pointer) {
        this.put(pointer.address());
        return this;
    }

    public PointerBuffer put(int index, Pointer pointer) {
        this.put(index, pointer.address());
        return this;
    }

    @Override
    public PointerBuffer put(ByteBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(ShortBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(IntBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(LongBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(FloatBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    @Override
    public PointerBuffer put(DoubleBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(PointerBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, ByteBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, ShortBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, IntBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, LongBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, FloatBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(int index, DoubleBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(int index, PointerBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
        return this;
    }

    public ByteBuffer getByteBuffer(int size) {
        return MemoryUtil.memByteBuffer(this.get(), size);
    }

    public ShortBuffer getShortBuffer(int size) {
        return MemoryUtil.memShortBuffer(this.get(), size);
    }

    public IntBuffer getIntBuffer(int size) {
        return MemoryUtil.memIntBuffer(this.get(), size);
    }

    public LongBuffer getLongBuffer(int size) {
        return MemoryUtil.memLongBuffer(this.get(), size);
    }

    public FloatBuffer getFloatBuffer(int size) {
        return MemoryUtil.memFloatBuffer(this.get(), size);
    }

    public DoubleBuffer getDoubleBuffer(int size) {
        return MemoryUtil.memDoubleBuffer(this.get(), size);
    }

    public PointerBuffer getPointerBuffer(int size) {
        return MemoryUtil.memPointerBuffer(this.get(), size);
    }

    public String getStringASCII() {
        return MemoryUtil.memASCII(this.get());
    }

    public String getStringUTF8() {
        return MemoryUtil.memUTF8(this.get());
    }

    public String getStringUTF16() {
        return MemoryUtil.memUTF16(this.get());
    }

    public ByteBuffer getByteBuffer(int index, int size) {
        return MemoryUtil.memByteBuffer(this.get(index), size);
    }

    public ShortBuffer getShortBuffer(int index, int size) {
        return MemoryUtil.memShortBuffer(this.get(index), size);
    }

    public IntBuffer getIntBuffer(int index, int size) {
        return MemoryUtil.memIntBuffer(this.get(index), size);
    }

    public LongBuffer getLongBuffer(int index, int size) {
        return MemoryUtil.memLongBuffer(this.get(index), size);
    }

    public FloatBuffer getFloatBuffer(int index, int size) {
        return MemoryUtil.memFloatBuffer(this.get(index), size);
    }

    public DoubleBuffer getDoubleBuffer(int index, int size) {
        return MemoryUtil.memDoubleBuffer(this.get(index), size);
    }

    public PointerBuffer getPointerBuffer(int index, int size) {
        return MemoryUtil.memPointerBuffer(this.get(index), size);
    }

    public String getStringASCII(int index) {
        return MemoryUtil.memASCII(this.get(index));
    }

    public String getStringUTF8(int index) {
        return MemoryUtil.memUTF8(this.get(index));
    }

    public String getStringUTF16(int index) {
        return MemoryUtil.memUTF16(this.get(index));
    }

    public PointerBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public PointerBuffer get(long[] dst, int offset, int length) {
        PointerBuffer.checkBounds(offset, length, dst.length);
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    @Override
    public PointerBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public PointerBuffer put(long[] src, int offset, int length) {
        PointerBuffer.checkBounds(offset, length, src.length);
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + (int)this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof PointerBuffer)) {
            return false;
        }
        PointerBuffer that = (PointerBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public int compareTo(PointerBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    private static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

