/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIFace
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNUMINDICES;
    public static final int MINDICES;

    AIFace(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIFace(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIFace.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int mNumIndices() {
        return AIFace.nmNumIndices(this.address());
    }

    public IntBuffer mIndices() {
        return AIFace.nmIndices(this.address());
    }

    public AIFace mIndices(IntBuffer value) {
        AIFace.nmIndices(this.address(), value);
        return this;
    }

    public AIFace set(AIFace src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIFace malloc() {
        return AIFace.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIFace calloc() {
        return AIFace.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIFace create() {
        return new AIFace(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIFace create(long address) {
        return address == 0L ? null : new AIFace(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIFace.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIFace.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIFace mallocStack() {
        return AIFace.mallocStack(MemoryStack.stackGet());
    }

    public static AIFace callocStack() {
        return AIFace.callocStack(MemoryStack.stackGet());
    }

    public static AIFace mallocStack(MemoryStack stack) {
        return AIFace.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIFace callocStack(MemoryStack stack) {
        return AIFace.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIFace.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIFace.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIFace.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIFace.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmNumIndices(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMINDICES);
    }

    public static IntBuffer nmIndices(long struct) {
        return MemoryUtil.memIntBuffer(MemoryUtil.memGetAddress(struct + (long)MINDICES), AIFace.nmNumIndices(struct));
    }

    public static void nmNumIndices(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMINDICES, value);
    }

    public static void nmIndices(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MINDICES, MemoryUtil.memAddress(value));
        AIFace.nmNumIndices(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MINDICES));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIFace.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIFace.__struct(AIFace.__member(4), AIFace.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNUMINDICES = layout.offsetof(0);
        MINDICES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIFace, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIFace newInstance(long address) {
            return new AIFace(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int mNumIndices() {
            return AIFace.nmNumIndices(this.address());
        }

        public IntBuffer mIndices() {
            return AIFace.nmIndices(this.address());
        }

        public Buffer mIndices(IntBuffer value) {
            AIFace.nmIndices(this.address(), value);
            return this;
        }
    }
}

