/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AILogStreamCallback;
import org.lwjgl.assimp.AILogStreamCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AILogStream
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CALLBACK;
    public static final int USER;

    AILogStream(long address, ByteBuffer container) {
        super(address, container);
    }

    public AILogStream(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AILogStream.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AILogStreamCallback callback() {
        return AILogStream.ncallback(this.address());
    }

    public long user() {
        return AILogStream.nuser(this.address());
    }

    public AILogStream callback(AILogStreamCallbackI value) {
        AILogStream.ncallback(this.address(), value);
        return this;
    }

    public AILogStream user(long value) {
        AILogStream.nuser(this.address(), value);
        return this;
    }

    public AILogStream set(AILogStreamCallbackI callback, long user) {
        this.callback(callback);
        this.user(user);
        return this;
    }

    public AILogStream set(AILogStream src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AILogStream malloc() {
        return AILogStream.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AILogStream calloc() {
        return AILogStream.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AILogStream create() {
        return new AILogStream(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AILogStream create(long address) {
        return address == 0L ? null : new AILogStream(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AILogStream.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AILogStream.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AILogStream mallocStack() {
        return AILogStream.mallocStack(MemoryStack.stackGet());
    }

    public static AILogStream callocStack() {
        return AILogStream.callocStack(MemoryStack.stackGet());
    }

    public static AILogStream mallocStack(MemoryStack stack) {
        return AILogStream.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AILogStream callocStack(MemoryStack stack) {
        return AILogStream.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AILogStream.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AILogStream.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AILogStream.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AILogStream.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AILogStreamCallback ncallback(long struct) {
        return AILogStreamCallback.create(MemoryUtil.memGetAddress(struct + (long)CALLBACK));
    }

    public static long nuser(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USER);
    }

    public static void ncallback(long struct, AILogStreamCallbackI value) {
        MemoryUtil.memPutAddress(struct + (long)CALLBACK, value.address());
    }

    public static void nuser(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USER, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)CALLBACK));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)USER));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AILogStream.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AILogStream.__struct(AILogStream.__member(POINTER_SIZE), AILogStream.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CALLBACK = layout.offsetof(0);
        USER = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AILogStream, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AILogStream newInstance(long address) {
            return new AILogStream(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AILogStreamCallback callback() {
            return AILogStream.ncallback(this.address());
        }

        public long user() {
            return AILogStream.nuser(this.address());
        }

        public Buffer callback(AILogStreamCallbackI value) {
            AILogStream.ncallback(this.address(), value);
            return this;
        }

        public Buffer user(long value) {
            AILogStream.nuser(this.address(), value);
            return this;
        }
    }
}

