/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIMaterialProperty
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MKEY;
    public static final int MSEMANTIC;
    public static final int MINDEX;
    public static final int MDATALENGTH;
    public static final int MTYPE;
    public static final int MDATA;

    AIMaterialProperty(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIMaterialProperty(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIMaterialProperty.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIString mKey() {
        return AIMaterialProperty.nmKey(this.address());
    }

    public int mSemantic() {
        return AIMaterialProperty.nmSemantic(this.address());
    }

    public int mIndex() {
        return AIMaterialProperty.nmIndex(this.address());
    }

    public int mDataLength() {
        return AIMaterialProperty.nmDataLength(this.address());
    }

    public int mType() {
        return AIMaterialProperty.nmType(this.address());
    }

    public ByteBuffer mData() {
        return AIMaterialProperty.nmData(this.address());
    }

    public static AIMaterialProperty create(long address) {
        return address == 0L ? null : new AIMaterialProperty(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIString nmKey(long struct) {
        return AIString.create(struct + (long)MKEY);
    }

    public static int nmSemantic(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MSEMANTIC);
    }

    public static int nmIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINDEX);
    }

    public static int nmDataLength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MDATALENGTH);
    }

    public static int nmType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MTYPE);
    }

    public static ByteBuffer nmData(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MDATA), AIMaterialProperty.nmDataLength(struct));
    }

    static {
        Struct.Layout layout = AIMaterialProperty.__struct(AIMaterialProperty.__member(AIString.SIZEOF, AIString.ALIGNOF), AIMaterialProperty.__member(4), AIMaterialProperty.__member(4), AIMaterialProperty.__member(4), AIMaterialProperty.__member(4), AIMaterialProperty.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MKEY = layout.offsetof(0);
        MSEMANTIC = layout.offsetof(1);
        MINDEX = layout.offsetof(2);
        MDATALENGTH = layout.offsetof(3);
        MTYPE = layout.offsetof(4);
        MDATA = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<AIMaterialProperty, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIMaterialProperty newInstance(long address) {
            return new AIMaterialProperty(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIString mKey() {
            return AIMaterialProperty.nmKey(this.address());
        }

        public int mSemantic() {
            return AIMaterialProperty.nmSemantic(this.address());
        }

        public int mIndex() {
            return AIMaterialProperty.nmIndex(this.address());
        }

        public int mDataLength() {
            return AIMaterialProperty.nmDataLength(this.address());
        }

        public int mType() {
            return AIMaterialProperty.nmType(this.address());
        }

        public ByteBuffer mData() {
            return AIMaterialProperty.nmData(this.address());
        }
    }
}

