/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMeshKey;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIMeshAnim
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MNUMKEYS;
    public static final int MKEYS;

    AIMeshAnim(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIMeshAnim(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIMeshAnim.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public AIString mName() {
        return AIMeshAnim.nmName(this.address());
    }

    public int mNumKeys() {
        return AIMeshAnim.nmNumKeys(this.address());
    }

    public AIMeshKey.Buffer mKeys() {
        return AIMeshAnim.nmKeys(this.address());
    }

    public AIMeshAnim mName(AIString value) {
        AIMeshAnim.nmName(this.address(), value);
        return this;
    }

    public AIMeshAnim mKeys(AIMeshKey.Buffer value) {
        AIMeshAnim.nmKeys(this.address(), value);
        return this;
    }

    public AIMeshAnim set(AIString mName, AIMeshKey.Buffer mKeys) {
        this.mName(mName);
        this.mKeys(mKeys);
        return this;
    }

    public AIMeshAnim set(AIMeshAnim src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIMeshAnim malloc() {
        return AIMeshAnim.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIMeshAnim calloc() {
        return AIMeshAnim.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIMeshAnim create() {
        return new AIMeshAnim(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIMeshAnim create(long address) {
        return address == 0L ? null : new AIMeshAnim(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIMeshAnim.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMeshAnim.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIMeshAnim mallocStack() {
        return AIMeshAnim.mallocStack(MemoryStack.stackGet());
    }

    public static AIMeshAnim callocStack() {
        return AIMeshAnim.callocStack(MemoryStack.stackGet());
    }

    public static AIMeshAnim mallocStack(MemoryStack stack) {
        return AIMeshAnim.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMeshAnim callocStack(MemoryStack stack) {
        return AIMeshAnim.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMeshAnim.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMeshAnim.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMeshAnim.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMeshAnim.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumKeys(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMKEYS);
    }

    public static AIMeshKey.Buffer nmKeys(long struct) {
        return AIMeshKey.create(MemoryUtil.memGetAddress(struct + (long)MKEYS), AIMeshAnim.nmNumKeys(struct));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmNumKeys(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMKEYS, value);
    }

    public static void nmKeys(long struct, AIMeshKey.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)MKEYS, value.address());
        AIMeshAnim.nmNumKeys(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MKEYS));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMeshAnim.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIMeshAnim.__struct(AIMeshAnim.__member(AIString.SIZEOF, AIString.ALIGNOF), AIMeshAnim.__member(4), AIMeshAnim.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MNUMKEYS = layout.offsetof(1);
        MKEYS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIMeshAnim, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIMeshAnim newInstance(long address) {
            return new AIMeshAnim(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public AIString mName() {
            return AIMeshAnim.nmName(this.address());
        }

        public int mNumKeys() {
            return AIMeshAnim.nmNumKeys(this.address());
        }

        public AIMeshKey.Buffer mKeys() {
            return AIMeshAnim.nmKeys(this.address());
        }

        public Buffer mName(AIString value) {
            AIMeshAnim.nmName(this.address(), value);
            return this;
        }

        public Buffer mKeys(AIMeshKey.Buffer value) {
            AIMeshAnim.nmKeys(this.address(), value);
            return this;
        }
    }
}

