/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIMetaDataEntry
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTYPE;
    public static final int MDATA;

    AIMetaDataEntry(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIMetaDataEntry(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIMetaDataEntry.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int mType() {
        return AIMetaDataEntry.nmType(this.address());
    }

    public ByteBuffer mData(int capacity) {
        return AIMetaDataEntry.nmData(this.address(), capacity);
    }

    public AIMetaDataEntry mType(int value) {
        AIMetaDataEntry.nmType(this.address(), value);
        return this;
    }

    public AIMetaDataEntry mData(ByteBuffer value) {
        AIMetaDataEntry.nmData(this.address(), value);
        return this;
    }

    public AIMetaDataEntry set(int mType, ByteBuffer mData) {
        this.mType(mType);
        this.mData(mData);
        return this;
    }

    public AIMetaDataEntry set(AIMetaDataEntry src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIMetaDataEntry malloc() {
        return AIMetaDataEntry.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIMetaDataEntry calloc() {
        return AIMetaDataEntry.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIMetaDataEntry create() {
        return new AIMetaDataEntry(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIMetaDataEntry create(long address) {
        return address == 0L ? null : new AIMetaDataEntry(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIMetaDataEntry.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIMetaDataEntry.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIMetaDataEntry mallocStack() {
        return AIMetaDataEntry.mallocStack(MemoryStack.stackGet());
    }

    public static AIMetaDataEntry callocStack() {
        return AIMetaDataEntry.callocStack(MemoryStack.stackGet());
    }

    public static AIMetaDataEntry mallocStack(MemoryStack stack) {
        return AIMetaDataEntry.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMetaDataEntry callocStack(MemoryStack stack) {
        return AIMetaDataEntry.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMetaDataEntry.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMetaDataEntry.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIMetaDataEntry.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIMetaDataEntry.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MTYPE);
    }

    public static ByteBuffer nmData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MDATA), capacity);
    }

    public static void nmType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MTYPE, value);
    }

    public static void nmData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MDATA, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MDATA));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMetaDataEntry.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIMetaDataEntry.__struct(AIMetaDataEntry.__member(4), AIMetaDataEntry.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTYPE = layout.offsetof(0);
        MDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIMetaDataEntry, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIMetaDataEntry newInstance(long address) {
            return new AIMetaDataEntry(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int mType() {
            return AIMetaDataEntry.nmType(this.address());
        }

        public ByteBuffer mData(int capacity) {
            return AIMetaDataEntry.nmData(this.address(), capacity);
        }

        public Buffer mType(int value) {
            AIMetaDataEntry.nmType(this.address(), value);
            return this;
        }

        public Buffer mData(ByteBuffer value) {
            AIMetaDataEntry.nmData(this.address(), value);
            return this;
        }
    }
}

