/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIQuaternion;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIQuatKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;

    AIQuatKey(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIQuatKey(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIQuatKey.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIQuatKey.nmTime(this.address());
    }

    public AIQuaternion mValue() {
        return AIQuatKey.nmValue(this.address());
    }

    public AIQuatKey mTime(double value) {
        AIQuatKey.nmTime(this.address(), value);
        return this;
    }

    public AIQuatKey mValue(AIQuaternion value) {
        AIQuatKey.nmValue(this.address(), value);
        return this;
    }

    public AIQuatKey set(double mTime, AIQuaternion mValue) {
        this.mTime(mTime);
        this.mValue(mValue);
        return this;
    }

    public AIQuatKey set(AIQuatKey src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIQuatKey malloc() {
        return AIQuatKey.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIQuatKey calloc() {
        return AIQuatKey.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIQuatKey create() {
        return new AIQuatKey(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIQuatKey create(long address) {
        return address == 0L ? null : new AIQuatKey(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIQuatKey.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIQuatKey.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIQuatKey mallocStack() {
        return AIQuatKey.mallocStack(MemoryStack.stackGet());
    }

    public static AIQuatKey callocStack() {
        return AIQuatKey.callocStack(MemoryStack.stackGet());
    }

    public static AIQuatKey mallocStack(MemoryStack stack) {
        return AIQuatKey.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIQuatKey callocStack(MemoryStack stack) {
        return AIQuatKey.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIQuatKey.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIQuatKey.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIQuatKey.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIQuatKey.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nmTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MTIME);
    }

    public static AIQuaternion nmValue(long struct) {
        return AIQuaternion.create(struct + (long)MVALUE);
    }

    public static void nmTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MTIME, value);
    }

    public static void nmValue(long struct, AIQuaternion value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MVALUE, AIQuaternion.SIZEOF);
    }

    static {
        Struct.Layout layout = AIQuatKey.__struct(AIQuatKey.__member(8), AIQuatKey.__member(AIQuaternion.SIZEOF, AIQuaternion.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIQuatKey, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIQuatKey newInstance(long address) {
            return new AIQuatKey(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public double mTime() {
            return AIQuatKey.nmTime(this.address());
        }

        public AIQuaternion mValue() {
            return AIQuatKey.nmValue(this.address());
        }

        public Buffer mTime(double value) {
            AIQuatKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(AIQuaternion value) {
            AIQuatKey.nmValue(this.address(), value);
            return this;
        }
    }
}

