/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AINode;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIScene
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MFLAGS;
    public static final int MROOTNODE;
    public static final int MNUMMESHES;
    public static final int MMESHES;
    public static final int MNUMMATERIALS;
    public static final int MMATERIALS;
    public static final int MNUMANIMATIONS;
    public static final int MANIMATIONS;
    public static final int MNUMTEXTURES;
    public static final int MTEXTURES;
    public static final int MNUMLIGHTS;
    public static final int MLIGHTS;
    public static final int MNUMCAMERAS;
    public static final int MCAMERAS;
    public static final int MPRIVATE;

    AIScene(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIScene(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIScene.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int mFlags() {
        return AIScene.nmFlags(this.address());
    }

    public AINode mRootNode() {
        return AIScene.nmRootNode(this.address());
    }

    public int mNumMeshes() {
        return AIScene.nmNumMeshes(this.address());
    }

    public PointerBuffer mMeshes() {
        return AIScene.nmMeshes(this.address());
    }

    public int mNumMaterials() {
        return AIScene.nmNumMaterials(this.address());
    }

    public PointerBuffer mMaterials() {
        return AIScene.nmMaterials(this.address());
    }

    public int mNumAnimations() {
        return AIScene.nmNumAnimations(this.address());
    }

    public PointerBuffer mAnimations() {
        return AIScene.nmAnimations(this.address());
    }

    public int mNumTextures() {
        return AIScene.nmNumTextures(this.address());
    }

    public PointerBuffer mTextures() {
        return AIScene.nmTextures(this.address());
    }

    public int mNumLights() {
        return AIScene.nmNumLights(this.address());
    }

    public PointerBuffer mLights() {
        return AIScene.nmLights(this.address());
    }

    public int mNumCameras() {
        return AIScene.nmNumCameras(this.address());
    }

    public PointerBuffer mCameras() {
        return AIScene.nmCameras(this.address());
    }

    public AIScene mFlags(int value) {
        AIScene.nmFlags(this.address(), value);
        return this;
    }

    public AIScene mRootNode(AINode value) {
        AIScene.nmRootNode(this.address(), value);
        return this;
    }

    public AIScene mMeshes(PointerBuffer value) {
        AIScene.nmMeshes(this.address(), value);
        return this;
    }

    public AIScene mMaterials(PointerBuffer value) {
        AIScene.nmMaterials(this.address(), value);
        return this;
    }

    public AIScene mAnimations(PointerBuffer value) {
        AIScene.nmAnimations(this.address(), value);
        return this;
    }

    public AIScene mTextures(PointerBuffer value) {
        AIScene.nmTextures(this.address(), value);
        return this;
    }

    public AIScene mLights(PointerBuffer value) {
        AIScene.nmLights(this.address(), value);
        return this;
    }

    public AIScene mCameras(PointerBuffer value) {
        AIScene.nmCameras(this.address(), value);
        return this;
    }

    public AIScene set(int mFlags, AINode mRootNode, PointerBuffer mMeshes, PointerBuffer mMaterials, PointerBuffer mAnimations, PointerBuffer mTextures, PointerBuffer mLights, PointerBuffer mCameras) {
        this.mFlags(mFlags);
        this.mRootNode(mRootNode);
        this.mMeshes(mMeshes);
        this.mMaterials(mMaterials);
        this.mAnimations(mAnimations);
        this.mTextures(mTextures);
        this.mLights(mLights);
        this.mCameras(mCameras);
        return this;
    }

    public AIScene set(AIScene src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIScene malloc() {
        return AIScene.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIScene calloc() {
        return AIScene.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIScene create() {
        return new AIScene(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIScene create(long address) {
        return address == 0L ? null : new AIScene(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIScene.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIScene.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIScene mallocStack() {
        return AIScene.mallocStack(MemoryStack.stackGet());
    }

    public static AIScene callocStack() {
        return AIScene.callocStack(MemoryStack.stackGet());
    }

    public static AIScene mallocStack(MemoryStack stack) {
        return AIScene.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIScene callocStack(MemoryStack stack) {
        return AIScene.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIScene.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIScene.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIScene.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIScene.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MFLAGS);
    }

    public static AINode nmRootNode(long struct) {
        return AINode.create(MemoryUtil.memGetAddress(struct + (long)MROOTNODE));
    }

    public static int nmNumMeshes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMMESHES);
    }

    public static PointerBuffer nmMeshes(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MMESHES), AIScene.nmNumMeshes(struct));
    }

    public static int nmNumMaterials(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMMATERIALS);
    }

    public static PointerBuffer nmMaterials(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MMATERIALS), AIScene.nmNumMaterials(struct));
    }

    public static int nmNumAnimations(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMANIMATIONS);
    }

    public static PointerBuffer nmAnimations(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MANIMATIONS), AIScene.nmNumAnimations(struct));
    }

    public static int nmNumTextures(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMTEXTURES);
    }

    public static PointerBuffer nmTextures(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MTEXTURES), AIScene.nmNumTextures(struct));
    }

    public static int nmNumLights(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMLIGHTS);
    }

    public static PointerBuffer nmLights(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MLIGHTS), AIScene.nmNumLights(struct));
    }

    public static int nmNumCameras(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MNUMCAMERAS);
    }

    public static PointerBuffer nmCameras(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)MCAMERAS), AIScene.nmNumCameras(struct));
    }

    public static ByteBuffer nmPrivate(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MPRIVATE), capacity);
    }

    public static void nmFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MFLAGS, value);
    }

    public static void nmRootNode(long struct, AINode value) {
        MemoryUtil.memPutAddress(struct + (long)MROOTNODE, AIScene.addressSafe(value));
    }

    public static void nmNumMeshes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMMESHES, value);
    }

    public static void nmMeshes(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMESHES, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumMeshes(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumMaterials(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMMATERIALS, value);
    }

    public static void nmMaterials(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMATERIALS, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumMaterials(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumAnimations(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMANIMATIONS, value);
    }

    public static void nmAnimations(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MANIMATIONS, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumAnimations(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumTextures(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMTEXTURES, value);
    }

    public static void nmTextures(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MTEXTURES, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumTextures(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumLights(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMLIGHTS, value);
    }

    public static void nmLights(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MLIGHTS, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumLights(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumCameras(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MNUMCAMERAS, value);
    }

    public static void nmCameras(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MCAMERAS, MemoryUtil.memAddressSafe(value));
        AIScene.nmNumCameras(struct, value == null ? 0 : value.remaining());
    }

    public static void nmPrivate(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MPRIVATE, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        if (AIScene.nmNumMeshes(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MMESHES));
        }
        if (AIScene.nmNumMaterials(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MMATERIALS));
        }
        if (AIScene.nmNumAnimations(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MANIMATIONS));
        }
        if (AIScene.nmNumTextures(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MTEXTURES));
        }
        if (AIScene.nmNumLights(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MLIGHTS));
        }
        if (AIScene.nmNumCameras(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MCAMERAS));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIScene.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = AIScene.__struct(AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(4), AIScene.__member(POINTER_SIZE), AIScene.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MFLAGS = layout.offsetof(0);
        MROOTNODE = layout.offsetof(1);
        MNUMMESHES = layout.offsetof(2);
        MMESHES = layout.offsetof(3);
        MNUMMATERIALS = layout.offsetof(4);
        MMATERIALS = layout.offsetof(5);
        MNUMANIMATIONS = layout.offsetof(6);
        MANIMATIONS = layout.offsetof(7);
        MNUMTEXTURES = layout.offsetof(8);
        MTEXTURES = layout.offsetof(9);
        MNUMLIGHTS = layout.offsetof(10);
        MLIGHTS = layout.offsetof(11);
        MNUMCAMERAS = layout.offsetof(12);
        MCAMERAS = layout.offsetof(13);
        MPRIVATE = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<AIScene, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIScene newInstance(long address) {
            return new AIScene(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int mFlags() {
            return AIScene.nmFlags(this.address());
        }

        public AINode mRootNode() {
            return AIScene.nmRootNode(this.address());
        }

        public int mNumMeshes() {
            return AIScene.nmNumMeshes(this.address());
        }

        public PointerBuffer mMeshes() {
            return AIScene.nmMeshes(this.address());
        }

        public int mNumMaterials() {
            return AIScene.nmNumMaterials(this.address());
        }

        public PointerBuffer mMaterials() {
            return AIScene.nmMaterials(this.address());
        }

        public int mNumAnimations() {
            return AIScene.nmNumAnimations(this.address());
        }

        public PointerBuffer mAnimations() {
            return AIScene.nmAnimations(this.address());
        }

        public int mNumTextures() {
            return AIScene.nmNumTextures(this.address());
        }

        public PointerBuffer mTextures() {
            return AIScene.nmTextures(this.address());
        }

        public int mNumLights() {
            return AIScene.nmNumLights(this.address());
        }

        public PointerBuffer mLights() {
            return AIScene.nmLights(this.address());
        }

        public int mNumCameras() {
            return AIScene.nmNumCameras(this.address());
        }

        public PointerBuffer mCameras() {
            return AIScene.nmCameras(this.address());
        }

        public Buffer mFlags(int value) {
            AIScene.nmFlags(this.address(), value);
            return this;
        }

        public Buffer mRootNode(AINode value) {
            AIScene.nmRootNode(this.address(), value);
            return this;
        }

        public Buffer mMeshes(PointerBuffer value) {
            AIScene.nmMeshes(this.address(), value);
            return this;
        }

        public Buffer mMaterials(PointerBuffer value) {
            AIScene.nmMaterials(this.address(), value);
            return this;
        }

        public Buffer mAnimations(PointerBuffer value) {
            AIScene.nmAnimations(this.address(), value);
            return this;
        }

        public Buffer mTextures(PointerBuffer value) {
            AIScene.nmTextures(this.address(), value);
            return this;
        }

        public Buffer mLights(PointerBuffer value) {
            AIScene.nmLights(this.address(), value);
            return this;
        }

        public Buffer mCameras(PointerBuffer value) {
            AIScene.nmCameras(this.address(), value);
            return this;
        }
    }
}

