/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class AIVectorKey
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MTIME;
    public static final int MVALUE;

    AIVectorKey(long address, ByteBuffer container) {
        super(address, container);
    }

    public AIVectorKey(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), AIVectorKey.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public double mTime() {
        return AIVectorKey.nmTime(this.address());
    }

    public AIVector3D mValue() {
        return AIVectorKey.nmValue(this.address());
    }

    public AIVectorKey mTime(double value) {
        AIVectorKey.nmTime(this.address(), value);
        return this;
    }

    public AIVectorKey mValue(AIVector3D value) {
        AIVectorKey.nmValue(this.address(), value);
        return this;
    }

    public AIVectorKey set(double mTime, AIVector3D mValue) {
        this.mTime(mTime);
        this.mValue(mValue);
        return this;
    }

    public AIVectorKey set(AIVectorKey src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIVectorKey malloc() {
        return AIVectorKey.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static AIVectorKey calloc() {
        return AIVectorKey.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static AIVectorKey create() {
        return new AIVectorKey(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static AIVectorKey create(long address) {
        return address == 0L ? null : new AIVectorKey(address, null);
    }

    public static Buffer malloc(int capacity) {
        return AIVectorKey.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return AIVectorKey.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static AIVectorKey mallocStack() {
        return AIVectorKey.mallocStack(MemoryStack.stackGet());
    }

    public static AIVectorKey callocStack() {
        return AIVectorKey.callocStack(MemoryStack.stackGet());
    }

    public static AIVectorKey mallocStack(MemoryStack stack) {
        return AIVectorKey.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIVectorKey callocStack(MemoryStack stack) {
        return AIVectorKey.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIVectorKey.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIVectorKey.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIVectorKey.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIVectorKey.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static double nmTime(long struct) {
        return MemoryUtil.memGetDouble(struct + (long)MTIME);
    }

    public static AIVector3D nmValue(long struct) {
        return AIVector3D.create(struct + (long)MVALUE);
    }

    public static void nmTime(long struct, double value) {
        MemoryUtil.memPutDouble(struct + (long)MTIME, value);
    }

    public static void nmValue(long struct, AIVector3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MVALUE, AIVector3D.SIZEOF);
    }

    static {
        Struct.Layout layout = AIVectorKey.__struct(AIVectorKey.__member(8), AIVectorKey.__member(AIVector3D.SIZEOF, AIVector3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MTIME = layout.offsetof(0);
        MVALUE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<AIVectorKey, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected AIVectorKey newInstance(long address) {
            return new AIVectorKey(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public double mTime() {
            return AIVectorKey.nmTime(this.address());
        }

        public AIVector3D mValue() {
            return AIVectorKey.nmValue(this.address());
        }

        public Buffer mTime(double value) {
            AIVectorKey.nmTime(this.address(), value);
            return this;
        }

        public Buffer mValue(AIVector3D value) {
            AIVectorKey.nmValue(this.address(), value);
            return this;
        }
    }
}

